/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.symbol;

import com.google.common.collect.Range;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.trace.model.symbol.TraceOffsetReference;
import ghidra.trace.model.symbol.TraceReference;
import ghidra.trace.model.symbol.TraceShiftedReference;
import java.util.Collection;

public interface TraceReferenceOperations {
    public TraceReference addReference(TraceReference var1);

    public TraceReference addReference(Range<Long> var1, Reference var2);

    public TraceReference addMemoryReference(Range<Long> var1, Address var2, Address var3, RefType var4, SourceType var5, int var6);

    public TraceOffsetReference addOffsetReference(Range<Long> var1, Address var2, Address var3, long var4, RefType var6, SourceType var7, int var8);

    public TraceShiftedReference addShiftedReference(Range<Long> var1, Address var2, Address var3, int var4, RefType var5, SourceType var6, int var7);

    public TraceReference addRegisterReference(Range<Long> var1, Address var2, Register var3, RefType var4, SourceType var5, int var6);

    public TraceReference addStackReference(Range<Long> var1, Address var2, int var3, RefType var4, SourceType var5, int var6);

    public TraceReference getReference(long var1, Address var3, Address var4, int var5);

    public Collection<? extends TraceReference> getReferencesFrom(long var1, Address var3);

    public Collection<? extends TraceReference> getReferencesFrom(long var1, Address var3, int var4);

    public Collection<? extends TraceReference> getReferencesFromRange(Range<Long> var1, AddressRange var2);

    public TraceReference getPrimaryReferenceFrom(long var1, Address var3, int var4);

    public Collection<? extends TraceReference> getFlowReferencesFrom(long var1, Address var3);

    public void clearReferencesFrom(Range<Long> var1, AddressRange var2);

    public Collection<? extends TraceReference> getReferencesTo(long var1, Address var3);

    public void clearReferencesTo(Range<Long> var1, AddressRange var2);

    public Collection<? extends TraceReference> getReferencesToRange(Range<Long> var1, AddressRange var2);

    default public boolean hasReferencesFrom(long snap, Address fromAddress) {
        return !this.getReferencesFrom(snap, fromAddress).isEmpty();
    }

    default public boolean hasReferencesFrom(long snap, Address fromAddress, int operandIndex) {
        return !this.getReferencesFrom(snap, fromAddress, operandIndex).isEmpty();
    }

    default public boolean hasFlowReferencesFrom(long snap, Address fromAddress) {
        return !this.getFlowReferencesFrom(snap, fromAddress).isEmpty();
    }

    default public boolean hasReferencesTo(long snap, Address toAddress) {
        return !this.getReferencesTo(snap, toAddress).isEmpty();
    }

    public AddressSetView getReferenceSources(Range<Long> var1);

    public AddressSetView getReferenceDestinations(Range<Long> var1);

    public int getReferenceCountFrom(long var1, Address var3);

    public int getReferenceCountTo(long var1, Address var3);
}

