/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import ghidra.program.database.mem.ByteMappingScheme;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockSourceInfo;
import ghidra.program.model.mem.MemoryBlockType;
import ghidra.trace.database.memory.DBTraceMemorySpace;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.model.memory.TraceMemorySpaceInputStream;
import ghidra.util.MathUtilities;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class AbstractDBTraceProgramViewMemoryBlock
implements MemoryBlock {
    protected final DBTraceProgramView program;
    private final List<MemoryBlockSourceInfo> info = Collections.singletonList(new MyMemoryBlockSourceInfo());

    protected AbstractDBTraceProgramViewMemoryBlock(DBTraceProgramView program) {
        this.program = program;
    }

    protected abstract String getInfoDescription();

    protected AddressSpace getAddressSpace() {
        return this.getStart().getAddressSpace();
    }

    protected DBTraceMemorySpace getMemorySpace() {
        return this.program.trace.getMemoryManager().getMemorySpace(this.getAddressSpace(), false);
    }

    protected AddressRange getAddressRange() {
        return new AddressRangeImpl(this.getStart(), this.getEnd());
    }

    public int compareTo(MemoryBlock that) {
        return this.getStart().compareTo((Object)that.getStart());
    }

    public boolean contains(Address addr) {
        return this.getAddressRange().contains(addr);
    }

    public long getSize() {
        return this.getEnd().subtract(this.getStart()) + 1L;
    }

    public BigInteger getSizeAsBigInteger() {
        return this.getEnd().getOffsetAsBigInteger().subtract(this.getStart().getOffsetAsBigInteger()).add(BigInteger.ONE);
    }

    public String getComment() {
        return null;
    }

    public void setComment(String comment) {
        throw new UnsupportedOperationException();
    }

    public InputStream getData() {
        DBTraceMemorySpace ms = this.getMemorySpace();
        if (ms == null) {
            return null;
        }
        return new TraceMemorySpaceInputStream(this.program, ms, this.getAddressRange());
    }

    public String getSourceName() {
        return "Trace";
    }

    public void setSourceName(String sourceName) {
        throw new UnsupportedOperationException();
    }

    public byte getByte(Address addr) throws MemoryAccessException {
        AddressRange range = this.getAddressRange();
        if (!range.contains(addr)) {
            throw new MemoryAccessException();
        }
        DBTraceMemorySpace space = this.program.trace.getMemoryManager().getMemorySpace(range.getAddressSpace(), false);
        if (space == null) {
            throw new MemoryAccessException("Space does not exist");
        }
        ByteBuffer buf = ByteBuffer.allocate(1);
        if (space.getViewBytes(this.program.snap, addr, buf) != 1) {
            throw new MemoryAccessException();
        }
        return buf.get(0);
    }

    public int getBytes(Address addr, byte[] b) throws MemoryAccessException {
        return this.getBytes(addr, b, 0, b.length);
    }

    public int getBytes(Address addr, byte[] b, int off, int len) throws MemoryAccessException {
        AddressRange range = this.getAddressRange();
        if (!range.contains(addr)) {
            throw new MemoryAccessException();
        }
        DBTraceMemorySpace space = this.program.trace.getMemoryManager().getMemorySpace(range.getAddressSpace(), false);
        if (space == null) {
            throw new MemoryAccessException("Space does not exist");
        }
        len = MathUtilities.unsignedMin((int)len, (long)(range.getMaxAddress().subtract(addr) + 1L));
        return space.getViewBytes(this.program.snap, addr, ByteBuffer.wrap(b, off, len));
    }

    public void putByte(Address addr, byte b) throws MemoryAccessException {
        if (this.putBytes(addr, new byte[]{b}) != 1) {
            throw new MemoryAccessException();
        }
    }

    public int putBytes(Address addr, byte[] b) throws MemoryAccessException {
        return this.putBytes(addr, b, 0, b.length);
    }

    public int putBytes(Address addr, byte[] b, int off, int len) throws MemoryAccessException {
        AddressRange range = this.getAddressRange();
        if (!range.contains(addr)) {
            throw new MemoryAccessException();
        }
        DBTraceMemorySpace space = this.program.trace.getMemoryManager().getMemorySpace(range.getAddressSpace(), true);
        len = (int)Math.min((long)len, range.getMaxAddress().subtract(addr) + 1L);
        return space.putBytes(this.program.snap, addr, ByteBuffer.wrap(b, off, len));
    }

    public MemoryBlockType getType() {
        return MemoryBlockType.DEFAULT;
    }

    public boolean isInitialized() {
        return true;
    }

    public boolean isMapped() {
        return false;
    }

    public boolean isOverlay() {
        return this.getAddressSpace().isOverlaySpace();
    }

    public boolean isLoaded() {
        return true;
    }

    public List<MemoryBlockSourceInfo> getSourceInfos() {
        return this.info;
    }

    private class MyMemoryBlockSourceInfo
    implements MemoryBlockSourceInfo {
        private MyMemoryBlockSourceInfo() {
        }

        public long getLength() {
            return this.getMemoryBlock().getSize();
        }

        public Address getMinAddress() {
            return this.getMemoryBlock().getStart();
        }

        public Address getMaxAddress() {
            return this.getMemoryBlock().getEnd();
        }

        public String getDescription() {
            return AbstractDBTraceProgramViewMemoryBlock.this.getInfoDescription();
        }

        public Optional<FileBytes> getFileBytes() {
            return Optional.empty();
        }

        public long getFileBytesOffset() {
            return -1L;
        }

        public long getFileBytesOffset(Address address) {
            return -1L;
        }

        public Optional<AddressRange> getMappedRange() {
            return Optional.empty();
        }

        public Optional<ByteMappingScheme> getByteMappingScheme() {
            return Optional.empty();
        }

        public MemoryBlock getMemoryBlock() {
            return AbstractDBTraceProgramViewMemoryBlock.this;
        }

        public boolean contains(Address address) {
            return this.getMemoryBlock().contains(address);
        }

        public String toString() {
            return this.getDescription();
        }
    }
}

