/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.memory;

import com.google.common.collect.Collections2;
import com.google.common.collect.Range;
import db.DBHandle;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.mem.MemBuffer;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.address.DBTraceOverlaySpaceAdapter;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.memory.DBTraceMemoryRegion;
import ghidra.trace.database.memory.DBTraceMemoryRegisterSpace;
import ghidra.trace.database.memory.DBTraceMemorySpace;
import ghidra.trace.database.space.AbstractDBTraceSpaceBasedManager;
import ghidra.trace.database.space.DBTraceDelegatingManager;
import ghidra.trace.database.thread.DBTraceThread;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.memory.TraceMemoryFlag;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemoryRegisterSpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.memory.TraceOverlappedRegionException;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.MathUtilities;
import ghidra.util.UnionAddressSetView;
import ghidra.util.database.DBOpenMode;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.UsrException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Predicate;

public class DBTraceMemoryManager
extends AbstractDBTraceSpaceBasedManager<DBTraceMemorySpace, DBTraceMemoryRegisterSpace>
implements TraceMemoryManager,
DBTraceDelegatingManager<DBTraceMemorySpace> {
    protected static final String NAME = "Memory";
    protected final DBTraceOverlaySpaceAdapter overlayAdapter;

    public DBTraceMemoryManager(DBHandle dbh, DBOpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace, DBTraceThreadManager threadManager, DBTraceOverlaySpaceAdapter overlayAdapter) throws IOException, VersionException {
        super(NAME, dbh, openMode, lock, monitor, baseLanguage, trace, threadManager);
        this.overlayAdapter = overlayAdapter;
        this.loadSpaces();
    }

    @Override
    public AddressSpace createOverlayAddressSpace(String name, AddressSpace base) throws DuplicateNameException {
        return this.overlayAdapter.createOverlayAddressSpace(name, base);
    }

    @Override
    public void deleteOverlayAddressSpace(String name) {
        this.overlayAdapter.deleteOverlayAddressSpace(name);
    }

    @Override
    protected DBTraceMemorySpace createSpace(AddressSpace space, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        return new DBTraceMemorySpace(this, this.dbh, space, ent);
    }

    @Override
    protected DBTraceMemoryRegisterSpace createRegisterSpace(AddressSpace space, DBTraceThread thread, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        return new DBTraceMemoryRegisterSpace(this, this.dbh, space, ent, thread);
    }

    @Override
    public DBTraceMemorySpace getForSpace(AddressSpace space, boolean createIfAbsent) {
        return (DBTraceMemorySpace)super.getForSpace(space, createIfAbsent);
    }

    @Override
    public Lock readLock() {
        return this.lock.readLock();
    }

    @Override
    public Lock writeLock() {
        return this.lock.writeLock();
    }

    @Override
    public DBTraceMemorySpace getMemorySpace(AddressSpace space, boolean createIfAbsent) {
        return this.getForSpace(space, createIfAbsent);
    }

    @Override
    public DBTraceMemoryRegisterSpace getMemoryRegisterSpace(TraceThread thread, boolean createIfAbsent) {
        return (DBTraceMemoryRegisterSpace)this.getForRegisterSpace(thread, 0, createIfAbsent);
    }

    @Override
    public TraceMemoryRegisterSpace getMemoryRegisterSpace(TraceThread thread, int frame, boolean createIfAbsent) {
        return (TraceMemoryRegisterSpace)this.getForRegisterSpace(thread, frame, createIfAbsent);
    }

    @Override
    public DBTraceMemoryRegisterSpace getMemoryRegisterSpace(TraceStackFrame frame, boolean createIfAbsent) {
        return (DBTraceMemoryRegisterSpace)this.getForRegisterSpace(frame, createIfAbsent);
    }

    @Override
    public DBTraceMemoryRegion addRegion(String path, Range<Long> lifespan, AddressRange range, Collection<TraceMemoryFlag> flags) throws TraceOverlappedRegionException, DuplicateNameException {
        try {
            return (DBTraceMemoryRegion)this.delegateWrite(range.getAddressSpace(), m -> m.addRegion(path, (Range)lifespan, range, (Collection)flags));
        }
        catch (TraceOverlappedRegionException | DuplicateNameException e) {
            throw e;
        }
        catch (UsrException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Collection<TraceMemoryRegion> getAllRegions() {
        return this.delegateCollection(this.getActiveMemorySpaces(), m -> m.getAllRegions());
    }

    public Collection<DBTraceMemoryRegion> getRegionsInternal() {
        return this.delegateCollection(this.getActiveMemorySpaces(), m -> m.regionMapSpace.values());
    }

    @Override
    public DBTraceMemoryRegion getLiveRegionByPath(long snap, String regionName) {
        return (DBTraceMemoryRegion)this.delegateFirst(this.getActiveMemorySpaces(), m -> m.getLiveRegionByPath(snap, regionName));
    }

    @Override
    public DBTraceMemoryRegion getRegionContaining(long snap, Address address) {
        return (DBTraceMemoryRegion)this.delegateRead(address.getAddressSpace(), m -> m.getRegionContaining(snap, address));
    }

    public Collection<? extends DBTraceMemoryRegion> getRegionsIntersecting(Range<Long> lifespan, AddressRange range) {
        return (Collection)this.delegateRead(range.getAddressSpace(), m -> m.getRegionsIntersecting(lifespan, range), Collections.emptyList());
    }

    public Collection<? extends DBTraceMemoryRegion> getRegionsAtSnap(long snap) {
        return this.delegateCollection(this.memSpaces.values(), m -> m.getRegionsAtSnap(snap));
    }

    public Collection<TraceMemoryRegion> getRegionsWithPathInLifespan(Range<Long> lifespan, String regionPath) {
        HashSet<TraceMemoryRegion> result = new HashSet<TraceMemoryRegion>();
        for (DBTraceMemorySpace m : this.getActiveMemorySpaces()) {
            for (TraceMemoryRegion traceMemoryRegion : m.getRegionsIntersecting(lifespan, (AddressRange)new AddressRangeImpl(m.getAddressSpace().getMinAddress(), m.getAddressSpace().getMaxAddress()))) {
                if (!regionPath.equals(traceMemoryRegion.getPath())) continue;
                result.add(traceMemoryRegion);
            }
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public AddressSetView getRegionsAddressSet(long snap) {
        return new UnionAddressSetView(Collections2.transform(this.getActiveMemorySpaces(), m -> m.getRegionsAddressSet(snap)));
    }

    @Override
    public AddressSetView getRegionsAddressSetWith(long snap, Predicate<TraceMemoryRegion> predicate) {
        return new UnionAddressSetView(Collections2.transform(this.getActiveMemorySpaces(), m -> m.getRegionsAddressSetWith(snap, predicate)));
    }

    @Override
    public void setState(long snap, Address address, TraceMemoryState state) {
        this.delegateWriteV(address.getAddressSpace(), m -> m.setState(snap, address, state));
    }

    @Override
    public void setState(long snap, Address start, Address end, TraceMemoryState state) {
        this.delegateWriteV(start.getAddressSpace(), m -> m.setState(snap, start, end, state));
    }

    @Override
    public void setState(long snap, AddressRange range, TraceMemoryState state) {
        this.delegateWriteV(range.getAddressSpace(), m -> m.setState(snap, range, state));
    }

    @Override
    public void setState(long snap, AddressSetView set, TraceMemoryState state) {
        for (AddressRange range : set) {
            this.delegateWriteV(range.getAddressSpace(), m -> m.setState(snap, range, state));
        }
    }

    @Override
    public TraceMemoryState getState(long snap, Address address) {
        return (TraceMemoryState)((Object)this.delegateRead(address.getAddressSpace(), m -> m.getState(snap, address)));
    }

    @Override
    public Map.Entry<Long, TraceMemoryState> getViewState(long snap, Address address) {
        return (Map.Entry)this.delegateRead(address.getAddressSpace(), m -> m.getViewState(snap, address));
    }

    @Override
    public Map.Entry<TraceAddressSnapRange, TraceMemoryState> getMostRecentStateEntry(long snap, Address address) {
        return (Map.Entry)this.delegateRead(address.getAddressSpace(), m -> m.getMostRecentStateEntry(snap, address));
    }

    @Override
    public Map.Entry<TraceAddressSnapRange, TraceMemoryState> getViewMostRecentStateEntry(long snap, Address address) {
        return (Map.Entry)this.delegateRead(address.getAddressSpace(), m -> m.getViewMostRecentStateEntry(snap, address));
    }

    @Override
    public AddressSetView getAddressesWithState(long snap, AddressSetView set, Predicate<TraceMemoryState> predicate) {
        return this.delegateAddressSet(this.getActiveMemorySpaces(), m -> m.getAddressesWithState(snap, set, predicate));
    }

    @Override
    public AddressSetView getAddressesWithState(long snap, Predicate<TraceMemoryState> predicate) {
        return new UnionAddressSetView(Collections2.transform(this.getActiveMemorySpaces(), m -> m.getAddressesWithState(snap, predicate)));
    }

    @Override
    public AddressSetView getAddressesWithState(Range<Long> lifespan, Predicate<TraceMemoryState> predicate) {
        return new UnionAddressSetView(Collections2.transform(this.getActiveMemorySpaces(), m -> m.getAddressesWithState(lifespan, predicate)));
    }

    @Override
    public Collection<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> getStates(long snap, AddressRange range) {
        return (Collection)this.delegateRead(range.getAddressSpace(), m -> m.getStates(snap, range), Collections.emptyList());
    }

    @Override
    public Iterable<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> getMostRecentStates(TraceAddressSnapRange within) {
        return (Iterable)this.delegateRead(within.getRange().getAddressSpace(), m -> m.getMostRecentStates(within), Collections.emptyList());
    }

    @Override
    public int putBytes(long snap, Address start, ByteBuffer buf) {
        return this.delegateWriteI(start.getAddressSpace(), m -> m.putBytes(snap, start, buf));
    }

    @Override
    public int getBytes(long snap, Address start, ByteBuffer buf) {
        return this.delegateReadI(start.getAddressSpace(), m -> m.getBytes(snap, start, buf), () -> {
            Address max = start.getAddressSpace().getMaxAddress();
            int len = MathUtilities.unsignedMin((int)buf.remaining(), (long)max.subtract(start));
            buf.position(buf.position() + len);
            return len;
        });
    }

    @Override
    public int getViewBytes(long snap, Address start, ByteBuffer buf) {
        return this.delegateReadI(start.getAddressSpace(), m -> m.getViewBytes(snap, start, buf), () -> {
            Address max = start.getAddressSpace().getMaxAddress();
            int len = MathUtilities.unsignedMin((int)buf.remaining(), (long)max.subtract(start));
            buf.position(buf.position() + len);
            return len;
        });
    }

    @Override
    public void removeBytes(long snap, Address start, int len) {
        this.delegateDeleteV(start.getAddressSpace(), m -> m.removeBytes(snap, start, len));
    }

    @Override
    public Address findBytes(long snap, AddressRange range, ByteBuffer data, ByteBuffer mask, boolean forward, TaskMonitor monitor) {
        return (Address)this.delegateRead(range.getAddressSpace(), m -> m.findBytes(snap, range, data, mask, forward, monitor));
    }

    @Override
    public MemBuffer getBufferAt(long snap, Address start, ByteOrder byteOrder) {
        return (MemBuffer)this.delegateRead(start.getAddressSpace(), m -> m.getBufferAt(snap, start, byteOrder));
    }

    @Override
    public Long getSnapOfMostRecentChangeToBlock(long snap, Address address) {
        return (Long)this.delegateRead(address.getAddressSpace(), m -> m.getSnapOfMostRecentChangeToBlock(snap, address));
    }

    @Override
    public int getBlockSize() {
        return 4096;
    }

    @Override
    public void pack() {
        this.delegateWriteAll(this.getActiveSpaces(), m -> m.pack());
    }

    public Collection<? extends DBTraceMemoryRegion> getRegionsAdded(long from, long to) {
        if (from == to) {
            return Collections.emptySet();
        }
        ArrayList result = new ArrayList();
        for (DBTraceMemorySpace space : this.memSpaces.values()) {
            result.addAll(space.regionMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.added(from, to, space.space)).values());
        }
        return result;
    }

    public Collection<? extends DBTraceMemoryRegion> getRegionsRemoved(long from, long to) {
        if (from == to) {
            return Collections.emptySet();
        }
        ArrayList result = new ArrayList();
        for (DBTraceMemorySpace space : this.memSpaces.values()) {
            result.addAll(space.regionMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.removed(from, to, space.space)).values());
        }
        return result;
    }

    @Override
    public Collection<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> getStateChanges(long from, long to) {
        if (from == to) {
            return Collections.emptySet();
        }
        Range between = from < to ? Range.closed((Comparable)Long.valueOf(from + 1L), (Comparable)Long.valueOf(to)) : Range.closed((Comparable)Long.valueOf(to + 1L), (Comparable)Long.valueOf(from));
        ArrayList<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> result = new ArrayList<Map.Entry<TraceAddressSnapRange, TraceMemoryState>>();
        for (DBTraceMemorySpace space : this.memSpaces.values()) {
            AddressRangeImpl rng = new AddressRangeImpl(space.space.getMinAddress(), space.space.getMaxAddress());
            result.addAll(space.stateMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.enclosed((AddressRange)rng, (Range<Long>)between)).entries());
        }
        return result;
    }
}

