/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace;

import com.google.common.collect.RangeSet;
import com.google.common.primitives.UnsignedLong;
import ghidra.pcode.exec.trace.TraceCachedWriteBytesPcodeExecutorState;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.thread.TraceThread;

public abstract class AbstractCheckedTraceCachedWriteBytesPcodeExecutorState
extends TraceCachedWriteBytesPcodeExecutorState {
    public AbstractCheckedTraceCachedWriteBytesPcodeExecutorState(Trace trace, long snap, TraceThread thread, int frame) {
        super(trace, snap, thread, frame);
    }

    @Override
    protected TraceCachedWriteBytesPcodeExecutorState.CachedSpace newSpace(AddressSpace space, TraceMemorySpace source, long snap) {
        return new CheckedCachedSpace(this.language, space, source, snap);
    }

    protected abstract int checkUninitialized(TraceMemorySpace var1, Address var2, int var3, AddressSet var4);

    protected class CheckedCachedSpace
    extends TraceCachedWriteBytesPcodeExecutorState.CachedSpace {
        public CheckedCachedSpace(Language language, AddressSpace space, TraceMemorySpace source, long snap) {
            super(language, space, source, snap);
        }

        @Override
        public byte[] read(long offset, int size) {
            RangeSet uninitialized = this.cache.getUninitialized(offset, offset + (long)size - 1L);
            if (!uninitialized.isEmpty()) {
                size = AbstractCheckedTraceCachedWriteBytesPcodeExecutorState.this.checkUninitialized(this.source, this.space.getAddress(offset), size, this.addrSet((RangeSet<UnsignedLong>)uninitialized));
                if (this.source != null) {
                    this.readUninitializedFromSource((RangeSet<UnsignedLong>)uninitialized);
                }
            }
            return this.readCached(offset, size);
        }
    }
}

