/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.layout;

import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.layout.DNLayoutOptions;
import ghidra.app.plugin.core.functiongraph.graph.layout.DecompilerNestedLayout;
import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayout;
import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayoutOptions;
import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayoutProviderExtensionPoint;
import ghidra.framework.options.Options;
import ghidra.util.task.TaskMonitor;
import javax.swing.Icon;
import resources.ResourceManager;

public class DecompilerNestedLayoutProvider
extends FGLayoutProviderExtensionPoint {
    private static final Icon ICON = ResourceManager.loadImage((String)"images/function_graph_code_flow.png");
    static final String LAYOUT_NAME = "Nested Code Layout";

    public FGLayout getFGLayout(FunctionGraph graph, TaskMonitor monitor) {
        DecompilerNestedLayout layout = new DecompilerNestedLayout(graph, LAYOUT_NAME);
        layout.setTaskMonitor(monitor);
        return layout;
    }

    public FGLayoutOptions createLayoutOptions(Options options) {
        DNLayoutOptions layoutOptions = new DNLayoutOptions();
        layoutOptions.registerOptions(options);
        return layoutOptions;
    }

    public String getLayoutName() {
        return LAYOUT_NAME;
    }

    public Icon getActionIcon() {
        return ICON;
    }

    public int getPriorityLevel() {
        return 200;
    }
}

