/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.SleighUseropLibrary;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ComposedSleighUseropLibrary<T>
implements SleighUseropLibrary<T> {
    private final Map<String, SleighUseropLibrary.SleighUseropDefinition<T>> userops;

    public static <T> Map<String, SleighUseropLibrary.SleighUseropDefinition<T>> composeUserops(Collection<SleighUseropLibrary<T>> libraries) {
        HashMap<String, SleighUseropLibrary.SleighUseropDefinition<T>> userops = new HashMap<String, SleighUseropLibrary.SleighUseropDefinition<T>>();
        for (SleighUseropLibrary<T> lib : libraries) {
            for (SleighUseropLibrary.SleighUseropDefinition<T> def : lib.getUserops().values()) {
                if (userops.put(def.getName(), def) == null) continue;
                throw new IllegalArgumentException("Cannot compose libraries with conflicting definitions on " + def.getName());
            }
        }
        return userops;
    }

    public ComposedSleighUseropLibrary(Collection<SleighUseropLibrary<T>> libraries) {
        this.userops = ComposedSleighUseropLibrary.composeUserops(libraries);
    }

    @Override
    public Map<String, SleighUseropLibrary.SleighUseropDefinition<T>> getUserops() {
        return this.userops;
    }
}

