/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghpattern;

import ghidra.pcodeCPort.slghpattern.CombinePattern;
import ghidra.pcodeCPort.slghpattern.ContextPattern;
import ghidra.pcodeCPort.slghpattern.InstructionPattern;
import ghidra.pcodeCPort.slghpattern.Pattern;
import ghidra.pcodeCPort.slghpattern.PatternBlock;
import org.jdom.Element;

public abstract class DisjointPattern
extends Pattern {
    protected abstract PatternBlock getBlock(boolean var1);

    @Override
    public int numDisjoint() {
        return 0;
    }

    @Override
    public DisjointPattern getDisjoint(int i) {
        return null;
    }

    public int getMask(int startbit, int size, boolean context) {
        PatternBlock block = this.getBlock(context);
        if (block != null) {
            return block.getMask(startbit, size);
        }
        return 0;
    }

    public int getValue(int startbit, int size, boolean context) {
        PatternBlock block = this.getBlock(context);
        if (block != null) {
            return block.getValue(startbit, size);
        }
        return 0;
    }

    public int getLength(boolean context) {
        PatternBlock block = this.getBlock(context);
        if (block != null) {
            return block.getLength();
        }
        return 0;
    }

    public boolean specializes(DisjointPattern op2) {
        PatternBlock a = this.getBlock(false);
        PatternBlock b = op2.getBlock(false);
        if (b != null && !b.alwaysTrue()) {
            if (a == null) {
                return false;
            }
            if (!a.specializes(b)) {
                return false;
            }
        }
        a = this.getBlock(true);
        b = op2.getBlock(true);
        if (b != null && !b.alwaysTrue()) {
            if (a == null) {
                return false;
            }
            if (!a.specializes(b)) {
                return false;
            }
        }
        return true;
    }

    public boolean identical(DisjointPattern op2) {
        PatternBlock a = this.getBlock(false);
        PatternBlock b = op2.getBlock(false);
        if (b != null ? (a == null ? !b.alwaysTrue() : !a.identical(b)) : a != null && !a.alwaysTrue()) {
            return false;
        }
        a = this.getBlock(true);
        b = op2.getBlock(true);
        return !(b != null ? (a == null ? !b.alwaysTrue() : !a.identical(b)) : a != null && !a.alwaysTrue());
    }

    public static boolean resolveIntersectBlock(PatternBlock bl1, PatternBlock bl2, PatternBlock thisblock) {
        boolean res = true;
        PatternBlock inter = bl1 == null ? bl2 : (bl2 == null ? bl1 : bl1.intersect(bl2));
        if (inter == null) {
            if (thisblock != null) {
                res = false;
            }
        } else {
            res = thisblock == null ? false : thisblock.identical(inter);
        }
        return res;
    }

    public boolean resolvesIntersect(DisjointPattern op1, DisjointPattern op2) {
        if (!DisjointPattern.resolveIntersectBlock(op1.getBlock(false), op2.getBlock(false), this.getBlock(false))) {
            return false;
        }
        return DisjointPattern.resolveIntersectBlock(op1.getBlock(true), op2.getBlock(true), this.getBlock(true));
    }

    public static DisjointPattern restoreDisjoint(Element el) {
        DisjointPattern res = el.getName().equals("instruct_pat") ? new InstructionPattern() : (el.getName().equals("context_pat") ? new ContextPattern() : new CombinePattern());
        ((Pattern)res).restoreXml(el);
        return res;
    }

    public String toString() {
        return "DisjointPattern{" + this.getBlock(true) + " : " + this.getBlock(false) + "}";
    }
}

