/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.opbehavior;

import ghidra.pcode.error.LowlevelError;
import ghidra.pcode.opbehavior.BinaryOpBehavior;
import ghidra.pcode.utils.Utils;
import java.math.BigInteger;

public class OpBehaviorIntSrem
extends BinaryOpBehavior {
    public OpBehaviorIntSrem() {
        super(36);
    }

    @Override
    public long evaluateBinary(int sizeout, int sizein, long in1, long in2) {
        if (in2 == 0L) {
            throw new LowlevelError("Remainder by 0");
        }
        long val = in1;
        long mod = in2;
        val = Utils.zzz_sign_extend(val, 8 * sizein - 1);
        mod = Utils.zzz_sign_extend(mod, 8 * sizein - 1);
        long sres = val % mod;
        sres = Utils.zzz_zero_extend(sres, 8 * sizeout - 1);
        return sres;
    }

    @Override
    public BigInteger evaluateBinary(int sizeout, int sizein, BigInteger in1, BigInteger in2) {
        if (in2.signum() == 0) {
            throw new LowlevelError("Remainder by 0");
        }
        in1 = Utils.convertToSignedValue(in1, sizein);
        in2 = Utils.convertToSignedValue(in2, sizein);
        return in1.remainder(in2);
    }
}

