/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.memstate;

import generic.stl.VectorSTL;
import ghidra.pcode.error.LowlevelError;
import ghidra.pcode.memstate.MemoryBank;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.pcode.Varnode;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class MemoryState {
    Language language;
    VectorSTL<MemoryBank> memspace = new VectorSTL();
    Map<Register, Varnode> regVarnodeCache = new HashMap<Register, Varnode>();

    public MemoryState(Language language) {
        this.language = language;
    }

    private Varnode getVarnode(Register reg) {
        Varnode varnode = this.regVarnodeCache.get(reg);
        if (varnode == null) {
            varnode = new Varnode(reg.getAddress(), reg.getMinimumByteSize());
            this.regVarnodeCache.put(reg, varnode);
        }
        return varnode;
    }

    public final void setMemoryBank(MemoryBank bank) {
        AddressSpace spc = bank.getSpace();
        int index = spc.getUnique();
        while (index >= this.memspace.size()) {
            this.memspace.push_back(null);
        }
        this.memspace.set(index, (Object)bank);
    }

    public final MemoryBank getMemoryBank(AddressSpace spc) {
        int index = spc.getUnique();
        if (index >= this.memspace.size()) {
            return null;
        }
        return (MemoryBank)this.memspace.get(index);
    }

    public final void setValue(Varnode vn, long cval) {
        Address addr = vn.getAddress();
        this.setValue(addr.getAddressSpace(), addr.getOffset(), vn.getSize(), cval);
    }

    public final void setValue(Register reg, long cval) {
        Address addr = reg.getAddress();
        this.setValue(addr.getAddressSpace(), addr.getOffset(), reg.getMinimumByteSize(), cval);
    }

    public final void setValue(String nm, long cval) {
        Varnode vdata = this.getVarnode(this.language.getRegister(nm));
        Address addr = vdata.getAddress();
        this.setValue(addr.getAddressSpace(), addr.getOffset(), vdata.getSize(), cval);
    }

    public final void setValue(AddressSpace spc, long off, int size, long cval) {
        this.setChunk(Utils.longToBytes(cval, size, this.language.isBigEndian()), spc, off, size);
    }

    public final long getValue(Varnode vn) {
        Address addr = vn.getAddress();
        return this.getValue(addr.getAddressSpace(), addr.getOffset(), vn.getSize());
    }

    public final long getValue(Register reg) {
        Address addr = reg.getAddress();
        return this.getValue(addr.getAddressSpace(), addr.getOffset(), reg.getMinimumByteSize());
    }

    public final long getValue(String nm) {
        Varnode vdata = this.getVarnode(this.language.getRegister(nm));
        Address addr = vdata.getAddress();
        return this.getValue(addr.getAddressSpace(), addr.getOffset(), vdata.getSize());
    }

    public final long getValue(AddressSpace spc, long off, int size) {
        if (spc.isConstantSpace()) {
            return off;
        }
        byte[] bytes = new byte[size];
        this.getChunk(bytes, spc, off, size, false);
        return Utils.bytesToLong(bytes, size, this.language.isBigEndian());
    }

    public final void setValue(Varnode vn, BigInteger cval) {
        Address addr = vn.getAddress();
        this.setValue(addr.getAddressSpace(), addr.getOffset(), vn.getSize(), cval);
    }

    public final void setValue(Register reg, BigInteger cval) {
        Address addr = reg.getAddress();
        this.setValue(addr.getAddressSpace(), addr.getOffset(), reg.getMinimumByteSize(), cval);
    }

    public final void setValue(String nm, BigInteger cval) {
        Varnode vdata = this.getVarnode(this.language.getRegister(nm));
        Address addr = vdata.getAddress();
        this.setValue(addr.getAddressSpace(), addr.getOffset(), vdata.getSize(), cval);
    }

    public final void setValue(AddressSpace spc, long off, int size, BigInteger cval) {
        this.setChunk(Utils.bigIntegerToBytes(cval, size, this.language.isBigEndian()), spc, off, size);
    }

    public final BigInteger getBigInteger(Varnode vn, boolean signed) {
        Address addr = vn.getAddress();
        return this.getBigInteger(addr.getAddressSpace(), addr.getOffset(), vn.getSize(), signed);
    }

    public final BigInteger getBigInteger(Register reg) {
        Address addr = reg.getAddress();
        return this.getBigInteger(addr.getAddressSpace(), addr.getOffset(), reg.getMinimumByteSize(), false);
    }

    public final BigInteger getBigInteger(String nm) {
        Varnode vdata = this.getVarnode(this.language.getRegister(nm));
        Address addr = vdata.getAddress();
        return this.getBigInteger(addr.getAddressSpace(), addr.getOffset(), vdata.getSize(), false);
    }

    public final BigInteger getBigInteger(AddressSpace spc, long off, int size, boolean signed) {
        if (spc.isConstantSpace()) {
            if (!signed && off < 0L) {
                return new BigInteger(1, Utils.longToBytes(off, 8, true));
            }
            return BigInteger.valueOf(off);
        }
        byte[] bytes = new byte[size];
        this.getChunk(bytes, spc, off, size, false);
        return Utils.bytesToBigInteger(bytes, size, this.language.isBigEndian(), signed);
    }

    public int getChunk(byte[] res, AddressSpace spc, long off, int size, boolean stopOnUnintialized) {
        if (spc.isConstantSpace()) {
            System.arraycopy(Utils.longToBytes(off, size, this.language.isBigEndian()), 0, res, 0, size);
            return size;
        }
        MemoryBank mspace = this.getMemoryBank(spc);
        if (mspace == null) {
            throw new LowlevelError("Getting chunk from unmapped memory space: " + spc.getName());
        }
        return mspace.getChunk(off, size, res, stopOnUnintialized);
    }

    public void setChunk(byte[] val, AddressSpace spc, long off, int size) {
        MemoryBank mspace = this.getMemoryBank(spc);
        if (mspace == null) {
            throw new LowlevelError("Setting chunk of unmapped memory space: " + spc.getName());
        }
        mspace.setChunk(off, size, val);
    }

    public void setInitialized(boolean initialized, AddressSpace spc, long off, int size) {
        MemoryBank mspace = this.getMemoryBank(spc);
        if (mspace == null) {
            throw new LowlevelError("Setting intialization status of unmapped memory space: " + spc.getName());
        }
        mspace.setInitialized(off, size, initialized);
    }
}

