/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.target;

import ghidra.dbg.DebuggerTargetObjectIface;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;

@DebuggerTargetObjectIface(value="ExecutionStateful")
public interface TargetExecutionStateful
extends TargetObject {
    public static final String STATE_ATTRIBUTE_NAME = "_state";

    @TargetAttributeType(name="_state", required=true, hidden=true)
    default public TargetExecutionState getExecutionState() {
        return this.getTypedAttributeNowByName(STATE_ATTRIBUTE_NAME, TargetExecutionState.class, TargetExecutionState.INACTIVE);
    }

    public static enum TargetExecutionState {
        INACTIVE{

            @Override
            public boolean isAlive() {
                return false;
            }

            @Override
            public boolean isRunning() {
                return false;
            }

            @Override
            public boolean isStopped() {
                return false;
            }
        }
        ,
        ALIVE{

            @Override
            public boolean isAlive() {
                return true;
            }

            @Override
            public boolean isRunning() {
                return false;
            }

            @Override
            public boolean isStopped() {
                return false;
            }
        }
        ,
        STOPPED{

            @Override
            public boolean isAlive() {
                return true;
            }

            @Override
            public boolean isRunning() {
                return false;
            }

            @Override
            public boolean isStopped() {
                return true;
            }
        }
        ,
        RUNNING{

            @Override
            public boolean isAlive() {
                return true;
            }

            @Override
            public boolean isRunning() {
                return true;
            }

            @Override
            public boolean isStopped() {
                return false;
            }
        }
        ,
        TERMINATED{

            @Override
            public boolean isAlive() {
                return false;
            }

            @Override
            public boolean isRunning() {
                return false;
            }

            @Override
            public boolean isStopped() {
                return false;
            }
        };


        public abstract boolean isAlive();

        public abstract boolean isRunning();

        public abstract boolean isStopped();
    }
}

