/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.jna.cmd;

import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgmodel.dbgmodel.main.ModelObject;
import agent.dbgmodel.gadp.impl.WrappedDbgModel;
import agent.dbgmodel.manager.DbgManager2Impl;
import agent.dbgmodel.model.impl.DbgModel2TargetObjectImpl;
import agent.dbgmodel.model.impl.DbgModel2TargetProxy;
import agent.dbgmodel.model.impl.DelegateDbgModel2TargetObject;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.PathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DbgListElementsCommand
extends AbstractDbgCommand<List<TargetObject>> {
    private List<TargetObject> updatedElements;
    private WrappedDbgModel access;
    private List<String> path;
    private DbgModel2TargetObjectImpl targetObject;

    public DbgListElementsCommand(DbgManager2Impl manager, List<String> path, DbgModel2TargetObjectImpl targetObject) {
        super((DbgManagerImpl)manager);
        this.access = manager.getAccess();
        this.path = path;
        this.targetObject = targetObject;
    }

    public List<TargetObject> complete(DbgPendingCommand<?> pending) {
        return this.updatedElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() {
        WrappedDbgModel wrappedDbgModel = this.access;
        synchronized (wrappedDbgModel) {
            this.updatedElements = new ArrayList<TargetObject>();
            List<ModelObject> list = this.access.getElements(this.path);
            Map existingElements = this.targetObject.getCachedElements();
            for (ModelObject obj : list) {
                DbgModel2TargetProxy proxyElement;
                String searchKey = obj.getSearchKey();
                String elKey = PathUtils.makeKey((String)searchKey);
                if (existingElements.containsKey(searchKey)) {
                    proxyElement = (DbgModel2TargetProxy)existingElements.get(searchKey);
                    DelegateDbgModel2TargetObject delegate = proxyElement.getDelegate();
                    delegate.setModelObject(obj);
                } else {
                    proxyElement = (DbgModel2TargetProxy)DelegateDbgModel2TargetObject.makeProxy(this.targetObject.getModel(), this.targetObject, elKey, obj);
                }
                this.updatedElements.add((TargetObject)proxyElement);
            }
        }
    }
}

