/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl.cmd;

import agent.gdb.manager.breakpoint.GdbBreakpointInfo;
import agent.gdb.manager.breakpoint.GdbBreakpointType;
import agent.gdb.manager.evt.GdbBreakpointCreatedEvent;
import agent.gdb.manager.evt.GdbCommandDoneEvent;
import agent.gdb.manager.impl.GdbEvent;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbPendingCommand;
import agent.gdb.manager.impl.cmd.AbstractGdbCommandWithThreadId;
import agent.gdb.manager.parsing.GdbMiParser;
import org.apache.commons.text.StringEscapeUtils;

public class GdbInsertBreakpointCommand
extends AbstractGdbCommandWithThreadId<GdbBreakpointInfo> {
    private final String loc;
    private final GdbBreakpointType type;

    public GdbInsertBreakpointCommand(GdbManagerImpl manager, Integer threadId, String loc, GdbBreakpointType type) {
        super(manager, threadId);
        this.loc = loc;
        this.type = type;
    }

    @Override
    protected String makeThreadPart() {
        return this.threadId == null ? "" : " -p " + this.threadId;
    }

    protected static String esc(String param) {
        return "\"" + StringEscapeUtils.escapeJava((String)param) + "\"";
    }

    @Override
    protected String encode(String threadPart) {
        switch (this.type) {
            case BREAKPOINT: {
                return "-break-insert" + threadPart + " " + GdbInsertBreakpointCommand.esc(this.loc);
            }
            case HW_BREAKPOINT: {
                return "-break-insert -h" + threadPart + " " + GdbInsertBreakpointCommand.esc(this.loc);
            }
            case DPRINTF: {
                return "-dprintf-insert" + threadPart + " " + GdbInsertBreakpointCommand.esc(this.loc);
            }
            case HW_WATCHPOINT: {
                String cmd = "watch -l " + this.loc;
                return "-interpreter-exec" + threadPart + " console " + GdbInsertBreakpointCommand.esc(cmd);
            }
            case READ_WATCHPOINT: {
                String cmd = "rwatch -l " + this.loc;
                return "-interpreter-exec" + threadPart + " console " + GdbInsertBreakpointCommand.esc(cmd);
            }
            case ACCESS_WATCHPOINT: {
                String cmd = "awatch -l " + this.loc;
                return "-interpreter-exec" + threadPart + " console " + GdbInsertBreakpointCommand.esc(cmd);
            }
        }
        throw new IllegalArgumentException("type=" + this.type);
    }

    @Override
    public boolean handle(GdbEvent<?> evt, GdbPendingCommand<?> pending) {
        if (super.handle(evt, pending)) {
            return true;
        }
        if (evt instanceof GdbBreakpointCreatedEvent) {
            pending.claim(evt);
        }
        return false;
    }

    @Override
    public GdbBreakpointInfo complete(GdbPendingCommand<?> pending) {
        GdbCommandDoneEvent done = (GdbCommandDoneEvent)pending.checkCompletion(GdbCommandDoneEvent.class);
        if (this.type.isWatchpoint()) {
            GdbBreakpointCreatedEvent evt = pending.findSingleOf(GdbBreakpointCreatedEvent.class);
            return evt.getBreakpointInfo();
        }
        GdbBreakpointInfo bkpt = GdbBreakpointInfo.parse((GdbMiParser.GdbMiFieldList)done.getInfo(), this.manager.currentInferior().getId());
        this.manager.doBreakpointCreated(bkpt, pending);
        return bkpt;
    }
}

