/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.dwarf4.LEB128;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.dex.format.EncodedField;
import ghidra.file.formats.android.dex.format.EncodedMethod;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClassDataItem
implements StructConverter {
    private int staticFieldsSize;
    private int instanceFieldsSize;
    private int directMethodsSize;
    private int virtualMethodsSize;
    private int staticFieldsSizeLength;
    private int instanceFieldsSizeLength;
    private int directMethodsSizeLength;
    private int virtualMethodsSizeLength;
    private List<EncodedField> staticFields = new ArrayList<EncodedField>();
    private List<EncodedField> instancesFields = new ArrayList<EncodedField>();
    private List<EncodedMethod> directMethods = new ArrayList<EncodedMethod>();
    private List<EncodedMethod> virtualMethods = new ArrayList<EncodedMethod>();

    public ClassDataItem(BinaryReader reader, DexHeader dexHeader) throws IOException {
        EncodedMethod encodedMethod;
        int i;
        int i2;
        LEB128 leb128 = LEB128.readUnsignedValue((BinaryReader)reader);
        this.staticFieldsSize = leb128.asUInt32();
        this.staticFieldsSizeLength = leb128.getLength();
        leb128 = LEB128.readUnsignedValue((BinaryReader)reader);
        this.instanceFieldsSize = leb128.asUInt32();
        this.instanceFieldsSizeLength = leb128.getLength();
        leb128 = LEB128.readUnsignedValue((BinaryReader)reader);
        this.directMethodsSize = leb128.asUInt32();
        this.directMethodsSizeLength = leb128.getLength();
        leb128 = LEB128.readUnsignedValue((BinaryReader)reader);
        this.virtualMethodsSize = leb128.asUInt32();
        this.virtualMethodsSizeLength = leb128.getLength();
        for (i2 = 0; i2 < this.staticFieldsSize; ++i2) {
            this.staticFields.add(new EncodedField(reader));
        }
        for (i2 = 0; i2 < this.instanceFieldsSize; ++i2) {
            this.instancesFields.add(new EncodedField(reader));
        }
        int methodIndex = 0;
        for (i = 0; i < this.directMethodsSize; ++i) {
            encodedMethod = new EncodedMethod(reader, dexHeader);
            this.directMethods.add(encodedMethod);
            encodedMethod.setMethodIndex(methodIndex += encodedMethod.getMethodIndexDifference());
        }
        methodIndex = 0;
        for (i = 0; i < this.virtualMethodsSize; ++i) {
            encodedMethod = new EncodedMethod(reader, dexHeader);
            this.virtualMethods.add(encodedMethod);
            encodedMethod.setMethodIndex(methodIndex += encodedMethod.getMethodIndexDifference());
        }
    }

    public List<EncodedField> getInstancesFields() {
        return Collections.unmodifiableList(this.instancesFields);
    }

    public List<EncodedField> getStaticFields() {
        return Collections.unmodifiableList(this.staticFields);
    }

    public List<EncodedMethod> getDirectMethods() {
        return Collections.unmodifiableList(this.directMethods);
    }

    public List<EncodedMethod> getVirtualMethods() {
        return Collections.unmodifiableList(this.virtualMethods);
    }

    public int getStaticFieldsSize() {
        return this.staticFieldsSize;
    }

    public int getInstanceFieldsSize() {
        return this.instanceFieldsSize;
    }

    public int getDirectMethodsSize() {
        return this.directMethodsSize;
    }

    public int getVirtualMethodsSize() {
        return this.virtualMethodsSize;
    }

    public EncodedMethod getMethodByIndex(int index) {
        EncodedMethod encodedMethod;
        int i;
        for (i = 0; i < this.directMethods.size(); ++i) {
            encodedMethod = this.directMethods.get(i);
            if (encodedMethod.getMethodIndex() != index) continue;
            return encodedMethod;
        }
        for (i = 0; i < this.virtualMethods.size(); ++i) {
            encodedMethod = this.virtualMethods.get(i);
            if (encodedMethod.getMethodIndex() != index) continue;
            return encodedMethod;
        }
        return null;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "class_data_item_" + this.staticFieldsSizeLength + "_" + this.instanceFieldsSizeLength + "_" + this.directMethodsSizeLength + "_" + this.virtualMethodsSizeLength;
        StructureDataType structure = new StructureDataType(name, 0);
        structure.add((DataType)new ArrayDataType(BYTE, this.staticFieldsSizeLength, BYTE.getLength()), "static_fields", null);
        structure.add((DataType)new ArrayDataType(BYTE, this.instanceFieldsSizeLength, BYTE.getLength()), "instance_fields", null);
        structure.add((DataType)new ArrayDataType(BYTE, this.directMethodsSizeLength, BYTE.getLength()), "direct_methods", null);
        structure.add((DataType)new ArrayDataType(BYTE, this.virtualMethodsSizeLength, BYTE.getLength()), "virtual_methods", null);
        structure.setCategoryPath(new CategoryPath("/dex/class_data_item"));
        return structure;
    }
}

