/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.emulation;

import ghidra.app.plugin.core.debug.service.emulation.AbstractReadsTargetPcodeExecutorState;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.TraceRecorder;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.MathUtilities;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.Map;

public class ReadsTargetMemoryPcodeExecutorState
extends AbstractReadsTargetPcodeExecutorState {
    public ReadsTargetMemoryPcodeExecutorState(PluginTool tool, Trace trace, long snap, TraceThread thread, int frame, TraceRecorder recorder) {
        super(tool, trace, snap, thread, frame, recorder);
    }

    @Override
    protected AbstractReadsTargetPcodeExecutorState.AbstractReadsTargetCachedSpace createCachedSpace(AddressSpace s, TraceMemorySpace tms) {
        return new ReadsTargetMemoryCachedSpace(this.language, s, tms, this.snap);
    }

    protected class ReadsTargetMemoryCachedSpace
    extends AbstractReadsTargetPcodeExecutorState.AbstractReadsTargetCachedSpace {
        public ReadsTargetMemoryCachedSpace(Language language, AddressSpace space, TraceMemorySpace source, long snap) {
            super(language, space, source, snap);
        }

        @Override
        protected void fillUninitialized(AddressSet uninitialized) {
            AddressSet unknown = this.computeUnknown(uninitialized);
            if (unknown.isEmpty()) {
                return;
            }
            if (this.fillUnknownWithRecorder(unknown) && (unknown = this.computeUnknown(uninitialized)).isEmpty()) {
                return;
            }
            if (this.fillUnknownWithStaticImages(unknown) && (unknown = this.computeUnknown(uninitialized)).isEmpty()) {
                return;
            }
        }

        protected boolean fillUnknownWithRecorder(AddressSet unknown) {
            if (!this.isLive()) {
                return false;
            }
            this.waitTimeout(ReadsTargetMemoryPcodeExecutorState.this.recorder.captureProcessMemory((AddressSetView)unknown, TaskMonitor.DUMMY, false));
            return true;
        }

        private boolean fillUnknownWithStaticImages(AddressSet unknown) {
            boolean result = false;
            DebuggerStaticMappingService mappingService = (DebuggerStaticMappingService)ReadsTargetMemoryPcodeExecutorState.this.tool.getService(DebuggerStaticMappingService.class);
            byte[] data = new byte[4096];
            for (Map.Entry<Program, Collection<DebuggerStaticMappingService.MappedAddressRange>> ent : mappingService.getOpenMappedViews(ReadsTargetMemoryPcodeExecutorState.this.trace, (AddressSetView)unknown, this.snap).entrySet()) {
                Program program = ent.getKey();
                Memory memory = program.getMemory();
                AddressSetView initialized = memory.getLoadedAndInitializedAddressSet();
                Collection<DebuggerStaticMappingService.MappedAddressRange> mappedSet = ent.getValue();
                for (DebuggerStaticMappingService.MappedAddressRange mappedRng : mappedSet) {
                    AddressRange srng = mappedRng.getSourceAddressRange();
                    long shift = mappedRng.getShift();
                    for (AddressRange subsrng : initialized.intersectRange(srng.getMinAddress(), srng.getMaxAddress())) {
                        int len;
                        Msg.debug((Object)((Object)this), (Object)("Filling in unknown trace memory in emulator using mapped image: " + program + ": " + subsrng));
                        long lower = subsrng.getMinAddress().getOffset();
                        for (long fullLen = subsrng.getLength(); fullLen > 0L; fullLen -= (long)len) {
                            len = MathUtilities.unsignedMin((int)data.length, (long)fullLen);
                            try {
                                int read = memory.getBytes(this.space.getAddress(lower), data, 0, len);
                                if (read < len) {
                                    Msg.warn((Object)((Object)this), (Object)("  Partial read of " + subsrng + ". Got " + read + " bytes"));
                                }
                                this.cache.putData(lower - shift, data, 0, read);
                            }
                            catch (AddressOutOfBoundsException | MemoryAccessException e) {
                                throw new AssertionError((Object)e);
                            }
                            lower += (long)len;
                        }
                        result = true;
                    }
                }
            }
            return result;
        }
    }
}

