/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.breakpoint;

import docking.widgets.table.GTableCellRenderingData;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.services.LogicalBreakpoint;
import ghidra.docking.settings.Settings;
import ghidra.util.table.column.AbstractGColumnRenderer;
import java.awt.Component;
import javax.swing.Icon;

public class DebuggerBreakpointEnablementTableCellRenderer
extends AbstractGColumnRenderer<LogicalBreakpoint.Enablement> {
    protected static Icon iconForEnablement(LogicalBreakpoint.Enablement en) {
        switch (en) {
            case NONE: {
                return null;
            }
            case ENABLED: {
                return DebuggerResources.ICON_BREAKPOINT_ENABLED_MARKER;
            }
            case DISABLED: {
                return DebuggerResources.ICON_BREAKPOINT_DISABLED_MARKER;
            }
            case INEFFECTIVE_ENABLED: {
                return DebuggerResources.ICON_BREAKPOINT_INEFFECTIVE_E_MARKER;
            }
            case INEFFECTIVE_DISABLED: {
                return DebuggerResources.ICON_BREAKPOINT_INEFFECTIVE_D_MARKER;
            }
            case ENABLED_DISABLED: {
                return DebuggerResources.ICON_BREAKPOINT_MIXED_ED_MARKER;
            }
            case DISABLED_ENABLED: {
                return DebuggerResources.ICON_BREAKPOINT_MIXED_DE_MARKER;
            }
        }
        throw new AssertionError((Object)en);
    }

    public DebuggerBreakpointEnablementTableCellRenderer() {
        this.setHorizontalAlignment(0);
    }

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        super.getTableCellRendererComponent(data);
        LogicalBreakpoint.Enablement en = (LogicalBreakpoint.Enablement)((Object)data.getValue());
        this.setIcon(DebuggerBreakpointEnablementTableCellRenderer.iconForEnablement(en));
        this.setHorizontalAlignment(0);
        this.setText("");
        this.setToolTipText(en.name());
        return this;
    }

    public String getFilterString(LogicalBreakpoint.Enablement t, Settings settings) {
        return t.name();
    }
}

