/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.RegisterLocationTrackingSpec;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.trace.model.Trace;
import javax.swing.Icon;

public class SPLocationTrackingSpec
implements RegisterLocationTrackingSpec {
    public static final String CONFIG_NAME = "TRACK_SP";

    @Override
    public String getConfigName() {
        return CONFIG_NAME;
    }

    @Override
    public String getMenuName() {
        return "Track Stack Pointer";
    }

    @Override
    public Icon getMenuIcon() {
        return DebuggerResources.TrackLocationAction.ICON_SP;
    }

    @Override
    public Register computeRegister(DebuggerCoordinates coordinates) {
        Trace trace = coordinates.getTrace();
        if (trace == null) {
            return null;
        }
        return trace.getBaseCompilerSpec().getStackPointer();
    }

    @Override
    public AddressSpace computeDefaultAddressSpace(DebuggerCoordinates coordinates) {
        return coordinates.getTrace().getBaseLanguage().getDefaultDataSpace();
    }
}

