/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.renderer;

import ghidra.graph.viewer.renderer.PaintableShape;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.Rectangle2D;

public class MouseDraggedPaintableShape
extends PaintableShape {
    private static final Color START_COLOR = new Color(200, 0, 80, 25);
    private static final Color END_COLOR = new Color(200, 0, 80, 200);
    private Paint paint;

    public MouseDraggedPaintableShape(Point start, Point end, double tx, double ty) {
        super(tx, ty);
        this.color = new Color(200, 0, 80, 147);
        this.stroke = new BasicStroke(15.0f);
        int x1 = start.x;
        int y1 = start.y;
        int x2 = end.x;
        int y2 = end.y;
        int w = Math.abs(x2 - x1);
        int h = Math.abs(y2 - y1);
        if (w == 0) {
            ++x2;
        }
        if (h == 0) {
            ++y2;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(x1, y1, w, h);
        rect.setFrameFromDiagonal(x1, y1, x2, y2);
        this.rebuildPaint(start, end);
        this.shape = rect;
    }

    public void setPoints(Point start, Point end) {
        int x1 = start.x;
        int y1 = start.y;
        int x2 = end.x;
        int y2 = end.y;
        int w = Math.abs(x2 - x1);
        int h = Math.abs(y2 - y1);
        if (w == 0) {
            ++x2;
        }
        if (h == 0) {
            ++y2;
        }
        Rectangle2D rect = (Rectangle2D)this.shape;
        rect.setFrameFromDiagonal(x1, y1, x2, y2);
        this.rebuildPaint(start, end);
    }

    private void rebuildPaint(Point start, Point end) {
        this.paint = new GradientPaint(start.x, start.y, START_COLOR, end.x, end.y, END_COLOR, true);
    }

    @Override
    public void paint(Graphics2D g) {
        g.setPaint(this.paint);
        g.setStroke(this.stroke);
        g.fill(this.shape);
    }
}

