/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.editors;

import docking.DialogComponentProvider;
import docking.widgets.label.GDLabel;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemDestinationAddressEditStatus;
import ghidra.feature.vt.gui.editors.AddressEditorPanel;
import ghidra.feature.vt.gui.editors.AddressEditorPanelListener;
import ghidra.feature.vt.gui.editors.EditableAddress;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.program.model.address.Address;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

public class AddressInputDialog
extends AbstractCellEditor
implements TableCellEditor {
    private DialogComponentProvider dialog;
    private JTable table;
    private Address address;
    private final VTController controller;

    public AddressInputDialog(VTController controller) {
        this.controller = controller;
    }

    @Override
    public Component getTableCellEditorComponent(JTable theTable, Object value, boolean isSelected, int row, int column) {
        this.table = theTable;
        EditableAddress editableAddress = (EditableAddress)value;
        this.address = editableAddress.getAddress();
        GDLabel label = new GDLabel();
        label.setBorder(BorderFactory.createBevelBorder(1));
        label.setText(editableAddress.getDisplayString());
        VTMarkupItem markupItem = editableAddress.getMarkupItem();
        VTMarkupItemDestinationAddressEditStatus status = markupItem.getDestinationAddressEditStatus();
        if (status != VTMarkupItemDestinationAddressEditStatus.EDITABLE) {
            final String description = status.getDescription();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AddressInputDialog.this.fireEditingCanceled();
                    Msg.showInfo(this.getClass(), (Component)AddressInputDialog.this.table, (String)"Cannot Edit Destination Address", (Object)description);
                }
            });
            return label;
        }
        this.dialog = new DialogProvider(editableAddress);
        this.dialog.setRememberSize(false);
        SwingUtilities.invokeLater(new Runnable((JLabel)label){
            final /* synthetic */ JLabel val$label;
            {
                this.val$label = jLabel;
            }

            @Override
            public void run() {
                AddressInputDialog.this.controller.getTool().showDialog(AddressInputDialog.this.dialog, (Component)this.val$label);
                AddressInputDialog.this.stopCellEditing();
            }
        });
        return label;
    }

    @Override
    public void cancelCellEditing() {
        if (this.dialog instanceof DialogProvider) {
            ((DialogProvider)this.dialog).cancelCallback();
        }
    }

    @Override
    public Object getCellEditorValue() {
        return ((DialogProvider)this.dialog).getAddress();
    }

    @Override
    public boolean stopCellEditing() {
        ListSelectionModel columnSelectionModel = this.table.getColumnModel().getSelectionModel();
        columnSelectionModel.setValueIsAdjusting(true);
        int columnAnchor = columnSelectionModel.getAnchorSelectionIndex();
        int columnLead = columnSelectionModel.getLeadSelectionIndex();
        this.dialog.close();
        Address newAddress = null;
        if (this.dialog instanceof DialogProvider) {
            newAddress = ((DialogProvider)this.dialog).getAddress();
        }
        if (newAddress == null) {
            this.fireEditingCanceled();
            return true;
        }
        if (newAddress.equals((Object)this.address)) {
            this.fireEditingCanceled();
            return true;
        }
        this.address = newAddress;
        this.fireEditingStopped();
        columnSelectionModel.setAnchorSelectionIndex(columnAnchor);
        columnSelectionModel.setLeadSelectionIndex(columnLead);
        columnSelectionModel.setValueIsAdjusting(false);
        return true;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= 2;
        }
        return true;
    }

    private class DialogProvider
    extends DialogComponentProvider
    implements AddressEditorPanelListener {
        private EditableAddress editableAddress;
        private Address editedAddress;
        private AddressEditorPanel editorPanel;

        protected DialogProvider(EditableAddress address) {
            super(address.getEditorTitle(), true, true, true, false);
            this.editableAddress = address;
            this.editorPanel = this.editableAddress.getEditorPanel();
            this.editorPanel.setAddressPanelListener(this);
            this.addWorkPanel(this.editorPanel);
            this.addOKButton();
            this.addCancelButton();
        }

        protected void cancelCallback() {
            super.cancelCallback();
        }

        protected void okCallback() {
            try {
                Address newAddress;
                this.editedAddress = newAddress = this.editorPanel.getAddress();
                this.close();
            }
            catch (InvalidInputException e) {
                this.setStatusText(e.getMessage());
            }
        }

        Address getAddress() {
            return this.editedAddress;
        }

        @Override
        public void addressEdited() {
            this.okCallback();
        }
    }
}

