/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.textfield;

import docking.util.GraphicsUtils;
import ghidra.util.SystemUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LocalDateTextField {
    private JTextField textField;
    private LocalDate minimum;
    private LocalDate maximum;
    private DateTimeFormatter dateFormat = null;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static final String MONTH_LABEL = "Month";
    private static final String DAY_LABEL = "Day";
    private boolean isMonthMode = false;
    private boolean showFieldDecoration = true;

    public LocalDateTextField(String dateFormatPattern) {
        this.textField = new MyTextField();
        this.dateFormat = DateTimeFormatter.ofPattern(dateFormatPattern);
        this.setDayMode();
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                LocalDateTextField.this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                LocalDateTextField.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LocalDateTextField.this.update();
            }
        });
    }

    private void update() {
        SystemUtilities.runSwingLater(() -> this.notifyListeners());
    }

    private void notifyListeners() {
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(null);
        }
    }

    public void setMinimum(LocalDate minimum) {
        this.minimum = minimum;
    }

    public void setMaximum(LocalDate maximum) {
        this.maximum = maximum;
    }

    public void setValue(LocalDate newDate) {
        if (newDate == null) {
            return;
        }
        if (this.minimum != null && this.minimum.compareTo(newDate) > 0) {
            throw new IllegalArgumentException("value is before the minimum allowed date!");
        }
        if (this.maximum != null && this.maximum.compareTo(newDate) < 0) {
            throw new IllegalArgumentException("value is after the maximum allowed date!");
        }
        if (!newDate.equals(this.getValue())) {
            this.setText(this.dateFormat.format(newDate));
        }
    }

    public LocalDate getValue() {
        String str = this.textField.getText();
        try {
            return LocalDate.parse(str, this.dateFormat);
        }
        catch (DateTimeParseException pe) {
            return null;
        }
    }

    public LocalDate getMinimum() {
        return this.minimum;
    }

    public LocalDate getMaximum() {
        return this.maximum;
    }

    public void setShowFieldMode(boolean show) {
        this.showFieldDecoration = show;
        this.textField.repaint();
    }

    public boolean isShowingFieldMode() {
        return this.showFieldDecoration;
    }

    public void setMonthMode() {
        this.isMonthMode = true;
        this.textField.repaint();
    }

    public void setDayMode() {
        this.isMonthMode = false;
        this.textField.repaint();
    }

    private void setText(String str) {
        this.textField.setText(str);
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public JComponent getComponent() {
        return this.textField;
    }

    public void setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
    }

    public void requestFocus() {
        this.textField.requestFocus();
    }

    public void selectAll() {
        this.textField.selectAll();
    }

    public void addActionListener(ActionListener listener) {
        this.textField.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.textField.removeActionListener(listener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private class MyTextField
    extends JTextField {
        private MyTextField() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (LocalDateTextField.this.showFieldDecoration) {
                Font font = new Font("Monospaced", 0, 10);
                Font savedFont = g.getFont();
                g.setFont(font);
                g.setColor(Color.LIGHT_GRAY);
                FontMetrics fontMetrics = this.getFontMetrics(font);
                String label = LocalDateTextField.this.isMonthMode ? LocalDateTextField.MONTH_LABEL : LocalDateTextField.DAY_LABEL;
                int stringWidth = fontMetrics.stringWidth(label);
                Dimension size = this.getSize();
                Insets insets = this.getInsets();
                int x = size.width - insets.right - stringWidth;
                int y = size.height - insets.bottom;
                GraphicsUtils.drawString((JComponent)this, g, label, x, y);
                g.setFont(savedFont);
            }
        }
    }
}

