/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint.dialog;

import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicColumnTableModel;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.RowObjectFilterModel;
import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.ColumnTypeMapper;
import ghidra.docking.settings.Settings;
import ghidra.util.table.column.GColumnRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class ColumnFilterData<T>
implements Comparable<ColumnFilterData<T>> {
    private final String name;
    private final int modelIndex;
    private final List<ColumnConstraint<T>> applicableConstraints;
    private int viewIndex;

    public ColumnFilterData(RowObjectFilterModel<?> model, int columnModelIndex, int columnViewIndex, Class<T> columnClass) {
        this.modelIndex = columnModelIndex;
        this.viewIndex = columnViewIndex;
        this.name = model.getColumnName(columnModelIndex);
        this.applicableConstraints = this.initializeConstraints(model, columnClass);
    }

    private List<ColumnConstraint<T>> initializeConstraints(RowObjectFilterModel<?> model, Class<T> columnClass) {
        Collection<ColumnConstraint<T>> defaultConstraints = DiscoverableTableUtils.getColumnConstraints(columnClass);
        if (!(model instanceof DynamicColumnTableModel)) {
            return new ArrayList<ColumnConstraint<T>>(defaultConstraints);
        }
        DynamicColumnTableModel columnBasedModel = (DynamicColumnTableModel)((Object)model);
        DynamicTableColumn column = columnBasedModel.getColumn(this.modelIndex);
        GColumnRenderer<?> columnRenderer = column.getColumnRenderer();
        if (columnRenderer == null) {
            return new ArrayList<ColumnConstraint<T>>(defaultConstraints);
        }
        GColumnRenderer.ColumnConstraintFilterMode mode = columnRenderer.getColumnConstraintFilterMode();
        if (mode == GColumnRenderer.ColumnConstraintFilterMode.ALLOW_CONSTRAINTS_FILTER_ONLY) {
            return new ArrayList<ColumnConstraint<T>>(defaultConstraints);
        }
        GColumnRenderer<?> asT = columnRenderer;
        ColumnRendererMapper mapper = new ColumnRendererMapper(asT, columnBasedModel, this.modelIndex);
        Collection rendererStringConstraints = DiscoverableTableUtils.getColumnConstraints(mapper);
        if (mode == GColumnRenderer.ColumnConstraintFilterMode.ALLOW_RENDERER_STRING_FILTER_ONLY) {
            return new ArrayList(rendererStringConstraints);
        }
        ArrayList results = new ArrayList(rendererStringConstraints);
        results.addAll(defaultConstraints);
        return results;
    }

    public void setViewIndex(int viewIndex) {
        this.viewIndex = viewIndex;
    }

    public int getViewIndex() {
        return this.viewIndex;
    }

    public boolean isFilterable() {
        return !this.applicableConstraints.isEmpty();
    }

    public ColumnConstraint<?>[] getConstraints() {
        return (ColumnConstraint[])this.applicableConstraints.stream().toArray(ColumnConstraint[]::new);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "{\n\tname: " + this.name + ",\n\tmodelColumn" + this.modelIndex + ",\n\tviewColumn: " + this.viewIndex + ",\n\tconstraints: " + CollectionUtils.collect(this.applicableConstraints, c -> c.asString()) + "\n}";
    }

    public ColumnConstraint<T> getConstraint(String constraintName) {
        for (ColumnConstraint<T> columnConstraint : this.applicableConstraints) {
            if (!columnConstraint.getName().equals(constraintName)) continue;
            return columnConstraint;
        }
        return null;
    }

    public int getColumnModelIndex() {
        return this.modelIndex;
    }

    public ColumnConstraint<T> getFirstConstraint() {
        return this.applicableConstraints.get(0);
    }

    @Override
    public int compareTo(ColumnFilterData<T> o) {
        return this.viewIndex - o.viewIndex;
    }

    public void replace(ColumnConstraint<T> value) {
        this.applicableConstraints.replaceAll(v -> {
            if (v.getName().equals(value.getName())) {
                return value;
            }
            return v;
        });
    }

    private class ColumnRendererMapper
    extends ColumnTypeMapper<T, String> {
        private GColumnRenderer<T> renderer;
        private DynamicColumnTableModel<?> model;
        private int columnModelIndex;

        ColumnRendererMapper(GColumnRenderer<T> renderer, DynamicColumnTableModel<?> model, int columnModelIndex) {
            this.renderer = renderer;
            this.model = model;
            this.columnModelIndex = columnModelIndex;
        }

        @Override
        public String convert(T value) {
            if (value == null) {
                return null;
            }
            Settings settings = this.model.getColumnSettings(this.columnModelIndex);
            String s = this.renderer.getFilterString(value, settings);
            return s;
        }
    }
}

