/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.dbgeng.DebugSystemObjects;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;

public class DbgThreadHoldCommand
extends AbstractDbgCommand<Void> {
    static final String FREEZE_ALL_THREADS_COMMAND = "~* f";
    static final String FREEZE_CURRENT_THREAD_COMMAND = "~. f";
    static final String UNFREEZE_CURRENT_THREAD_COMMAND = "~. u";
    static final String UNFREEZE_ALL_THREADS_COMMAND = "~* u";
    static final String SUSPEND_ALL_THREADS_COMMAND = "~* n";
    static final String SUSPEND_CURRENT_THREAD_COMMAND = "~. n";
    static final String RESUME_CURRENT_THREAD_COMMAND = "~. m";
    static final String RESUME_ALL_THREADS_COMMAND = "~* m";
    static final Boolean preferFreeze = true;
    private DbgThread thread;
    private Boolean set;

    public DbgThreadHoldCommand(DbgManagerImpl manager, DbgThread thread, Boolean set) {
        super(manager);
        this.thread = thread;
        this.set = set;
    }

    @Override
    public void invoke() {
        DebugThreadId id = this.thread.getId();
        if (id != null) {
            DebugSystemObjects so = this.manager.getSystemObjects();
            DebugThreadId previous = so.getCurrentThreadId();
            so.setCurrentThreadId(id);
            if (!this.manager.isKernelMode()) {
                DebugControl control = this.manager.getControl();
                if (preferFreeze.booleanValue()) {
                    control.execute(this.set != false ? FREEZE_CURRENT_THREAD_COMMAND : UNFREEZE_CURRENT_THREAD_COMMAND);
                } else {
                    control.execute(this.set != false ? SUSPEND_CURRENT_THREAD_COMMAND : RESUME_CURRENT_THREAD_COMMAND);
                }
            }
            so.setCurrentThreadId(previous);
        }
    }
}

