/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.splitWord;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.ansj.domain.Result;
import org.ansj.domain.Term;
import org.ansj.domain.TermNature;
import org.ansj.domain.TermNatures;
import org.ansj.library.AmbiguityLibrary;
import org.ansj.library.DATDictionary;
import org.ansj.library.DicLibrary;
import org.ansj.splitWord.impl.GetWordsImpl;
import org.ansj.util.AnsjReader;
import org.ansj.util.Graph;
import org.ansj.util.MyStaticValue;
import org.nlpcn.commons.lang.tire.GetWord;
import org.nlpcn.commons.lang.tire.domain.Forest;
import org.nlpcn.commons.lang.util.StringUtil;
import org.nlpcn.commons.lang.util.WordAlert;

public abstract class Analysis {
    public int offe;
    private GetWordsImpl gwi = new GetWordsImpl();
    protected Forest[] forests = null;
    private Forest ambiguityForest = AmbiguityLibrary.get();
    protected Boolean isNameRecognition = true;
    protected Boolean isNumRecognition = true;
    protected Boolean isQuantifierRecognition = true;
    protected Boolean isRealName = false;
    private AnsjReader br;
    private LinkedList<Term> terms = new LinkedList();

    protected Analysis() {
        this.forests = new Forest[]{DicLibrary.get()};
        this.isNameRecognition = MyStaticValue.isNameRecognition;
        this.isNumRecognition = MyStaticValue.isNumRecognition;
        this.isQuantifierRecognition = MyStaticValue.isQuantifierRecognition;
        this.isRealName = MyStaticValue.isRealName;
    }

    public Term next() throws IOException {
        Term term = null;
        if (!this.terms.isEmpty()) {
            term = this.terms.poll();
            term.updateOffe(this.offe);
            return term;
        }
        String temp = this.br.readLine();
        this.offe = this.br.getStart();
        while (StringUtil.isBlank((CharSequence)temp)) {
            if (temp == null) {
                return null;
            }
            temp = this.br.readLine();
        }
        this.fullTerms(temp);
        if (!this.terms.isEmpty()) {
            term = this.terms.poll();
            term.updateOffe(this.offe);
            return term;
        }
        return null;
    }

    private void fullTerms(String temp) {
        List<Term> result = this.analysisStr(temp);
        this.terms.addAll(result);
    }

    private List<Term> analysisStr(String temp) {
        Graph gp = new Graph(temp);
        int startOffe = 0;
        if (this.ambiguityForest != null) {
            GetWord gw = new GetWord(this.ambiguityForest, gp.chars);
            String[] params = null;
            while (gw.getFrontWords() != null) {
                if (gw.offe > startOffe) {
                    this.analysis(gp, startOffe, gw.offe);
                }
                params = gw.getParams();
                startOffe = gw.offe;
                for (int i = 0; i < params.length; i += 2) {
                    gp.addTerm(new Term(params[i], startOffe, new TermNatures(new TermNature(params[i + 1], 1))));
                    startOffe += params[i].length();
                }
            }
        }
        if (startOffe < gp.chars.length) {
            this.analysis(gp, startOffe, gp.chars.length);
        }
        List<Term> result = this.getResult(gp);
        return result;
    }

    private void analysis(Graph gp, int startOffe, int endOffe) {
        int start = 0;
        int end = 0;
        char[] chars = gp.chars;
        String str = null;
        block4: for (int i = startOffe; i < endOffe; ++i) {
            switch (DATDictionary.status(chars[i])) {
                case 4: {
                    start = i;
                    end = 1;
                    while (++i < endOffe && DATDictionary.status(chars[i]) == 4) {
                        ++end;
                    }
                    str = WordAlert.alertEnglish((char[])chars, (int)start, (int)end);
                    gp.addTerm(new Term(str, start, TermNatures.EN));
                    --i;
                    continue block4;
                }
                case 5: {
                    start = i;
                    end = 1;
                    while (++i < endOffe && DATDictionary.status(chars[i]) == 5) {
                        ++end;
                    }
                    str = WordAlert.alertNumber((char[])chars, (int)start, (int)end);
                    gp.addTerm(new Term(str, start, TermNatures.M));
                    --i;
                    continue block4;
                }
                default: {
                    start = i;
                    end = i;
                    int status = 0;
                    do {
                        end = ++i;
                    } while (i < endOffe && (status = DATDictionary.status(chars[i])) < 4);
                    if (status > 3) {
                        --i;
                    }
                    this.gwi.setChars(chars, start, end);
                    int max = start;
                    while ((str = this.gwi.allWords()) != null) {
                        Term term = new Term(str, this.gwi.offe, this.gwi.getItem());
                        int len = term.getOffe() - max;
                        if (len > 0) {
                            while (max < term.getOffe()) {
                                gp.addTerm(new Term(String.valueOf(chars[max]), max, TermNatures.NULL));
                                ++max;
                            }
                        }
                        gp.addTerm(term);
                        max = term.toValue();
                    }
                    int len = end - max;
                    if (len <= 0) continue block4;
                    while (max < end) {
                        gp.addTerm(new Term(String.valueOf(chars[max]), max, TermNatures.NULL));
                        ++max;
                    }
                    break block0;
                }
            }
        }
    }

    protected void setRealName(Graph graph, List<Term> result) {
        if (!MyStaticValue.isRealName.booleanValue()) {
            return;
        }
        String str = graph.realStr;
        for (Term term : result) {
            term.setRealName(str.substring(term.getOffe(), term.getOffe() + term.getName().length()));
        }
    }

    public Result parseStr(String temp) {
        return new Result(this.analysisStr(temp));
    }

    public Result parse() throws IOException {
        ArrayList<Term> list = new ArrayList<Term>();
        Term temp = null;
        while ((temp = this.next()) != null) {
            list.add(temp);
        }
        Result result = new Result(list);
        return result;
    }

    protected abstract List<Term> getResult(Graph var1);

    public void resetContent(AnsjReader br) {
        this.offe = 0;
        this.br = br;
    }

    public void resetContent(Reader reader) {
        this.offe = 0;
        this.br = new AnsjReader(reader);
    }

    public void resetContent(Reader reader, int buffer) {
        this.offe = 0;
        this.br = new AnsjReader(reader, buffer);
    }

    public Forest getAmbiguityForest() {
        return this.ambiguityForest;
    }

    public Analysis setAmbiguityForest(Forest ambiguityForest) {
        this.ambiguityForest = ambiguityForest;
        return this;
    }

    public Analysis setForests(Forest ... forests) {
        this.forests = forests;
        return this;
    }

    public Analysis setIsNameRecognition(Boolean isNameRecognition) {
        this.isNameRecognition = isNameRecognition;
        return this;
    }

    public Analysis setIsNumRecognition(Boolean isNumRecognition) {
        this.isNumRecognition = isNumRecognition;
        return this;
    }

    public Analysis setIsQuantifierRecognition(Boolean isQuantifierRecognition) {
        this.isQuantifierRecognition = isQuantifierRecognition;
        return this;
    }

    public Analysis setIsRealName(Boolean isRealName) {
        this.isRealName = isRealName;
        return this;
    }

    public abstract class Merger {
        public abstract List<Term> merger();
    }
}

