/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.dic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ansj.app.crf.SplitWord;
import org.ansj.domain.Nature;
import org.ansj.domain.NewWord;
import org.ansj.domain.TermNatures;
import org.ansj.recognition.arrimpl.AsianPersonRecognition;
import org.ansj.recognition.arrimpl.ForeignPersonRecognition;
import org.ansj.recognition.impl.NatureRecognition;
import org.ansj.util.Graph;
import org.nlpcn.commons.lang.tire.domain.Forest;
import org.nlpcn.commons.lang.tire.domain.SmartForest;
import org.nlpcn.commons.lang.util.CollectionUtil;

public class LearnTool {
    private SplitWord splitWord = null;
    public boolean isAsianName = true;
    public boolean isForeignName = true;
    public int count;
    private final SmartForest<NewWord> sf = new SmartForest();
    private Forest[] forests;

    public void learn(Graph graph, SplitWord splitWord, Forest ... forests) {
        this.splitWord = splitWord;
        this.forests = forests;
        if (this.isAsianName) {
            this.findAsianPerson(graph);
        }
        if (this.isForeignName) {
            this.findForeignPerson(graph);
        }
    }

    private void findAsianPerson(Graph graph) {
        List<NewWord> newWords = new AsianPersonRecognition().getNewWords(graph.terms);
        this.addListToTerm(newWords);
    }

    private void findForeignPerson(Graph graph) {
        List<NewWord> newWords = new ForeignPersonRecognition().getNewWords(graph.terms);
        this.addListToTerm(newWords);
    }

    private void addListToTerm(List<NewWord> newWords) {
        if (newWords.size() == 0) {
            return;
        }
        for (NewWord newWord : newWords) {
            TermNatures termNatures = new NatureRecognition(this.forests).getTermNatures(newWord.getName());
            if (termNatures != TermNatures.NULL) continue;
            this.addTerm(newWord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTerm(NewWord newWord) {
        NewWord temp = null;
        SmartForest smartForest = null;
        smartForest = this.sf.getBranch(newWord.getName());
        if (smartForest != null && smartForest.getParam() != null) {
            temp = (NewWord)smartForest.getParam();
            temp.update(newWord.getNature(), newWord.getAllFreq());
        } else {
            ++this.count;
            if (this.splitWord == null) {
                newWord.setScore(-1.0);
            } else {
                newWord.setScore(-this.splitWord.cohesion(newWord.getName()));
            }
            SmartForest<NewWord> smartForest2 = this.sf;
            synchronized (smartForest2) {
                this.sf.add(newWord.getName(), (Object)newWord);
            }
        }
    }

    public SmartForest<NewWord> getForest() {
        return this.sf;
    }

    public List<Map.Entry<String, Double>> getTopTree(int num) {
        return this.getTopTree(num, null);
    }

    public List<Map.Entry<String, Double>> getTopTree(int num, Nature nature) {
        if (this.sf.branches == null) {
            return null;
        }
        HashMap<String, Double> hm = new HashMap<String, Double>();
        for (int i = 0; i < this.sf.branches.length; ++i) {
            this.valueResult((SmartForest<NewWord>)this.sf.branches[i], hm, nature);
        }
        List sortMapByValue = CollectionUtil.sortMapByValue(hm, (int)-1);
        if (num == 0) {
            return sortMapByValue;
        }
        num = Math.min(num, sortMapByValue.size());
        return sortMapByValue.subList(0, num);
    }

    private void valueResult(SmartForest<NewWord> smartForest, HashMap<String, Double> hm, Nature nature) {
        if (smartForest == null || smartForest.branches == null) {
            return;
        }
        for (int i = 0; i < smartForest.branches.length; ++i) {
            NewWord param = (NewWord)smartForest.branches[i].getParam();
            if (smartForest.branches[i].getStatus() == 3) {
                if (!param.isActive() || nature != null && !param.getNature().equals(nature)) continue;
                hm.put(param.getName(), param.getScore());
                continue;
            }
            if (smartForest.branches[i].getStatus() == 2) {
                if (param.isActive() && (nature == null || param.getNature().equals(nature))) {
                    hm.put(param.getName(), param.getScore());
                }
                this.valueResult((SmartForest<NewWord>)smartForest.branches[i], hm, nature);
                continue;
            }
            this.valueResult((SmartForest<NewWord>)smartForest.branches[i], hm, nature);
        }
    }

    public void active(String name) {
        SmartForest branch = this.sf.getBranch(name);
        if (branch != null && branch.getParam() != null) {
            ((NewWord)branch.getParam()).setActive(true);
        }
    }
}

