/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sequence.editor;

import com.informagen.sequence.editor.Editor;

class Model {
    private StringBuffer text = null;
    private Editor editor;
    private int cursor;
    private int selectStart;
    private int selectEnd;
    private String alphabet;

    Model(Editor editor, String string) {
        this.editor = editor;
        this.alphabet = string;
        this.text = new StringBuffer();
    }

    void clear() {
        this.text.setLength(0);
        this.setPosition(0);
        this.reportNoTextObject();
    }

    void setText(String string) {
        this.text.setLength(0);
        this.setPosition(0);
        this.insert(string);
        this.setPosition(0);
        this.reportTextChanged();
    }

    void setAlphabet(String string) {
        this.alphabet = string;
    }

    int getLength() {
        return this.text.length();
    }

    int getPosition() {
        return this.cursor;
    }

    void setPosition(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > this.text.length()) {
            n = this.text.length();
        }
        this.cursor = n;
        this.setSelection(this.cursor, this.cursor);
        this.reportTextChanged();
    }

    void setSelection(int n, int n2) {
        this.selectStart = n < n2 ? n : n2;
        this.selectEnd = n2 > n ? n2 : n;
        this.reportSelectionChanged(n, n2);
    }

    private void reportPositionChanged(int n) {
        this.editor.modelPositionChanged(n);
    }

    private void reportTextChanged() {
        this.editor.modelTextChanged();
    }

    private void reportNoTextObject() {
        this.editor.modelHasNoObject();
    }

    private void reportSelectionChanged(int n, int n2) {
        this.editor.modelSelectionChanged(n, n2);
    }

    void doUppercase() {
        if (this.hasSelection()) {
            String string = this.text.substring(this.selectStart, this.selectEnd);
            string = string.toUpperCase();
            this.text.replace(this.selectStart, this.selectEnd, string);
            this.setText(this.text.toString());
        } else {
            this.setText(this.text.toString().toUpperCase());
        }
    }

    void doLowercase() {
        if (this.hasSelection()) {
            String string = this.text.substring(this.selectStart, this.selectEnd);
            string = string.toLowerCase();
            this.text.replace(this.selectStart, this.selectEnd, string);
            this.setText(this.text.toString());
        } else {
            this.setText(this.text.toString().toLowerCase());
        }
    }

    char[] getChars(int n, int n2) {
        char[] cArray = new char[n2];
        this.text.getChars(n, n + n2, cArray, 0);
        return cArray;
    }

    String getText() {
        return this.text.toString();
    }

    String getSelection() {
        if (this.selectStart == this.selectEnd) {
            return null;
        }
        return new String(this.getChars(this.selectStart, this.selectEnd - this.selectStart));
    }

    int[] getSelectionRange() {
        int[] nArray = new int[]{this.selectStart, this.selectEnd};
        return nArray;
    }

    boolean hasSelection() {
        return this.selectStart != this.selectEnd;
    }

    void deleteSelection() {
        this.deleteSection(this.selectStart, this.selectEnd);
    }

    void insert(char c) {
        if (!this.isValid(c)) {
            return;
        }
        this.text.insert(this.cursor++, c);
        this.setPosition(this.cursor);
        this.reportTextChanged();
    }

    void delete_prev_char() {
        if (this.cursor == 0) {
            return;
        }
        int n = this.text.length();
        int n2 = n - this.cursor;
        if (n2 > 0) {
            char[] cArray = new char[n2];
            this.text.getChars(this.cursor, n, cArray, 0);
            this.text.setLength(this.cursor - 1);
            this.text.append(cArray);
        } else {
            this.text.setLength(n - 1);
        }
        --this.cursor;
        this.setPosition(this.cursor);
        this.reportTextChanged();
    }

    void delete_next_char() {
        if (this.cursor >= this.text.length()) {
            return;
        }
        int n = this.text.length();
        int n2 = n - this.cursor - 1;
        if (n2 > 0) {
            char[] cArray = new char[n2];
            this.text.getChars(this.cursor + 1, n - 1, cArray, 0);
            this.text.setLength(this.cursor);
            this.text.append(cArray);
        }
        this.text.setLength(this.cursor + n2);
        this.setPosition(this.cursor);
        this.reportTextChanged();
    }

    boolean isValid(char c) {
        if (this.alphabet == null) {
            return false;
        }
        return this.alphabet.indexOf(c) != -1;
    }

    int insert(String string) {
        if (string == null) {
            return this.cursor;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!this.isValid(c)) continue;
            stringBuffer.append(c);
        }
        if (stringBuffer.length() > 0) {
            this.text.insert(this.cursor, stringBuffer);
            this.setPosition(this.cursor + stringBuffer.length());
            this.reportTextChanged();
        }
        return this.cursor;
    }

    void deleteSection(int n, int n2) {
        int n3 = this.text.length();
        int n4 = n3 - n2;
        if (n4 > 0) {
            char[] cArray = new char[n4];
            this.text.getChars(n2, n3, cArray, 0);
            this.text.setLength(n);
            this.text.append(cArray);
        } else {
            this.text.setLength(n);
        }
        this.setPosition(n);
        this.reportTextChanged();
    }
}

