/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.pI;

import com.informagen.F;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JPanel;

public class IsoElectricGraph
extends JPanel {
    static final Font titleFont = new Font("SansSerif", 1, 16);
    static final Font graphFont = new Font("SansSerif", 0, 12);
    private static final int UP = 1;
    private static final int DOWN = -1;
    private String title = null;
    private double[][] data = null;
    private double isoelectricPoint = Double.NaN;

    public IsoElectricGraph() {
        this((double[][])null);
    }

    public IsoElectricGraph(double[][] dArray) {
        this(dArray, "Isoelectric Point Graph");
    }

    public IsoElectricGraph(double[][] dArray, String string) {
        this.setBackground(Color.white);
        this.setTitle(string);
        if (dArray != null) {
            this.setData(dArray);
        }
    }

    public void setTitle(String string) {
        this.title = string;
        this.repaint();
    }

    public void setData(double[][] dArray) {
        this.data = dArray;
        this.isoelectricPoint = this.calculateIsoelectric();
        this.repaint();
    }

    public double getIsoElectricPoint() {
        return this.isoelectricPoint;
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 350);
    }

    private double calculateIsoelectric() {
        double d = Double.NaN;
        if (this.data == null) {
            return d;
        }
        if (this.data.length > 1 && this.data[0][1] > 0.0 && this.data[this.data.length - 1][1] < 0.0) {
            double d2 = this.data[0][0];
            double d3 = this.data[0][1];
            int n = 1;
            while (this.data[n][1] > 0.0) {
                d2 = this.data[n][0];
                d3 = this.data[n][1];
                ++n;
            }
            double d4 = this.data[n][0] - d2;
            double d5 = this.data[n][1] - d3;
            try {
                d = d2 - d3 * d4 / d5;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }

    private int findMaxValue(int n) {
        if (this.data == null) {
            return 10;
        }
        double d = Double.MIN_VALUE;
        for (int i = 0; i < this.data.length; ++i) {
            d = d < this.data[i][n] ? this.data[i][n] : d;
        }
        return this.findBoundary(d, 1);
    }

    private int findMinValue(int n) {
        if (this.data == null) {
            return -10;
        }
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.data.length; ++i) {
            d = d > this.data[i][n] ? this.data[i][n] : d;
        }
        return this.findBoundary(d, -1);
    }

    private int findBoundary(double d, int n) {
        int n2 = 1;
        while (Math.abs(d / (double)n2) > 10.0) {
            n2 *= 10;
        }
        int n3 = (int)(d / (double)n2) + n;
        return n3 * n2;
    }

    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        int n4 = 15;
        int n5 = 10;
        boolean bl = false;
        int n6 = 14;
        int n7 = this.findMinValue(1);
        int n8 = this.findMaxValue(1);
        graphics.setFont(titleFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n9 = 5 + fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        graphics.drawString(this.title, (dimension.width - fontMetrics.stringWidth(this.title)) / 2, n5 + 2 + fontMetrics.getMaxAscent());
        graphics.setFont(graphFont);
        fontMetrics = graphics.getFontMetrics();
        int n10 = fontMetrics.stringWidth(Integer.toString(n8));
        if (n10 < fontMetrics.stringWidth(Integer.toString(n7))) {
            n10 = fontMetrics.stringWidth(Integer.toString(n7));
        }
        int n11 = n10 + 5;
        int n12 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 5;
        int n13 = dimension.width - 2 * n4 - n11;
        int n14 = dimension.height - 2 * n5 - n12 - n9;
        graphics.drawRect(n4 + n11, n5 + n9, n13, n14);
        int n15 = 0;
        int n16 = 1;
        while (Math.abs(n8 / n16) > 10) {
            n16 *= 10;
        }
        int n17 = 1;
        while (Math.abs(n7 / n17) > 10) {
            n17 *= 10;
        }
        if (n17 == n16) {
            n15 = n17;
        } else {
            n3 = n17;
            n2 = n16;
            if (n16 < n17) {
                n3 = n16;
                n2 = n17;
            }
            n15 = (n8 - n7) / n3 < 16 ? n3 : ((n8 - n7) / n2 > 5 ? n2 : n2 / 2);
        }
        if (n7 % n15 != 0) {
            n7 = n7 < 0 ? -n15 : 0;
        }
        n3 = (n8 - n7) / n15;
        n2 = n14 / n3;
        int n18 = n7;
        int n19 = fontMetrics.getMaxAscent() / 2;
        int n20 = n4 + n11;
        int n21 = n5 + n14 + n9;
        for (n = 1; n <= n3; ++n) {
            n21 = n5 + n14 - n * n2 + n9;
            n18 = n7 + n * n15;
            graphics.drawLine(n20, n21, n20 + 3, n21);
            graphics.drawString(Integer.toString(n18), n20 - n11, n21 + n19);
        }
        n = n13 / 14;
        n20 = n4 + n11;
        n21 = n5 + n14 + n9;
        String string = "0.0";
        int n22 = 0;
        for (int i = 0; i <= 14; ++i) {
            string = Integer.toString(i) + ".0";
            n22 = fontMetrics.stringWidth(string) / 2;
            graphics.drawLine(n20, n21, n20, n21 - 3);
            graphics.drawString(string, n20 - n22, n21 + fontMetrics.getMaxAscent() + 2);
            n20 += n;
        }
        double d = 0.0;
        int n23 = 0;
        int n24 = n5 + n14 + n9;
        int n25 = 0;
        int n26 = 0;
        if (this.data != null) {
            for (int i = 0; i < this.data.length; ++i) {
                n20 = (int)(this.data[i][0] * (double)n + (double)n4 + (double)n11);
                d = this.data[i][1] - (double)n7;
                n23 = (int)(d * (double)n2 / (double)n15);
                n21 = n24 - n23;
                graphics.drawLine(n20 - 3, n21, n20 + 3, n21);
                graphics.drawLine(n20, n21 - 3, n20, n21 + 3);
                if (i > 0) {
                    graphics.drawLine(n25, n26, n20, n21);
                }
                n25 = n20;
                n26 = n21;
            }
            graphics.drawLine(n25, n26, n20, n21);
            if (!Double.isNaN(this.isoelectricPoint)) {
                n20 = (int)(this.isoelectricPoint * (double)n + (double)n4 + (double)n11);
                d = -n7;
                n23 = (int)(d * (double)n2 / (double)n15);
                n21 = n24 - n23;
                graphics.setColor(Color.red);
                graphics.drawLine(n4 + n11, n21, n20, n21);
                graphics.drawLine(n20, n24, n20, n21);
                String string2 = "Isoelectric Point = " + F.f(this.isoelectricPoint, 4, 1);
                graphics.drawString(string2, n20 - fontMetrics.stringWidth(string2) - 3, n21 - 3);
            }
        }
    }
}

