/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.composition;

import com.informagen.F;
import com.informagen.Sequence;
import com.informagen.sa.Tm;
import com.informagen.sa.pI.IsoElectricPoint;

public class Composition {
    static StringBuffer buffer = new StringBuffer();
    static char[] array;
    static Sequence sequence;
    static int[] selection;

    static synchronized String composition(Sequence sequence, int[] nArray) {
        buffer.setLength(0);
        Composition.sequence = sequence;
        selection = nArray;
        String string = sequence.getSequence().toUpperCase();
        if (nArray != null) {
            string = string.substring(nArray[0], nArray[1]);
        }
        array = string.toCharArray();
        if (sequence.isProtein()) {
            Composition.doProtein();
        } else {
            Composition.doNucleotide();
        }
        return buffer.toString();
    }

    static void doProtein() {
        int n;
        int n2;
        int n3 = 10;
        short s = 2;
        buffer.append("\n");
        if (sequence.getUID() != null && sequence.getUID().length() > 0) {
            buffer.append(" ").append(sequence.getUID()).append("\n");
        }
        if (sequence.getTitle() != null && sequence.getTitle().length() > 0) {
            buffer.append(" ").append(sequence.getTitle()).append("\n");
        }
        buffer.append(" ").append(sequence.getDescription()).append("\n");
        if (selection != null) {
            buffer.append(" Selection: ").append(selection[0] + 1).append("-").append(selection[1]);
            buffer.append(", ").append(selection[1] - selection[0]).append("aa");
        }
        buffer.append("\n\n");
        int[] nArray = new int[21];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = 0;
        }
        for (n2 = 0; n2 < array.length; ++n2) {
            int n4 = Composition.aa2num(array[n2]);
            nArray[n4] = nArray[n4] + 1;
        }
        double d = sequence.molwt();
        int n5 = nArray[18] * 5690 + nArray[19] * 1280 + nArray[1] * 120;
        buffer.append("    Molecular weight: ").append(F.f(d, 12, 1).trim()).append(" Daltons\n");
        buffer.append("Ext. Coeff. at 280nm: ").append(n5).append("\n");
        buffer.append("            1 A(280): ");
        if (n5 != 0) {
            buffer.append(F.f(d / (double)n5, 12, 3).trim());
        } else {
            buffer.append("---");
        }
        buffer.append("\n");
        double[][] dArray = IsoElectricPoint.pIData(sequence, selection, 2.0, 12.0, 0.5);
        double d2 = IsoElectricPoint.calculateIsoelectric(dArray);
        if (new Double(d2).isNaN()) {
            buffer.append("               pI: ").append("----").append("\n\n");
        } else {
            buffer.append("               pI: ").append(F.f(d2, 8, 2).trim()).append("\n\n");
        }
        buffer.append(" Charge at pH\n");
        buffer.append(" ------------\n");
        int n6 = dArray.length / 3;
        for (n = 0; n < n6; ++n) {
            double d3 = dArray[n][0];
            double d4 = dArray[n][1];
            buffer.append("     ").append(F.f("pH=" + d3 + ":", 9, (short)2)).append(F.f(d4, 7, 2)).append("       ");
            d3 = dArray[n + n6][0];
            d4 = dArray[n + n6][1];
            buffer.append(F.f("pH=" + d3 + ":", 9, (short)2)).append(F.f(d4, 7, 2)).append("       ");
            d3 = dArray[n + n6 + n6][0];
            d4 = dArray[n + n6 + n6][1];
            buffer.append(F.f("pH=" + d3 + ":", 9, (short)2)).append(F.f(d4, 7, 2)).append("\n");
        }
        buffer.append("\n");
        buffer.append("\n");
        buffer.append(" Amino Acid Composition\n");
        buffer.append(" ----------------------\n");
        buffer.append("     A (Ala): ").append(F.f(nArray[0], n3, s));
        buffer.append("  I (Ile): ").append(F.f(nArray[7], n3, s));
        buffer.append("  R (Arg): ").append(F.f(nArray[14], n3, s)).append("\n");
        buffer.append("     C (Cys): ").append(F.f(nArray[1], n3, s));
        buffer.append("  K (Lys): ").append(F.f(nArray[8], n3, s));
        buffer.append("  S (Ser): ").append(F.f(nArray[15], n3, s)).append("\n");
        buffer.append("     D (Asp): ").append(F.f(nArray[2], n3, s));
        buffer.append("  L (Leu): ").append(F.f(nArray[9], n3, s));
        buffer.append("  T (Thr): ").append(F.f(nArray[16], n3, s)).append("\n");
        buffer.append("     E (Glu): ").append(F.f(nArray[3], n3, s));
        buffer.append("  M (Met): ").append(F.f(nArray[10], n3, s));
        buffer.append("  V (Val): ").append(F.f(nArray[17], n3, s)).append("\n");
        buffer.append("     F (Phe): ").append(F.f(nArray[4], n3, s));
        buffer.append("  N (Asn): ").append(F.f(nArray[11], n3, s));
        buffer.append("  W (Trp): ").append(F.f(nArray[18], n3, s)).append("\n");
        buffer.append("     G (Gly): ").append(F.f(nArray[5], n3, s));
        buffer.append("  P (Pro): ").append(F.f(nArray[12], n3, s));
        buffer.append("  Y (Tyr): ").append(F.f(nArray[19], n3, s)).append("\n");
        buffer.append("     H (His): ").append(F.f(nArray[6], n3, s));
        buffer.append("  Q (Gln): ").append(F.f(nArray[13], n3, s)).append("\n\n");
        buffer.append(F.f((Object)"Other: ", 32)).append(F.f(nArray[20], n3, s)).append("\n\n");
        n = nArray[8] + nArray[14];
        int n7 = nArray[2] + nArray[3];
        int n8 = nArray[0] + nArray[7] + nArray[9] + nArray[4] + nArray[18] + nArray[17];
        int n9 = nArray[11] + nArray[1] + nArray[13] + nArray[15] + nArray[16] + nArray[19];
        int n10 = array.length;
        double d5 = (double)n * 100.0 / (double)n10;
        buffer.append(F.f(n, 8)).append(F.f(d5, 6, 1)).append("%");
        buffer.append(" Basic(+) amino acids, (K,R)\n");
        d5 = (double)n7 * 100.0 / (double)n10;
        buffer.append(F.f(n7, 8)).append(F.f(d5, 6, 1)).append("%");
        buffer.append(" Acidic(-) amino acids, (D,E)\n");
        d5 = (double)n8 * 100.0 / (double)n10;
        buffer.append(F.f(n8, 8)).append(F.f(d5, 6, 1)).append("%");
        buffer.append(" Hydrophobic amino acids, (A,I,L,F,W,V)\n");
        d5 = (double)n9 * 100.0 / (double)n10;
        buffer.append(F.f(n9, 8)).append(F.f(d5, 6, 1)).append("%");
        buffer.append(" Hydrophilic amino acids, (N,C,Q,S,T,Y)\n");
    }

    static void doNucleotide() {
        int n;
        int n2;
        int n3;
        boolean bl = sequence.getSequence().indexOf("N") != -1 | sequence.getSequence().indexOf("n") != -1;
        int n4 = 10;
        short s = 2;
        int n5 = array.length;
        buffer.append("\n");
        if (sequence.getUID() != null && sequence.getUID().length() > 0) {
            buffer.append(" ").append(sequence.getUID()).append("\n");
        }
        if (sequence.getTitle() != null && sequence.getTitle().length() > 0) {
            buffer.append(" ").append(sequence.getTitle()).append("\n");
        }
        buffer.append(" ").append(sequence.getDescription()).append("\n");
        if (selection != null) {
            buffer.append(" Selection: ").append(selection[0] + 1).append("-").append(selection[1]);
            buffer.append(", ").append(selection[1] - selection[0]).append("bp");
        }
        buffer.append("\n\n");
        if (sequence.isDNA() && bl) {
            buffer.append("   NB - These values may not be correct as the sequence contains\n        bases designated as N.\n\n");
        }
        double d = 0.0;
        Sequence sequence = Composition.sequence.createClone();
        sequence.revComp();
        double d2 = sequence.molwt();
        double d3 = Composition.sequence.molwt();
        buffer.append(" Molecular weight,ss: ").append(F.f(d3, 12, 1).trim()).append(" Daltons");
        buffer.append("\n");
        buffer.append(" Molecular weight,ds: ").append(F.f(d3 + d2, 12, 1).trim()).append(" Daltons");
        buffer.append("\n");
        d = Composition.sequence.simpleTm();
        buffer.append("           Simple Tm: ");
        buffer.append(d > 110.0 || n5 <= 8 ? "----" : F.f(d, 12, 1).trim() + " \u00b0C");
        buffer.append("\n");
        if (Composition.sequence.isDNA()) {
            double d4;
            buffer.append("          Complex Tm: ");
            if (n5 > 8) {
                d4 = 50.0;
                double d5 = 50.0;
                d = Tm.seqtm(Composition.sequence.getSequence(), d4, d5);
                if (d != Tm.OLIGOTM_ERROR) {
                    buffer.append(F.f(d, 12, 1).trim() + " \u00b0C ");
                    buffer.append("(").append((int)d4).append(" nM [DNA], ");
                    buffer.append((int)d5).append(" mM [Na+])");
                } else {
                    buffer.append("----");
                }
            } else {
                buffer.append("----");
            }
            buffer.append("\n");
            d4 = Composition.sequence.simpleConc();
            buffer.append("  DNA conc. (simple): ").append(F.f(d4, 6, 1).trim()).append(" ug/OD\n");
            d4 = Composition.sequence.ugPerOD();
            buffer.append(" DNA conc. (complex): ").append(F.f(d4, 6, 1).trim()).append(" ug/OD\n");
        }
        buffer.append("\n");
        buffer.append(F.f("-", bl ? 75 : 62, (short)16)).append("\n");
        int[] nArray = new int[6];
        for (n3 = 0; n3 < nArray.length; ++n3) {
            nArray[n3] = 0;
        }
        for (n3 = 0; n3 < array.length; ++n3) {
            int n6 = Composition.nuc2num(array[n3]);
            nArray[n6] = nArray[n6] + 1;
        }
        buffer.append("\n");
        buffer.append("       A: ").append(F.f(nArray[0], n4, s));
        buffer.append("  C: ").append(F.f(nArray[1], n4, s));
        buffer.append("  G: ").append(F.f(nArray[2], n4, s));
        buffer.append("  T: ").append(F.f(nArray[3], n4, s));
        if (bl) {
            buffer.append("  N: ").append(F.f(nArray[4], n4, s));
        }
        buffer.append("\n\n");
        if (nArray[5] > 0) {
            buffer.append(F.f((Object)"Other: ", bl ? 42 : 32)).append(F.f(nArray[5], n4, s)).append("\n\n");
        }
        double d6 = (double)nArray[0] * 100.0 / (double)n5;
        buffer.append("       A: ").append(F.f(F.f(d6, 6, 1).trim() + "%", n4, s));
        d6 = (double)nArray[1] * 100.0 / (double)n5;
        buffer.append("  C: ").append(F.f(F.f(d6, 6, 1).trim() + "%", n4, s));
        d6 = (double)nArray[2] * 100.0 / (double)n5;
        buffer.append("  G: ").append(F.f(F.f(d6, 6, 1).trim() + "%", n4, s));
        d6 = (double)nArray[3] * 100.0 / (double)n5;
        buffer.append("  T: ").append(F.f(F.f(d6, 6, 1).trim() + "%", n4, s));
        if (bl) {
            d6 = (double)nArray[4] * 100.0 / (double)n5;
            buffer.append("  N: ").append(F.f(F.f(d6, 6, 1).trim() + "%", n4, s));
        }
        buffer.append("\n\n");
        if (nArray[5] > 0) {
            d6 = (double)nArray[5] * 100.0 / (double)n5;
            buffer.append(F.f((Object)"Other: ", bl ? 42 : 32)).append(F.f(F.f(d6, 6, 1).trim() + "%", n4, s)).append("\n\n");
        }
        d6 = (double)(nArray[0] + nArray[3]) * 100.0 / (double)n5;
        buffer.append(F.f((Object)"A+T: ", bl ? 38 : 28)).append(F.f(nArray[0] + nArray[3], 5, s));
        buffer.append(F.f(F.f(d6, 6, 1).trim() + "%", 6, s)).append("\n");
        d6 = (double)(nArray[1] + nArray[2]) * 100.0 / (double)n5;
        buffer.append(F.f((Object)"C+G: ", bl ? 38 : 28)).append(F.f(nArray[1] + nArray[2], 5, s));
        buffer.append(F.f(F.f(d6, 6, 1).trim() + "%", 6, s)).append("\n");
        int[] nArray2 = new int[37];
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            nArray2[n2] = 0;
        }
        for (n2 = 0; n2 < array.length - 1; ++n2) {
            int n7 = Composition.nuc2num(array[n2 + 1]) * 6 + Composition.nuc2num(array[n2]);
            nArray2[n7] = nArray2[n7] + 1;
        }
        buffer.append("\n\n").append(F.f("*****", bl ? 82 : 62, (short)4)).append("\n\n");
        buffer.append(F.f((Object)"AA: ", 10)).append(F.f(nArray2[0], n4, s));
        buffer.append(" CA: ").append(F.f(nArray2[1], n4, s));
        buffer.append(" GA: ").append(F.f(nArray2[2], n4, s));
        buffer.append(" TA: ").append(F.f(nArray2[3], n4, s));
        if (bl) {
            buffer.append(" NA: ").append(F.f(nArray2[4], n4, s));
        }
        buffer.append("\n");
        buffer.append(F.f((Object)"AC: ", 10)).append(F.f(nArray2[6], n4, s));
        buffer.append(" CC: ").append(F.f(nArray2[7], n4, s));
        buffer.append(" GC: ").append(F.f(nArray2[8], n4, s));
        buffer.append(" TC: ").append(F.f(nArray2[9], n4, s));
        if (bl) {
            buffer.append(" NC: ").append(F.f(nArray2[10], n4, s));
        }
        buffer.append("\n");
        buffer.append(F.f((Object)"AG: ", 10)).append(F.f(nArray2[12], n4, s));
        buffer.append(" CG: ").append(F.f(nArray2[13], n4, s));
        buffer.append(" GG: ").append(F.f(nArray2[14], n4, s));
        buffer.append(" TG: ").append(F.f(nArray2[15], n4, s));
        if (bl) {
            buffer.append(" NG: ").append(F.f(nArray2[16], n4, s));
        }
        buffer.append("\n");
        buffer.append(F.f((Object)"AT: ", 10)).append(F.f(nArray2[18], n4, s));
        buffer.append(" CT: ").append(F.f(nArray2[19], n4, s));
        buffer.append(" GT: ").append(F.f(nArray2[20], n4, s));
        buffer.append(" TT: ").append(F.f(nArray2[21], n4, s));
        if (bl) {
            buffer.append(" NT: ").append(F.f(nArray2[22], n4, s));
        }
        buffer.append("\n");
        if (bl) {
            buffer.append(F.f((Object)"AN: ", 10)).append(F.f(nArray2[24], n4, s));
            buffer.append(" CN: ").append(F.f(nArray2[25], n4, s));
            buffer.append(" GN: ").append(F.f(nArray2[26], n4, s));
            buffer.append(" TN: ").append(F.f(nArray2[27], n4, s));
            buffer.append(" NN: ").append(F.f(nArray2[28], n4, s));
            buffer.append("\n");
        }
        buffer.append("\n");
        n2 = 0;
        for (int i = 29; i < nArray2.length; ++i) {
            n2 += nArray2[i];
        }
        if (n2 > 0) {
            buffer.append(F.f((Object)"Other: ", bl ? 42 : 32)).append(F.f(n2, n4, s)).append("\n");
        }
        int[] nArray3 = new int[217];
        for (n = 0; n < nArray3.length; ++n) {
            nArray3[n] = 0;
        }
        for (n = 0; n < array.length - 2; ++n) {
            int n8 = Composition.nuc2num(array[n]) * 36 + Composition.nuc2num(array[n + 1]) * 6 + Composition.nuc2num(array[n + 2]);
            nArray3[n8] = nArray3[n8] + 1;
        }
        buffer.append("\n\n").append(F.f("*****", bl ? 82 : 62, (short)4)).append("\n\n");
        buffer.append("     AAA: ").append(F.f(nArray3[0], n4, s));
        buffer.append("ACA: ").append(F.f(nArray3[6], n4, s));
        buffer.append("AGA: ").append(F.f(nArray3[12], n4, s));
        buffer.append("ATA: ").append(F.f(nArray3[18], n4, s));
        if (bl) {
            buffer.append("ANA: ").append(F.f(nArray3[24], n4, s));
        }
        buffer.append("\n");
        buffer.append("     AAC: ").append(F.f(nArray3[1], n4, s));
        buffer.append("ACC: ").append(F.f(nArray3[7], n4, s));
        buffer.append("AGC: ").append(F.f(nArray3[13], n4, s));
        buffer.append("ATC: ").append(F.f(nArray3[19], n4, s));
        if (bl) {
            buffer.append("ANC: ").append(F.f(nArray3[25], n4, s));
        }
        buffer.append("\n");
        buffer.append("     AAG: ").append(F.f(nArray3[2], n4, s));
        buffer.append("ACG: ").append(F.f(nArray3[8], n4, s));
        buffer.append("AGG: ").append(F.f(nArray3[14], n4, s));
        buffer.append("ATG: ").append(F.f(nArray3[20], n4, s));
        if (bl) {
            buffer.append("ANG: ").append(F.f(nArray3[26], n4, s));
        }
        buffer.append("\n");
        buffer.append("     AAT: ").append(F.f(nArray3[3], n4, s));
        buffer.append("ACT: ").append(F.f(nArray3[9], n4, s));
        buffer.append("AGT: ").append(F.f(nArray3[15], n4, s));
        buffer.append("ATT: ").append(F.f(nArray3[21], n4, s));
        if (bl) {
            buffer.append("ANT: ").append(F.f(nArray3[27], n4, s));
        }
        buffer.append("\n");
        buffer.append("     AAN: ").append(F.f(nArray3[4], n4, s));
        buffer.append("ACN: ").append(F.f(nArray3[10], n4, s));
        buffer.append("AGN: ").append(F.f(nArray3[16], n4, s));
        buffer.append("ATN: ").append(F.f(nArray3[22], n4, s));
        if (bl) {
            buffer.append("ANN: ").append(F.f(nArray3[28], n4, s));
        }
        buffer.append("\n");
        buffer.append("\n");
        buffer.append("     CAA: ").append(F.f(nArray3[36], n4, s));
        buffer.append("CCA: ").append(F.f(nArray3[42], n4, s));
        buffer.append("CGA: ").append(F.f(nArray3[48], n4, s));
        buffer.append("CTA: ").append(F.f(nArray3[54], n4, s));
        if (bl) {
            buffer.append("CNA: ").append(F.f(nArray3[60], n4, s));
        }
        buffer.append("\n");
        buffer.append("     CAC: ").append(F.f(nArray3[37], n4, s));
        buffer.append("CCC: ").append(F.f(nArray3[43], n4, s));
        buffer.append("CGC: ").append(F.f(nArray3[49], n4, s));
        buffer.append("CTC: ").append(F.f(nArray3[55], n4, s));
        if (bl) {
            buffer.append("CNC: ").append(F.f(nArray3[61], n4, s));
        }
        buffer.append("\n");
        buffer.append("     CAG: ").append(F.f(nArray3[38], n4, s));
        buffer.append("CCG: ").append(F.f(nArray3[44], n4, s));
        buffer.append("CGG: ").append(F.f(nArray3[50], n4, s));
        buffer.append("CTG: ").append(F.f(nArray3[56], n4, s));
        if (bl) {
            buffer.append("CNG: ").append(F.f(nArray3[62], n4, s));
        }
        buffer.append("\n");
        buffer.append("     CAT: ").append(F.f(nArray3[39], n4, s));
        buffer.append("CCT: ").append(F.f(nArray3[45], n4, s));
        buffer.append("CGT: ").append(F.f(nArray3[51], n4, s));
        buffer.append("CTT: ").append(F.f(nArray3[57], n4, s));
        if (bl) {
            buffer.append("CNT: ").append(F.f(nArray3[63], n4, s));
        }
        buffer.append("\n");
        buffer.append("     CAN: ").append(F.f(nArray3[40], n4, s));
        buffer.append("CCN: ").append(F.f(nArray3[46], n4, s));
        buffer.append("CGN: ").append(F.f(nArray3[52], n4, s));
        buffer.append("CTN: ").append(F.f(nArray3[58], n4, s));
        if (bl) {
            buffer.append("CNN: ").append(F.f(nArray3[64], n4, s));
        }
        buffer.append("\n");
        buffer.append("\n");
        buffer.append("     GAA: ").append(F.f(nArray3[72], n4, s));
        buffer.append("GCA: ").append(F.f(nArray3[78], n4, s));
        buffer.append("GGA: ").append(F.f(nArray3[84], n4, s));
        buffer.append("GTA: ").append(F.f(nArray3[90], n4, s));
        if (bl) {
            buffer.append("GNA: ").append(F.f(nArray3[96], n4, s));
        }
        buffer.append("\n");
        buffer.append("     GAC: ").append(F.f(nArray3[73], n4, s));
        buffer.append("GCC: ").append(F.f(nArray3[79], n4, s));
        buffer.append("GGC: ").append(F.f(nArray3[85], n4, s));
        buffer.append("GTC: ").append(F.f(nArray3[91], n4, s));
        if (bl) {
            buffer.append("GNC: ").append(F.f(nArray3[97], n4, s));
        }
        buffer.append("\n");
        buffer.append("     GAG: ").append(F.f(nArray3[74], n4, s));
        buffer.append("GCG: ").append(F.f(nArray3[80], n4, s));
        buffer.append("GGG: ").append(F.f(nArray3[86], n4, s));
        buffer.append("GTG: ").append(F.f(nArray3[92], n4, s));
        if (bl) {
            buffer.append("GNG: ").append(F.f(nArray3[98], n4, s));
        }
        buffer.append("\n");
        buffer.append("     GAT: ").append(F.f(nArray3[75], n4, s));
        buffer.append("GCT: ").append(F.f(nArray3[81], n4, s));
        buffer.append("GGT: ").append(F.f(nArray3[87], n4, s));
        buffer.append("GTT: ").append(F.f(nArray3[93], n4, s));
        if (bl) {
            buffer.append("GNT: ").append(F.f(nArray3[99], n4, s));
        }
        buffer.append("\n");
        buffer.append("     GAN: ").append(F.f(nArray3[76], n4, s));
        buffer.append("GCN: ").append(F.f(nArray3[82], n4, s));
        buffer.append("GGN: ").append(F.f(nArray3[88], n4, s));
        buffer.append("GTN: ").append(F.f(nArray3[94], n4, s));
        if (bl) {
            buffer.append("GNN: ").append(F.f(nArray3[100], n4, s));
        }
        buffer.append("\n");
        buffer.append("\n");
        buffer.append("     TAA: ").append(F.f(nArray3[108], n4, s));
        buffer.append("TCA: ").append(F.f(nArray3[114], n4, s));
        buffer.append("TGA: ").append(F.f(nArray3[120], n4, s));
        buffer.append("TTA: ").append(F.f(nArray3[126], n4, s));
        if (bl) {
            buffer.append("TNA: ").append(F.f(nArray3[132], n4, s));
        }
        buffer.append("\n");
        buffer.append("     TAC: ").append(F.f(nArray3[109], n4, s));
        buffer.append("TCC: ").append(F.f(nArray3[115], n4, s));
        buffer.append("TGC: ").append(F.f(nArray3[121], n4, s));
        buffer.append("TTC: ").append(F.f(nArray3[127], n4, s));
        if (bl) {
            buffer.append("TNC: ").append(F.f(nArray3[133], n4, s));
        }
        buffer.append("\n");
        buffer.append("     TAG: ").append(F.f(nArray3[100], n4, s));
        buffer.append("TCG: ").append(F.f(nArray3[116], n4, s));
        buffer.append("TGG: ").append(F.f(nArray3[122], n4, s));
        buffer.append("TTG: ").append(F.f(nArray3[128], n4, s));
        if (bl) {
            buffer.append("TNG: ").append(F.f(nArray3[134], n4, s));
        }
        buffer.append("\n");
        buffer.append("     TAT: ").append(F.f(nArray3[111], n4, s));
        buffer.append("TCT: ").append(F.f(nArray3[117], n4, s));
        buffer.append("TGT: ").append(F.f(nArray3[123], n4, s));
        buffer.append("TTT: ").append(F.f(nArray3[129], n4, s));
        if (bl) {
            buffer.append("TNT: ").append(F.f(nArray3[135], n4, s));
        }
        buffer.append("\n");
        if (bl) {
            buffer.append("     TAN: ").append(F.f(nArray3[112], n4, s));
            buffer.append("TCN: ").append(F.f(nArray3[118], n4, s));
            buffer.append("TGN: ").append(F.f(nArray3[124], n4, s));
            buffer.append("TTN: ").append(F.f(nArray3[130], n4, s));
            buffer.append("TNN: ").append(F.f(nArray3[136], n4, s));
            buffer.append("\n");
        }
        buffer.append("\n");
        if (bl) {
            buffer.append("     NAA: ").append(F.f(nArray3[144], n4, s));
            buffer.append("NCA: ").append(F.f(nArray3[150], n4, s));
            buffer.append("NGA: ").append(F.f(nArray3[156], n4, s));
            buffer.append("NTA: ").append(F.f(nArray3[162], n4, s));
            buffer.append("NNA: ").append(F.f(nArray3[168], n4, s));
            buffer.append("\n");
            buffer.append("     NAC: ").append(F.f(nArray3[145], n4, s));
            buffer.append("NCC: ").append(F.f(nArray3[151], n4, s));
            buffer.append("NGC: ").append(F.f(nArray3[157], n4, s));
            buffer.append("NTC: ").append(F.f(nArray3[163], n4, s));
            buffer.append("NNC: ").append(F.f(nArray3[169], n4, s));
            buffer.append("\n");
            buffer.append("     NAG: ").append(F.f(nArray3[146], n4, s));
            buffer.append("NCG: ").append(F.f(nArray3[152], n4, s));
            buffer.append("NGG: ").append(F.f(nArray3[158], n4, s));
            buffer.append("NTG: ").append(F.f(nArray3[164], n4, s));
            buffer.append("NNG: ").append(F.f(nArray3[170], n4, s));
            buffer.append("\n");
            buffer.append("     NAT: ").append(F.f(nArray3[147], n4, s));
            buffer.append("NCT: ").append(F.f(nArray3[153], n4, s));
            buffer.append("NGT: ").append(F.f(nArray3[159], n4, s));
            buffer.append("NTT: ").append(F.f(nArray3[165], n4, s));
            buffer.append("NNT: ").append(F.f(nArray3[171], n4, s));
            buffer.append("\n");
            buffer.append("     NAN: ").append(F.f(nArray3[148], n4, s));
            buffer.append("NCN: ").append(F.f(nArray3[154], n4, s));
            buffer.append("NGN: ").append(F.f(nArray3[160], n4, s));
            buffer.append("NTN: ").append(F.f(nArray3[166], n4, s));
            buffer.append("NNN: ").append(F.f(nArray3[172], n4, s));
            buffer.append("\n");
            buffer.append("\n");
        }
        n2 = nArray3[5] + nArray3[11] + nArray3[17] + nArray3[23] + nArray3[29];
        for (n = 30; n < 36; ++n) {
            n2 += nArray3[n];
        }
        n2 += nArray3[41] + nArray3[47] + nArray3[53] + nArray3[59] + nArray3[65];
        for (n = 66; n < 72; ++n) {
            n2 += nArray3[n];
        }
        n2 += nArray3[77] + nArray3[83] + nArray3[89] + nArray3[95] + nArray3[101];
        for (n = 102; n < 108; ++n) {
            n2 += nArray3[n];
        }
        n2 += nArray3[113] + nArray3[119] + nArray3[125] + nArray3[131] + nArray3[137];
        for (n = 138; n < 144; ++n) {
            n2 += nArray3[n];
        }
        n2 += nArray3[149] + nArray3[155] + nArray3[161] + nArray3[167] + nArray3[173];
        for (n = 174; n < nArray3.length; ++n) {
            n2 += nArray3[n];
        }
        if (n2 > 0) {
            buffer.append(F.f((Object)"Other: ", 32)).append(n2).append("\n");
        }
    }

    public static double[][] pIData(Sequence sequence, int[] nArray, double d, double d2, double d3) {
        int n;
        Composition.sequence = sequence;
        selection = nArray;
        String string = sequence.getSequence().toUpperCase();
        if (nArray != null) {
            string = string.substring(nArray[0], nArray[1]);
        }
        array = string.toCharArray();
        int[] nArray2 = new int[21];
        for (n = 0; n < nArray2.length; ++n) {
            nArray2[n] = 0;
        }
        for (n = 0; n < array.length; ++n) {
            int n2 = Composition.aa2num(array[n]);
            nArray2[n2] = nArray2[n2] + 1;
        }
        n = (int)((d2 - d) / d3) + 1;
        double[][] dArray = new double[n][2];
        for (int i = 0; i < n; ++i) {
            double d4;
            dArray[i][0] = d4 = d + d3 * (double)i;
            dArray[i][1] = Composition.pH(d4, nArray2);
        }
        return dArray;
    }

    static double pH(double d, int[] nArray) {
        double d2 = Math.pow(10.0, d);
        double d3 = 0.0;
        double d4 = 3.91;
        int n = -1;
        int n2 = nArray[2];
        double d5 = d2 / Math.pow(10.0, d4);
        double d6 = d5 / (1.0 + d5);
        double d7 = (double)(n * n2) * d6;
        double d8 = 1.0 / d5;
        double d9 = d8 / (1.0 + d8);
        double d10 = (double)((1 + n) * n2) * d9;
        d3 += d7 + d10;
        d4 = 4.25;
        n = -1;
        n2 = nArray[3];
        d5 = d2 / Math.pow(10.0, d4);
        d6 = d5 / (1.0 + d5);
        d7 = (double)(n * n2) * d6;
        d8 = 1.0 / d5;
        d9 = d8 / (1.0 + d8);
        d10 = (double)((1 + n) * n2) * d9;
        d3 += d7 + d10;
        d4 = 6.5;
        n = 0;
        n2 = nArray[6];
        d5 = d2 / Math.pow(10.0, d4);
        d6 = d5 / (1.0 + d5);
        d7 = (double)(n * n2) * d6;
        d8 = 1.0 / d5;
        d9 = d8 / (1.0 + d8);
        d10 = (double)((1 + n) * n2) * d9;
        d3 += d7 + d10;
        d4 = 8.3;
        n = -1;
        n2 = nArray[1];
        d5 = d2 / Math.pow(10.0, d4);
        d6 = d5 / (1.0 + d5);
        d7 = (double)(n * n2) * d6;
        d8 = 1.0 / d5;
        d9 = d8 / (1.0 + d8);
        d10 = (double)((1 + n) * n2) * d9;
        d3 += d7 + d10;
        d4 = 10.95;
        n = -1;
        n2 = nArray[19];
        d5 = d2 / Math.pow(10.0, d4);
        d6 = d5 / (1.0 + d5);
        d7 = (double)(n * n2) * d6;
        d8 = 1.0 / d5;
        d9 = d8 / (1.0 + d8);
        d10 = (double)((1 + n) * n2) * d9;
        d3 += d7 + d10;
        d4 = 10.79;
        n = 0;
        n2 = nArray[8];
        d5 = d2 / Math.pow(10.0, d4);
        d6 = d5 / (1.0 + d5);
        d7 = (double)(n * n2) * d6;
        d8 = 1.0 / d5;
        d9 = d8 / (1.0 + d8);
        d10 = (double)((1 + n) * n2) * d9;
        d3 += d7 + d10;
        d4 = 12.5;
        n = 0;
        n2 = nArray[14];
        d5 = d2 / Math.pow(10.0, d4);
        d6 = d5 / (1.0 + d5);
        d7 = (double)(n * n2) * d6;
        d8 = 1.0 / d5;
        d9 = d8 / (1.0 + d8);
        d10 = (double)((1 + n) * n2) * d9;
        d3 += d7 + d10;
        d4 = 3.56;
        n = -1;
        n2 = 1;
        d5 = d2 / Math.pow(10.0, d4);
        d6 = d5 / (1.0 + d5);
        d7 = (double)(n * n2) * d6;
        d8 = 1.0 / d5;
        d9 = d8 / (1.0 + d8);
        d10 = (double)((1 + n) * n2) * d9;
        d3 += d7 + d10;
        d4 = 8.56;
        n = 0;
        n2 = 1;
        d5 = d2 / Math.pow(10.0, d4);
        d6 = d5 / (1.0 + d5);
        d7 = (double)(n * n2) * d6;
        d8 = 1.0 / d5;
        d9 = d8 / (1.0 + d8);
        d10 = (double)((1 + n) * n2) * d9;
        return d3 += d7 + d10;
    }

    public static int nuc2num(char c) {
        int n = 5;
        switch (c) {
            case 'A': {
                n = 0;
                break;
            }
            case 'C': {
                n = 1;
                break;
            }
            case 'G': {
                n = 2;
                break;
            }
            case 'T': {
                n = 3;
                break;
            }
            case 'U': {
                n = 3;
                break;
            }
            case 'N': {
                n = 4;
            }
        }
        return n;
    }

    public static int aa2num(char c) {
        int n = 20;
        switch (c) {
            case 'A': {
                n = 0;
                break;
            }
            case 'C': {
                n = 1;
                break;
            }
            case 'D': {
                n = 2;
                break;
            }
            case 'E': {
                n = 3;
                break;
            }
            case 'F': {
                n = 4;
                break;
            }
            case 'G': {
                n = 5;
                break;
            }
            case 'H': {
                n = 6;
                break;
            }
            case 'I': {
                n = 7;
                break;
            }
            case 'K': {
                n = 8;
                break;
            }
            case 'L': {
                n = 9;
                break;
            }
            case 'M': {
                n = 10;
                break;
            }
            case 'N': {
                n = 11;
                break;
            }
            case 'P': {
                n = 12;
                break;
            }
            case 'Q': {
                n = 13;
                break;
            }
            case 'R': {
                n = 14;
                break;
            }
            case 'S': {
                n = 15;
                break;
            }
            case 'T': {
                n = 16;
                break;
            }
            case 'V': {
                n = 17;
                break;
            }
            case 'W': {
                n = 18;
                break;
            }
            case 'Y': {
                n = 19;
                break;
            }
            case 'B': {
                n = 20;
                break;
            }
            case 'Z': {
                n = 20;
                break;
            }
            case 'X': {
                n = 20;
            }
        }
        return n;
    }
}

