/*
 * Decompiled with CFR 0.152.
 */
package com.infocom.print;

import com.infocom.print.ColumnLayout;
import com.infocom.print.RowLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class FormLayout
implements LayoutManager {
    private int m_hgap = 5;
    private int m_vgap = 5;
    private int m_externalHGap = 0;
    private int m_externalVGap = 0;
    private double m_pct = 0.0;
    private Vector m_Columns = new Vector();
    private ColumnLeader m_ColumnLeader = null;
    private RowLeader m_RowLeader = null;
    private Container m_container = null;
    public static final int DEFAULT = 0;
    public static final int FREE_LABEL = 1;
    public static final int FREE_FIELD = 2;
    public static final int LABEL_ON_TOP = 3;
    private static final int DEBUG_LEVEL = 0;

    public FormLayout() {
        this.debug("FormLayout.FormLayout()", 3);
        this.init();
    }

    public FormLayout(int n, int n2, int n3, int n4) {
        this.debug("FormLayout.FormLayout(int, int, int, int): internalHGap " + n + ", internalVGap " + n2 + ", externalHGap " + n3 + ", externalVGap " + n4, 3);
        this.m_hgap = n;
        this.m_vgap = n2;
        this.m_externalHGap = n3;
        this.m_externalVGap = n4;
        this.init();
    }

    protected int getLeftInset() {
        return this.m_externalHGap + this.m_container.getInsets().left;
    }

    protected int getRightInset() {
        return this.m_externalHGap + this.m_container.getInsets().right;
    }

    protected int getTopInset() {
        return this.m_externalVGap + this.m_container.getInsets().top;
    }

    protected int getBottomInset() {
        return this.m_externalVGap + this.m_container.getInsets().bottom;
    }

    public int getInternalHGap() {
        return this.m_hgap;
    }

    public int getInternalVGap() {
        return this.m_vgap;
    }

    public int getExternalHGap() {
        return this.m_externalHGap;
    }

    public int getExternalVGap() {
        return this.m_externalVGap;
    }

    public void setInternalVGap(int n) {
        this.m_vgap = n;
    }

    public void setInternalHGap(int n) {
        this.m_hgap = n;
    }

    public void setExternalVGap(int n) {
        this.m_externalVGap = n;
    }

    public void setExternalHGap(int n) {
        this.m_externalHGap = n;
    }

    private void init() {
        this.debug("FormLayout.init()", 3);
        this.m_ColumnLeader = new ColumnLeader(this);
        this.m_Columns.add(this.m_ColumnLeader);
        this.m_RowLeader = new RowLeader(this);
    }

    public void layoutContainer(Container container) {
        this.debug("FormLayout.layoutContainer(Container)", 8);
        this.m_container = container;
        long l = System.currentTimeMillis();
        this.m_RowLeader.layoutRows(container.getSize().height);
        this.debugTimer("FormLayout.layoutContainter(Container) -- Rows", l);
        l = System.currentTimeMillis();
        this.m_ColumnLeader.layoutColumns(container.getSize().width);
        this.debugTimer("FormLayout.layoutContainter(Container) -- Columns", l);
    }

    public Dimension minimumLayoutSize(Container container) {
        this.debug("FormLayout.minimumLayoutSize(Container)", 6);
        this.m_container = container;
        Dimension dimension = new Dimension(this.m_ColumnLeader.getMinimumLocation(), this.m_RowLeader.getMinimumLocation());
        this.debug("FormLayout.minimumLayoutSize(Container): returning " + dimension, 6);
        return dimension;
    }

    public Dimension preferredLayoutSize(Container container) {
        this.debug("FormLayout.preferredLayoutSize(Container)", 6);
        this.m_container = container;
        Dimension dimension = new Dimension(this.m_ColumnLeader.getPreferredLocation(), this.m_RowLeader.getPreferredLocation());
        this.debug("FormLayout.preferredLayoutSize(Container): returning " + dimension, 6);
        return dimension;
    }

    public void removeLayoutComponent(Component component) {
        this.debug("FormLayout.removeLayoutComponent(Component)", 3);
        this.m_RowLeader.removeLayoutComponent(component);
        this.m_ColumnLeader.removeLayoutComponent(component);
    }

    private void debugLabel(Component component) {
        try {
            this.debug("FormLayout.add: Label is '" + ((JLabel)component).getText() + "'", 3);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void add(Component component, int n, int n2) {
        this.debug("FormLayout.add(Component, int, int): row " + n + ", column " + n2, 3);
        this.m_RowLeader.add(component, n);
        this.m_ColumnLeader.add(component, n, n2, this.m_pct);
    }

    public void add(Component component, Component component2, int n, int n2) {
        this.debug("FormLayout.add(Component, Component, int, int): row " + n + ", column " + n2, 3);
        this.debugLabel(component);
        this.m_RowLeader.add(component, component2, n);
        this.m_ColumnLeader.add(component, component2, n, n2, this.m_pct);
    }

    public void add(Component component, Component component2, int n, int n2, int n3) {
        this.debug("FormLayout.add(Component, Component, int, int, int): column " + n2 + ", row " + n + ", mode " + n3, 3);
        if (n3 < 0 || n3 > 3) {
            this.debug("FormLayout.add(Component, Component, int, int, int): Invalid mode: " + n3 + "!  Adding components in default mode.", 0);
            this.add(component, component2, n, n2);
        }
        if (n2 == 0 && n3 == 1) {
            this.debug("FormLayout.add(Component, Component, int, int, int): Invalid mode: FREE_LABEL cannot be used on column #0!  Adding components in default mode.", 0);
            this.add(component, component2, n, n2);
        }
        if (n3 == 3) {
            if (n >= 0x7FFFFFFE) {
                this.debug("FormLayout.add(Component, Component, int, int, int): Invalid row for mode LABEL_ON_TOP: must be less than (Integer.MAX_VALUE - 1): 2147483646.  Adding components in default mode.", 0);
                this.add(component, component2, n, n2);
            }
            try {
                ((JComponent)component).setAlignmentY(1.0f);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            this.m_RowLeader.add(component, n);
            this.m_ColumnLeader.add(component, n, n2, this.m_pct);
            this.m_RowLeader.add(component2, n + 1);
            this.m_ColumnLeader.add(component2, n + 1, n2, this.m_pct);
            return;
        }
        this.debugLabel(component);
        this.m_RowLeader.add(component, component2, n);
        this.m_ColumnLeader.add(component, component2, n, n2, n3, this.m_pct);
    }

    public void addMultiRow(Component component, int n, int n2, int n3) {
        this.debug("FormLayout.addMultiRow(Component, int, int, int): startRow " + n + ", endRow " + n2 + ", column " + n3, 3);
        this.m_RowLeader.addMultiRow(component, n, n2);
        this.m_ColumnLeader.addMultiRow(component, n, n2, n3, this.m_pct);
    }

    public void addMultiRow(Component component, Component component2, int n, int n2, int n3) {
        this.debug("FormLayout.addMultiRow(Component, Component, int, int, int): startRow " + n + ", endRow " + n2 + ", column " + n3, 3);
        this.debugLabel(component);
        this.m_RowLeader.addMultiRow(component, component2, n, n2);
        this.m_ColumnLeader.addMultiRow(component, component2, n, n2, n3, this.m_pct);
    }

    public void addMultiRow(Component component, Component component2, int n, int n2, int n3, int n4) {
        this.debug("FormLayout.addMultiRow(Component, Component, int, int, int, int): column " + n3 + ", startRow " + n + ", endRow " + n2 + ", mode " + n4, 3);
        if (n > n2) {
            n2 = n;
        }
        if (n4 < 0 || n4 > 3) {
            this.debug("FormLayout.addMultiRow(Component, Component, int, int, int, int): Invalid mode: " + n4 + "!  Adding components in default mode.", 0);
            this.addMultiRow(component, component2, n, n2, n3);
        }
        if (n4 == 1 || n4 == 2) {
            this.debug("FormLayout.addMultiRow(Component, Component, int, int, int, int): mode " + n4 + " not supported for multi-row components.  Layout may behave strangely", 0);
        }
        if (n4 == 3) {
            this.debug("FormLayout.addMultiRow(Component, Component, int, int, int, int): adding in mode FormLayout.LABEL_ON_TOP", 3);
            if (n2 >= 0x7FFFFFFE) {
                this.debug("FormLayout.addMultiRow(Component, Component, int, int, int, int): Invalid endRow for mode LABEL_ON_TOP: must be less than (Integer.MAX_VALUE - 1): 2147483646.  Adding components in default mode.", 0);
                this.add(component, component2, n, n2, n3);
            }
            if (n >= n2) {
                n2 = n + 1;
            }
            try {
                ((JComponent)component).setAlignmentY(1.0f);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            this.m_RowLeader.add(component, n);
            this.m_ColumnLeader.add(component, n, n3, this.m_pct);
            this.m_RowLeader.addMultiRow(component2, n + 1, n2);
            this.m_ColumnLeader.addMultiRow(component2, n + 1, n2, n3, this.m_pct);
            return;
        }
        this.debugLabel(component);
        this.m_RowLeader.addMultiRow(component, component2, n, n2);
        this.m_ColumnLeader.addMultiRow(component, component2, n, n2, n3, n4, this.m_pct);
    }

    public void add(Component component, int n, int n2, double d) {
        this.debug("FormLayout.add(Component, int, int, double): row " + n + ", column " + n2, 3);
        this.m_RowLeader.add(component, n);
        this.m_ColumnLeader.add(component, n, n2, d);
    }

    public void add(Component component, Component component2, int n, int n2, double d) {
        this.debug("FormLayout.add(Component, Component, int, int, double): row " + n + ", column " + n2, 3);
        this.debugLabel(component);
        this.m_RowLeader.add(component, component2, n);
        this.m_ColumnLeader.add(component, component2, n, n2, d);
    }

    public void add(Component component, Component component2, int n, int n2, int n3, double d) {
        this.debug("FormLayout.add(Component, Component, int, int, int, double): column " + n2 + ", row " + n + ", mode " + n3, 3);
        if (n3 < 0 || n3 > 3) {
            this.debug("FormLayout.add(Component, Component, int, int, int): Invalid mode: " + n3 + "!  Adding components in default mode.", 0);
            this.add(component, component2, n, n2, d);
        }
        if (n2 == 0 && n3 == 1) {
            this.debug("FormLayout.add(Component, Component, int, int, int): Invalid mode: FREE_LABEL cannot be used on column #0!  Adding components in default mode.", 0);
            this.add(component, component2, n, n2, d);
        }
        if (n3 == 3) {
            if (n >= 0x7FFFFFFE) {
                this.debug("FormLayout.add(Component, Component, int, int, int): Invalid row for mode LABEL_ON_TOP: must be less than (Integer.MAX_VALUE - 1): 2147483646.  Adding components in default mode.", 0);
                this.add(component, component2, n, n2, d);
            }
            try {
                ((JComponent)component).setAlignmentY(1.0f);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            this.m_RowLeader.add(component, n);
            this.m_ColumnLeader.add(component, n, n2, d);
            this.m_RowLeader.add(component2, n + 1);
            this.m_ColumnLeader.add(component2, n + 1, n2, d);
        }
        this.debugLabel(component);
        this.m_RowLeader.add(component, component2, n);
        this.m_ColumnLeader.add(component, component2, n, n2, n3, d);
    }

    public void addMultiRow(Component component, int n, int n2, int n3, double d) {
        this.debug("FormLayout.addMultiRow(Component, int, int, int, double): startRow " + n + ", endRow " + n2 + ", column " + n3, 3);
        this.m_RowLeader.addMultiRow(component, n, n2);
        this.m_ColumnLeader.addMultiRow(component, n, n2, n3, d);
    }

    public void addMultiRow(Component component, Component component2, int n, int n2, int n3, double d) {
        this.debug("FormLayout.addMultiRow(Component, Component, int, int, int, double): startRow " + n + ", endRow " + n2 + ", column " + n3, 3);
        this.debugLabel(component);
        this.m_RowLeader.addMultiRow(component, component2, n, n2);
        this.m_ColumnLeader.addMultiRow(component, component2, n, n2, n3, d);
    }

    public void addMultiRow(Component component, Component component2, int n, int n2, int n3, int n4, double d) {
        this.debug("FormLayout.addMultiRow(Component, Component, int, int, int, int, double): column " + n3 + ", startRow " + n + ", endRow " + n2 + ", mode " + n4, 3);
        if (n > n2) {
            n2 = n;
        }
        if (n4 < 0 || n4 > 3) {
            this.debug("FormLayout.addMultiRow(Component, Component, int, int, int, int): Invalid mode: " + n4 + "!  Adding components in default mode.", 0);
            this.addMultiRow(component, component2, n, n2, n3, d);
        }
        if (n4 == 1 || n4 == 2) {
            this.debug("FormLayout.addMultiRow(Component, Component, int, int, int, int): mode " + n4 + " not supported for multi-row components.  Layout may behave strangely", 0);
        }
        if (n4 == 3) {
            this.debug("FormLayout.addMultiRow(Component, Component, int, int, int, int): adding in mode FormLayout.LABEL_ON_TOP", 3);
            if (n2 >= 0x7FFFFFFE) {
                this.debug("FormLayout.addMultiRow(Component, Component, int, int, int, int): Invalid endRow for mode LABEL_ON_TOP: must be less than (Integer.MAX_VALUE - 1): 2147483646.  Adding components in default mode.", 0);
                this.add(component, component2, n, n2, n3, d);
            }
            if (n >= n2) {
                n2 = n + 1;
            }
            try {
                ((JComponent)component).setAlignmentY(1.0f);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            this.m_RowLeader.add(component, n);
            this.m_ColumnLeader.add(component, n, n3, d);
            this.m_RowLeader.addMultiRow(component2, n + 1, n2);
            this.m_ColumnLeader.addMultiRow(component2, n + 1, n2, n3, d);
            return;
        }
        this.debugLabel(component);
        this.m_RowLeader.addMultiRow(component, component2, n, n2);
        this.m_ColumnLeader.addMultiRow(component, component2, n, n2, n3, n4, d);
    }

    public void setDefaultFillRightPct(double d) {
        this.debug("FormLayout.setDefaultFillRightPct(double): pct " + d, 3);
        this.m_pct = d;
    }

    public double getDefaultFillRightPct() {
        return this.m_pct;
    }

    ColumnLayout getColumn(int n) {
        this.debug("FormLayout.getColumn(int): column " + n, 3);
        Enumeration enumeration = this.m_Columns.elements();
        ColumnLayout columnLayout = null;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            columnLayout = (ColumnLayout)enumeration.nextElement();
            if (n == columnLayout.getIndex()) {
                return columnLayout;
            }
            if (n < columnLayout.getIndex()) {
                ColumnLayout columnLayout2 = new ColumnLayout(n, this);
                this.m_Columns.insertElementAt(columnLayout2, n2);
                return columnLayout2;
            }
            ++n2;
        }
        this.debug("FormLayout.getColumn(int): Error!  Attempt to add column with index > Integer.MAX_VALUE!!", 0);
        return null;
    }

    public void addLayoutComponent(String string, Component component) {
        this.debug("FormLayout.addLayoutComponent(String, Component): Warning!  Use of unsupported method!", 0);
    }

    private void debug(String string, int n) {
        if (n <= 0) {
            for (int i = 0; i < n; ++i) {
                string = "-" + string;
            }
            System.out.println(string);
        }
    }

    private void debugTimer(String string, long l) {
        this.debug(string + " total time: " + (System.currentTimeMillis() - l), 1);
    }

    class ColumnLeader
    extends ColumnLayout {
        private Vector m_invisibleGhosts = new Vector();

        public ColumnLeader(FormLayout formLayout2) {
            super(Integer.MAX_VALUE, formLayout2);
            this.debug("ColumnLeader.ColumnLeader(FormLayout)", 3);
        }

        public void add(Component component, int n, int n2, double d) {
            this.debug("ColumnLeader.add(Component, int, int, double)", 3);
            ColumnLayout.SegmentLayout segmentLayout = this.getSegment(FormLayout.this.getColumn(n2), n);
            segmentLayout.add(component, 2, d);
        }

        public void add(Component component, Component component2, int n, int n2, double d) {
            this.debug("ColumnLeader.add(Component, Component, int, int, double)", 3);
            ColumnLayout.SegmentLayout segmentLayout = this.getSegment(FormLayout.this.getColumn(n2), n);
            segmentLayout.add(component, d);
            segmentLayout.add(component2, d);
        }

        public void add(Component component, Component component2, int n, int n2, int n3, double d) {
            this.debug("ColumnLeader.add(Component, Component, int, int, int, double)", 3);
            ColumnLayout.SegmentLayout segmentLayout = this.getSegment(FormLayout.this.getColumn(n2), n);
            segmentLayout.add(component, n3, d);
            segmentLayout.add(component2, d);
        }

        public void addMultiRow(Component component, int n, int n2, int n3, double d) {
            this.debug("ColumnLeader.addMultiRow(Component, int, int, int, double)", 3);
            this.add(component, n, n3, d);
            this.addMultiRows(component, n, n2, n3, 2);
        }

        public void addMultiRow(Component component, Component component2, int n, int n2, int n3, double d) {
            this.debug("ColumnLeader.addMultiRow(Component, Component, int, int, int, double)", 3);
            this.add(component, component2, n, n3, d);
            this.addMultiRows(component2, n, n2, n3, 0);
        }

        public void addMultiRow(Component component, Component component2, int n, int n2, int n3, int n4, double d) {
            this.debug("ColumnLeader.addMultiRow(Component, Component, int, int, int, int, double)", 3);
            this.add(component, component2, n, n3, n4, d);
            this.addMultiRows(component2, n, n2, n3, 0);
        }

        private void addMultiRows(Component component, int n, int n2, int n3, int n4) {
            this.debug("ColumnLeader.addMultiRows(Component, int, int, int, int) startRow " + n + ", endRow " + n2 + ", column " + n3, 3);
            ColumnLayout columnLayout = FormLayout.this.getColumn(n3);
            this.getSegment(columnLayout, n).setLastGhost(n2);
            Enumeration enumeration = this.m_segments.elements();
            ColumnLayout.SegmentLayout segmentLayout = null;
            ColumnLayout.SegmentLayout segmentLayout2 = null;
            while (enumeration.hasMoreElements()) {
                segmentLayout = (ColumnLayout.SegmentLayout)enumeration.nextElement();
                this.debug("ColumnLeader.addMultiRows(Component, int, int, int, int): nextLeaderSegment " + segmentLayout.getIndex(), 3);
                if (segmentLayout.getIndex() <= n || segmentLayout.getIndex() > n2) continue;
                segmentLayout2 = segmentLayout.getSegment(columnLayout);
                segmentLayout2.addGhost(new JLabel(""));
                segmentLayout2.add(component, n4, 0.0);
            }
            this.m_invisibleGhosts.add(new InvisibleGhost(n, n2, n4, component, columnLayout));
        }

        public void removeLayoutComponent(Component component) {
            this.debug("ColumnLeader.removeLayoutComponent(Component)", 3);
            Enumeration enumeration = this.m_segments.elements();
            while (enumeration.hasMoreElements()) {
                ((ColumnLayout.SegmentLayout)enumeration.nextElement()).removeLayoutComponent(component);
            }
        }

        public ColumnLayout.SegmentLayout getSegment(ColumnLayout columnLayout, int n) {
            this.debug("ColumnLeader.getSegment(ColumnLayout, int): column of columnLayout " + columnLayout.getIndex() + ", row " + n, 3);
            ColumnLayout.SegmentLayout segmentLayout = this.findSegment(n);
            if (segmentLayout == null) {
                segmentLayout = new ColumnLayout.SegmentLayout(n);
                this.m_segments.add(segmentLayout);
                Enumeration enumeration = this.m_invisibleGhosts.elements();
                while (enumeration.hasMoreElements()) {
                    ((InvisibleGhost)enumeration.nextElement()).makeVisible(segmentLayout);
                }
            }
            return segmentLayout.getSegment(columnLayout);
        }

        private ColumnLayout.SegmentLayout findSegment(int n) {
            this.debug("ColumnLeader.findSegment(int): row " + n + ", index " + this.getIndex(), 3);
            Enumeration enumeration = this.m_segments.elements();
            ColumnLayout.SegmentLayout segmentLayout = null;
            while (enumeration.hasMoreElements()) {
                segmentLayout = (ColumnLayout.SegmentLayout)enumeration.nextElement();
                if (segmentLayout.getIndex() != n) continue;
                return segmentLayout;
            }
            return null;
        }

        public void layoutColumns(int n) {
            ColumnLayout columnLayout;
            this.debug("ColumnLeader.layoutColumns(int): room " + n, 8);
            if (n < this.m_minLocation) {
                n = this.m_minLocation;
            } else if (n > this.m_prefLocation) {
                n = this.m_prefLocation;
            }
            n -= FormLayout.this.m_externalHGap;
            this.recalcMinimumLocations();
            this.recalcPreferredLocations();
            double d = 1.0;
            if (this.m_prefLocation - this.m_minLocation > 0) {
                d = (double)(n - (this.m_minLocation - FormLayout.this.m_externalHGap)) / (double)(this.m_prefLocation - FormLayout.this.m_externalHGap - (this.m_minLocation - FormLayout.this.m_externalHGap));
            }
            this.debug("ColumnLeader.layoutColumns(int): ******* laying out Columns with min " + this.m_minLocation + ", pref " + this.m_prefLocation + ", room " + n + ", pct " + d, 10);
            Enumeration enumeration = FormLayout.this.m_Columns.elements();
            while (enumeration.hasMoreElements()) {
                columnLayout = (ColumnLayout)enumeration.nextElement();
                columnLayout.findIntermediateLocation(d);
            }
            this.m_currLocation = n;
            enumeration = FormLayout.this.m_Columns.elements();
            while (enumeration.hasMoreElements()) {
                columnLayout = (ColumnLayout)enumeration.nextElement();
                columnLayout.doLayout();
            }
        }

        public int getPreferredLocation() {
            this.debug("ColumnLeader.getPreferredLocation()", 6);
            this.recalcPreferredLocations();
            return this.m_prefLocation;
        }

        public int getMinimumLocation() {
            this.debug("ColumnLeader.getMinimumLocation()", 6);
            this.recalcMinimumLocations();
            return this.m_minLocation;
        }

        protected void setMinimumLocation(int n) {
            this.debug("ColumnLeader.setMinimumLocation(int): " + n, 6);
            this.m_minLocation = n + FormLayout.this.m_externalHGap;
        }

        protected void setPreferredLocation(int n) {
            this.debug("ColumnLeader.setPreferredLocation(int): " + (n + FormLayout.this.m_externalHGap), 6);
            this.m_prefLocation = n + FormLayout.this.m_externalHGap;
        }

        void recalcMinimumLocations() {
            this.debug("ColumnLeader.recalcMinimumLocations()", 6);
            Enumeration enumeration = FormLayout.this.m_Columns.elements();
            ColumnLayout columnLayout = null;
            while (enumeration.hasMoreElements()) {
                columnLayout = (ColumnLayout)enumeration.nextElement();
                columnLayout.findMinimumLocation();
            }
        }

        void recalcPreferredLocations() {
            this.debug("ColumnLeader.recalcPreferredLocations()", 6);
            Enumeration enumeration = FormLayout.this.m_Columns.elements();
            ColumnLayout columnLayout = null;
            while (enumeration.hasMoreElements()) {
                columnLayout = (ColumnLayout)enumeration.nextElement();
                columnLayout.findPreferredLocation();
            }
        }

        private void debug(String string, int n) {
            if (n <= 0) {
                for (int i = 0; i < n; ++i) {
                    string = "-" + string;
                }
                System.out.println(string);
            }
        }

        class InvisibleGhost {
            private int m_startRow;
            private int m_endRow;
            private int m_mode;
            private Component m_field;
            private ColumnLayout m_columnLayout;

            public InvisibleGhost(int n, int n2, int n3, Component component, ColumnLayout columnLayout) {
                ColumnLeader.this.debug("InvisibleGhost.InvisibleGhost(int, int, int, Component, ColumnLayout): columnLayout.getIndex() " + columnLayout.getIndex() + ", startRow " + n + ", endRow " + n2, 3);
                this.m_startRow = n;
                this.m_endRow = n2;
                this.m_mode = n3;
                this.m_field = component;
                this.m_columnLayout = columnLayout;
            }

            public void makeVisible(ColumnLayout.SegmentLayout segmentLayout) {
                ColumnLeader.this.debug("InvisibleGhost.makeVisible(SegmentLayout): segmentLayout index " + segmentLayout.getIndex() + ", m_columnLayout.getIndex() " + this.m_columnLayout.getIndex() + ", startRow " + this.m_startRow + ", endRow " + this.m_endRow, 3);
                if (segmentLayout.getIndex() >= this.m_startRow && segmentLayout.getIndex() <= this.m_endRow) {
                    ColumnLeader.this.debug("InvisibleGhost.makeVisible(SegmentLayout): Ja!", 3);
                    ColumnLayout.SegmentLayout segmentLayout2 = segmentLayout.getSegment(this.m_columnLayout);
                    segmentLayout2.addGhost(new JLabel(""));
                    segmentLayout2.add(this.m_field, this.m_mode, 0.0);
                }
            }
        }
    }

    class RowLeader
    extends RowLayout {
        public RowLeader(FormLayout formLayout2) {
            super(Integer.MAX_VALUE, formLayout2);
            RowLeader.debug("RowLeader.RowLeader(FormLayout)", 3);
        }

        public void add(Component component, Component component2, int n) {
            RowLeader.debug("RowLeader.add(Component, Component, int): row " + n, 3);
            RowLayout rowLayout = FormLayout.this.m_RowLeader.getRow(n);
            rowLayout.add(component);
            rowLayout.add(component2);
        }

        public void add(Component component, int n) {
            RowLeader.debug("RowLeader.add(Component, int): row " + n, 3);
            RowLayout rowLayout = FormLayout.this.m_RowLeader.getRow(n);
            rowLayout.add(component);
        }

        public void addMultiRow(Component component, int n, int n2) {
            RowLeader.debug("RowLeader.addMultiRow(Component, int, int): startRow " + n + ", endRow " + n2, 3);
            this.getRow(n2).addFloater(component, n);
        }

        public void addMultiRow(Component component, Component component2, int n, int n2) {
            RowLeader.debug("RowLeader.addMultiRow(Component, Component, int, int): startRow " + n + ", endRow " + n2, 3);
            this.getRow(n).add(component);
            this.getRow(n2).addFloater(component2, n);
        }

        protected void removeIfEmpty() {
        }

        public void layoutRows(int n) {
            RowLeader.debug("RowLeader.layoutRows(int): room " + n, 8);
            if (n < this.m_minLocation) {
                n = this.m_minLocation;
            }
            this.findPreferredLocation();
            this.findMinimumLocation();
            double d = 1.0;
            if (this.m_prefLocation > this.m_minLocation) {
                d = (double)(n - this.m_minLocation) / (double)(this.m_prefLocation - this.m_minLocation);
            }
            if (d > 1.0) {
                d = 1.0;
            }
            this.setLocation(d);
            this.doLayout();
        }

        public int getPreferredLocation() {
            RowLeader.debug("RowLeader.getPreferredLocation()", 6);
            this.findPreferredLocation();
            return this.m_prefLocation;
        }

        public int getMinimumLocation() {
            RowLeader.debug("RowLeader.getMinimumLocation()", 6);
            this.findMinimumLocation();
            return this.m_minLocation;
        }

        protected void setMinimumLocation(int n) {
            RowLeader.debug("RowLeader.setMinimumLocation(int)", 6);
            this.m_minLocation = n + FormLayout.this.getRightInset();
        }

        protected void setPreferredLocation(int n) {
            RowLeader.debug("RowLeader.setPreferredLocation(int)", 6);
            this.m_prefLocation = n + FormLayout.this.m_externalVGap;
        }

        protected int getUpperBoundary() {
            RowLeader.debug("RowLeader.getUpperBoundary(): returning " + this.m_currLocation, 8);
            return this.m_currLocation;
        }

        protected int getGap() {
            return FormLayout.this.m_externalVGap;
        }
    }
}

