/*
 * Decompiled with CFR 0.152.
 */
package org.forester.ws.seqdb;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.phylogeny.data.Accession;
import org.forester.util.ForesterUtil;
import org.forester.util.SequenceAccessionTools;
import org.forester.ws.seqdb.UniprotData;

public final class UniprotRetrieve {
    private final boolean _verbose;
    private static final String BASE_URL = "http://www.uniprot.org/uploadlists/";
    private static final boolean DEBUG = false;

    public UniprotRetrieve(boolean bl) {
        this._verbose = bl;
    }

    public UniprotRetrieve() {
        this._verbose = false;
    }

    public final SortedMap<String, UniprotData> retrieve(Set<String> set) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : set) {
            arrayList.add(string);
        }
        return this.retrieve(arrayList);
    }

    public final SortedMap<String, UniprotData> retrieve(List<String> list) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : list) {
            Accession accession = SequenceAccessionTools.parseAccessorFromString(string);
            if (accession != null) {
                if (accession.getSource().equals("ncbi")) {
                    arrayList.add(string);
                    continue;
                }
                if (accession.getSource().equals("refseq")) {
                    arrayList2.add(string);
                    continue;
                }
                if (accession.getSource().equals("ensembl")) {
                    System.out.println("NOTE: query \"" + string + "\" is Ensembl -- ignored");
                    continue;
                }
                if (accession.getSource().equals("uniprot")) {
                    System.out.println("NOTE: query \"" + string + "\" is UniProt -- ignored");
                    continue;
                }
                if (accession.getSource().equals("ViPR")) {
                    System.out.println("NOTE: query \"" + string + "\" is ViPR -- ignored");
                    continue;
                }
                System.out.println("NOTE: query \"" + string + "\" is of unknown source -- ignored");
                continue;
            }
            if (!this._verbose) continue;
            System.out.println("NOTE: query \"" + string + "\" is of unknown source -- ignored");
        }
        TreeMap treeMap = new TreeMap();
        this.runQuery("P_REFSEQ_AC", "ACC", arrayList2, treeMap);
        this.runQuery("EMBL", "ACC", arrayList, treeMap);
        return treeMap;
    }

    private final void runQuery(String string, String string2, List<String> list, SortedMap<String, UniprotData> sortedMap) throws IOException {
        String string3;
        HttpURLConnection httpURLConnection;
        if (ForesterUtil.isEmpty(list)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("http://www.uniprot.org/uploadlists/?from=" + string + "&to=" + string2 + "&format=tab&query=");
        boolean bl = true;
        for (String object2 : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append("+");
            }
            stringBuilder.append(object2);
        }
        Object object = stringBuilder.toString();
        block4: while (true) {
            URL uRL = new URL((String)object);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setConnectTimeout(50000);
            httpURLConnection.setReadTimeout(50000);
            httpURLConnection.setInstanceFollowRedirects(false);
            httpURLConnection.setRequestProperty("User-Agent", "Mozilla/5.0...");
            switch (httpURLConnection.getResponseCode()) {
                case 301: 
                case 302: {
                    String string4 = httpURLConnection.getHeaderField("Location");
                    string4 = URLDecoder.decode(string4, "UTF-8");
                    string4 = string4.replaceAll("\\s+", "%20");
                    URL uRL2 = new URL((String)object);
                    URL uRL3 = new URL(uRL2, string4);
                    object = uRL3.toExternalForm();
                    continue block4;
                }
            }
            break;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
        int n = 0;
        while ((string3 = bufferedReader.readLine()) != null) {
            if (string3.startsWith("yourlist")) continue;
            UniprotData uniprotData = new UniprotData(string3);
            sortedMap.put(uniprotData.getId(), uniprotData);
            if (!this._verbose) continue;
            System.out.println(n++ + ": " + uniprotData.getId() + " -> " + uniprotData.getEntryName());
        }
        bufferedReader.close();
    }

    public static void main(String[] stringArray) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("YP_009256203.1");
        arrayList.add("YP_009199248.1");
        arrayList.add("AAX85683.1");
        arrayList.add("AGT20977.1");
        arrayList.add("ABG89282.1");
        arrayList.add("ACN89752.1");
        arrayList.add("YP_006908645.1");
        arrayList.add("ACN89728.1");
        arrayList.add("YP_001718613.1");
        arrayList.add("AIV41800.1");
        UniprotRetrieve uniprotRetrieve = new UniprotRetrieve(true);
        SortedMap<String, UniprotData> sortedMap = uniprotRetrieve.retrieve(arrayList);
        for (Map.Entry<String, UniprotData> entry : sortedMap.entrySet()) {
            System.out.println(entry.getKey() + " => " + entry.getValue().getProteinNames());
        }
    }
}

