/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.evoinference.matrix.character.BasicCharacterStateMatrix;
import org.forester.evoinference.matrix.character.CharacterStateMatrix;
import org.forester.io.parsers.HmmPfamOutputParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.protein.BasicDomain;
import org.forester.protein.BasicProtein;
import org.forester.protein.BinaryDomainCombination;
import org.forester.protein.Domain;
import org.forester.protein.Protein;
import org.forester.protein.ProteinId;
import org.forester.species.BasicSpecies;
import org.forester.surfacing.AdjactantDirectedBinaryDomainCombination;
import org.forester.surfacing.BasicBinaryDomainCombination;
import org.forester.surfacing.BasicCombinableDomains;
import org.forester.surfacing.BasicDomainSimilarityCalculator;
import org.forester.surfacing.BasicGenomeWideCombinableDomains;
import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.CombinationsBasedPairwiseDomainSimilarity;
import org.forester.surfacing.CombinationsBasedPairwiseDomainSimilarityCalculator;
import org.forester.surfacing.DirectedBinaryDomainCombination;
import org.forester.surfacing.DirectedCombinableDomains;
import org.forester.surfacing.DomainArchitectureBasedGenomeSimilarityCalculator;
import org.forester.surfacing.DomainCountsBasedPairwiseSimilarityCalculator;
import org.forester.surfacing.DomainParsimonyCalculator;
import org.forester.surfacing.DomainSimilarity;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.surfacing.PairwiseDomainSimilarity;
import org.forester.surfacing.PrintableSpeciesSpecificDcData;
import org.forester.surfacing.ProteinCountsBasedPairwiseDomainSimilarityCalculator;
import org.forester.surfacing.SimpleDomain;
import org.forester.surfacing.SurfacingUtil;
import org.forester.util.ForesterUtil;

public class TestSurfacing {
    private static final double ZERO_DIFF = 1.0E-9;

    public static boolean isEqual(double d, double d2) {
        return Math.abs(d - d2) < 1.0E-9;
    }

    public static boolean test(File file) {
        System.out.print("  Combinable domains: ");
        if (!TestSurfacing.testCombinableDomains()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Directed combinable domains: ");
        if (!TestSurfacing.testDirectedCombinableDomains()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Genome wide specific combinable domains: ");
        if (!TestSurfacing.testGenomeWideCombinableDomains()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Domain architecture based genome similarity calculator: ");
        if (!TestSurfacing.testDomainArchitectureBasedGenomeSimilarityCalculator()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Hmmpfam output parser: ");
        if (!TestSurfacing.testHmmPfamOutputParser(file)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Hmmpfam output parser with filter: ");
        if (!TestSurfacing.testHmmPfamOutputParserWithFilter(file)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Combinations based pairwise similarity calculator: ");
        if (!TestSurfacing.testCombinationsBasedPairwiseSimilarityCalculator()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Copy number based pairwise similarity calculator: ");
        if (!TestSurfacing.testCopyNumberBasedPairwiseSimilarityCalculator()) {
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Domain combination counting: ");
        if (!TestSurfacing.testDomainCombinationCounting(file)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Basic domain similarity calculator: ");
        if (!TestSurfacing.testBasicDomainSimilarityCalculator()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Basic domain similarity calculator not ignoring species specific domains: ");
        if (!TestSurfacing.testBasicDomainSimilarityCalculatorNotIgnoringSpeciesSpeficDomains()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Basic domain similarity calculator removal of singles: ");
        if (!TestSurfacing.testBasicDomainSimilarityCalculatorRemovalOfSingles()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Domain sorting: ");
        if (!TestSurfacing.testDomainSorting()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Binary domain combination: ");
        if (!TestSurfacing.testBinaryDomainCombination()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Parsimony: ");
        if (!TestSurfacing.testParsimony()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Directedness: ");
        if (!TestSurfacing.testDirectedness()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Directedness and adjacency: ");
        if (!TestSurfacing.testDirectednessAndAdjacency()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Dollo parsimony on secodary features: ");
        if (!TestSurfacing.testParsimonyOnSecondaryFeatures()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Binary state matrix to gain loss matrix: ");
        if (!TestSurfacing.testBinaryStateMatrixToGainLossMatrix(file)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        return true;
    }

    private static StringBuffer mapToStringBuffer(Map<PhylogenyNode, CharacterStateMatrix.BinaryStates> map) {
        StringBuffer stringBuffer = new StringBuffer();
        for (PhylogenyNode phylogenyNode : map.keySet()) {
            if (phylogenyNode.isExternal()) continue;
            stringBuffer.append(phylogenyNode.getName());
            stringBuffer.append(" : ");
            stringBuffer.append(map.get(phylogenyNode).toString());
            stringBuffer.append(ForesterUtil.getLineSeparator());
        }
        return stringBuffer;
    }

    private static boolean testBasicDomainSimilarityCalculator() {
        try {
            BasicDomain basicDomain = new BasicDomain("A", 1, 2, 1, 1, 0.15, -12.0);
            BasicDomain basicDomain2 = new BasicDomain("B", 1, 2, 1, 1, 0.2, -12.0);
            BasicDomain basicDomain3 = new BasicDomain("C", 1, 2, 1, 1, 0.3, -12.0);
            BasicDomain basicDomain4 = new BasicDomain("D", 1, 2, 1, 1, 0.5, -12.0);
            BasicDomain basicDomain5 = new BasicDomain("E", 1, 2, 1, 1, 0.5, -12.0);
            BasicDomain basicDomain6 = new BasicDomain("F", 1, 2, 1, 1, 0.01, -12.0);
            BasicDomain basicDomain7 = new BasicDomain("G", 1, 2, 1, 1, 0.001, -12.0);
            BasicDomain basicDomain8 = new BasicDomain("X", 1, 2, 1, 1, 1.0E-4, -12.0);
            BasicProtein basicProtein = new BasicProtein("1", "mouse", 0);
            BasicProtein basicProtein2 = new BasicProtein("1", "rabbit", 0);
            BasicProtein basicProtein3 = new BasicProtein("1", "ciona", 0);
            BasicProtein basicProtein4 = new BasicProtein("1", "nemve", 0);
            basicProtein.addProteinDomain(basicDomain);
            basicProtein.addProteinDomain(basicDomain2);
            basicProtein.addProteinDomain(basicDomain3);
            basicProtein.addProteinDomain(basicDomain4);
            basicProtein.addProteinDomain(basicDomain5);
            basicProtein2.addProteinDomain(basicDomain);
            basicProtein2.addProteinDomain(basicDomain3);
            basicProtein2.addProteinDomain(basicDomain5);
            basicProtein2.addProteinDomain(basicDomain6);
            basicProtein2.addProteinDomain(basicDomain6);
            basicProtein2.addProteinDomain(basicDomain6);
            basicProtein2.addProteinDomain(basicDomain6);
            basicProtein2.addProteinDomain(basicDomain6);
            basicProtein2.addProteinDomain(basicDomain6);
            basicProtein3.addProteinDomain(basicDomain);
            basicProtein3.addProteinDomain(basicDomain);
            basicProtein3.addProteinDomain(basicDomain);
            basicProtein3.addProteinDomain(basicDomain);
            basicProtein3.addProteinDomain(basicDomain);
            basicProtein3.addProteinDomain(basicDomain6);
            basicProtein3.addProteinDomain(basicDomain7);
            basicProtein3.addProteinDomain(basicDomain8);
            basicProtein4.addProteinDomain(basicDomain);
            basicProtein4.addProteinDomain(basicDomain2);
            basicProtein4.addProteinDomain(basicDomain3);
            basicProtein4.addProteinDomain(basicDomain4);
            basicProtein4.addProteinDomain(basicDomain5);
            basicProtein4.addProteinDomain(basicDomain6);
            basicProtein4.addProteinDomain(basicDomain7);
            ArrayList<Protein> arrayList = new ArrayList<Protein>();
            ArrayList<Protein> arrayList2 = new ArrayList<Protein>();
            ArrayList<Protein> arrayList3 = new ArrayList<Protein>();
            ArrayList<Protein> arrayList4 = new ArrayList<Protein>();
            arrayList.add(basicProtein);
            arrayList2.add(basicProtein2);
            arrayList3.add(basicProtein3);
            arrayList4.add(basicProtein4);
            ArrayList<GenomeWideCombinableDomains> arrayList5 = new ArrayList<GenomeWideCombinableDomains>();
            arrayList5.add(BasicGenomeWideCombinableDomains.createInstance(arrayList, true, new BasicSpecies("mouse")));
            arrayList5.add(BasicGenomeWideCombinableDomains.createInstance(arrayList2, true, new BasicSpecies("rabbit")));
            arrayList5.add(BasicGenomeWideCombinableDomains.createInstance(arrayList3, true, new BasicSpecies("ciona")));
            arrayList5.add(BasicGenomeWideCombinableDomains.createInstance(arrayList4, true, new BasicSpecies("nemve")));
            BasicDomainSimilarityCalculator basicDomainSimilarityCalculator = new BasicDomainSimilarityCalculator(DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID, false, false, true);
            SortedSet<DomainSimilarity> sortedSet = basicDomainSimilarityCalculator.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), arrayList5, true, true);
            Iterator iterator = sortedSet.iterator();
            DomainSimilarity domainSimilarity = (DomainSimilarity)iterator.next();
            if (!domainSimilarity.getDomainId().equals("A")) {
                return false;
            }
            if (domainSimilarity.getSpeciesData().size() != 4) {
                return false;
            }
            if (!domainSimilarity.getSpecies().contains(new BasicSpecies("ciona"))) {
                return false;
            }
            if (!domainSimilarity.getSpecies().contains(new BasicSpecies("mouse"))) {
                return false;
            }
            if (!domainSimilarity.getSpecies().contains(new BasicSpecies("nemve"))) {
                return false;
            }
            if (!domainSimilarity.getSpecies().contains(new BasicSpecies("rabbit"))) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity.getMeanSimilarityScore(), 0.342063492063492)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity.getStandardDeviationOfSimilarityScore(), 0.23410788192183737)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity.getMaximalSimilarityScore(), 0.6666666666666666)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity.getMinimalSimilarityScore(), 0.0)) {
                return false;
            }
            if (domainSimilarity.getN() != 6) {
                return false;
            }
            if (domainSimilarity.getMaximalDifference() != 7) {
                return false;
            }
            if (domainSimilarity.getMaximalDifferenceInCounts() != 3) {
                return false;
            }
            DomainSimilarity domainSimilarity2 = (DomainSimilarity)iterator.next();
            if (!domainSimilarity2.getDomainId().equals("B")) {
                return false;
            }
            if (domainSimilarity2.getSpeciesData().size() != 2) {
                return false;
            }
            if (!domainSimilarity2.getSpecies().contains(new BasicSpecies("mouse"))) {
                return false;
            }
            if (!domainSimilarity2.getSpecies().contains(new BasicSpecies("nemve"))) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity2.getMeanSimilarityScore(), 0.6666666666666666)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity2.getStandardDeviationOfSimilarityScore(), 0.0)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity2.getMaximalSimilarityScore(), 0.6666666666666666)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity2.getMinimalSimilarityScore(), 0.6666666666666666)) {
                return false;
            }
            if (domainSimilarity2.getN() != 1) {
                return false;
            }
            if (domainSimilarity2.getMaximalDifference() != 2) {
                return false;
            }
            if (domainSimilarity2.getMaximalDifferenceInCounts() != 2) {
                return false;
            }
            DomainSimilarity domainSimilarity3 = (DomainSimilarity)iterator.next();
            if (!domainSimilarity3.getDomainId().equals("C")) {
                return false;
            }
            if (domainSimilarity3.getSpeciesData().size() != 3) {
                return false;
            }
            if (!domainSimilarity3.getSpecies().contains(new BasicSpecies("mouse"))) {
                return false;
            }
            if (!domainSimilarity3.getSpecies().contains(new BasicSpecies("rabbit"))) {
                return false;
            }
            if (!domainSimilarity3.getSpecies().contains(new BasicSpecies("nemve"))) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity3.getMeanSimilarityScore(), 0.5222222222222223)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity3.getStandardDeviationOfSimilarityScore(), 0.13471506281091264)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity3.getMaximalSimilarityScore(), 0.6666666666666666)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity3.getMinimalSimilarityScore(), 0.4)) {
                return false;
            }
            if (domainSimilarity3.getN() != 3) {
                return false;
            }
            if (domainSimilarity3.getMaximalDifference() != 3) {
                return false;
            }
            if (domainSimilarity3.getMaximalDifferenceInCounts() != 3) {
                return false;
            }
            ArrayList<GenomeWideCombinableDomains> arrayList6 = new ArrayList<GenomeWideCombinableDomains>();
            arrayList6.add(BasicGenomeWideCombinableDomains.createInstance(arrayList, false, new BasicSpecies("mouse")));
            arrayList6.add(BasicGenomeWideCombinableDomains.createInstance(arrayList2, false, new BasicSpecies("rabbit")));
            arrayList6.add(BasicGenomeWideCombinableDomains.createInstance(arrayList3, false, new BasicSpecies("ciona")));
            arrayList6.add(BasicGenomeWideCombinableDomains.createInstance(arrayList4, false, new BasicSpecies("nemve")));
            BasicDomainSimilarityCalculator basicDomainSimilarityCalculator2 = new BasicDomainSimilarityCalculator(DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID, false, false, true);
            SortedSet<DomainSimilarity> sortedSet2 = basicDomainSimilarityCalculator2.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), arrayList6, false, true);
            Iterator iterator2 = sortedSet2.iterator();
            DomainSimilarity domainSimilarity4 = (DomainSimilarity)iterator2.next();
            if (!domainSimilarity4.getDomainId().equals("A")) {
                return false;
            }
            if (domainSimilarity4.getSpeciesData().size() != 4) {
                return false;
            }
            if (!domainSimilarity4.getSpecies().contains(new BasicSpecies("ciona"))) {
                return false;
            }
            if (!domainSimilarity4.getSpecies().contains(new BasicSpecies("mouse"))) {
                return false;
            }
            if (!domainSimilarity4.getSpecies().contains(new BasicSpecies("nemve"))) {
                return false;
            }
            if (!domainSimilarity4.getSpeciesData().keySet().contains(new BasicSpecies("rabbit"))) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity4.getMeanSimilarityScore(), 0.33055555555555555)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity4.getStandardDeviationOfSimilarityScore(), 0.2404663678647683)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity4.getMaximalSimilarityScore(), 0.6666666666666666)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity4.getMinimalSimilarityScore(), 0.0)) {
                return false;
            }
            if (domainSimilarity4.getN() != 6) {
                return false;
            }
            if (domainSimilarity4.getMaximalDifference() != 8) {
                return false;
            }
            if (domainSimilarity4.getMaximalDifferenceInCounts() != 3) {
                return false;
            }
            BasicProtein basicProtein5 = new BasicProtein("2", "ciona", 0);
            basicProtein5.addProteinDomain(basicDomain);
            basicProtein5.addProteinDomain(basicDomain);
            basicProtein5.addProteinDomain(basicDomain);
            basicProtein5.addProteinDomain(basicDomain2);
            basicProtein5.addProteinDomain(basicDomain2);
            basicProtein5.addProteinDomain(basicDomain2);
            basicProtein5.addProteinDomain(basicDomain6);
            basicProtein5.addProteinDomain(basicDomain6);
            basicProtein5.addProteinDomain(basicDomain6);
            basicProtein5.addProteinDomain(basicDomain6);
            basicProtein5.addProteinDomain(basicDomain7);
            basicProtein5.addProteinDomain(basicDomain8);
            BasicProtein basicProtein6 = new BasicProtein("3", "ciona", 0);
            basicProtein6.addProteinDomain(basicDomain);
            basicProtein6.addProteinDomain(basicDomain);
            basicProtein6.addProteinDomain(basicDomain);
            basicProtein6.addProteinDomain(basicDomain);
            basicProtein6.addProteinDomain(basicDomain2);
            basicProtein6.addProteinDomain(basicDomain2);
            basicProtein6.addProteinDomain(basicDomain8);
            basicProtein6.addProteinDomain(basicDomain8);
            arrayList3.add(basicProtein5);
            arrayList3.add(basicProtein6);
            ArrayList<GenomeWideCombinableDomains> arrayList7 = new ArrayList<GenomeWideCombinableDomains>();
            arrayList7.add(BasicGenomeWideCombinableDomains.createInstance(arrayList, true, new BasicSpecies("mouse")));
            arrayList7.add(BasicGenomeWideCombinableDomains.createInstance(arrayList2, true, new BasicSpecies("rabbit")));
            arrayList7.add(BasicGenomeWideCombinableDomains.createInstance(arrayList3, true, new BasicSpecies("ciona")));
            arrayList7.add(BasicGenomeWideCombinableDomains.createInstance(arrayList4, true, new BasicSpecies("nemve")));
            BasicDomainSimilarityCalculator basicDomainSimilarityCalculator3 = new BasicDomainSimilarityCalculator(DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID, false, false, true);
            SortedSet<DomainSimilarity> sortedSet3 = basicDomainSimilarityCalculator3.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), arrayList7, false, true);
            Iterator iterator3 = sortedSet3.iterator();
            DomainSimilarity domainSimilarity5 = (DomainSimilarity)iterator3.next();
            if (!domainSimilarity5.getDomainId().equals("A")) {
                return false;
            }
            PrintableSpeciesSpecificDcData printableSpeciesSpecificDcData = (PrintableSpeciesSpecificDcData)domainSimilarity5.getSpeciesData().get(new BasicSpecies("ciona"));
            if (printableSpeciesSpecificDcData.getCombinableDomainIdToCountsMap().size() != 4) {
                return false;
            }
            if (printableSpeciesSpecificDcData.getNumberOfProteinsExhibitingCombinationWith("B") != 2) {
                return false;
            }
            if (printableSpeciesSpecificDcData.getNumberOfProteinsExhibitingCombinationWith("F") != 2) {
                return false;
            }
            if (printableSpeciesSpecificDcData.getNumberOfProteinsExhibitingCombinationWith("G") != 2) {
                return false;
            }
            if (printableSpeciesSpecificDcData.getNumberOfProteinsExhibitingCombinationWith("X") != 3) {
                return false;
            }
            ArrayList<GenomeWideCombinableDomains> arrayList8 = new ArrayList<GenomeWideCombinableDomains>();
            arrayList8.add(BasicGenomeWideCombinableDomains.createInstance(arrayList, false, new BasicSpecies("mouse")));
            arrayList8.add(BasicGenomeWideCombinableDomains.createInstance(arrayList2, false, new BasicSpecies("rabbit")));
            arrayList8.add(BasicGenomeWideCombinableDomains.createInstance(arrayList3, false, new BasicSpecies("ciona")));
            arrayList8.add(BasicGenomeWideCombinableDomains.createInstance(arrayList4, false, new BasicSpecies("nemve")));
            BasicDomainSimilarityCalculator basicDomainSimilarityCalculator4 = new BasicDomainSimilarityCalculator(DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID, true, false, true);
            SortedSet<DomainSimilarity> sortedSet4 = basicDomainSimilarityCalculator4.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), arrayList8, false, true);
            Iterator iterator4 = sortedSet4.iterator();
            DomainSimilarity domainSimilarity6 = (DomainSimilarity)iterator4.next();
            if (!domainSimilarity6.getDomainId().equals("A")) {
                return false;
            }
            PrintableSpeciesSpecificDcData printableSpeciesSpecificDcData2 = (PrintableSpeciesSpecificDcData)domainSimilarity6.getSpeciesData().get(new BasicSpecies("ciona"));
            if (printableSpeciesSpecificDcData2.getCombinableDomainIdToCountsMap().size() != 5) {
                return false;
            }
            if (printableSpeciesSpecificDcData2.getNumberOfProteinsExhibitingCombinationWith("A") != 3) {
                return false;
            }
            if (printableSpeciesSpecificDcData2.getNumberOfProteinsExhibitingCombinationWith("B") != 2) {
                return false;
            }
            if (printableSpeciesSpecificDcData2.getNumberOfProteinsExhibitingCombinationWith("F") != 2) {
                return false;
            }
            if (printableSpeciesSpecificDcData2.getNumberOfProteinsExhibitingCombinationWith("G") != 2) {
                return false;
            }
            if (printableSpeciesSpecificDcData2.getNumberOfProteinsExhibitingCombinationWith("X") != 3) {
                return false;
            }
            SortedSet<DomainSimilarity> sortedSet5 = basicDomainSimilarityCalculator4.calculateSimilarities(new DomainCountsBasedPairwiseSimilarityCalculator(), arrayList8, false, true);
            Iterator iterator5 = sortedSet5.iterator();
            DomainSimilarity domainSimilarity7 = (DomainSimilarity)iterator5.next();
            if (!domainSimilarity7.getDomainId().equals("A")) {
                return false;
            }
            if (domainSimilarity7.getCombinableDomainIds(new BasicSpecies("ciona")).size() != 5) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity7.getMeanSimilarityScore(), 0.5769230769230769)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity7.getMaximalSimilarityScore(), 1.0)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity7.getMinimalSimilarityScore(), 0.15384615384615385)) {
                return false;
            }
            if (domainSimilarity7.getN() != 6) {
                return false;
            }
            SortedSet<DomainSimilarity> sortedSet6 = basicDomainSimilarityCalculator4.calculateSimilarities(new ProteinCountsBasedPairwiseDomainSimilarityCalculator(), arrayList8, false, true);
            Iterator iterator6 = sortedSet6.iterator();
            DomainSimilarity domainSimilarity8 = (DomainSimilarity)iterator6.next();
            if (!domainSimilarity8.getDomainId().equals("A")) {
                return false;
            }
            if (domainSimilarity8.getCombinableDomainIds(new BasicSpecies("ciona")).size() != 5) {
                return false;
            }
            if (!domainSimilarity8.getCombinableDomainIds(new BasicSpecies("ciona")).contains("A")) {
                return false;
            }
            if (!domainSimilarity8.getCombinableDomainIds(new BasicSpecies("ciona")).contains("B")) {
                return false;
            }
            if (!domainSimilarity8.getCombinableDomainIds(new BasicSpecies("ciona")).contains("F")) {
                return false;
            }
            if (!domainSimilarity8.getCombinableDomainIds(new BasicSpecies("ciona")).contains("G")) {
                return false;
            }
            if (!domainSimilarity8.getCombinableDomainIds(new BasicSpecies("ciona")).contains("X")) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity8.getMeanSimilarityScore(), 0.75)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity8.getMaximalSimilarityScore(), 1.0)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity8.getMinimalSimilarityScore(), 0.5)) {
                return false;
            }
            if (domainSimilarity8.getN() != 6) {
                return false;
            }
            ArrayList<GenomeWideCombinableDomains> arrayList9 = new ArrayList<GenomeWideCombinableDomains>();
            arrayList9.add(BasicGenomeWideCombinableDomains.createInstance(arrayList, true, new BasicSpecies("mouse")));
            arrayList9.add(BasicGenomeWideCombinableDomains.createInstance(arrayList2, true, new BasicSpecies("rabbit")));
            arrayList9.add(BasicGenomeWideCombinableDomains.createInstance(arrayList3, true, new BasicSpecies("ciona")));
            arrayList9.add(BasicGenomeWideCombinableDomains.createInstance(arrayList4, true, new BasicSpecies("nemve")));
            SortedSet<DomainSimilarity> sortedSet7 = basicDomainSimilarityCalculator4.calculateSimilarities(new DomainCountsBasedPairwiseSimilarityCalculator(), arrayList9, false, true);
            Iterator iterator7 = sortedSet7.iterator();
            DomainSimilarity domainSimilarity9 = (DomainSimilarity)iterator7.next();
            if (domainSimilarity9.getSpecies().size() != 4) {
                return false;
            }
            if (!domainSimilarity9.getSpecies().last().equals(new BasicSpecies("rabbit"))) {
                return false;
            }
            PrintableSpeciesSpecificDcData printableSpeciesSpecificDcData3 = (PrintableSpeciesSpecificDcData)domainSimilarity9.getSpeciesData().get(new BasicSpecies("ciona"));
            if (printableSpeciesSpecificDcData3.getCombinableDomainIdToCountsMap().size() != 4) {
                return false;
            }
            if (printableSpeciesSpecificDcData3.getNumberOfProteinsExhibitingCombinationWith("B") != 2) {
                return false;
            }
            if (printableSpeciesSpecificDcData3.getNumberOfProteinsExhibitingCombinationWith("F") != 2) {
                return false;
            }
            if (printableSpeciesSpecificDcData3.getNumberOfProteinsExhibitingCombinationWith("G") != 2) {
                return false;
            }
            if (printableSpeciesSpecificDcData3.getNumberOfProteinsExhibitingCombinationWith("X") != 3) {
                return false;
            }
            if (!domainSimilarity9.getDomainId().equals("A")) {
                return false;
            }
            BasicSpecies basicSpecies = new BasicSpecies("ciona");
            if (domainSimilarity9.getCombinableDomainIds(basicSpecies).size() != 4) {
                return false;
            }
            if (domainSimilarity9.getCombinableDomainIds(basicSpecies).contains("A")) {
                return false;
            }
            if (!domainSimilarity9.getCombinableDomainIds(basicSpecies).contains("B")) {
                return false;
            }
            if (!domainSimilarity9.getCombinableDomainIds(basicSpecies).contains("F")) {
                return false;
            }
            if (!domainSimilarity9.getCombinableDomainIds(basicSpecies).contains("G")) {
                return false;
            }
            if (!domainSimilarity9.getCombinableDomainIds(basicSpecies).contains("X")) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity9.getMeanSimilarityScore(), 0.5769230769230769)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity9.getMaximalSimilarityScore(), 1.0)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity9.getMinimalSimilarityScore(), 0.15384615384615385)) {
                return false;
            }
            if (domainSimilarity9.getN() != 6) {
                return false;
            }
            if (domainSimilarity9.getMaximalDifference() != domainSimilarity9.getMaximalDifferenceInCounts()) {
                return false;
            }
            if (domainSimilarity9.getMaximalDifference() != 11) {
                return false;
            }
            if (domainSimilarity9.getMaximalDifferenceInCounts() != 11) {
                return false;
            }
            SortedSet<DomainSimilarity> sortedSet8 = basicDomainSimilarityCalculator4.calculateSimilarities(new ProteinCountsBasedPairwiseDomainSimilarityCalculator(), arrayList9, false, true);
            Iterator iterator8 = sortedSet8.iterator();
            DomainSimilarity domainSimilarity10 = (DomainSimilarity)iterator8.next();
            if (!domainSimilarity10.getDomainId().equals("A")) {
                return false;
            }
            if (domainSimilarity10.getCombinableDomainIds(basicSpecies).size() != 4) {
                return false;
            }
            if (domainSimilarity10.getCombinableDomainIds(basicSpecies).contains("A")) {
                return false;
            }
            if (!domainSimilarity10.getCombinableDomainIds(basicSpecies).contains("B")) {
                return false;
            }
            if (!domainSimilarity10.getCombinableDomainIds(basicSpecies).contains("F")) {
                return false;
            }
            if (!domainSimilarity10.getCombinableDomainIds(basicSpecies).contains("G")) {
                return false;
            }
            if (!domainSimilarity10.getCombinableDomainIds(basicSpecies).contains("X")) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity10.getMeanSimilarityScore(), 0.75)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity10.getMaximalSimilarityScore(), 1.0)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity10.getMinimalSimilarityScore(), 0.5)) {
                return false;
            }
            if (domainSimilarity10.getN() != 6) {
                return false;
            }
            if (domainSimilarity10.getMaximalDifference() != domainSimilarity10.getMaximalDifferenceInCounts()) {
                return false;
            }
            if (domainSimilarity10.getMaximalDifference() != 2) {
                return false;
            }
            if (domainSimilarity10.getMaximalDifferenceInCounts() != 2) {
                return false;
            }
            ArrayList<GenomeWideCombinableDomains> arrayList10 = new ArrayList<GenomeWideCombinableDomains>();
            arrayList10.add(BasicGenomeWideCombinableDomains.createInstance(arrayList, false, new BasicSpecies("mouse")));
            arrayList10.add(BasicGenomeWideCombinableDomains.createInstance(arrayList2, false, new BasicSpecies("rabbit")));
            arrayList10.add(BasicGenomeWideCombinableDomains.createInstance(arrayList3, false, new BasicSpecies("ciona")));
            arrayList10.add(BasicGenomeWideCombinableDomains.createInstance(arrayList4, false, new BasicSpecies("nemve")));
            SortedSet<DomainSimilarity> sortedSet9 = basicDomainSimilarityCalculator4.calculateSimilarities(new DomainCountsBasedPairwiseSimilarityCalculator(), arrayList10, false, true);
            Iterator iterator9 = sortedSet9.iterator();
            DomainSimilarity domainSimilarity11 = (DomainSimilarity)iterator9.next();
            if (domainSimilarity11.getSpecies().size() != 4) {
                return false;
            }
            if (!domainSimilarity11.getSpecies().last().equals(new BasicSpecies("rabbit"))) {
                return false;
            }
            PrintableSpeciesSpecificDcData printableSpeciesSpecificDcData4 = (PrintableSpeciesSpecificDcData)domainSimilarity11.getSpeciesData().get(new BasicSpecies("ciona"));
            if (printableSpeciesSpecificDcData4.getCombinableDomainIdToCountsMap().size() != 5) {
                return false;
            }
            if (printableSpeciesSpecificDcData4.getNumberOfProteinsExhibitingCombinationWith("B") != 2) {
                return false;
            }
            if (printableSpeciesSpecificDcData4.getNumberOfProteinsExhibitingCombinationWith("F") != 2) {
                return false;
            }
            if (printableSpeciesSpecificDcData4.getNumberOfProteinsExhibitingCombinationWith("G") != 2) {
                return false;
            }
            if (printableSpeciesSpecificDcData4.getNumberOfProteinsExhibitingCombinationWith("X") != 3) {
                return false;
            }
            if (!domainSimilarity9.getDomainId().equals("A")) {
                return false;
            }
            BasicSpecies basicSpecies2 = new BasicSpecies("ciona");
            if (domainSimilarity11.getCombinableDomainIds(basicSpecies2).size() != 5) {
                return false;
            }
            if (!domainSimilarity11.getCombinableDomainIds(basicSpecies2).contains("A")) {
                return false;
            }
            if (!domainSimilarity11.getCombinableDomainIds(basicSpecies2).contains("B")) {
                return false;
            }
            if (!domainSimilarity11.getCombinableDomainIds(basicSpecies2).contains("F")) {
                return false;
            }
            if (!domainSimilarity11.getCombinableDomainIds(basicSpecies2).contains("G")) {
                return false;
            }
            if (!domainSimilarity11.getCombinableDomainIds(basicSpecies2).contains("X")) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity11.getMeanSimilarityScore(), 0.5769230769230769)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity11.getMaximalSimilarityScore(), 1.0)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity11.getMinimalSimilarityScore(), 0.15384615384615385)) {
                return false;
            }
            if (domainSimilarity11.getN() != 6) {
                return false;
            }
            if (domainSimilarity11.getMaximalDifference() != domainSimilarity11.getMaximalDifferenceInCounts()) {
                return false;
            }
            if (domainSimilarity11.getMaximalDifference() != 11) {
                return false;
            }
            if (domainSimilarity11.getMaximalDifferenceInCounts() != 11) {
                return false;
            }
            SortedSet<DomainSimilarity> sortedSet10 = basicDomainSimilarityCalculator4.calculateSimilarities(new ProteinCountsBasedPairwiseDomainSimilarityCalculator(), arrayList10, false, true);
            Iterator iterator10 = sortedSet10.iterator();
            DomainSimilarity domainSimilarity12 = (DomainSimilarity)iterator10.next();
            if (!domainSimilarity12.getDomainId().equals("A")) {
                return false;
            }
            if (domainSimilarity12.getCombinableDomainIds(basicSpecies).size() != 5) {
                return false;
            }
            if (!domainSimilarity12.getCombinableDomainIds(basicSpecies).contains("A")) {
                return false;
            }
            if (!domainSimilarity12.getCombinableDomainIds(basicSpecies).contains("B")) {
                return false;
            }
            if (!domainSimilarity12.getCombinableDomainIds(basicSpecies).contains("F")) {
                return false;
            }
            if (!domainSimilarity12.getCombinableDomainIds(basicSpecies).contains("G")) {
                return false;
            }
            if (!domainSimilarity12.getCombinableDomainIds(basicSpecies).contains("X")) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity12.getMeanSimilarityScore(), 0.75)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity12.getMaximalSimilarityScore(), 1.0)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity12.getMinimalSimilarityScore(), 0.5)) {
                return false;
            }
            if (domainSimilarity12.getN() != 6) {
                return false;
            }
            if (domainSimilarity12.getMaximalDifference() != domainSimilarity12.getMaximalDifferenceInCounts()) {
                return false;
            }
            if (domainSimilarity12.getMaximalDifference() != 2) {
                return false;
            }
            if (domainSimilarity12.getMaximalDifferenceInCounts() != 2) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testBasicDomainSimilarityCalculatorNotIgnoringSpeciesSpeficDomains() {
        try {
            BasicDomain basicDomain = new BasicDomain("A", 1, 2, 1, 1, 0.15, -12.0);
            BasicDomain basicDomain2 = new BasicDomain("B", 1, 2, 1, 1, 0.2, -12.0);
            BasicDomain basicDomain3 = new BasicDomain("D", 1, 2, 1, 1, 0.5, -12.0);
            BasicDomain basicDomain4 = new BasicDomain("E", 1, 2, 1, 1, 0.5, -12.0);
            BasicDomain basicDomain5 = new BasicDomain("F", 1, 2, 1, 1, 0.01, -12.0);
            BasicDomain basicDomain6 = new BasicDomain("G", 1, 2, 1, 1, 0.001, -12.0);
            BasicDomain basicDomain7 = new BasicDomain("X", 1, 2, 1, 1, 1.0E-4, -12.0);
            BasicProtein basicProtein = new BasicProtein("1", "mouse", 0);
            BasicProtein basicProtein2 = new BasicProtein("1", "rabbit", 0);
            BasicProtein basicProtein3 = new BasicProtein("1", "ciona", 0);
            BasicProtein basicProtein4 = new BasicProtein("1", "nemve", 0);
            basicProtein.addProteinDomain(basicDomain);
            basicProtein.addProteinDomain(basicDomain3);
            basicProtein.addProteinDomain(basicDomain4);
            basicProtein2.addProteinDomain(basicDomain2);
            basicProtein2.addProteinDomain(basicDomain4);
            basicProtein2.addProteinDomain(basicDomain5);
            basicProtein2.addProteinDomain(basicDomain5);
            basicProtein2.addProteinDomain(basicDomain5);
            basicProtein2.addProteinDomain(basicDomain5);
            basicProtein2.addProteinDomain(basicDomain5);
            basicProtein2.addProteinDomain(basicDomain5);
            basicProtein3.addProteinDomain(basicDomain5);
            basicProtein3.addProteinDomain(basicDomain6);
            basicProtein3.addProteinDomain(basicDomain7);
            basicProtein4.addProteinDomain(basicDomain3);
            basicProtein4.addProteinDomain(basicDomain4);
            basicProtein4.addProteinDomain(basicDomain5);
            basicProtein4.addProteinDomain(basicDomain6);
            ArrayList<Protein> arrayList = new ArrayList<Protein>();
            ArrayList<Protein> arrayList2 = new ArrayList<Protein>();
            ArrayList<Protein> arrayList3 = new ArrayList<Protein>();
            ArrayList<Protein> arrayList4 = new ArrayList<Protein>();
            arrayList.add(basicProtein);
            arrayList2.add(basicProtein2);
            arrayList3.add(basicProtein3);
            arrayList4.add(basicProtein4);
            ArrayList<GenomeWideCombinableDomains> arrayList5 = new ArrayList<GenomeWideCombinableDomains>();
            arrayList5.add(BasicGenomeWideCombinableDomains.createInstance(arrayList, true, new BasicSpecies("mouse")));
            arrayList5.add(BasicGenomeWideCombinableDomains.createInstance(arrayList2, true, new BasicSpecies("rabbit")));
            arrayList5.add(BasicGenomeWideCombinableDomains.createInstance(arrayList3, true, new BasicSpecies("ciona")));
            arrayList5.add(BasicGenomeWideCombinableDomains.createInstance(arrayList4, true, new BasicSpecies("nemve")));
            BasicDomainSimilarityCalculator basicDomainSimilarityCalculator = new BasicDomainSimilarityCalculator(DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID, false, false, true);
            SortedSet<DomainSimilarity> sortedSet = basicDomainSimilarityCalculator.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), arrayList5, true, false);
            Iterator iterator = sortedSet.iterator();
            DomainSimilarity domainSimilarity = (DomainSimilarity)iterator.next();
            if (!domainSimilarity.getDomainId().equals("A")) {
                return false;
            }
            if (domainSimilarity.getSpeciesData().size() != 1) {
                return false;
            }
            if (!domainSimilarity.getSpecies().contains(new BasicSpecies("mouse"))) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity.getMeanSimilarityScore(), 1.0)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity.getStandardDeviationOfSimilarityScore(), 0.0)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity.getMaximalSimilarityScore(), 1.0)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainSimilarity.getMinimalSimilarityScore(), 1.0)) {
                return false;
            }
            if (domainSimilarity.getN() != 0) {
                return false;
            }
            if (domainSimilarity.getMaximalDifference() != 0) {
                return false;
            }
            if (domainSimilarity.getMaximalDifferenceInCounts() != 0) {
                return false;
            }
            DomainSimilarity domainSimilarity2 = (DomainSimilarity)iterator.next();
            if (!domainSimilarity2.getDomainId().equals("B")) {
                return false;
            }
            if (domainSimilarity2.getSpeciesData().size() != 1) {
                return false;
            }
            if (!domainSimilarity2.getSpecies().contains(new BasicSpecies("rabbit"))) {
                return false;
            }
            SortedSet<DomainSimilarity> sortedSet2 = basicDomainSimilarityCalculator.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), arrayList5, true, true);
            Iterator iterator2 = sortedSet2.iterator();
            DomainSimilarity domainSimilarity3 = (DomainSimilarity)iterator2.next();
            if (!domainSimilarity3.getDomainId().equals("D")) {
                return false;
            }
            if (domainSimilarity3.getSpeciesData().size() != 2) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testBasicDomainSimilarityCalculatorRemovalOfSingles() {
        try {
            BasicDomain basicDomain = new BasicDomain("A", 1, 2, 1, 1, 0.15, -12.0);
            BasicDomain basicDomain2 = new BasicDomain("B", 1, 2, 1, 1, 0.2, -12.0);
            BasicProtein basicProtein = new BasicProtein("1", "mouse", 0);
            BasicProtein basicProtein2 = new BasicProtein("1", "rabbit", 0);
            BasicProtein basicProtein3 = new BasicProtein("1", "ciona", 0);
            BasicProtein basicProtein4 = new BasicProtein("1", "nemve", 0);
            basicProtein.addProteinDomain(basicDomain);
            basicProtein2.addProteinDomain(basicDomain);
            basicProtein3.addProteinDomain(basicDomain);
            basicProtein3.addProteinDomain(basicDomain);
            basicProtein3.addProteinDomain(basicDomain);
            basicProtein3.addProteinDomain(basicDomain);
            basicProtein3.addProteinDomain(basicDomain);
            basicProtein4.addProteinDomain(basicDomain);
            ArrayList<Protein> arrayList = new ArrayList<Protein>();
            ArrayList<Protein> arrayList2 = new ArrayList<Protein>();
            ArrayList<Protein> arrayList3 = new ArrayList<Protein>();
            ArrayList<Protein> arrayList4 = new ArrayList<Protein>();
            arrayList.add(basicProtein);
            arrayList2.add(basicProtein2);
            arrayList3.add(basicProtein3);
            arrayList4.add(basicProtein4);
            ArrayList<GenomeWideCombinableDomains> arrayList5 = new ArrayList<GenomeWideCombinableDomains>();
            arrayList5.add(BasicGenomeWideCombinableDomains.createInstance(arrayList, true, new BasicSpecies("mouse")));
            arrayList5.add(BasicGenomeWideCombinableDomains.createInstance(arrayList2, true, new BasicSpecies("rabbit")));
            arrayList5.add(BasicGenomeWideCombinableDomains.createInstance(arrayList3, true, new BasicSpecies("ciona")));
            arrayList5.add(BasicGenomeWideCombinableDomains.createInstance(arrayList4, true, new BasicSpecies("nemve")));
            BasicDomainSimilarityCalculator basicDomainSimilarityCalculator = new BasicDomainSimilarityCalculator(DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID, false, false, true);
            SortedSet<DomainSimilarity> sortedSet = basicDomainSimilarityCalculator.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), arrayList5, false, true);
            if (sortedSet.size() != 1) {
                return false;
            }
            Iterator iterator = sortedSet.iterator();
            DomainSimilarity domainSimilarity = (DomainSimilarity)iterator.next();
            if (!domainSimilarity.getDomainId().equals("A")) {
                return false;
            }
            if (domainSimilarity.getSpeciesData().size() != 4) {
                return false;
            }
            if (!domainSimilarity.getSpecies().contains(new BasicSpecies("ciona"))) {
                return false;
            }
            if (!domainSimilarity.getSpecies().contains(new BasicSpecies("mouse"))) {
                return false;
            }
            if (!domainSimilarity.getSpecies().contains(new BasicSpecies("nemve"))) {
                return false;
            }
            if (!domainSimilarity.getSpecies().contains(new BasicSpecies("rabbit"))) {
                return false;
            }
            SortedSet<DomainSimilarity> sortedSet2 = basicDomainSimilarityCalculator.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), arrayList5, true, true);
            if (sortedSet2.size() != 0) {
                return false;
            }
            BasicProtein basicProtein5 = new BasicProtein("1", "mouse", 0);
            BasicProtein basicProtein6 = new BasicProtein("1", "rabbit", 0);
            BasicProtein basicProtein7 = new BasicProtein("1", "ciona", 0);
            BasicProtein basicProtein8 = new BasicProtein("1", "nemve", 0);
            basicProtein5.addProteinDomain(basicDomain);
            basicProtein6.addProteinDomain(basicDomain);
            basicProtein7.addProteinDomain(basicDomain);
            basicProtein7.addProteinDomain(basicDomain);
            basicProtein7.addProteinDomain(basicDomain2);
            basicProtein7.addProteinDomain(basicDomain);
            basicProtein7.addProteinDomain(basicDomain);
            basicProtein7.addProteinDomain(basicDomain);
            basicProtein8.addProteinDomain(basicDomain);
            ArrayList<Protein> arrayList6 = new ArrayList<Protein>();
            ArrayList<Protein> arrayList7 = new ArrayList<Protein>();
            ArrayList<Protein> arrayList8 = new ArrayList<Protein>();
            ArrayList<Protein> arrayList9 = new ArrayList<Protein>();
            arrayList6.add(basicProtein5);
            arrayList7.add(basicProtein6);
            arrayList8.add(basicProtein7);
            arrayList9.add(basicProtein8);
            ArrayList<GenomeWideCombinableDomains> arrayList10 = new ArrayList<GenomeWideCombinableDomains>();
            arrayList10.add(BasicGenomeWideCombinableDomains.createInstance(arrayList6, true, new BasicSpecies("mouse")));
            arrayList10.add(BasicGenomeWideCombinableDomains.createInstance(arrayList7, true, new BasicSpecies("rabbit")));
            arrayList10.add(BasicGenomeWideCombinableDomains.createInstance(arrayList8, true, new BasicSpecies("ciona")));
            arrayList10.add(BasicGenomeWideCombinableDomains.createInstance(arrayList9, true, new BasicSpecies("nemve")));
            SortedSet<DomainSimilarity> sortedSet3 = basicDomainSimilarityCalculator.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), arrayList10, true, true);
            if (sortedSet3.size() != 1) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testBinaryDomainCombination() {
        try {
            BasicBinaryDomainCombination basicBinaryDomainCombination = BasicBinaryDomainCombination.obtainInstance("a", "a");
            BasicBinaryDomainCombination basicBinaryDomainCombination2 = BasicBinaryDomainCombination.obtainInstance("b", "a");
            BasicBinaryDomainCombination basicBinaryDomainCombination3 = BasicBinaryDomainCombination.obtainInstance("a", "b");
            BasicBinaryDomainCombination basicBinaryDomainCombination4 = BasicBinaryDomainCombination.obtainInstance("B", "A");
            BasicBinaryDomainCombination basicBinaryDomainCombination5 = BasicBinaryDomainCombination.obtainInstance("A", "B");
            BasicBinaryDomainCombination basicBinaryDomainCombination6 = BasicBinaryDomainCombination.obtainInstance("c", "a");
            BasicBinaryDomainCombination basicBinaryDomainCombination7 = BasicBinaryDomainCombination.obtainInstance("b", "c");
            BasicBinaryDomainCombination basicBinaryDomainCombination8 = BasicBinaryDomainCombination.obtainInstance("d", "a");
            BasicBinaryDomainCombination basicBinaryDomainCombination9 = BasicBinaryDomainCombination.obtainInstance("b", "d");
            BinaryDomainCombination binaryDomainCombination = BasicBinaryDomainCombination.obtainInstance("z-z=a-aa");
            if (!binaryDomainCombination.toString().equals("a-aa=z-z")) {
                System.out.println(binaryDomainCombination.toString());
                return false;
            }
            if (!basicBinaryDomainCombination.equals(basicBinaryDomainCombination)) {
                return false;
            }
            if (basicBinaryDomainCombination.equals(basicBinaryDomainCombination2)) {
                return false;
            }
            if (basicBinaryDomainCombination2.equals(basicBinaryDomainCombination)) {
                return false;
            }
            if (!basicBinaryDomainCombination2.equals(basicBinaryDomainCombination3)) {
                return false;
            }
            if (!basicBinaryDomainCombination3.equals(basicBinaryDomainCombination2)) {
                return false;
            }
            if (basicBinaryDomainCombination3.equals(basicBinaryDomainCombination4)) {
                return false;
            }
            if (basicBinaryDomainCombination3.equals(basicBinaryDomainCombination4)) {
                return false;
            }
            if (basicBinaryDomainCombination3.equals(basicBinaryDomainCombination5)) {
                return false;
            }
            TreeSet<BasicBinaryDomainCombination> treeSet = new TreeSet<BasicBinaryDomainCombination>();
            treeSet.add(basicBinaryDomainCombination);
            treeSet.add(basicBinaryDomainCombination2);
            treeSet.add(basicBinaryDomainCombination3);
            treeSet.add(basicBinaryDomainCombination4);
            treeSet.add(basicBinaryDomainCombination4);
            treeSet.add(basicBinaryDomainCombination4);
            treeSet.add(basicBinaryDomainCombination5);
            treeSet.add(basicBinaryDomainCombination6);
            treeSet.add(basicBinaryDomainCombination7);
            treeSet.add(basicBinaryDomainCombination8);
            treeSet.add(basicBinaryDomainCombination8);
            treeSet.add(basicBinaryDomainCombination9);
            if (treeSet.size() != 7) {
                System.out.println(treeSet.size());
                return false;
            }
            DirectedBinaryDomainCombination directedBinaryDomainCombination = DirectedBinaryDomainCombination.obtainInstance("a", "a");
            DirectedBinaryDomainCombination directedBinaryDomainCombination2 = DirectedBinaryDomainCombination.obtainInstance("b", "a");
            DirectedBinaryDomainCombination directedBinaryDomainCombination3 = DirectedBinaryDomainCombination.obtainInstance("a", "b");
            DirectedBinaryDomainCombination directedBinaryDomainCombination4 = DirectedBinaryDomainCombination.obtainInstance("b", "b");
            if (!directedBinaryDomainCombination.equals(directedBinaryDomainCombination)) {
                return false;
            }
            if (directedBinaryDomainCombination.equals(directedBinaryDomainCombination4)) {
                return false;
            }
            if (directedBinaryDomainCombination3.equals(directedBinaryDomainCombination2)) {
                return false;
            }
            if (directedBinaryDomainCombination2.equals(directedBinaryDomainCombination3)) {
                return false;
            }
            if (!directedBinaryDomainCombination3.equals(directedBinaryDomainCombination3)) {
                return false;
            }
            if (directedBinaryDomainCombination3.equals(directedBinaryDomainCombination)) {
                return false;
            }
            if (directedBinaryDomainCombination3.equals(directedBinaryDomainCombination4)) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testBinaryStateMatrixToGainLossMatrix(File file) {
        CharacterStateMatrix.BinaryStates binaryStates = CharacterStateMatrix.BinaryStates.PRESENT;
        CharacterStateMatrix.BinaryStates binaryStates2 = CharacterStateMatrix.BinaryStates.ABSENT;
        try {
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> basicCharacterStateMatrix = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(7, 6);
            basicCharacterStateMatrix.setIdentifier(0, "A");
            basicCharacterStateMatrix.setIdentifier(1, "B");
            basicCharacterStateMatrix.setIdentifier(2, "C");
            basicCharacterStateMatrix.setIdentifier(3, "D");
            basicCharacterStateMatrix.setIdentifier(4, "1");
            basicCharacterStateMatrix.setIdentifier(5, "2");
            basicCharacterStateMatrix.setIdentifier(6, "3");
            basicCharacterStateMatrix.setState(0, 0, binaryStates2);
            basicCharacterStateMatrix.setState(1, 0, binaryStates2);
            basicCharacterStateMatrix.setState(2, 0, binaryStates2);
            basicCharacterStateMatrix.setState(3, 0, binaryStates2);
            basicCharacterStateMatrix.setState(4, 0, binaryStates2);
            basicCharacterStateMatrix.setState(5, 0, binaryStates2);
            basicCharacterStateMatrix.setState(6, 0, binaryStates2);
            basicCharacterStateMatrix.setState(0, 1, binaryStates);
            basicCharacterStateMatrix.setState(1, 1, binaryStates2);
            basicCharacterStateMatrix.setState(2, 1, binaryStates2);
            basicCharacterStateMatrix.setState(3, 1, binaryStates2);
            basicCharacterStateMatrix.setState(4, 1, binaryStates2);
            basicCharacterStateMatrix.setState(5, 1, binaryStates2);
            basicCharacterStateMatrix.setState(6, 1, binaryStates2);
            basicCharacterStateMatrix.setState(0, 2, binaryStates2);
            basicCharacterStateMatrix.setState(1, 2, binaryStates2);
            basicCharacterStateMatrix.setState(2, 2, binaryStates2);
            basicCharacterStateMatrix.setState(3, 2, binaryStates2);
            basicCharacterStateMatrix.setState(4, 2, binaryStates);
            basicCharacterStateMatrix.setState(5, 2, binaryStates2);
            basicCharacterStateMatrix.setState(6, 2, binaryStates2);
            basicCharacterStateMatrix.setState(0, 3, binaryStates);
            basicCharacterStateMatrix.setState(1, 3, binaryStates2);
            basicCharacterStateMatrix.setState(2, 3, binaryStates2);
            basicCharacterStateMatrix.setState(3, 3, binaryStates2);
            basicCharacterStateMatrix.setState(4, 3, binaryStates);
            basicCharacterStateMatrix.setState(5, 3, binaryStates2);
            basicCharacterStateMatrix.setState(6, 3, binaryStates);
            basicCharacterStateMatrix.setState(0, 4, binaryStates);
            basicCharacterStateMatrix.setState(1, 4, binaryStates2);
            basicCharacterStateMatrix.setState(2, 4, binaryStates);
            basicCharacterStateMatrix.setState(3, 4, binaryStates2);
            basicCharacterStateMatrix.setState(4, 4, binaryStates);
            basicCharacterStateMatrix.setState(5, 4, binaryStates2);
            basicCharacterStateMatrix.setState(6, 4, binaryStates);
            basicCharacterStateMatrix.setState(0, 5, binaryStates);
            basicCharacterStateMatrix.setState(1, 5, binaryStates);
            basicCharacterStateMatrix.setState(2, 5, binaryStates);
            basicCharacterStateMatrix.setState(3, 5, binaryStates);
            basicCharacterStateMatrix.setState(4, 5, binaryStates);
            basicCharacterStateMatrix.setState(5, 5, binaryStates);
            basicCharacterStateMatrix.setState(6, 5, binaryStates);
            String[] stringArray = new String[]{"first", "second", "third", "forth", "fifth", "sixth"};
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phylogeny = phylogenyFactory.create("(((A,B)1,C)2,D)3", new NHXParser())[0];
            DomainParsimonyCalculator domainParsimonyCalculator = DomainParsimonyCalculator.createInstance(phylogeny);
            domainParsimonyCalculator.executeOnGivenBinaryStatesMatrix(basicCharacterStateMatrix, stringArray);
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix = domainParsimonyCalculator.getGainLossMatrix();
            if (domainParsimonyCalculator.getCost() != 13) {
                return false;
            }
            if (domainParsimonyCalculator.getTotalGains() != 5) {
                return false;
            }
            if (domainParsimonyCalculator.getTotalLosses() != 8) {
                return false;
            }
            if (domainParsimonyCalculator.getTotalUnchanged() != 29) {
                return false;
            }
            if (characterStateMatrix.getState("A", 1) != CharacterStateMatrix.GainLossStates.GAIN) {
                return false;
            }
            if (characterStateMatrix.getState("A", 4) != CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT) {
                return false;
            }
            if (characterStateMatrix.getState("B", 4) != CharacterStateMatrix.GainLossStates.LOSS) {
                return false;
            }
            if (characterStateMatrix.getState("C", 4) != CharacterStateMatrix.GainLossStates.GAIN) {
                return false;
            }
            if (characterStateMatrix.getState("D", 4) != CharacterStateMatrix.GainLossStates.LOSS) {
                return false;
            }
            if (characterStateMatrix.getState("1", 4) != CharacterStateMatrix.GainLossStates.GAIN) {
                return false;
            }
            if (characterStateMatrix.getState("2", 4) != CharacterStateMatrix.GainLossStates.LOSS) {
                return false;
            }
            if (characterStateMatrix.getState("3", 4) != CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testCombinableDomains() {
        try {
            BasicDomain basicDomain = new BasicDomain("key0", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain2 = new BasicDomain("a", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain3 = new BasicDomain("b", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain4 = new BasicDomain("c", 23, 25, 1, 4, 0.1, -12.0);
            BasicCombinableDomains basicCombinableDomains = new BasicCombinableDomains(basicDomain.getDomainId(), new BasicSpecies("eel"));
            basicCombinableDomains.addCombinableDomain(basicDomain2.getDomainId());
            basicCombinableDomains.addCombinableDomain(basicDomain3.getDomainId());
            basicCombinableDomains.addCombinableDomain(basicDomain3.getDomainId());
            basicCombinableDomains.addCombinableDomain(basicDomain4.getDomainId());
            basicCombinableDomains.addCombinableDomain(basicDomain4.getDomainId());
            basicCombinableDomains.addCombinableDomain(basicDomain4.getDomainId());
            if (basicCombinableDomains.getNumberOfCombinableDomains() != 3) {
                return false;
            }
            if (basicCombinableDomains.getNumberOfProteinsExhibitingCombination(basicDomain2.getDomainId()) != 1) {
                return false;
            }
            if (basicCombinableDomains.getNumberOfProteinsExhibitingCombination(basicDomain3.getDomainId()) != 2) {
                return false;
            }
            if (basicCombinableDomains.getNumberOfProteinsExhibitingCombination(basicDomain4.getDomainId()) != 3) {
                return false;
            }
            if (basicCombinableDomains.getNumberOfProteinsExhibitingCombination(basicDomain.getDomainId()) != 0) {
                return false;
            }
            if (basicCombinableDomains.getAllDomains().size() != 4) {
                return false;
            }
            if (!basicCombinableDomains.getAllDomains().contains(basicDomain2.getDomainId())) {
                return false;
            }
            if (!basicCombinableDomains.getAllDomains().contains(basicDomain3.getDomainId())) {
                return false;
            }
            if (!basicCombinableDomains.getAllDomains().contains(basicDomain4.getDomainId())) {
                return false;
            }
            if (!basicCombinableDomains.getAllDomains().contains(basicDomain.getDomainId())) {
                return false;
            }
            if (basicCombinableDomains.toBinaryDomainCombinations().size() != 3) {
                return false;
            }
            BasicBinaryDomainCombination basicBinaryDomainCombination = BasicBinaryDomainCombination.obtainInstance("key0", "a");
            BasicBinaryDomainCombination basicBinaryDomainCombination2 = BasicBinaryDomainCombination.obtainInstance("b", "key0");
            BasicBinaryDomainCombination basicBinaryDomainCombination3 = BasicBinaryDomainCombination.obtainInstance("key0", "c");
            BasicBinaryDomainCombination basicBinaryDomainCombination4 = BasicBinaryDomainCombination.obtainInstance("key0", "cc");
            BasicBinaryDomainCombination basicBinaryDomainCombination5 = BasicBinaryDomainCombination.obtainInstance("c", "key0");
            if (!basicCombinableDomains.toBinaryDomainCombinations().contains(basicBinaryDomainCombination)) {
                return false;
            }
            if (!basicCombinableDomains.toBinaryDomainCombinations().contains(basicBinaryDomainCombination2)) {
                return false;
            }
            if (!basicCombinableDomains.toBinaryDomainCombinations().contains(basicBinaryDomainCombination3)) {
                return false;
            }
            if (basicCombinableDomains.toBinaryDomainCombinations().contains(basicBinaryDomainCombination4)) {
                return false;
            }
            if (!basicCombinableDomains.toBinaryDomainCombinations().contains(basicBinaryDomainCombination5)) {
                return false;
            }
            BasicDomain basicDomain5 = new BasicDomain("key1", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain6 = new BasicDomain("a1", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain7 = new BasicDomain("b1", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain8 = new BasicDomain("c1", 23, 25, 1, 4, 0.1, -12.0);
            BasicCombinableDomains basicCombinableDomains2 = new BasicCombinableDomains(basicDomain5.getDomainId(), new BasicSpecies("eel"));
            basicCombinableDomains2.addCombinableDomain(basicDomain6.getDomainId());
            basicCombinableDomains2.addCombinableDomain(basicDomain7.getDomainId());
            basicCombinableDomains2.addCombinableDomain(basicDomain8.getDomainId());
            basicCombinableDomains2.addCombinableDomain(basicDomain5.getDomainId());
            if (basicCombinableDomains2.getNumberOfCombinableDomains() != 4) {
                return false;
            }
            if (basicCombinableDomains2.getNumberOfProteinsExhibitingCombination(basicDomain6.getDomainId()) != 1) {
                return false;
            }
            if (basicCombinableDomains2.getNumberOfProteinsExhibitingCombination(basicDomain7.getDomainId()) != 1) {
                return false;
            }
            if (basicCombinableDomains2.getNumberOfProteinsExhibitingCombination(basicDomain8.getDomainId()) != 1) {
                return false;
            }
            if (basicCombinableDomains2.getNumberOfProteinsExhibitingCombination(basicDomain5.getDomainId()) != 1) {
                return false;
            }
            if (basicCombinableDomains2.getAllDomains().size() != 4) {
                return false;
            }
            if (basicCombinableDomains2.toBinaryDomainCombinations().size() != 4) {
                return false;
            }
            BasicBinaryDomainCombination basicBinaryDomainCombination6 = BasicBinaryDomainCombination.obtainInstance("key1", "key1");
            if (!basicCombinableDomains2.toBinaryDomainCombinations().contains(basicBinaryDomainCombination6)) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testCombinationsBasedPairwiseSimilarityCalculator() {
        try {
            BasicDomain basicDomain = new BasicDomain("A", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain2 = new BasicDomain("B", 2, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain3 = new BasicDomain("C", 3, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain4 = new BasicDomain("bcl2", 4, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain5 = new BasicDomain("bcl2", 5, 25, 1, 4, 0.1, -12.0);
            BasicCombinableDomains basicCombinableDomains = new BasicCombinableDomains(basicDomain4.getDomainId(), new BasicSpecies("mouse"));
            BasicCombinableDomains basicCombinableDomains2 = new BasicCombinableDomains(basicDomain5.getDomainId(), new BasicSpecies("rabbit"));
            basicCombinableDomains.addCombinableDomain(basicDomain.getDomainId());
            basicCombinableDomains.addCombinableDomain(basicDomain.getDomainId());
            basicCombinableDomains2.addCombinableDomain(new BasicDomain("A", 1, 5, 1, 4, 0.1, -12.0).getDomainId());
            basicCombinableDomains2.addCombinableDomain(basicDomain2.getDomainId());
            basicCombinableDomains2.addCombinableDomain(basicDomain3.getDomainId());
            CombinationsBasedPairwiseDomainSimilarityCalculator combinationsBasedPairwiseDomainSimilarityCalculator = new CombinationsBasedPairwiseDomainSimilarityCalculator();
            PairwiseDomainSimilarity pairwiseDomainSimilarity = combinationsBasedPairwiseDomainSimilarityCalculator.calculateSimilarity(basicCombinableDomains, basicCombinableDomains2);
            if (!TestSurfacing.isEqual(pairwiseDomainSimilarity.getSimilarityScore(), 0.3333333333333333)) {
                return false;
            }
            if (pairwiseDomainSimilarity.getDifferenceInCounts() != -2) {
                return false;
            }
            if (((CombinationsBasedPairwiseDomainSimilarity)pairwiseDomainSimilarity).getNumberOfDifferentDomains() != 2) {
                return false;
            }
            basicCombinableDomains.addCombinableDomain(basicDomain2.getDomainId());
            basicCombinableDomains.addCombinableDomain(basicDomain3.getDomainId());
            PairwiseDomainSimilarity pairwiseDomainSimilarity2 = combinationsBasedPairwiseDomainSimilarityCalculator.calculateSimilarity(basicCombinableDomains, basicCombinableDomains2);
            if (!TestSurfacing.isEqual(pairwiseDomainSimilarity2.getSimilarityScore(), 1.0)) {
                return false;
            }
            if (pairwiseDomainSimilarity2.getDifferenceInCounts() != 0) {
                return false;
            }
            if (((CombinationsBasedPairwiseDomainSimilarity)pairwiseDomainSimilarity2).getNumberOfDifferentDomains() != 0) {
                return false;
            }
            BasicDomain basicDomain6 = new BasicDomain("D", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain7 = new BasicDomain("E", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain8 = new BasicDomain("F", 23, 25, 1, 4, 0.1, -12.0);
            basicCombinableDomains.addCombinableDomain(basicDomain6.getDomainId());
            basicCombinableDomains.addCombinableDomain(basicDomain6.getDomainId());
            basicCombinableDomains.addCombinableDomain(basicDomain7.getDomainId());
            basicCombinableDomains.addCombinableDomain(basicDomain8.getDomainId());
            PairwiseDomainSimilarity pairwiseDomainSimilarity3 = combinationsBasedPairwiseDomainSimilarityCalculator.calculateSimilarity(basicCombinableDomains, basicCombinableDomains2);
            if (!TestSurfacing.isEqual(pairwiseDomainSimilarity3.getSimilarityScore(), 0.5)) {
                return false;
            }
            if (pairwiseDomainSimilarity3.getDifferenceInCounts() != 3) {
                return false;
            }
            if (((CombinationsBasedPairwiseDomainSimilarity)pairwiseDomainSimilarity3).getNumberOfDifferentDomains() != 3) {
                return false;
            }
            BasicDomain basicDomain9 = new BasicDomain("aaa", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain10 = new BasicDomain("bbb", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain11 = new BasicDomain("bcl2", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain12 = new BasicDomain("bcl2", 23, 25, 1, 4, 0.1, -12.0);
            BasicCombinableDomains basicCombinableDomains3 = new BasicCombinableDomains(basicDomain11.getDomainId(), new BasicSpecies("mouse"));
            BasicCombinableDomains basicCombinableDomains4 = new BasicCombinableDomains(basicDomain12.getDomainId(), new BasicSpecies("rabbit"));
            basicCombinableDomains3.addCombinableDomain(basicDomain9.getDomainId());
            basicCombinableDomains4.addCombinableDomain(basicDomain10.getDomainId());
            CombinationsBasedPairwiseDomainSimilarityCalculator combinationsBasedPairwiseDomainSimilarityCalculator2 = new CombinationsBasedPairwiseDomainSimilarityCalculator();
            PairwiseDomainSimilarity pairwiseDomainSimilarity4 = combinationsBasedPairwiseDomainSimilarityCalculator2.calculateSimilarity(basicCombinableDomains3, basicCombinableDomains4);
            if (!TestSurfacing.isEqual(pairwiseDomainSimilarity4.getSimilarityScore(), 0.0)) {
                return false;
            }
            BasicDomain basicDomain13 = new BasicDomain("aaa", 23, 25, 1, 4, 0.1, -12.0);
            basicCombinableDomains4.addCombinableDomain(basicDomain13.getDomainId());
            PairwiseDomainSimilarity pairwiseDomainSimilarity5 = combinationsBasedPairwiseDomainSimilarityCalculator.calculateSimilarity(basicCombinableDomains3, basicCombinableDomains4);
            if (!TestSurfacing.isEqual(pairwiseDomainSimilarity5.getSimilarityScore(), 0.5)) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testCopyNumberBasedPairwiseSimilarityCalculator() {
        try {
            BasicDomain basicDomain = new BasicDomain("bcl2", 4, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain2 = new BasicDomain("bcl2", 5, 25, 1, 4, 0.1, -12.0);
            BasicCombinableDomains basicCombinableDomains = new BasicCombinableDomains(basicDomain.getDomainId(), new BasicSpecies("mouse"));
            BasicCombinableDomains basicCombinableDomains2 = new BasicCombinableDomains(basicDomain2.getDomainId(), new BasicSpecies("rabbit"));
            basicCombinableDomains.setKeyDomainCount(2);
            basicCombinableDomains2.setKeyDomainCount(3);
            DomainCountsBasedPairwiseSimilarityCalculator domainCountsBasedPairwiseSimilarityCalculator = new DomainCountsBasedPairwiseSimilarityCalculator();
            PairwiseDomainSimilarity pairwiseDomainSimilarity = domainCountsBasedPairwiseSimilarityCalculator.calculateSimilarity(basicCombinableDomains, basicCombinableDomains2);
            if (!TestSurfacing.isEqual(pairwiseDomainSimilarity.getSimilarityScore(), 0.8)) {
                return false;
            }
            if (pairwiseDomainSimilarity.getDifferenceInCounts() != -1) {
                return false;
            }
            basicCombinableDomains.setKeyDomainCount(1);
            basicCombinableDomains2.setKeyDomainCount(1);
            pairwiseDomainSimilarity = domainCountsBasedPairwiseSimilarityCalculator.calculateSimilarity(basicCombinableDomains, basicCombinableDomains2);
            if (!TestSurfacing.isEqual(pairwiseDomainSimilarity.getSimilarityScore(), 1.0)) {
                return false;
            }
            if (pairwiseDomainSimilarity.getDifferenceInCounts() != 0) {
                return false;
            }
            basicCombinableDomains.setKeyDomainCount(1);
            basicCombinableDomains2.setKeyDomainCount(1000);
            pairwiseDomainSimilarity = domainCountsBasedPairwiseSimilarityCalculator.calculateSimilarity(basicCombinableDomains, basicCombinableDomains2);
            if (!TestSurfacing.isEqual(pairwiseDomainSimilarity.getSimilarityScore(), 0.0019980019980020414)) {
                return false;
            }
            if (pairwiseDomainSimilarity.getDifferenceInCounts() != -999) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testDirectedCombinableDomains() {
        try {
            BasicDomain basicDomain = new BasicDomain("key0", 10, 20, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain2 = new BasicDomain("a", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain3 = new BasicDomain("b", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain4 = new BasicDomain("c", 23, 25, 1, 4, 0.1, -12.0);
            DirectedCombinableDomains directedCombinableDomains = new DirectedCombinableDomains(basicDomain.getDomainId(), new BasicSpecies("eel"));
            directedCombinableDomains.addCombinableDomain(basicDomain2.getDomainId());
            directedCombinableDomains.addCombinableDomain(basicDomain3.getDomainId());
            directedCombinableDomains.addCombinableDomain(basicDomain3.getDomainId());
            directedCombinableDomains.addCombinableDomain(basicDomain4.getDomainId());
            directedCombinableDomains.addCombinableDomain(basicDomain4.getDomainId());
            directedCombinableDomains.addCombinableDomain(basicDomain4.getDomainId());
            if (directedCombinableDomains.getNumberOfCombinableDomains() != 3) {
                return false;
            }
            if (directedCombinableDomains.getNumberOfProteinsExhibitingCombination(basicDomain2.getDomainId()) != 1) {
                return false;
            }
            if (directedCombinableDomains.getNumberOfProteinsExhibitingCombination(basicDomain3.getDomainId()) != 2) {
                return false;
            }
            if (directedCombinableDomains.getNumberOfProteinsExhibitingCombination(basicDomain4.getDomainId()) != 3) {
                return false;
            }
            if (directedCombinableDomains.getNumberOfProteinsExhibitingCombination(basicDomain.getDomainId()) != 0) {
                return false;
            }
            if (directedCombinableDomains.getAllDomains().size() != 4) {
                return false;
            }
            if (!directedCombinableDomains.getAllDomains().contains(basicDomain2.getDomainId())) {
                return false;
            }
            if (!directedCombinableDomains.getAllDomains().contains(basicDomain3.getDomainId())) {
                return false;
            }
            if (!directedCombinableDomains.getAllDomains().contains(basicDomain4.getDomainId())) {
                return false;
            }
            if (!directedCombinableDomains.getAllDomains().contains(basicDomain.getDomainId())) {
                return false;
            }
            if (directedCombinableDomains.toBinaryDomainCombinations().size() != 3) {
                return false;
            }
            DirectedBinaryDomainCombination directedBinaryDomainCombination = DirectedBinaryDomainCombination.obtainInstance("key0", "a");
            DirectedBinaryDomainCombination directedBinaryDomainCombination2 = DirectedBinaryDomainCombination.obtainInstance("b", "key0");
            DirectedBinaryDomainCombination directedBinaryDomainCombination3 = DirectedBinaryDomainCombination.obtainInstance("key0", "c");
            DirectedBinaryDomainCombination directedBinaryDomainCombination4 = DirectedBinaryDomainCombination.obtainInstance("key0", "cc");
            DirectedBinaryDomainCombination directedBinaryDomainCombination5 = DirectedBinaryDomainCombination.obtainInstance("a", "b");
            DirectedBinaryDomainCombination directedBinaryDomainCombination6 = DirectedBinaryDomainCombination.obtainInstance("b", "a");
            DirectedBinaryDomainCombination directedBinaryDomainCombination7 = DirectedBinaryDomainCombination.obtainInstance("key0", "b");
            DirectedBinaryDomainCombination directedBinaryDomainCombination8 = DirectedBinaryDomainCombination.obtainInstance("a", "key0");
            DirectedBinaryDomainCombination directedBinaryDomainCombination9 = DirectedBinaryDomainCombination.obtainInstance("c", "key0");
            if (!directedCombinableDomains.toBinaryDomainCombinations().contains(directedBinaryDomainCombination)) {
                return false;
            }
            if (directedCombinableDomains.toBinaryDomainCombinations().contains(directedBinaryDomainCombination2)) {
                return false;
            }
            if (!directedCombinableDomains.toBinaryDomainCombinations().contains(directedBinaryDomainCombination3)) {
                return false;
            }
            if (directedCombinableDomains.toBinaryDomainCombinations().contains(directedBinaryDomainCombination4)) {
                return false;
            }
            if (directedCombinableDomains.toBinaryDomainCombinations().contains(directedBinaryDomainCombination5)) {
                return false;
            }
            if (directedCombinableDomains.toBinaryDomainCombinations().contains(directedBinaryDomainCombination6)) {
                return false;
            }
            if (!directedCombinableDomains.toBinaryDomainCombinations().contains(directedBinaryDomainCombination7)) {
                return false;
            }
            if (directedCombinableDomains.toBinaryDomainCombinations().contains(directedBinaryDomainCombination8)) {
                return false;
            }
            if (directedCombinableDomains.toBinaryDomainCombinations().contains(directedBinaryDomainCombination9)) {
                return false;
            }
            BasicDomain basicDomain5 = new BasicDomain("key1", 1, 2, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain6 = new BasicDomain("a1", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain7 = new BasicDomain("b1", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain8 = new BasicDomain("c1", 23, 25, 1, 4, 0.1, -12.0);
            DirectedCombinableDomains directedCombinableDomains2 = new DirectedCombinableDomains(basicDomain5.getDomainId(), new BasicSpecies("eel"));
            directedCombinableDomains2.addCombinableDomain(basicDomain6.getDomainId());
            directedCombinableDomains2.addCombinableDomain(basicDomain7.getDomainId());
            directedCombinableDomains2.addCombinableDomain(basicDomain8.getDomainId());
            directedCombinableDomains2.addCombinableDomain(basicDomain5.getDomainId());
            if (directedCombinableDomains2.getNumberOfCombinableDomains() != 4) {
                return false;
            }
            if (directedCombinableDomains2.getNumberOfProteinsExhibitingCombination(basicDomain6.getDomainId()) != 1) {
                return false;
            }
            if (directedCombinableDomains2.getNumberOfProteinsExhibitingCombination(basicDomain7.getDomainId()) != 1) {
                return false;
            }
            if (directedCombinableDomains2.getNumberOfProteinsExhibitingCombination(basicDomain8.getDomainId()) != 1) {
                return false;
            }
            if (directedCombinableDomains2.getNumberOfProteinsExhibitingCombination(basicDomain5.getDomainId()) != 1) {
                return false;
            }
            if (directedCombinableDomains2.getAllDomains().size() != 4) {
                return false;
            }
            if (directedCombinableDomains2.toBinaryDomainCombinations().size() != 4) {
                return false;
            }
            DirectedBinaryDomainCombination directedBinaryDomainCombination10 = DirectedBinaryDomainCombination.obtainInstance("key1", "key1");
            if (!directedCombinableDomains2.toBinaryDomainCombinations().contains(directedBinaryDomainCombination10)) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testDirectedness() {
        try {
            CharacterStateMatrix.BinaryStates binaryStates = CharacterStateMatrix.BinaryStates.PRESENT;
            CharacterStateMatrix.BinaryStates binaryStates2 = CharacterStateMatrix.BinaryStates.ABSENT;
            CharacterStateMatrix.GainLossStates gainLossStates = CharacterStateMatrix.GainLossStates.GAIN;
            CharacterStateMatrix.GainLossStates gainLossStates2 = CharacterStateMatrix.GainLossStates.LOSS;
            CharacterStateMatrix.GainLossStates gainLossStates3 = CharacterStateMatrix.GainLossStates.UNCHANGED_ABSENT;
            CharacterStateMatrix.GainLossStates gainLossStates4 = CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT;
            BasicProtein basicProtein = new BasicProtein("one", "1", 0);
            BasicProtein basicProtein2 = new BasicProtein("two", "1", 0);
            BasicProtein basicProtein3 = new BasicProtein("three", "1", 0);
            BasicProtein basicProtein4 = new BasicProtein("four", "1", 0);
            BasicProtein basicProtein5 = new BasicProtein("five", "1", 0);
            basicProtein.addProteinDomain(new BasicDomain("B", 12, 14, 1, 4, 0.1, -12.0));
            basicProtein.addProteinDomain(new BasicDomain("C", 13, 14, 1, 4, 0.1, -12.0));
            basicProtein.addProteinDomain(new BasicDomain("A", 11, 12, 1, 4, 0.1, -12.0));
            basicProtein.addProteinDomain(new BasicDomain("X", 100, 110, 1, 4, 0.1, -12.0));
            basicProtein.addProteinDomain(new BasicDomain("Y", 200, 210, 1, 4, 0.1, -12.0));
            basicProtein2.addProteinDomain(new BasicDomain("A", 10, 20, 1, 4, 0.1, -12.0));
            basicProtein2.addProteinDomain(new BasicDomain("B", 30, 40, 1, 4, 0.1, -12.0));
            basicProtein2.addProteinDomain(new BasicDomain("Y", 1, 2, 1, 4, 0.1, -12.0));
            basicProtein2.addProteinDomain(new BasicDomain("X", 10, 11, 1, 4, 0.1, -12.0));
            basicProtein3.addProteinDomain(new BasicDomain("P", 10, 11, 1, 4, 0.1, -12.0));
            basicProtein3.addProteinDomain(new BasicDomain("M", 1, 2, 1, 4, 0.1, -12.0));
            basicProtein3.addProteinDomain(new BasicDomain("M", 5, 6, 1, 4, 0.1, -12.0));
            basicProtein3.addProteinDomain(new BasicDomain("N", 7, 8, 1, 4, 0.1, -12.0));
            basicProtein3.addProteinDomain(new BasicDomain("N", 3, 4, 1, 4, 0.1, -12.0));
            basicProtein4.addProteinDomain(new BasicDomain("XX", 10, 20, 1, 4, 0.1, -12.0));
            basicProtein5.addProteinDomain(new BasicDomain("YY", 30, 40, 1, 4, 0.1, -12.0));
            ArrayList<Protein> arrayList = new ArrayList<Protein>();
            arrayList.add(basicProtein);
            arrayList.add(basicProtein2);
            arrayList.add(basicProtein3);
            arrayList.add(basicProtein4);
            arrayList.add(basicProtein5);
            BasicGenomeWideCombinableDomains basicGenomeWideCombinableDomains = BasicGenomeWideCombinableDomains.createInstance(arrayList, false, new BasicSpecies("1"), BinaryDomainCombination.DomainCombinationType.DIRECTED);
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("A", "B"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("B", "A"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("A", "A"))) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("A", "C"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("C", "A"))) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("B", "C"))) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("C", "X"))) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("C", "Y"))) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("A", "X"))) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("A", "Y"))) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("Y", "A"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("X", "A"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("C", "B"))) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("X", "Y"))) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("Y", "X"))) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("A", "Y"))) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("A", "X"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("Y", "C"))) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("M", "N"))) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("N", "M"))) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("N", "P"))) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("M", "P"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("P", "N"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("P", "M"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("XX", "YY"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("YY", "XX"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(DirectedBinaryDomainCombination.obtainInstance("B", "B"))) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testDirectednessAndAdjacency() {
        try {
            BasicProtein basicProtein = new BasicProtein("one", "1", 0);
            BasicProtein basicProtein2 = new BasicProtein("two", "1", 0);
            BasicProtein basicProtein3 = new BasicProtein("three", "1", 0);
            BasicProtein basicProtein4 = new BasicProtein("four", "1", 0);
            BasicProtein basicProtein5 = new BasicProtein("five", "1", 0);
            basicProtein.addProteinDomain(new BasicDomain("B", 12, 14, 1, 4, 0.1, -12.0));
            basicProtein.addProteinDomain(new BasicDomain("C", 13, 14, 1, 4, 0.1, -12.0));
            basicProtein.addProteinDomain(new BasicDomain("A", 11, 12, 1, 4, 0.1, -12.0));
            basicProtein.addProteinDomain(new BasicDomain("X", 100, 110, 1, 4, 0.1, -12.0));
            basicProtein.addProteinDomain(new BasicDomain("Y", 200, 210, 1, 4, 0.1, -12.0));
            basicProtein2.addProteinDomain(new BasicDomain("A", 10, 20, 1, 4, 0.1, -12.0));
            basicProtein2.addProteinDomain(new BasicDomain("B", 30, 40, 1, 4, 0.1, -12.0));
            basicProtein2.addProteinDomain(new BasicDomain("Y", 1, 2, 1, 4, 0.1, -12.0));
            basicProtein2.addProteinDomain(new BasicDomain("X", 10, 11, 1, 4, 0.1, -12.0));
            basicProtein3.addProteinDomain(new BasicDomain("P", 10, 11, 1, 4, 0.1, -12.0));
            basicProtein3.addProteinDomain(new BasicDomain("M", 1, 2, 1, 4, 0.1, -12.0));
            basicProtein3.addProteinDomain(new BasicDomain("M", 5, 6, 1, 4, 0.1, -12.0));
            basicProtein3.addProteinDomain(new BasicDomain("N", 7, 8, 1, 4, 0.1, -12.0));
            basicProtein3.addProteinDomain(new BasicDomain("N", 3, 4, 1, 4, 0.1, -12.0));
            basicProtein4.addProteinDomain(new BasicDomain("XX", 10, 20, 1, 4, 0.1, -12.0));
            basicProtein5.addProteinDomain(new BasicDomain("YY", 30, 40, 1, 4, 0.1, -12.0));
            ArrayList<Protein> arrayList = new ArrayList<Protein>();
            arrayList.add(basicProtein);
            arrayList.add(basicProtein2);
            arrayList.add(basicProtein3);
            arrayList.add(basicProtein4);
            arrayList.add(basicProtein5);
            BasicGenomeWideCombinableDomains basicGenomeWideCombinableDomains = BasicGenomeWideCombinableDomains.createInstance(arrayList, false, new BasicSpecies("1"), BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT);
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("A", "B"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("B", "A"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("A", "A"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("A", "C"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("C", "A"))) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("B", "C"))) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("C", "X"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("C", "Y"))) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("X", "Y"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("A", "X"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("A", "Y"))) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("Y", "A"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("X", "A"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("C", "B"))) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("X", "Y"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("Y", "X"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("A", "Y"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("A", "X"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("Y", "C"))) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("M", "N"))) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("N", "M"))) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("N", "P"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("M", "P"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("P", "N"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("P", "M"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("XX", "YY"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("YY", "XX"))) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.toBinaryDomainCombinations().contains(AdjactantDirectedBinaryDomainCombination.obtainInstance("B", "B"))) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testDomainArchitectureBasedGenomeSimilarityCalculator() {
        try {
            BasicDomain basicDomain = new BasicDomain("a", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain2 = new BasicDomain("b", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain3 = new BasicDomain("c", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain4 = new BasicDomain("d", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain5 = new BasicDomain("e", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain6 = new BasicDomain("f", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain7 = new BasicDomain("g", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain8 = new BasicDomain("h", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain9 = new BasicDomain("i", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain10 = new BasicDomain("j", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain11 = new BasicDomain("k", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain12 = new BasicDomain("l", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain13 = new BasicDomain("m", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain14 = new BasicDomain("n", 23, 25, 1, 4, 0.1, -12.0);
            BasicProtein basicProtein = new BasicProtein("0", "eel", 0);
            BasicProtein basicProtein2 = new BasicProtein("1", "eel", 0);
            BasicProtein basicProtein3 = new BasicProtein("2", "eel", 0);
            BasicProtein basicProtein4 = new BasicProtein("3", "eel", 0);
            BasicProtein basicProtein5 = new BasicProtein("4", "eel", 0);
            BasicProtein basicProtein6 = new BasicProtein("5", "eel", 0);
            BasicProtein basicProtein7 = new BasicProtein("6", "eel", 0);
            BasicProtein basicProtein8 = new BasicProtein("0", "rat", 0);
            BasicProtein basicProtein9 = new BasicProtein("1", "rat", 0);
            BasicProtein basicProtein10 = new BasicProtein("2", "rat", 0);
            BasicProtein basicProtein11 = new BasicProtein("3", "rat", 0);
            BasicProtein basicProtein12 = new BasicProtein("4", "rat", 0);
            BasicProtein basicProtein13 = new BasicProtein("5", "rat", 0);
            BasicProtein basicProtein14 = new BasicProtein("6", "rat", 0);
            BasicProtein basicProtein15 = new BasicProtein("7", "rat", 0);
            basicProtein2.addProteinDomain(basicDomain);
            basicProtein3.addProteinDomain(basicDomain);
            basicProtein3.addProteinDomain(basicDomain2);
            basicProtein4.addProteinDomain(basicDomain);
            basicProtein4.addProteinDomain(basicDomain);
            basicProtein4.addProteinDomain(basicDomain2);
            basicProtein5.addProteinDomain(basicDomain);
            basicProtein5.addProteinDomain(basicDomain2);
            basicProtein5.addProteinDomain(basicDomain3);
            basicProtein5.addProteinDomain(basicDomain4);
            basicProtein5.addProteinDomain(basicDomain5);
            basicProtein6.addProteinDomain(basicDomain5);
            basicProtein6.addProteinDomain(basicDomain5);
            basicProtein6.addProteinDomain(basicDomain6);
            basicProtein6.addProteinDomain(basicDomain6);
            basicProtein6.addProteinDomain(basicDomain6);
            basicProtein6.addProteinDomain(basicDomain6);
            basicProtein7.addProteinDomain(basicDomain7);
            basicProtein7.addProteinDomain(basicDomain8);
            basicProtein9.addProteinDomain(basicDomain);
            basicProtein10.addProteinDomain(basicDomain);
            basicProtein10.addProteinDomain(basicDomain2);
            basicProtein11.addProteinDomain(basicDomain);
            basicProtein11.addProteinDomain(basicDomain);
            basicProtein11.addProteinDomain(basicDomain2);
            basicProtein12.addProteinDomain(basicDomain);
            basicProtein12.addProteinDomain(basicDomain2);
            basicProtein12.addProteinDomain(basicDomain3);
            basicProtein12.addProteinDomain(basicDomain9);
            basicProtein12.addProteinDomain(basicDomain12);
            basicProtein13.addProteinDomain(basicDomain9);
            basicProtein13.addProteinDomain(basicDomain6);
            basicProtein13.addProteinDomain(basicDomain6);
            basicProtein14.addProteinDomain(basicDomain10);
            basicProtein14.addProteinDomain(basicDomain11);
            basicProtein15.addProteinDomain(basicDomain13);
            basicProtein15.addProteinDomain(basicDomain14);
            ArrayList<Protein> arrayList = new ArrayList<Protein>();
            arrayList.add(basicProtein);
            arrayList.add(basicProtein2);
            arrayList.add(basicProtein3);
            arrayList.add(basicProtein4);
            arrayList.add(basicProtein5);
            arrayList.add(basicProtein6);
            arrayList.add(basicProtein7);
            ArrayList<Protein> arrayList2 = new ArrayList<Protein>();
            arrayList2.add(basicProtein8);
            arrayList2.add(basicProtein9);
            arrayList2.add(basicProtein10);
            arrayList2.add(basicProtein11);
            arrayList2.add(basicProtein12);
            arrayList2.add(basicProtein13);
            arrayList2.add(basicProtein14);
            arrayList2.add(basicProtein15);
            BasicGenomeWideCombinableDomains basicGenomeWideCombinableDomains = BasicGenomeWideCombinableDomains.createInstance(arrayList, false, new BasicSpecies("eel"));
            BasicGenomeWideCombinableDomains basicGenomeWideCombinableDomains2 = BasicGenomeWideCombinableDomains.createInstance(arrayList, true, new BasicSpecies("eel"));
            BasicGenomeWideCombinableDomains basicGenomeWideCombinableDomains3 = BasicGenomeWideCombinableDomains.createInstance(arrayList2, false, new BasicSpecies("rat"));
            BasicGenomeWideCombinableDomains basicGenomeWideCombinableDomains4 = BasicGenomeWideCombinableDomains.createInstance(arrayList2, true, new BasicSpecies("rat"));
            DomainArchitectureBasedGenomeSimilarityCalculator domainArchitectureBasedGenomeSimilarityCalculator = new DomainArchitectureBasedGenomeSimilarityCalculator(basicGenomeWideCombinableDomains, basicGenomeWideCombinableDomains3);
            DomainArchitectureBasedGenomeSimilarityCalculator domainArchitectureBasedGenomeSimilarityCalculator2 = new DomainArchitectureBasedGenomeSimilarityCalculator(basicGenomeWideCombinableDomains2, basicGenomeWideCombinableDomains4);
            if (domainArchitectureBasedGenomeSimilarityCalculator.getAllDomains().size() != 14) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator2.getAllDomains().size() != 14) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator.getDomainsSpecificToGenome0().size() != 4) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator2.getDomainsSpecificToGenome0().size() != 4) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator.getDomainsSpecificToGenome1().size() != 6) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator2.getDomainsSpecificToGenome1().size() != 6) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator2.getSharedDomains().size() != 4) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator.getSharedDomains().size() != 4) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator.getDomainsSpecificToGenome0().contains(basicDomain4.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator.getDomainsSpecificToGenome0().contains(basicDomain5.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator.getDomainsSpecificToGenome0().contains(basicDomain7.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator.getDomainsSpecificToGenome0().contains(basicDomain8.getDomainId())) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator.getDomainsSpecificToGenome0().contains(basicDomain.getDomainId())) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator.getDomainsSpecificToGenome0().contains(basicDomain9.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator2.getDomainsSpecificToGenome0().contains(basicDomain4.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator2.getDomainsSpecificToGenome0().contains(basicDomain5.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator2.getDomainsSpecificToGenome0().contains(basicDomain7.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator2.getDomainsSpecificToGenome0().contains(basicDomain8.getDomainId())) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator2.getDomainsSpecificToGenome0().contains(basicDomain.getDomainId())) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator2.getDomainsSpecificToGenome0().contains(basicDomain9.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator.getDomainsSpecificToGenome1().contains(basicDomain9.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator.getDomainsSpecificToGenome1().contains(basicDomain12.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator.getDomainsSpecificToGenome1().contains(basicDomain10.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator.getDomainsSpecificToGenome1().contains(basicDomain11.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator.getDomainsSpecificToGenome1().contains(basicDomain13.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator.getDomainsSpecificToGenome1().contains(basicDomain14.getDomainId())) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator.getDomainsSpecificToGenome1().contains(basicDomain.getDomainId())) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator.getDomainsSpecificToGenome1().contains(basicDomain2.getDomainId())) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator.getDomainsSpecificToGenome1().contains(basicDomain4.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator2.getDomainsSpecificToGenome1().contains(basicDomain9.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator2.getDomainsSpecificToGenome1().contains(basicDomain12.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator2.getDomainsSpecificToGenome1().contains(basicDomain10.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator2.getDomainsSpecificToGenome1().contains(basicDomain11.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator2.getDomainsSpecificToGenome1().contains(basicDomain13.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator2.getDomainsSpecificToGenome1().contains(basicDomain14.getDomainId())) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator2.getDomainsSpecificToGenome1().contains(basicDomain.getDomainId())) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator2.getDomainsSpecificToGenome1().contains(basicDomain2.getDomainId())) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator2.getDomainsSpecificToGenome1().contains(basicDomain4.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator2.getSharedDomains().contains(basicDomain.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator2.getSharedDomains().contains(basicDomain2.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator2.getSharedDomains().contains(basicDomain3.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator2.getSharedDomains().contains(basicDomain6.getDomainId())) {
                return false;
            }
            Set<String> set = domainArchitectureBasedGenomeSimilarityCalculator.getAllDomains();
            if (!set.contains(basicDomain.getDomainId())) {
                return false;
            }
            if (!set.contains(basicDomain2.getDomainId())) {
                return false;
            }
            if (!set.contains(basicDomain3.getDomainId())) {
                return false;
            }
            if (!set.contains(basicDomain4.getDomainId())) {
                return false;
            }
            if (!set.contains(basicDomain5.getDomainId())) {
                return false;
            }
            if (!set.contains(basicDomain6.getDomainId())) {
                return false;
            }
            if (!set.contains(basicDomain7.getDomainId())) {
                return false;
            }
            if (!set.contains(basicDomain8.getDomainId())) {
                return false;
            }
            if (!set.contains(basicDomain9.getDomainId())) {
                return false;
            }
            if (!set.contains(basicDomain12.getDomainId())) {
                return false;
            }
            if (!set.contains(basicDomain10.getDomainId())) {
                return false;
            }
            if (!set.contains(basicDomain11.getDomainId())) {
                return false;
            }
            if (!set.contains(basicDomain13.getDomainId())) {
                return false;
            }
            if (!set.contains(basicDomain14.getDomainId())) {
                return false;
            }
            Set<BinaryDomainCombination> set2 = domainArchitectureBasedGenomeSimilarityCalculator.getBinaryDomainCombinationsSpecificToGenome0();
            Set<BinaryDomainCombination> set3 = domainArchitectureBasedGenomeSimilarityCalculator2.getBinaryDomainCombinationsSpecificToGenome0();
            Set<BinaryDomainCombination> set4 = domainArchitectureBasedGenomeSimilarityCalculator.getBinaryDomainCombinationsSpecificToGenome1();
            Set<BinaryDomainCombination> set5 = domainArchitectureBasedGenomeSimilarityCalculator2.getBinaryDomainCombinationsSpecificToGenome1();
            Set<BinaryDomainCombination> set6 = domainArchitectureBasedGenomeSimilarityCalculator.getAllBinaryDomainCombinations();
            Set<BinaryDomainCombination> set7 = domainArchitectureBasedGenomeSimilarityCalculator2.getAllBinaryDomainCombinations();
            Set<BinaryDomainCombination> set8 = domainArchitectureBasedGenomeSimilarityCalculator.getSharedBinaryDomainCombinations();
            Set<BinaryDomainCombination> set9 = domainArchitectureBasedGenomeSimilarityCalculator2.getSharedBinaryDomainCombinations();
            if (set6.size() != 25) {
                return false;
            }
            if (set7.size() != 22) {
                return false;
            }
            if (set2.size() != 10) {
                return false;
            }
            if (set3.size() != 9) {
                return false;
            }
            if (set4.size() != 10) {
                return false;
            }
            if (set5.size() != 10) {
                return false;
            }
            if (set8.size() != 5) {
                return false;
            }
            if (set9.size() != 3) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("a", "a"))) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("b", "a"))) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("a", "c"))) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("a", "d"))) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("a", "e"))) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("b", "c"))) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("b", "d"))) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("b", "e"))) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("c", "d"))) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("c", "e"))) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("d", "e"))) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("e", "f"))) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("g", "h"))) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("f", "f"))) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("e", "e"))) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("a", "i"))) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("a", "l"))) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("b", "i"))) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("b", "l"))) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("c", "i"))) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("c", "l"))) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("i", "l"))) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("i", "f"))) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("m", "n"))) {
                return false;
            }
            if (!set6.contains(BasicBinaryDomainCombination.obtainInstance("j", "k"))) {
                return false;
            }
            if (set6.contains(BasicBinaryDomainCombination.obtainInstance("a", "g"))) {
                return false;
            }
            if (set6.contains(BasicBinaryDomainCombination.obtainInstance("a", "m"))) {
                return false;
            }
            if (set7.contains(BasicBinaryDomainCombination.obtainInstance("a", "a"))) {
                return false;
            }
            if (set7.contains(BasicBinaryDomainCombination.obtainInstance("f", "f"))) {
                return false;
            }
            if (set7.contains(BasicBinaryDomainCombination.obtainInstance("e", "e"))) {
                return false;
            }
            if (!set8.contains(BasicBinaryDomainCombination.obtainInstance("a", "a"))) {
                return false;
            }
            if (!set8.contains(BasicBinaryDomainCombination.obtainInstance("a", "b"))) {
                return false;
            }
            if (!set8.contains(BasicBinaryDomainCombination.obtainInstance("a", "c"))) {
                return false;
            }
            if (!set8.contains(BasicBinaryDomainCombination.obtainInstance("b", "c"))) {
                return false;
            }
            if (!set8.contains(BasicBinaryDomainCombination.obtainInstance("f", "f"))) {
                return false;
            }
            if (set8.contains(BasicBinaryDomainCombination.obtainInstance("m", "n"))) {
                return false;
            }
            if (set9.contains(BasicBinaryDomainCombination.obtainInstance("a", "a"))) {
                return false;
            }
            if (!set9.contains(BasicBinaryDomainCombination.obtainInstance("a", "b"))) {
                return false;
            }
            if (!set9.contains(BasicBinaryDomainCombination.obtainInstance("a", "c"))) {
                return false;
            }
            if (!set9.contains(BasicBinaryDomainCombination.obtainInstance("b", "c"))) {
                return false;
            }
            if (set9.contains(BasicBinaryDomainCombination.obtainInstance("f", "f"))) {
                return false;
            }
            if (set9.contains(BasicBinaryDomainCombination.obtainInstance("m", "n"))) {
                return false;
            }
            if (!set2.contains(BasicBinaryDomainCombination.obtainInstance("a", "d"))) {
                return false;
            }
            if (!set2.contains(BasicBinaryDomainCombination.obtainInstance("a", "e"))) {
                return false;
            }
            if (!set2.contains(BasicBinaryDomainCombination.obtainInstance("b", "d"))) {
                return false;
            }
            if (!set2.contains(BasicBinaryDomainCombination.obtainInstance("b", "e"))) {
                return false;
            }
            if (!set2.contains(BasicBinaryDomainCombination.obtainInstance("c", "d"))) {
                return false;
            }
            if (!set2.contains(BasicBinaryDomainCombination.obtainInstance("c", "e"))) {
                return false;
            }
            if (!set2.contains(BasicBinaryDomainCombination.obtainInstance("d", "e"))) {
                return false;
            }
            if (!set2.contains(BasicBinaryDomainCombination.obtainInstance("e", "f"))) {
                return false;
            }
            if (!set2.contains(BasicBinaryDomainCombination.obtainInstance("g", "h"))) {
                return false;
            }
            if (!set2.contains(BasicBinaryDomainCombination.obtainInstance("e", "e"))) {
                return false;
            }
            if (!set3.contains(BasicBinaryDomainCombination.obtainInstance("a", "d"))) {
                return false;
            }
            if (!set3.contains(BasicBinaryDomainCombination.obtainInstance("a", "e"))) {
                return false;
            }
            if (!set3.contains(BasicBinaryDomainCombination.obtainInstance("b", "d"))) {
                return false;
            }
            if (!set3.contains(BasicBinaryDomainCombination.obtainInstance("b", "e"))) {
                return false;
            }
            if (!set3.contains(BasicBinaryDomainCombination.obtainInstance("c", "d"))) {
                return false;
            }
            if (!set3.contains(BasicBinaryDomainCombination.obtainInstance("c", "e"))) {
                return false;
            }
            if (!set3.contains(BasicBinaryDomainCombination.obtainInstance("d", "e"))) {
                return false;
            }
            if (!set3.contains(BasicBinaryDomainCombination.obtainInstance("e", "f"))) {
                return false;
            }
            if (!set3.contains(BasicBinaryDomainCombination.obtainInstance("g", "h"))) {
                return false;
            }
            if (set3.contains(BasicBinaryDomainCombination.obtainInstance("e", "e"))) {
                return false;
            }
            if (!set4.contains(BasicBinaryDomainCombination.obtainInstance("a", "i"))) {
                return false;
            }
            if (!set4.contains(BasicBinaryDomainCombination.obtainInstance("a", "l"))) {
                return false;
            }
            if (!set4.contains(BasicBinaryDomainCombination.obtainInstance("b", "i"))) {
                return false;
            }
            if (!set4.contains(BasicBinaryDomainCombination.obtainInstance("b", "l"))) {
                return false;
            }
            if (!set4.contains(BasicBinaryDomainCombination.obtainInstance("c", "i"))) {
                return false;
            }
            if (!set4.contains(BasicBinaryDomainCombination.obtainInstance("c", "l"))) {
                return false;
            }
            if (!set4.contains(BasicBinaryDomainCombination.obtainInstance("l", "i"))) {
                return false;
            }
            if (!set4.contains(BasicBinaryDomainCombination.obtainInstance("i", "f"))) {
                return false;
            }
            if (!set4.contains(BasicBinaryDomainCombination.obtainInstance("m", "n"))) {
                return false;
            }
            if (!set4.contains(BasicBinaryDomainCombination.obtainInstance("j", "k"))) {
                return false;
            }
            if (set4.contains(BasicBinaryDomainCombination.obtainInstance("a", "b"))) {
                return false;
            }
            if (!set5.contains(BasicBinaryDomainCombination.obtainInstance("a", "i"))) {
                return false;
            }
            if (!set5.contains(BasicBinaryDomainCombination.obtainInstance("a", "l"))) {
                return false;
            }
            if (!set5.contains(BasicBinaryDomainCombination.obtainInstance("b", "i"))) {
                return false;
            }
            if (!set5.contains(BasicBinaryDomainCombination.obtainInstance("b", "l"))) {
                return false;
            }
            if (!set5.contains(BasicBinaryDomainCombination.obtainInstance("c", "i"))) {
                return false;
            }
            if (!set5.contains(BasicBinaryDomainCombination.obtainInstance("c", "l"))) {
                return false;
            }
            if (!set5.contains(BasicBinaryDomainCombination.obtainInstance("l", "i"))) {
                return false;
            }
            if (!set5.contains(BasicBinaryDomainCombination.obtainInstance("i", "f"))) {
                return false;
            }
            if (!set5.contains(BasicBinaryDomainCombination.obtainInstance("m", "n"))) {
                return false;
            }
            if (!set5.contains(BasicBinaryDomainCombination.obtainInstance("j", "k"))) {
                return false;
            }
            if (set5.contains(BasicBinaryDomainCombination.obtainInstance("a", "b"))) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainArchitectureBasedGenomeSimilarityCalculator.calculateSharedBinaryDomainCombinationBasedGenomeSimilarityScore(), 0.19999999999999996)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainArchitectureBasedGenomeSimilarityCalculator2.calculateSharedBinaryDomainCombinationBasedGenomeSimilarityScore(), 0.13636363636363635)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainArchitectureBasedGenomeSimilarityCalculator.calculateSharedDomainsBasedGenomeSimilarityScore(), 0.2857142857142857)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainArchitectureBasedGenomeSimilarityCalculator2.calculateSharedDomainsBasedGenomeSimilarityScore(), 0.2857142857142857)) {
                return false;
            }
            BasicDomain basicDomain15 = new BasicDomain("u", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain16 = new BasicDomain("v", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain17 = new BasicDomain("w", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain18 = new BasicDomain("x", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain19 = new BasicDomain("y", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain20 = new BasicDomain("z", 23, 25, 1, 4, 0.1, -12.0);
            BasicProtein basicProtein16 = new BasicProtein("0", "a", 0);
            BasicProtein basicProtein17 = new BasicProtein("1", "a", 0);
            BasicProtein basicProtein18 = new BasicProtein("2", "a", 0);
            BasicProtein basicProtein19 = new BasicProtein("0", "b", 0);
            BasicProtein basicProtein20 = new BasicProtein("1", "b", 0);
            basicProtein16.addProteinDomain(basicDomain15);
            basicProtein16.addProteinDomain(basicDomain16);
            basicProtein16.addProteinDomain(basicDomain17);
            basicProtein17.addProteinDomain(basicDomain17);
            basicProtein17.addProteinDomain(basicDomain18);
            basicProtein18.addProteinDomain(basicDomain19);
            basicProtein18.addProteinDomain(basicDomain20);
            basicProtein19.addProteinDomain(basicDomain15);
            basicProtein19.addProteinDomain(basicDomain17);
            basicProtein20.addProteinDomain(basicDomain19);
            basicProtein20.addProteinDomain(basicDomain20);
            ArrayList<Protein> arrayList3 = new ArrayList<Protein>();
            arrayList3.add(basicProtein16);
            arrayList3.add(basicProtein17);
            arrayList3.add(basicProtein18);
            ArrayList<Protein> arrayList4 = new ArrayList<Protein>();
            arrayList4.add(basicProtein19);
            arrayList4.add(basicProtein20);
            BasicGenomeWideCombinableDomains basicGenomeWideCombinableDomains5 = BasicGenomeWideCombinableDomains.createInstance(arrayList3, false, new BasicSpecies("a"));
            BasicGenomeWideCombinableDomains basicGenomeWideCombinableDomains6 = BasicGenomeWideCombinableDomains.createInstance(arrayList4, true, new BasicSpecies("b"));
            DomainArchitectureBasedGenomeSimilarityCalculator domainArchitectureBasedGenomeSimilarityCalculator3 = new DomainArchitectureBasedGenomeSimilarityCalculator(basicGenomeWideCombinableDomains5, basicGenomeWideCombinableDomains6);
            domainArchitectureBasedGenomeSimilarityCalculator3.setAllowDomainsToBeIgnored(true);
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().size() != 6) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getDomainsSpecificToGenome0().size() != 2) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getDomainsSpecificToGenome1().size() != 0) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getDomainsSpecificToGenome0().contains(basicDomain16.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getDomainsSpecificToGenome0().contains(basicDomain18.getDomainId())) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getSharedDomains().size() != 4) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getSharedDomains().contains(basicDomain15.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getSharedDomains().contains(basicDomain17.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getSharedDomains().contains(basicDomain19.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getSharedDomains().contains(basicDomain20.getDomainId())) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().size() != 6) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().contains(basicDomain15.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().contains(basicDomain17.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().contains(basicDomain19.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().contains(basicDomain20.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().contains(basicDomain16.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().contains(basicDomain18.getDomainId())) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getBinaryDomainCombinationsSpecificToGenome0().size() != 3) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getBinaryDomainCombinationsSpecificToGenome1().size() != 0) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getSharedBinaryDomainCombinations().size() != 2) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getAllBinaryDomainCombinations().size() != 5) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getBinaryDomainCombinationsSpecificToGenome0().contains(BasicBinaryDomainCombination.obtainInstance("v", "u"))) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getBinaryDomainCombinationsSpecificToGenome0().contains(BasicBinaryDomainCombination.obtainInstance("w", "v"))) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getBinaryDomainCombinationsSpecificToGenome0().contains(BasicBinaryDomainCombination.obtainInstance("w", "x"))) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getSharedBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("w", "u"))) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getSharedBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("z", "y"))) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getAllBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("v", "u"))) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getAllBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("w", "v"))) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getAllBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("w", "x"))) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getAllBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("w", "u"))) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getAllBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("z", "y"))) {
                return false;
            }
            domainArchitectureBasedGenomeSimilarityCalculator3.setAllowDomainsToBeIgnored(true);
            domainArchitectureBasedGenomeSimilarityCalculator3.addDomainIdToIgnore(basicDomain15.getDomainId());
            domainArchitectureBasedGenomeSimilarityCalculator3.addDomainIdToIgnore("other");
            domainArchitectureBasedGenomeSimilarityCalculator3.addDomainIdToIgnore("other_too");
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().size() != 5) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getDomainsSpecificToGenome0().size() != 2) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getDomainsSpecificToGenome1().size() != 0) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getDomainsSpecificToGenome0().contains(basicDomain16.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getDomainsSpecificToGenome0().contains(basicDomain18.getDomainId())) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getSharedDomains().size() != 3) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getSharedDomains().contains(basicDomain15.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getSharedDomains().contains(basicDomain17.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getSharedDomains().contains(basicDomain19.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getSharedDomains().contains(basicDomain20.getDomainId())) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().size() != 5) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().contains(basicDomain15.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().contains(basicDomain17.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().contains(basicDomain19.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().contains(basicDomain20.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().contains(basicDomain16.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().contains(basicDomain18.getDomainId())) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getBinaryDomainCombinationsSpecificToGenome0().size() != 2) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getBinaryDomainCombinationsSpecificToGenome1().size() != 0) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getSharedBinaryDomainCombinations().size() != 1) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getAllBinaryDomainCombinations().size() != 3) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getBinaryDomainCombinationsSpecificToGenome0().contains(BasicBinaryDomainCombination.obtainInstance("v", "u"))) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getBinaryDomainCombinationsSpecificToGenome0().contains(BasicBinaryDomainCombination.obtainInstance("w", "v"))) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getBinaryDomainCombinationsSpecificToGenome0().contains(BasicBinaryDomainCombination.obtainInstance("w", "x"))) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getSharedBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("w", "u"))) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getSharedBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("z", "y"))) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getAllBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("v", "u"))) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getAllBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("w", "v"))) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getAllBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("w", "x"))) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getAllBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("w", "u"))) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getAllBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("z", "y"))) {
                return false;
            }
            domainArchitectureBasedGenomeSimilarityCalculator3.setAllowDomainsToBeIgnored(false);
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().size() != 6) {
                return false;
            }
            domainArchitectureBasedGenomeSimilarityCalculator3.setAllowDomainsToBeIgnored(true);
            domainArchitectureBasedGenomeSimilarityCalculator3.deleteAllDomainIdsToIgnore();
            domainArchitectureBasedGenomeSimilarityCalculator3.addDomainIdToIgnore("v");
            domainArchitectureBasedGenomeSimilarityCalculator3.addDomainIdToIgnore("w");
            domainArchitectureBasedGenomeSimilarityCalculator3.addDomainIdToIgnore("other");
            domainArchitectureBasedGenomeSimilarityCalculator3.addDomainIdToIgnore("other_too");
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().size() != 4) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getDomainsSpecificToGenome0().size() != 1) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getDomainsSpecificToGenome1().size() != 0) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getDomainsSpecificToGenome0().contains(basicDomain16.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getDomainsSpecificToGenome0().contains(basicDomain18.getDomainId())) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getSharedDomains().size() != 3) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getSharedDomains().contains(basicDomain15.getDomainId())) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getSharedDomains().contains(basicDomain17.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getSharedDomains().contains(basicDomain19.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getSharedDomains().contains(basicDomain20.getDomainId())) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().size() != 4) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().contains(basicDomain15.getDomainId())) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().contains(basicDomain17.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().contains(basicDomain19.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().contains(basicDomain20.getDomainId())) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().contains(basicDomain16.getDomainId())) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getAllDomains().contains(basicDomain18.getDomainId())) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getBinaryDomainCombinationsSpecificToGenome0().size() != 0) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getBinaryDomainCombinationsSpecificToGenome1().size() != 0) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getSharedBinaryDomainCombinations().size() != 1) {
                return false;
            }
            if (domainArchitectureBasedGenomeSimilarityCalculator3.getAllBinaryDomainCombinations().size() != 1) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getSharedBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("y", "z"))) {
                return false;
            }
            if (!domainArchitectureBasedGenomeSimilarityCalculator3.getAllBinaryDomainCombinations().contains(BasicBinaryDomainCombination.obtainInstance("z", "y"))) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainArchitectureBasedGenomeSimilarityCalculator3.calculateSharedBinaryDomainCombinationBasedGenomeSimilarityScore(), 1.0)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainArchitectureBasedGenomeSimilarityCalculator3.calculateSharedDomainsBasedGenomeSimilarityScore(), 0.75)) {
                return false;
            }
            domainArchitectureBasedGenomeSimilarityCalculator3.setAllowDomainsToBeIgnored(false);
            if (!TestSurfacing.isEqual(domainArchitectureBasedGenomeSimilarityCalculator3.calculateSharedBinaryDomainCombinationBasedGenomeSimilarityScore(), 0.4)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainArchitectureBasedGenomeSimilarityCalculator3.calculateSharedDomainsBasedGenomeSimilarityScore(), 0.6666666666666667)) {
                return false;
            }
            domainArchitectureBasedGenomeSimilarityCalculator3.setAllowDomainsToBeIgnored(true);
            if (!TestSurfacing.isEqual(domainArchitectureBasedGenomeSimilarityCalculator3.calculateSharedBinaryDomainCombinationBasedGenomeSimilarityScore(), 1.0)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainArchitectureBasedGenomeSimilarityCalculator3.calculateSharedDomainsBasedGenomeSimilarityScore(), 0.75)) {
                return false;
            }
            domainArchitectureBasedGenomeSimilarityCalculator3.deleteAllDomainIdsToIgnore();
            if (!TestSurfacing.isEqual(domainArchitectureBasedGenomeSimilarityCalculator3.calculateSharedBinaryDomainCombinationBasedGenomeSimilarityScore(), 0.4)) {
                return false;
            }
            if (!TestSurfacing.isEqual(domainArchitectureBasedGenomeSimilarityCalculator3.calculateSharedDomainsBasedGenomeSimilarityScore(), 0.6666666666666667)) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testDomainCombinationCounting(File file) {
        try {
            HmmPfamOutputParser hmmPfamOutputParser = new HmmPfamOutputParser(new File(file + ForesterUtil.getFileSeparator() + "hmmpfam_output2"), "human", "ls");
            hmmPfamOutputParser.setEValueMaximum(0.2);
            hmmPfamOutputParser.setIgnoreDufs(true);
            hmmPfamOutputParser.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            List<Protein> list = hmmPfamOutputParser.parse();
            BasicGenomeWideCombinableDomains basicGenomeWideCombinableDomains = BasicGenomeWideCombinableDomains.createInstance(list, false, new BasicSpecies("human"));
            CombinableDomains combinableDomains = basicGenomeWideCombinableDomains.get("A");
            if (combinableDomains.getKeyDomainCount() != 9) {
                return false;
            }
            if (combinableDomains.getKeyDomainProteinsCount() != 7) {
                return false;
            }
            if (combinableDomains.getNumberOfCombinableDomains() != 11) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("A").getDomainId()) != 2) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("B").getDomainId()) != 6) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("C").getDomainId()) != 4) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("D").getDomainId()) != 3) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("E").getDomainId()) != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("U").getDomainId()) != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("V").getDomainId()) != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("W").getDomainId()) != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("X").getDomainId()) != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("Y").getDomainId()) != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("Z").getDomainId()) != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("NN").getDomainId()) != 0) {
                return false;
            }
            if (combinableDomains.getKeyDomainCount() != 9) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains.get("B");
            if (combinableDomains.getKeyDomainCount() != 12) {
                return false;
            }
            if (combinableDomains.getKeyDomainProteinsCount() != 7) {
                return false;
            }
            if (combinableDomains.getNumberOfCombinableDomains() != 11) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("A").getDomainId()) != 6) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("B").getDomainId()) != 4) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("C").getDomainId()) != 4) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("D").getDomainId()) != 3) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("E").getDomainId()) != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("U").getDomainId()) != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("V").getDomainId()) != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("W").getDomainId()) != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("X").getDomainId()) != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("Y").getDomainId()) != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("Z").getDomainId()) != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("NN").getDomainId()) != 0) {
                return false;
            }
            if (combinableDomains.getKeyDomainCount() != 12) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains.get("C");
            if (combinableDomains.getKeyDomainCount() != 10) {
                return false;
            }
            if (combinableDomains.getKeyDomainProteinsCount() != 7) {
                return false;
            }
            if (combinableDomains.getNumberOfCombinableDomains() != 11) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("A").getDomainId()) != 4) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("B").getDomainId()) != 4) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("C").getDomainId()) != 2) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("D").getDomainId()) != 3) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("E").getDomainId()) != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("U").getDomainId()) != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("V").getDomainId()) != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("W").getDomainId()) != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("X").getDomainId()) != 2) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("Y").getDomainId()) != 2) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("Z").getDomainId()) != 2) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("NN").getDomainId()) != 0) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains.get("D");
            if (combinableDomains.getKeyDomainCount() != 15) {
                return false;
            }
            if (combinableDomains.getKeyDomainProteinsCount() != 6) {
                return false;
            }
            if (combinableDomains.getNumberOfCombinableDomains() != 11) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains.get("E");
            if (combinableDomains.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            if (combinableDomains.getKeyDomainCount() != 1) {
                return false;
            }
            if (combinableDomains.getKeyDomainProteinsCount() != 1) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains.get("U");
            if (combinableDomains.getNumberOfCombinableDomains() != 11) {
                return false;
            }
            if (combinableDomains.getKeyDomainCount() != 6) {
                return false;
            }
            if (combinableDomains.getKeyDomainProteinsCount() != 3) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains.get("V");
            if (combinableDomains.getNumberOfCombinableDomains() != 11) {
                return false;
            }
            if (combinableDomains.getKeyDomainCount() != 3) {
                return false;
            }
            if (combinableDomains.getKeyDomainProteinsCount() != 2) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains.get("W");
            if (combinableDomains.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            if (combinableDomains.getKeyDomainCount() != 2) {
                return false;
            }
            if (combinableDomains.getKeyDomainProteinsCount() != 2) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains.get("X");
            if (combinableDomains.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            if (combinableDomains.getKeyDomainCount() != 2) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains.get("Y");
            if (combinableDomains.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains.get("Z");
            if (combinableDomains.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains.get("NN");
            if (combinableDomains.getKeyDomainCount() != 1) {
                return false;
            }
            if (combinableDomains.getKeyDomainProteinsCount() != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfCombinableDomains() != 0) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("NN").getDomainId()) != 0) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains.get("MM");
            if (combinableDomains.getNumberOfCombinableDomains() != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("MM").getDomainId()) != 0) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("OO").getDomainId()) != 1) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains.get("OO");
            if (combinableDomains.getNumberOfCombinableDomains() != 2) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("OO").getDomainId()) != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("MM").getDomainId()) != 1) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains.get("QQ");
            if (combinableDomains.getNumberOfCombinableDomains() != 1) {
                return false;
            }
            if (combinableDomains.getKeyDomainCount() != 17) {
                return false;
            }
            if (combinableDomains.getKeyDomainProteinsCount() != 4) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("QQ").getDomainId()) != 3) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains.get("PP");
            if (combinableDomains.getNumberOfCombinableDomains() != 0) {
                return false;
            }
            if (combinableDomains.getKeyDomainCount() != 2) {
                return false;
            }
            if (combinableDomains.getKeyDomainProteinsCount() != 2) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains.get("singlet");
            if (combinableDomains.getKeyDomainCount() != 1) {
                return false;
            }
            if (combinableDomains.getKeyDomainProteinsCount() != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfCombinableDomains() != 0) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("singlet").getDomainId()) != 0) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains.get("three");
            if (combinableDomains.getKeyDomainCount() != 3) {
                return false;
            }
            if (combinableDomains.getKeyDomainProteinsCount() != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfCombinableDomains() != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("three") != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("so_far_so_bad") != 0) {
                return false;
            }
            BasicGenomeWideCombinableDomains basicGenomeWideCombinableDomains2 = BasicGenomeWideCombinableDomains.createInstance(list, true, new BasicSpecies("human"), null, BinaryDomainCombination.DomainCombinationType.BASIC, null, null);
            combinableDomains = basicGenomeWideCombinableDomains2.get("A");
            if (combinableDomains.getKeyDomainCount() != 9) {
                return false;
            }
            if (combinableDomains.getKeyDomainProteinsCount() != 7) {
                return false;
            }
            if (combinableDomains.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("A").getDomainId()) != 0) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("B").getDomainId()) != 6) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("C").getDomainId()) != 4) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("D").getDomainId()) != 3) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination(new SimpleDomain("E").getDomainId()) != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("U") != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("V") != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("W") != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("X") != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("Y") != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("Z") != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("NN") != 0) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains2.get("B");
            if (combinableDomains.getKeyDomainCount() != 12) {
                return false;
            }
            if (combinableDomains.getKeyDomainProteinsCount() != 7) {
                return false;
            }
            if (combinableDomains.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("A") != 6) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("B") != 0) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("C") != 4) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("D") != 3) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("E") != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("U") != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("V") != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("W") != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("X") != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("Y") != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("Z") != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("NN") != 0) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains2.get("C");
            if (combinableDomains.getKeyDomainCount() != 10) {
                return false;
            }
            if (combinableDomains.getKeyDomainProteinsCount() != 7) {
                return false;
            }
            if (combinableDomains.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("A") != 4) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("B") != 4) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("C") != 0) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("D") != 3) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("E") != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("U") != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("V") != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("W") != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("X") != 2) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("Y") != 2) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("Z") != 2) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("NN") != 0) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains2.get("D");
            if (combinableDomains.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains2.get("E");
            if (combinableDomains.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            if (combinableDomains.getKeyDomainCount() != 1) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains2.get("U");
            if (combinableDomains.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains2.get("V");
            if (combinableDomains.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains2.get("W");
            if (combinableDomains.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains2.get("X");
            if (combinableDomains.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains2.get("Y");
            if (combinableDomains.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains2.get("Z");
            if (combinableDomains.getNumberOfCombinableDomains() != 10) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains2.get("NN");
            if (combinableDomains.getNumberOfCombinableDomains() != 0) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("NN") != 0) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains2.get("MM");
            if (combinableDomains.getNumberOfCombinableDomains() != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("MM") != 0) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("OO") != 1) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains2.get("OO");
            if (combinableDomains.getNumberOfCombinableDomains() != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("OO") != 0) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("MM") != 1) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains2.get("QQ");
            if (combinableDomains.getNumberOfCombinableDomains() != 0) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("QQ") != 0) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains2.get("singlet");
            if (combinableDomains.getKeyDomainCount() != 1) {
                return false;
            }
            if (combinableDomains.getKeyDomainProteinsCount() != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfCombinableDomains() != 0) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("singlet") != 0) {
                return false;
            }
            combinableDomains = basicGenomeWideCombinableDomains2.get("three");
            if (combinableDomains.getKeyDomainCount() != 3) {
                return false;
            }
            if (combinableDomains.getKeyDomainProteinsCount() != 1) {
                return false;
            }
            if (combinableDomains.getNumberOfCombinableDomains() != 0) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("three") != 0) {
                return false;
            }
            if (combinableDomains.getNumberOfProteinsExhibitingCombination("so_far_so_bad") != 0) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testDomainSorting() {
        try {
            BasicDomain basicDomain = new BasicDomain("A", 1, 2, 1, 1, 0.1, -12.0);
            BasicDomain basicDomain2 = new BasicDomain("B", 1, 2, 1, 1, 0.1, -12.0);
            BasicDomain basicDomain3 = new BasicDomain("C", 1, 2, 1, 1, 0.2, -12.0);
            BasicDomain basicDomain4 = new BasicDomain("D", 1, 2, 1, 1, 0.3, -12.0);
            BasicDomain basicDomain5 = new BasicDomain("E", 1, 2, 1, 1, 0.4, -12.0);
            BasicDomain basicDomain6 = new BasicDomain("F", 1, 2, 1, 1, 0.5, -12.0);
            BasicDomain basicDomain7 = new BasicDomain("G", 1, 2, 1, 1, 0.6, -12.0);
            BasicDomain basicDomain8 = new BasicDomain("H", 100, 200, 1, 5, 0.7, -12.0);
            BasicDomain basicDomain9 = new BasicDomain("H", 300, 400, 2, 5, 0.7, -12.0);
            BasicDomain basicDomain10 = new BasicDomain("H", 500, 600, 3, 5, 0.7, -12.0);
            BasicDomain basicDomain11 = new BasicDomain("H", 700, 800, 4, 5, 0.7, -12.0);
            BasicDomain basicDomain12 = new BasicDomain("H", 700, 800, 5, 5, 0.7, -12.0);
            BasicDomain basicDomain13 = new BasicDomain("H", 1199, 1299, 6, 6, 0.7, -0.111);
            BasicDomain basicDomain14 = new BasicDomain("H7", 700, 800, 5, 5, 0.7, -12.0);
            BasicDomain basicDomain15 = new BasicDomain("H7", 700, 800, 5, 200, 0.7, -12.0);
            BasicProtein basicProtein = new BasicProtein("00", "bat", 0);
            basicProtein.addProteinDomain(basicDomain12);
            basicProtein.addProteinDomain(basicDomain9);
            basicProtein.addProteinDomain(basicDomain14);
            basicProtein.addProteinDomain(basicDomain13);
            basicProtein.addProteinDomain(basicDomain);
            basicProtein.addProteinDomain(basicDomain7);
            basicProtein.addProteinDomain(basicDomain11);
            basicProtein.addProteinDomain(basicDomain4);
            basicProtein.addProteinDomain(basicDomain8);
            basicProtein.addProteinDomain(basicDomain3);
            basicProtein.addProteinDomain(basicDomain5);
            basicProtein.addProteinDomain(basicDomain6);
            basicProtein.addProteinDomain(basicDomain2);
            basicProtein.addProteinDomain(basicDomain10);
            basicProtein.addProteinDomain(basicDomain14);
            basicProtein.addProteinDomain(basicDomain14);
            basicProtein.addProteinDomain(basicDomain15);
            List<Domain> list = SurfacingUtil.sortDomainsWithAscendingConfidenceValues(basicProtein);
            if (list.size() != 17) {
                return false;
            }
            if (!list.get(0).getDomainId().equals("A")) {
                return false;
            }
            if (list.get(0).getNumber() != 1) {
                return false;
            }
            if (!list.get(1).getDomainId().equals("B")) {
                return false;
            }
            if (list.get(1).getNumber() != 1) {
                return false;
            }
            if (!list.get(2).getDomainId().equals("C")) {
                return false;
            }
            if (list.get(2).getNumber() != 1) {
                return false;
            }
            if (!list.get(3).getDomainId().equals("D")) {
                return false;
            }
            if (list.get(3).getNumber() != 1) {
                return false;
            }
            if (!list.get(4).getDomainId().equals("E")) {
                return false;
            }
            if (list.get(4).getNumber() != 1) {
                return false;
            }
            if (!list.get(5).getDomainId().equals("F")) {
                return false;
            }
            if (list.get(5).getNumber() != 1) {
                return false;
            }
            if (!list.get(6).getDomainId().equals("G")) {
                return false;
            }
            if (list.get(6).getNumber() != 1) {
                return false;
            }
            if (!list.get(7).getDomainId().equals("H")) {
                return false;
            }
            if (list.get(7).getNumber() != 5) {
                return false;
            }
            if (!list.get(8).getDomainId().equals("H")) {
                return false;
            }
            if (list.get(8).getNumber() != 2) {
                return false;
            }
            if (!list.get(9).getDomainId().equals("H")) {
                return false;
            }
            if (list.get(9).getNumber() != 6) {
                return false;
            }
            if (!list.get(10).getDomainId().equals("H")) {
                return false;
            }
            if (list.get(10).getNumber() != 4) {
                return false;
            }
            if (!list.get(11).getDomainId().equals("H")) {
                return false;
            }
            if (list.get(11).getNumber() != 1) {
                return false;
            }
            if (list.get(11).getTotalCount() != 5) {
                return false;
            }
            if (!list.get(12).getDomainId().equals("H")) {
                return false;
            }
            if (list.get(12).getNumber() != 3) {
                return false;
            }
            if (!list.get(13).getDomainId().equals("H7")) {
                return false;
            }
            if (list.get(13).getNumber() != 5) {
                return false;
            }
            if (!list.get(14).getDomainId().equals("H7")) {
                return false;
            }
            if (list.get(14).getNumber() != 5) {
                return false;
            }
            if (!list.get(15).getDomainId().equals("H7")) {
                return false;
            }
            if (list.get(15).getNumber() != 5) {
                return false;
            }
            if (!list.get(16).getDomainId().equals("H7")) {
                return false;
            }
            if (list.get(16).getNumber() != 5) {
                return false;
            }
            if (list.get(16).getTotalCount() != 200) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testGenomeWideCombinableDomains() {
        try {
            BasicDomain basicDomain = new BasicDomain("a", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain2 = new BasicDomain("b", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain3 = new BasicDomain("c", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain4 = new BasicDomain("d", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain5 = new BasicDomain("e", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain6 = new BasicDomain("f", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain7 = new BasicDomain("g", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain8 = new BasicDomain("h", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain9 = new BasicDomain("x", 23, 25, 1, 4, 0.1, -12.0);
            BasicProtein basicProtein = new BasicProtein("0", "eel", 0);
            BasicProtein basicProtein2 = new BasicProtein("1", "eel", 0);
            BasicProtein basicProtein3 = new BasicProtein("2", "eel", 0);
            BasicProtein basicProtein4 = new BasicProtein("3", "eel", 0);
            BasicProtein basicProtein5 = new BasicProtein("4", "eel", 0);
            BasicProtein basicProtein6 = new BasicProtein("5", "eel", 0);
            BasicProtein basicProtein7 = new BasicProtein("6", "eel", 0);
            basicProtein2.addProteinDomain(basicDomain);
            basicProtein3.addProteinDomain(basicDomain);
            basicProtein3.addProteinDomain(basicDomain2);
            basicProtein4.addProteinDomain(basicDomain);
            basicProtein4.addProteinDomain(basicDomain);
            basicProtein4.addProteinDomain(basicDomain2);
            basicProtein5.addProteinDomain(basicDomain);
            basicProtein5.addProteinDomain(basicDomain2);
            basicProtein5.addProteinDomain(basicDomain3);
            basicProtein5.addProteinDomain(basicDomain4);
            basicProtein5.addProteinDomain(basicDomain5);
            basicProtein6.addProteinDomain(basicDomain5);
            basicProtein6.addProteinDomain(basicDomain5);
            basicProtein6.addProteinDomain(basicDomain6);
            basicProtein6.addProteinDomain(basicDomain6);
            basicProtein6.addProteinDomain(basicDomain6);
            basicProtein6.addProteinDomain(basicDomain6);
            basicProtein7.addProteinDomain(basicDomain7);
            basicProtein7.addProteinDomain(basicDomain8);
            ArrayList<Protein> arrayList = new ArrayList<Protein>();
            arrayList.add(basicProtein);
            arrayList.add(basicProtein2);
            arrayList.add(basicProtein3);
            arrayList.add(basicProtein4);
            arrayList.add(basicProtein5);
            arrayList.add(basicProtein6);
            arrayList.add(basicProtein7);
            BasicGenomeWideCombinableDomains basicGenomeWideCombinableDomains = BasicGenomeWideCombinableDomains.createInstance(arrayList, false, new BasicSpecies("eel"));
            BasicGenomeWideCombinableDomains basicGenomeWideCombinableDomains2 = BasicGenomeWideCombinableDomains.createInstance(arrayList, true, new BasicSpecies("eel"));
            if (!basicGenomeWideCombinableDomains.contains("a")) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.contains("b")) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.contains("c")) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.contains("d")) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.contains("e")) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.contains("f")) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.contains("g")) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.contains("h")) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.contains("x")) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains2.contains("a")) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains2.contains("b")) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains2.contains("c")) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains2.contains("d")) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains2.contains("e")) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains2.contains("f")) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains2.contains("g")) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains2.contains("h")) {
                return false;
            }
            if (basicGenomeWideCombinableDomains2.contains("x")) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.getSize() != 8) {
                return false;
            }
            if (basicGenomeWideCombinableDomains2.getSize() != 8) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.get("a").getCombinableDomainsIds().size() != 5) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.get("b").getCombinableDomainsIds().size() != 4) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.get("c").getCombinableDomainsIds().size() != 4) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.get("d").getCombinableDomainsIds().size() != 4) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.get("e").getCombinableDomainsIds().size() != 6) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.get("f").getCombinableDomainsIds().size() != 2) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.get("g").getCombinableDomainsIds().size() != 1) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.get("h").getCombinableDomainsIds().size() != 1) {
                return false;
            }
            if (basicGenomeWideCombinableDomains2.get("a").getCombinableDomainsIds().size() != 4) {
                return false;
            }
            if (basicGenomeWideCombinableDomains2.get("b").getCombinableDomainsIds().size() != 4) {
                return false;
            }
            if (basicGenomeWideCombinableDomains2.get("c").getCombinableDomainsIds().size() != 4) {
                return false;
            }
            if (basicGenomeWideCombinableDomains2.get("d").getCombinableDomainsIds().size() != 4) {
                return false;
            }
            if (basicGenomeWideCombinableDomains2.get("e").getCombinableDomainsIds().size() != 5) {
                return false;
            }
            if (basicGenomeWideCombinableDomains2.get("f").getCombinableDomainsIds().size() != 1) {
                return false;
            }
            if (basicGenomeWideCombinableDomains2.get("g").getCombinableDomainsIds().size() != 1) {
                return false;
            }
            if (basicGenomeWideCombinableDomains2.get("h").getCombinableDomainsIds().size() != 1) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.getAllDomainIds().size() != 8) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.getAllDomainIds().contains(basicDomain.getDomainId())) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.getAllDomainIds().contains(basicDomain2.getDomainId())) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.getAllDomainIds().contains(basicDomain3.getDomainId())) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.getAllDomainIds().contains(basicDomain4.getDomainId())) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.getAllDomainIds().contains(basicDomain5.getDomainId())) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.getAllDomainIds().contains(basicDomain6.getDomainId())) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.getAllDomainIds().contains(basicDomain7.getDomainId())) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains.getAllDomainIds().contains(basicDomain8.getDomainId())) {
                return false;
            }
            if (basicGenomeWideCombinableDomains.getAllDomainIds().contains(basicDomain9.getDomainId())) {
                return false;
            }
            if (basicGenomeWideCombinableDomains2.getAllDomainIds().size() != 8) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains2.getAllDomainIds().contains(basicDomain.getDomainId())) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains2.getAllDomainIds().contains(basicDomain2.getDomainId())) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains2.getAllDomainIds().contains(basicDomain3.getDomainId())) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains2.getAllDomainIds().contains(basicDomain4.getDomainId())) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains2.getAllDomainIds().contains(basicDomain5.getDomainId())) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains2.getAllDomainIds().contains(basicDomain6.getDomainId())) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains2.getAllDomainIds().contains(basicDomain7.getDomainId())) {
                return false;
            }
            if (!basicGenomeWideCombinableDomains2.getAllDomainIds().contains(basicDomain8.getDomainId())) {
                return false;
            }
            if (basicGenomeWideCombinableDomains2.getAllDomainIds().contains(basicDomain9.getDomainId())) {
                return false;
            }
            SortedSet<BinaryDomainCombination> sortedSet = basicGenomeWideCombinableDomains.toBinaryDomainCombinations();
            if (sortedSet.size() != 15) {
                return false;
            }
            if (!sortedSet.contains(BasicBinaryDomainCombination.obtainInstance("a", "a"))) {
                return false;
            }
            if (!sortedSet.contains(BasicBinaryDomainCombination.obtainInstance("a", "b"))) {
                return false;
            }
            if (!sortedSet.contains(BasicBinaryDomainCombination.obtainInstance("b", "a"))) {
                return false;
            }
            if (!sortedSet.contains(BasicBinaryDomainCombination.obtainInstance("a", "c"))) {
                return false;
            }
            if (!sortedSet.contains(BasicBinaryDomainCombination.obtainInstance("a", "d"))) {
                return false;
            }
            if (!sortedSet.contains(BasicBinaryDomainCombination.obtainInstance("a", "e"))) {
                return false;
            }
            if (!sortedSet.contains(BasicBinaryDomainCombination.obtainInstance("b", "c"))) {
                return false;
            }
            if (!sortedSet.contains(BasicBinaryDomainCombination.obtainInstance("b", "d"))) {
                return false;
            }
            if (!sortedSet.contains(BasicBinaryDomainCombination.obtainInstance("b", "e"))) {
                return false;
            }
            if (!sortedSet.contains(BasicBinaryDomainCombination.obtainInstance("c", "d"))) {
                return false;
            }
            if (!sortedSet.contains(BasicBinaryDomainCombination.obtainInstance("c", "e"))) {
                return false;
            }
            if (!sortedSet.contains(BasicBinaryDomainCombination.obtainInstance("d", "e"))) {
                return false;
            }
            if (!sortedSet.contains(BasicBinaryDomainCombination.obtainInstance("e", "f"))) {
                return false;
            }
            if (!sortedSet.contains(BasicBinaryDomainCombination.obtainInstance("e", "e"))) {
                return false;
            }
            if (!sortedSet.contains(BasicBinaryDomainCombination.obtainInstance("f", "f"))) {
                return false;
            }
            if (!sortedSet.contains(BasicBinaryDomainCombination.obtainInstance("g", "h"))) {
                return false;
            }
            if (sortedSet.contains(BasicBinaryDomainCombination.obtainInstance("f", "a"))) {
                return false;
            }
            if (sortedSet.contains(BasicBinaryDomainCombination.obtainInstance("f", "b"))) {
                return false;
            }
            if (sortedSet.contains(BasicBinaryDomainCombination.obtainInstance("a", "h"))) {
                return false;
            }
            if (sortedSet.contains(BasicBinaryDomainCombination.obtainInstance("a", "g"))) {
                return false;
            }
            SortedSet<BinaryDomainCombination> sortedSet2 = basicGenomeWideCombinableDomains2.toBinaryDomainCombinations();
            if (sortedSet2.size() != 12) {
                return false;
            }
            if (sortedSet2.contains(BasicBinaryDomainCombination.obtainInstance("a", "a"))) {
                return false;
            }
            if (!sortedSet2.contains(BasicBinaryDomainCombination.obtainInstance("a", "b"))) {
                return false;
            }
            if (!sortedSet2.contains(BasicBinaryDomainCombination.obtainInstance("b", "a"))) {
                return false;
            }
            if (!sortedSet2.contains(BasicBinaryDomainCombination.obtainInstance("a", "c"))) {
                return false;
            }
            if (!sortedSet2.contains(BasicBinaryDomainCombination.obtainInstance("a", "d"))) {
                return false;
            }
            if (!sortedSet2.contains(BasicBinaryDomainCombination.obtainInstance("a", "e"))) {
                return false;
            }
            if (!sortedSet2.contains(BasicBinaryDomainCombination.obtainInstance("b", "c"))) {
                return false;
            }
            if (!sortedSet2.contains(BasicBinaryDomainCombination.obtainInstance("b", "d"))) {
                return false;
            }
            if (!sortedSet2.contains(BasicBinaryDomainCombination.obtainInstance("b", "e"))) {
                return false;
            }
            if (!sortedSet2.contains(BasicBinaryDomainCombination.obtainInstance("c", "d"))) {
                return false;
            }
            if (!sortedSet2.contains(BasicBinaryDomainCombination.obtainInstance("c", "e"))) {
                return false;
            }
            if (!sortedSet2.contains(BasicBinaryDomainCombination.obtainInstance("d", "e"))) {
                return false;
            }
            if (!sortedSet2.contains(BasicBinaryDomainCombination.obtainInstance("e", "f"))) {
                return false;
            }
            if (!sortedSet2.contains(BasicBinaryDomainCombination.obtainInstance("g", "h"))) {
                return false;
            }
            if (sortedSet2.contains(BasicBinaryDomainCombination.obtainInstance("e", "e"))) {
                return false;
            }
            if (sortedSet2.contains(BasicBinaryDomainCombination.obtainInstance("f", "f"))) {
                return false;
            }
            if (sortedSet2.contains(BasicBinaryDomainCombination.obtainInstance("f", "a"))) {
                return false;
            }
            if (sortedSet2.contains(BasicBinaryDomainCombination.obtainInstance("f", "b"))) {
                return false;
            }
            if (sortedSet2.contains(BasicBinaryDomainCombination.obtainInstance("a", "g"))) {
                return false;
            }
            if (sortedSet2.contains(BasicBinaryDomainCombination.obtainInstance("b", "g"))) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testHmmPfamOutputParser(File file) {
        try {
            HmmPfamOutputParser hmmPfamOutputParser = new HmmPfamOutputParser(new File(file + ForesterUtil.getFileSeparator() + "hmmpfam_output"), "human", "ls");
            hmmPfamOutputParser.setEValueMaximum(0.2);
            hmmPfamOutputParser.setIgnoreDufs(true);
            hmmPfamOutputParser.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            List<Protein> list = null;
            list = hmmPfamOutputParser.parse();
            if (hmmPfamOutputParser.getDomainsEncountered() != 4) {
                return false;
            }
            if (hmmPfamOutputParser.getDomainsIgnoredDueToDuf() != 0) {
                return false;
            }
            if (hmmPfamOutputParser.getDomainsIgnoredDueToEval() != 1) {
                return false;
            }
            if (hmmPfamOutputParser.getDomainsIgnoredDueToOverlap() != 0) {
                return false;
            }
            if (hmmPfamOutputParser.getDomainsStored() != 3) {
                return false;
            }
            if (list.size() != 1) {
                return false;
            }
            Protein protein = list.get(0);
            if (!protein.getProteinId().equals(new ProteinId("ENSP00000285681"))) {
                return false;
            }
            if (!protein.getSpecies().getSpeciesId().equals("human")) {
                return false;
            }
            if (protein.getNumberOfProteinDomains() != 3) {
                return false;
            }
            if (!protein.getAccession().equals("acc_ENSP00000285681")) {
                return false;
            }
            if (!protein.getDescription().equals("pep:known chromosome:NCBI36:21:16024215:16174248:1 gene:ENSG00000155313 transcript:ENST00000285681")) {
                return false;
            }
            List<Domain> list2 = protein.getProteinDomains("UBA");
            List<Domain> list3 = protein.getProteinDomains("UIM");
            List<Domain> list4 = protein.getProteinDomains("UCH");
            if (list2.size() != 1) {
                return false;
            }
            if (list3.size() != 2) {
                return false;
            }
            if (list4.size() != 0) {
                return false;
            }
            BasicDomain basicDomain = (BasicDomain)list3.get(1);
            if (!basicDomain.getDomainId().equals("UIM")) {
                return false;
            }
            if (basicDomain.getTotalCount() != 2) {
                return false;
            }
            BasicDomain basicDomain2 = (BasicDomain)list2.get(0);
            if (!basicDomain2.getDomainId().equals("UBA")) {
                return false;
            }
            if (basicDomain2.getNumber() != 1) {
                return false;
            }
            if (basicDomain2.getTotalCount() != 1) {
                return false;
            }
            if (basicDomain2.getFrom() != 16) {
                return false;
            }
            if (basicDomain2.getTo() != 57) {
                return false;
            }
            HmmPfamOutputParser hmmPfamOutputParser2 = new HmmPfamOutputParser(new File(file + ForesterUtil.getFileSeparator() + "hmmpfam_output_short"), "human", "ls");
            hmmPfamOutputParser2.setEValueMaximum(0.2);
            hmmPfamOutputParser2.setIgnoreDufs(true);
            hmmPfamOutputParser2.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            List<Protein> list5 = null;
            list5 = hmmPfamOutputParser2.parse();
            if (hmmPfamOutputParser2.getDomainsEncountered() != 4) {
                return false;
            }
            if (hmmPfamOutputParser.getDomainsIgnoredDueToDuf() != 0) {
                return false;
            }
            if (hmmPfamOutputParser.getDomainsIgnoredDueToEval() != 1) {
                return false;
            }
            if (hmmPfamOutputParser.getDomainsIgnoredDueToOverlap() != 0) {
                return false;
            }
            if (hmmPfamOutputParser2.getDomainsStored() != 3) {
                return false;
            }
            if (list5.size() != 1) {
                return false;
            }
            Protein protein2 = list5.get(0);
            if (!protein2.getProteinId().getId().equals("ENSP00000285681")) {
                return false;
            }
            if (!protein2.getSpecies().getSpeciesId().equals("human")) {
                return false;
            }
            if (!protein2.getName().equals("")) {
                return false;
            }
            if (!protein2.getAccession().equals("223")) {
                return false;
            }
            if (!protein2.getDescription().equals("pep:known chromosome:NCBI36:21:16024215:16174248:1 gene:ENSG00000155313 transcript:ENST00000285681")) {
                return false;
            }
            if (protein2.getNumberOfProteinDomains() != 3) {
                return false;
            }
            List<Domain> list6 = protein2.getProteinDomains("UBA");
            List<Domain> list7 = protein2.getProteinDomains("UIM");
            List<Domain> list8 = protein2.getProteinDomains("UCH");
            if (list6.size() != 1) {
                return false;
            }
            if (list7.size() != 2) {
                return false;
            }
            if (list8.size() != 0) {
                return false;
            }
            BasicDomain basicDomain3 = (BasicDomain)list7.get(1);
            if (!basicDomain3.getDomainId().equals("UIM")) {
                return false;
            }
            if (basicDomain3.getTotalCount() != 2) {
                return false;
            }
            BasicDomain basicDomain4 = (BasicDomain)list6.get(0);
            if (!basicDomain4.getDomainId().equals("UBA")) {
                return false;
            }
            if (basicDomain4.getNumber() != 1) {
                return false;
            }
            if (basicDomain4.getTotalCount() != 1) {
                return false;
            }
            if (basicDomain4.getFrom() != 16) {
                return false;
            }
            if (basicDomain4.getTo() != 57) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testHmmPfamOutputParserWithFilter(File file) {
        try {
            HmmPfamOutputParser hmmPfamOutputParser = new HmmPfamOutputParser(new File(file + ForesterUtil.getFileSeparator() + "hmmpfam_output3"), "human", "ls");
            hmmPfamOutputParser.setEValueMaximum(0.2);
            hmmPfamOutputParser.setIgnoreDufs(true);
            hmmPfamOutputParser.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            List<Protein> list = null;
            list = hmmPfamOutputParser.parse();
            if (hmmPfamOutputParser.getProteinsIgnoredDueToFilter() != 0) {
                return false;
            }
            if (list.size() != 4) {
                return false;
            }
            TreeSet<String> treeSet = new TreeSet<String>();
            treeSet.add("beauty");
            treeSet.add("strange");
            hmmPfamOutputParser = new HmmPfamOutputParser(new File(file + ForesterUtil.getFileSeparator() + "hmmpfam_output3"), "human", treeSet, HmmPfamOutputParser.FilterType.NEGATIVE_PROTEIN);
            hmmPfamOutputParser.setEValueMaximum(0.2);
            hmmPfamOutputParser.setIgnoreDufs(true);
            hmmPfamOutputParser.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            list = null;
            list = hmmPfamOutputParser.parse();
            if (hmmPfamOutputParser.getProteinsIgnoredDueToFilter() != 0) {
                return false;
            }
            if (list.size() != 4) {
                return false;
            }
            treeSet = new TreeSet();
            treeSet.add("beauty");
            treeSet.add("strange");
            hmmPfamOutputParser = new HmmPfamOutputParser(new File(file + ForesterUtil.getFileSeparator() + "hmmpfam_output3"), "human", treeSet, HmmPfamOutputParser.FilterType.POSITIVE_PROTEIN);
            hmmPfamOutputParser.setEValueMaximum(0.2);
            hmmPfamOutputParser.setIgnoreDufs(true);
            hmmPfamOutputParser.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            list = null;
            list = hmmPfamOutputParser.parse();
            if (hmmPfamOutputParser.getProteinsIgnoredDueToFilter() != 4) {
                return false;
            }
            if (list.size() != 0) {
                return false;
            }
            treeSet = new TreeSet();
            treeSet.add("UIM");
            treeSet.add("A");
            treeSet.add("C");
            hmmPfamOutputParser = new HmmPfamOutputParser(new File(file + ForesterUtil.getFileSeparator() + "hmmpfam_output3"), "human", treeSet, HmmPfamOutputParser.FilterType.POSITIVE_PROTEIN);
            hmmPfamOutputParser.setEValueMaximum(0.2);
            hmmPfamOutputParser.setIgnoreDufs(true);
            hmmPfamOutputParser.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            list = null;
            list = hmmPfamOutputParser.parse();
            if (hmmPfamOutputParser.getProteinsIgnoredDueToFilter() != 0) {
                return false;
            }
            if (list.size() != 4) {
                return false;
            }
            treeSet = new TreeSet();
            treeSet.add("UIM");
            treeSet.add("A");
            treeSet.add("C");
            treeSet.add("X");
            hmmPfamOutputParser = new HmmPfamOutputParser(new File(file + ForesterUtil.getFileSeparator() + "hmmpfam_output3"), "human", treeSet, HmmPfamOutputParser.FilterType.NEGATIVE_DOMAIN);
            hmmPfamOutputParser.setEValueMaximum(0.2);
            hmmPfamOutputParser.setIgnoreDufs(true);
            hmmPfamOutputParser.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            list = null;
            list = hmmPfamOutputParser.parse();
            if (hmmPfamOutputParser.getDomainsIgnoredDueToNegativeDomainFilter() != 7) {
                return false;
            }
            if (list.size() != 3) {
                return false;
            }
            treeSet = new TreeSet();
            treeSet.add("UIM");
            treeSet.add("A");
            treeSet.add("C");
            hmmPfamOutputParser = new HmmPfamOutputParser(new File(file + ForesterUtil.getFileSeparator() + "hmmpfam_output3"), "human", treeSet, HmmPfamOutputParser.FilterType.NEGATIVE_PROTEIN);
            hmmPfamOutputParser.setEValueMaximum(0.2);
            hmmPfamOutputParser.setIgnoreDufs(true);
            hmmPfamOutputParser.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            list = null;
            list = hmmPfamOutputParser.parse();
            if (hmmPfamOutputParser.getProteinsIgnoredDueToFilter() != 4) {
                return false;
            }
            if (list.size() != 0) {
                return false;
            }
            treeSet = new TreeSet();
            treeSet.add("UIM");
            hmmPfamOutputParser = new HmmPfamOutputParser(new File(file + ForesterUtil.getFileSeparator() + "hmmpfam_output3"), "human", treeSet, HmmPfamOutputParser.FilterType.NEGATIVE_PROTEIN);
            hmmPfamOutputParser.setEValueMaximum(0.2);
            hmmPfamOutputParser.setIgnoreDufs(true);
            hmmPfamOutputParser.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            list = null;
            list = hmmPfamOutputParser.parse();
            if (hmmPfamOutputParser.getProteinsIgnoredDueToFilter() != 1) {
                return false;
            }
            if (hmmPfamOutputParser.getProteinsStored() != 3) {
                return false;
            }
            if (list.size() != 3) {
                return false;
            }
            treeSet = new TreeSet();
            treeSet.add("UIM");
            hmmPfamOutputParser = new HmmPfamOutputParser(new File(file + ForesterUtil.getFileSeparator() + "hmmpfam_output3"), "human", treeSet, HmmPfamOutputParser.FilterType.POSITIVE_PROTEIN);
            hmmPfamOutputParser.setEValueMaximum(0.2);
            hmmPfamOutputParser.setIgnoreDufs(true);
            hmmPfamOutputParser.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            list = null;
            list = hmmPfamOutputParser.parse();
            if (hmmPfamOutputParser.getProteinsIgnoredDueToFilter() != 3) {
                return false;
            }
            if (hmmPfamOutputParser.getProteinsStored() != 1) {
                return false;
            }
            if (list.size() != 1) {
                return false;
            }
            treeSet = new TreeSet();
            treeSet.add("A");
            treeSet.add("C");
            hmmPfamOutputParser = new HmmPfamOutputParser(new File(file + ForesterUtil.getFileSeparator() + "hmmpfam_output3"), "human", treeSet, HmmPfamOutputParser.FilterType.POSITIVE_PROTEIN);
            hmmPfamOutputParser.setEValueMaximum(0.2);
            hmmPfamOutputParser.setIgnoreDufs(true);
            hmmPfamOutputParser.setReturnType(HmmPfamOutputParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            list = null;
            list = hmmPfamOutputParser.parse();
            if (hmmPfamOutputParser.getDomainsEncountered() != 11) {
                return false;
            }
            if (hmmPfamOutputParser.getProteinsEncountered() != 4) {
                return false;
            }
            if (hmmPfamOutputParser.getProteinsIgnoredDueToFilter() != 1) {
                return false;
            }
            if (hmmPfamOutputParser.getProteinsStored() != 3) {
                return false;
            }
            if (list.size() != 3) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testParsimony() {
        try {
            CharacterStateMatrix.BinaryStates binaryStates = CharacterStateMatrix.BinaryStates.PRESENT;
            CharacterStateMatrix.BinaryStates binaryStates2 = CharacterStateMatrix.BinaryStates.ABSENT;
            CharacterStateMatrix.GainLossStates gainLossStates = CharacterStateMatrix.GainLossStates.GAIN;
            CharacterStateMatrix.GainLossStates gainLossStates2 = CharacterStateMatrix.GainLossStates.LOSS;
            CharacterStateMatrix.GainLossStates gainLossStates3 = CharacterStateMatrix.GainLossStates.UNCHANGED_ABSENT;
            CharacterStateMatrix.GainLossStates gainLossStates4 = CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT;
            BasicDomain basicDomain = new BasicDomain("A", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain2 = new BasicDomain("B", 2, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain3 = new BasicDomain("C", 3, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain4 = new BasicDomain("D", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain5 = new BasicDomain("E", 2, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain6 = new BasicDomain("F", 3, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain7 = new BasicDomain("G", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain8 = new BasicDomain("H", 2, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain9 = new BasicDomain("I", 3, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain10 = new BasicDomain("J", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain11 = new BasicDomain("L", 3, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain12 = new BasicDomain("M", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain13 = new BasicDomain("N", 2, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain14 = new BasicDomain("O", 3, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain15 = new BasicDomain("P", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain16 = new BasicDomain("Q", 2, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain17 = new BasicDomain("R", 3, 25, 1, 4, 0.1, -12.0);
            BasicProtein basicProtein = new BasicProtein("aa1", "one", 0);
            basicProtein.addProteinDomain(basicDomain);
            basicProtein.addProteinDomain(basicDomain);
            BasicProtein basicProtein2 = new BasicProtein("ab1", "one", 0);
            basicProtein2.addProteinDomain(basicDomain);
            basicProtein2.addProteinDomain(basicDomain2);
            BasicProtein basicProtein3 = new BasicProtein("ac1", "one", 0);
            basicProtein3.addProteinDomain(basicDomain);
            basicProtein3.addProteinDomain(basicDomain3);
            BasicProtein basicProtein4 = new BasicProtein("efgh1", "one", 0);
            basicProtein4.addProteinDomain(basicDomain5);
            basicProtein4.addProteinDomain(basicDomain6);
            basicProtein4.addProteinDomain(basicDomain7);
            basicProtein4.addProteinDomain(basicDomain8);
            BasicProtein basicProtein5 = new BasicProtein("lm1", "one", 0);
            basicProtein5.addProteinDomain(basicDomain11);
            basicProtein5.addProteinDomain(basicDomain12);
            BasicProtein basicProtein6 = new BasicProtein("ab2", "two", 0);
            basicProtein6.addProteinDomain(basicDomain);
            basicProtein6.addProteinDomain(basicDomain2);
            BasicProtein basicProtein7 = new BasicProtein("ac2", "two", 0);
            basicProtein7.addProteinDomain(basicDomain);
            basicProtein7.addProteinDomain(basicDomain3);
            BasicProtein basicProtein8 = new BasicProtein("efgi2", "two", 0);
            basicProtein8.addProteinDomain(basicDomain5);
            basicProtein8.addProteinDomain(basicDomain6);
            basicProtein8.addProteinDomain(basicDomain7);
            basicProtein8.addProteinDomain(basicDomain9);
            BasicProtein basicProtein9 = new BasicProtein("no2", "two", 0);
            basicProtein9.addProteinDomain(basicDomain13);
            basicProtein9.addProteinDomain(basicDomain14);
            BasicProtein basicProtein10 = new BasicProtein("ab3", "three", 0);
            basicProtein10.addProteinDomain(basicDomain);
            basicProtein10.addProteinDomain(basicDomain2);
            BasicProtein basicProtein11 = new BasicProtein("ad3", "three", 0);
            basicProtein11.addProteinDomain(basicDomain);
            basicProtein11.addProteinDomain(basicDomain4);
            BasicProtein basicProtein12 = new BasicProtein("efgj3", "three", 0);
            basicProtein12.addProteinDomain(basicDomain5);
            basicProtein12.addProteinDomain(basicDomain6);
            basicProtein12.addProteinDomain(basicDomain7);
            basicProtein12.addProteinDomain(basicDomain10);
            BasicProtein basicProtein13 = new BasicProtein("pq3", "three", 0);
            basicProtein13.addProteinDomain(basicDomain15);
            basicProtein13.addProteinDomain(basicDomain16);
            BasicProtein basicProtein14 = new BasicProtein("ab4", "four", 0);
            basicProtein14.addProteinDomain(basicDomain);
            basicProtein14.addProteinDomain(basicDomain2);
            BasicProtein basicProtein15 = new BasicProtein("ad4", "four", 0);
            basicProtein15.addProteinDomain(basicDomain);
            basicProtein15.addProteinDomain(basicDomain4);
            BasicProtein basicProtein16 = new BasicProtein("pr4", "four", 0);
            basicProtein16.addProteinDomain(basicDomain15);
            basicProtein16.addProteinDomain(basicDomain17);
            ArrayList<Protein> arrayList = new ArrayList<Protein>();
            arrayList.add(basicProtein);
            arrayList.add(basicProtein2);
            arrayList.add(basicProtein3);
            arrayList.add(basicProtein4);
            arrayList.add(basicProtein5);
            ArrayList<Protein> arrayList2 = new ArrayList<Protein>();
            arrayList2.add(basicProtein6);
            arrayList2.add(basicProtein7);
            arrayList2.add(basicProtein8);
            arrayList2.add(basicProtein9);
            ArrayList<Protein> arrayList3 = new ArrayList<Protein>();
            arrayList3.add(basicProtein10);
            arrayList3.add(basicProtein11);
            arrayList3.add(basicProtein12);
            arrayList3.add(basicProtein13);
            ArrayList<Protein> arrayList4 = new ArrayList<Protein>();
            arrayList4.add(basicProtein14);
            arrayList4.add(basicProtein15);
            arrayList4.add(basicProtein16);
            BasicGenomeWideCombinableDomains basicGenomeWideCombinableDomains = BasicGenomeWideCombinableDomains.createInstance(arrayList, false, new BasicSpecies("one"));
            BasicGenomeWideCombinableDomains basicGenomeWideCombinableDomains2 = BasicGenomeWideCombinableDomains.createInstance(arrayList2, false, new BasicSpecies("two"));
            BasicGenomeWideCombinableDomains basicGenomeWideCombinableDomains3 = BasicGenomeWideCombinableDomains.createInstance(arrayList3, false, new BasicSpecies("three"));
            BasicGenomeWideCombinableDomains basicGenomeWideCombinableDomains4 = BasicGenomeWideCombinableDomains.createInstance(arrayList4, false, new BasicSpecies("four"));
            ArrayList<GenomeWideCombinableDomains> arrayList5 = new ArrayList<GenomeWideCombinableDomains>();
            arrayList5.add(basicGenomeWideCombinableDomains);
            arrayList5.add(basicGenomeWideCombinableDomains2);
            arrayList5.add(basicGenomeWideCombinableDomains3);
            arrayList5.add(basicGenomeWideCombinableDomains4);
            CharacterStateMatrix<CharacterStateMatrix.BinaryStates> characterStateMatrix = DomainParsimonyCalculator.createMatrixOfDomainPresenceOrAbsence(arrayList5);
            CharacterStateMatrix<CharacterStateMatrix.BinaryStates> characterStateMatrix2 = DomainParsimonyCalculator.createMatrixOfBinaryDomainCombinationPresenceOrAbsence(arrayList5);
            if (characterStateMatrix.getState(0, 0) != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState(0, 1) != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState(0, 2) != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState(0, 3) != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState(0, 4) != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState(0, 5) != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState(0, 6) != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState(0, 7) != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState(0, 8) != binaryStates2) {
                return false;
            }
            if (characterStateMatrix2.getState(0, 0) != binaryStates) {
                return false;
            }
            if (characterStateMatrix2.getState(0, 1) != binaryStates) {
                return false;
            }
            if (characterStateMatrix2.getState(0, 2) != binaryStates) {
                return false;
            }
            if (characterStateMatrix2.getState(0, 3) != binaryStates2) {
                return false;
            }
            if (characterStateMatrix2.getState(0, 4) != binaryStates) {
                return false;
            }
            if (characterStateMatrix2.getState(1, 0) != binaryStates2) {
                return false;
            }
            if (characterStateMatrix2.getState(1, 1) != binaryStates) {
                return false;
            }
            if (characterStateMatrix2.getState(1, 2) != binaryStates) {
                return false;
            }
            if (characterStateMatrix2.getState(1, 3) != binaryStates2) {
                return false;
            }
            if (characterStateMatrix2.getState(1, 4) != binaryStates) {
                return false;
            }
            if (characterStateMatrix2.getState(2, 0) != binaryStates2) {
                return false;
            }
            if (characterStateMatrix2.getState(2, 1) != binaryStates) {
                return false;
            }
            if (characterStateMatrix2.getState(2, 2) != binaryStates2) {
                return false;
            }
            if (characterStateMatrix2.getState(2, 3) != binaryStates) {
                return false;
            }
            if (characterStateMatrix2.getState(2, 4) != binaryStates) {
                return false;
            }
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phylogeny = phylogenyFactory.create("((one,two)1-2,(three,four)3-4)root", new NHXParser())[0];
            DomainParsimonyCalculator domainParsimonyCalculator = DomainParsimonyCalculator.createInstance(phylogeny, arrayList5);
            domainParsimonyCalculator.executeDolloParsimonyOnDomainPresence();
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix3 = domainParsimonyCalculator.getGainLossMatrix();
            CharacterStateMatrix<CharacterStateMatrix.BinaryStates> characterStateMatrix4 = domainParsimonyCalculator.getInternalStatesMatrix();
            domainParsimonyCalculator.executeDolloParsimonyOnBinaryDomainCombintionPresence();
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix5 = domainParsimonyCalculator.getGainLossMatrix();
            CharacterStateMatrix<CharacterStateMatrix.BinaryStates> characterStateMatrix6 = domainParsimonyCalculator.getInternalStatesMatrix();
            if (characterStateMatrix4.getState("root", "A") != binaryStates) {
                return false;
            }
            if (characterStateMatrix4.getState("root", "B") != binaryStates) {
                return false;
            }
            if (characterStateMatrix4.getState("root", "C") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix4.getState("root", "D") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix4.getState("root", "E") != binaryStates) {
                return false;
            }
            if (characterStateMatrix6.getState("root", "A=A") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix6.getState("root", "A=B") != binaryStates) {
                return false;
            }
            if (characterStateMatrix6.getState("root", "A=C") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix6.getState("root", "A=D") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix6.getState("root", "G=H") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix6.getState("1-2", "G=H") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix6.getState("root", "E=F") != binaryStates) {
                return false;
            }
            if (characterStateMatrix5.getState("root", "E=F") != gainLossStates4) {
                return false;
            }
            if (characterStateMatrix5.getState("root", "A=A") != gainLossStates3) {
                return false;
            }
            if (characterStateMatrix5.getState("one", "A=A") != gainLossStates) {
                return false;
            }
            if (characterStateMatrix5.getState("root", "A=B") != gainLossStates4) {
                return false;
            }
            if (characterStateMatrix5.getState("3-4", "A=D") != gainLossStates) {
                return false;
            }
            if (characterStateMatrix5.getState("four", "E=F") != gainLossStates2) {
                return false;
            }
            if (characterStateMatrix3.getState("3-4", "P") != gainLossStates) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testParsimonyOnSecondaryFeatures() {
        try {
            CharacterStateMatrix.BinaryStates binaryStates = CharacterStateMatrix.BinaryStates.PRESENT;
            CharacterStateMatrix.BinaryStates binaryStates2 = CharacterStateMatrix.BinaryStates.ABSENT;
            CharacterStateMatrix.GainLossStates gainLossStates = CharacterStateMatrix.GainLossStates.GAIN;
            CharacterStateMatrix.GainLossStates gainLossStates2 = CharacterStateMatrix.GainLossStates.LOSS;
            CharacterStateMatrix.GainLossStates gainLossStates3 = CharacterStateMatrix.GainLossStates.UNCHANGED_ABSENT;
            CharacterStateMatrix.GainLossStates gainLossStates4 = CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT;
            BasicDomain basicDomain = new BasicDomain("A", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain2 = new BasicDomain("B", 2, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain3 = new BasicDomain("C", 3, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain4 = new BasicDomain("D", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain5 = new BasicDomain("E", 2, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain6 = new BasicDomain("F", 3, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain7 = new BasicDomain("G", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain8 = new BasicDomain("H", 2, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain9 = new BasicDomain("I", 3, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain10 = new BasicDomain("J", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain11 = new BasicDomain("L", 3, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain12 = new BasicDomain("M", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain13 = new BasicDomain("N", 2, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain14 = new BasicDomain("O", 3, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain15 = new BasicDomain("P", 1, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain16 = new BasicDomain("Q", 2, 25, 1, 4, 0.1, -12.0);
            BasicDomain basicDomain17 = new BasicDomain("R", 3, 25, 1, 4, 0.1, -12.0);
            BasicProtein basicProtein = new BasicProtein("aa1", "one", 0);
            basicProtein.addProteinDomain(basicDomain);
            basicProtein.addProteinDomain(basicDomain);
            BasicProtein basicProtein2 = new BasicProtein("ab1", "one", 0);
            basicProtein2.addProteinDomain(basicDomain);
            basicProtein2.addProteinDomain(basicDomain2);
            BasicProtein basicProtein3 = new BasicProtein("ac1", "one", 0);
            basicProtein3.addProteinDomain(basicDomain);
            basicProtein3.addProteinDomain(basicDomain3);
            BasicProtein basicProtein4 = new BasicProtein("efgh1", "one", 0);
            basicProtein4.addProteinDomain(basicDomain5);
            basicProtein4.addProteinDomain(basicDomain6);
            basicProtein4.addProteinDomain(basicDomain7);
            basicProtein4.addProteinDomain(basicDomain8);
            BasicProtein basicProtein5 = new BasicProtein("lm1", "one", 0);
            basicProtein5.addProteinDomain(basicDomain11);
            basicProtein5.addProteinDomain(basicDomain12);
            BasicProtein basicProtein6 = new BasicProtein("ab2", "two", 0);
            basicProtein6.addProteinDomain(basicDomain);
            basicProtein6.addProteinDomain(basicDomain2);
            BasicProtein basicProtein7 = new BasicProtein("ac2", "two", 0);
            basicProtein7.addProteinDomain(basicDomain);
            basicProtein7.addProteinDomain(basicDomain3);
            BasicProtein basicProtein8 = new BasicProtein("efgi2", "two", 0);
            basicProtein8.addProteinDomain(basicDomain5);
            basicProtein8.addProteinDomain(basicDomain6);
            basicProtein8.addProteinDomain(basicDomain7);
            basicProtein8.addProteinDomain(basicDomain9);
            BasicProtein basicProtein9 = new BasicProtein("no2", "two", 0);
            basicProtein9.addProteinDomain(basicDomain13);
            basicProtein9.addProteinDomain(basicDomain14);
            BasicProtein basicProtein10 = new BasicProtein("ab3", "three", 0);
            basicProtein10.addProteinDomain(basicDomain);
            basicProtein10.addProteinDomain(basicDomain2);
            BasicProtein basicProtein11 = new BasicProtein("ad3", "three", 0);
            basicProtein11.addProteinDomain(basicDomain);
            basicProtein11.addProteinDomain(basicDomain4);
            BasicProtein basicProtein12 = new BasicProtein("efgj3", "three", 0);
            basicProtein12.addProteinDomain(basicDomain5);
            basicProtein12.addProteinDomain(basicDomain6);
            basicProtein12.addProteinDomain(basicDomain7);
            basicProtein12.addProteinDomain(basicDomain10);
            BasicProtein basicProtein13 = new BasicProtein("pq3", "three", 0);
            basicProtein13.addProteinDomain(basicDomain15);
            basicProtein13.addProteinDomain(basicDomain16);
            BasicProtein basicProtein14 = new BasicProtein("ab4", "four", 0);
            basicProtein14.addProteinDomain(basicDomain);
            basicProtein14.addProteinDomain(basicDomain2);
            BasicProtein basicProtein15 = new BasicProtein("ad4", "four", 0);
            basicProtein15.addProteinDomain(basicDomain);
            basicProtein15.addProteinDomain(basicDomain4);
            BasicProtein basicProtein16 = new BasicProtein("pr4", "four", 0);
            basicProtein16.addProteinDomain(basicDomain15);
            basicProtein16.addProteinDomain(basicDomain17);
            ArrayList<Protein> arrayList = new ArrayList<Protein>();
            arrayList.add(basicProtein);
            arrayList.add(basicProtein2);
            arrayList.add(basicProtein3);
            arrayList.add(basicProtein4);
            arrayList.add(basicProtein5);
            ArrayList<Protein> arrayList2 = new ArrayList<Protein>();
            arrayList2.add(basicProtein6);
            arrayList2.add(basicProtein7);
            arrayList2.add(basicProtein8);
            arrayList2.add(basicProtein9);
            ArrayList<Protein> arrayList3 = new ArrayList<Protein>();
            arrayList3.add(basicProtein10);
            arrayList3.add(basicProtein11);
            arrayList3.add(basicProtein12);
            arrayList3.add(basicProtein13);
            ArrayList<Protein> arrayList4 = new ArrayList<Protein>();
            arrayList4.add(basicProtein14);
            arrayList4.add(basicProtein15);
            arrayList4.add(basicProtein16);
            BasicGenomeWideCombinableDomains basicGenomeWideCombinableDomains = BasicGenomeWideCombinableDomains.createInstance(arrayList, false, new BasicSpecies("one"));
            BasicGenomeWideCombinableDomains basicGenomeWideCombinableDomains2 = BasicGenomeWideCombinableDomains.createInstance(arrayList2, false, new BasicSpecies("two"));
            BasicGenomeWideCombinableDomains basicGenomeWideCombinableDomains3 = BasicGenomeWideCombinableDomains.createInstance(arrayList3, false, new BasicSpecies("three"));
            BasicGenomeWideCombinableDomains basicGenomeWideCombinableDomains4 = BasicGenomeWideCombinableDomains.createInstance(arrayList4, false, new BasicSpecies("four"));
            ArrayList<GenomeWideCombinableDomains> arrayList5 = new ArrayList<GenomeWideCombinableDomains>();
            arrayList5.add(basicGenomeWideCombinableDomains);
            arrayList5.add(basicGenomeWideCombinableDomains2);
            arrayList5.add(basicGenomeWideCombinableDomains3);
            arrayList5.add(basicGenomeWideCombinableDomains4);
            HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("AAA");
            HashSet<String> hashSet2 = new HashSet<String>();
            hashSet2.add("BBB");
            HashSet<String> hashSet3 = new HashSet<String>();
            hashSet3.add("CCC");
            HashSet<String> hashSet4 = new HashSet<String>();
            hashSet4.add("DDD");
            HashSet<String> hashSet5 = new HashSet<String>();
            hashSet5.add("EEE");
            HashSet<String> hashSet6 = new HashSet<String>();
            hashSet6.add("FFF");
            HashSet<String> hashSet7 = new HashSet<String>();
            hashSet7.add("GGG");
            HashSet<String> hashSet8 = new HashSet<String>();
            hashSet8.add("HHH");
            HashSet<String> hashSet9 = new HashSet<String>();
            hashSet9.add("III");
            HashSet<String> hashSet10 = new HashSet<String>();
            hashSet10.add("JJJ");
            HashSet<String> hashSet11 = new HashSet<String>();
            hashSet11.add("LLL");
            HashSet<String> hashSet12 = new HashSet<String>();
            hashSet12.add("MMM");
            HashSet<String> hashSet13 = new HashSet<String>();
            hashSet13.add("NNN");
            HashSet<String> hashSet14 = new HashSet<String>();
            hashSet14.add("OOO");
            HashSet<String> hashSet15 = new HashSet<String>();
            hashSet15.add("PPP");
            HashSet<String> hashSet16 = new HashSet<String>();
            hashSet16.add("QQQ");
            HashSet<String> hashSet17 = new HashSet<String>();
            hashSet17.add("RRR");
            hashMap.put(basicDomain.getDomainId(), hashSet);
            hashMap.put(basicDomain2.getDomainId(), hashSet2);
            hashMap.put(basicDomain3.getDomainId(), hashSet3);
            hashMap.put(basicDomain4.getDomainId(), hashSet4);
            hashMap.put(basicDomain5.getDomainId(), hashSet5);
            hashMap.put(basicDomain6.getDomainId(), hashSet6);
            hashMap.put(basicDomain7.getDomainId(), hashSet7);
            hashMap.put(basicDomain8.getDomainId(), hashSet8);
            hashMap.put(basicDomain9.getDomainId(), hashSet9);
            hashMap.put(basicDomain10.getDomainId(), hashSet10);
            hashMap.put(basicDomain11.getDomainId(), hashSet11);
            hashMap.put(basicDomain12.getDomainId(), hashSet12);
            hashMap.put(basicDomain13.getDomainId(), hashSet13);
            hashMap.put(basicDomain14.getDomainId(), hashSet14);
            hashMap.put(basicDomain15.getDomainId(), hashSet15);
            hashMap.put(basicDomain16.getDomainId(), hashSet16);
            hashMap.put(basicDomain17.getDomainId(), hashSet17);
            CharacterStateMatrix<CharacterStateMatrix.BinaryStates> characterStateMatrix = DomainParsimonyCalculator.createMatrixOfSecondaryFeaturePresenceOrAbsence(arrayList5, hashMap, null);
            if (characterStateMatrix.getState(0, 0) != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState(0, 1) != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState(0, 2) != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState(0, 3) != binaryStates2) {
                return false;
            }
            if (characterStateMatrix.getState(0, 4) != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState(0, 5) != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState(0, 6) != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState(0, 7) != binaryStates) {
                return false;
            }
            if (characterStateMatrix.getState(0, 8) != binaryStates2) {
                return false;
            }
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phylogeny = phylogenyFactory.create("((one,two)1-2,(three,four)3-4)root", new NHXParser())[0];
            DomainParsimonyCalculator domainParsimonyCalculator = DomainParsimonyCalculator.createInstance(phylogeny, arrayList5, hashMap);
            domainParsimonyCalculator.executeDolloParsimonyOnSecondaryFeatures(null);
            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix2 = domainParsimonyCalculator.getGainLossMatrix();
            CharacterStateMatrix<CharacterStateMatrix.BinaryStates> characterStateMatrix3 = domainParsimonyCalculator.getInternalStatesMatrix();
            if (characterStateMatrix3.getState("root", "AAA") != binaryStates) {
                return false;
            }
            if (characterStateMatrix3.getState("root", "BBB") != binaryStates) {
                return false;
            }
            if (characterStateMatrix3.getState("root", "CCC") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix3.getState("root", "DDD") != binaryStates2) {
                return false;
            }
            if (characterStateMatrix3.getState("root", "EEE") != binaryStates) {
                return false;
            }
            if (characterStateMatrix2.getState("3-4", "PPP") != gainLossStates) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }
}

