/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.phylogeny.data.Accession;
import org.forester.surfacing.DomainSimilarityCalculator;
import org.forester.util.ForesterUtil;
import org.forester.util.SequenceAccessionTools;

class PrintableSpeciesSpecificDcData {
    final SortedMap<String, Integer> _combinable_domain_id_to_count_map;
    final SortedSet<String> _key_domain_proteins = new TreeSet<String>();
    private final int _combinable_domains_count;
    private final int _key_domain_domains_count;

    public PrintableSpeciesSpecificDcData(int n, int n2) {
        this._key_domain_domains_count = n;
        this._combinable_domains_count = n2;
        this._combinable_domain_id_to_count_map = new TreeMap<String, Integer>();
    }

    public void addKeyDomainProtein(String string) {
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("attempt to add null or empty protein");
        }
        if (this.getKeyDomainProteins().contains(string)) {
            throw new IllegalArgumentException("protein \"" + string + "\" is not unique");
        }
        this.getKeyDomainProteins().add(string);
    }

    public void addProteinsExhibitingCombinationCount(String string, int n) {
        if (this.getCombinableDomainIdToCountsMap().containsKey(string)) {
            throw new IllegalArgumentException("Domain with id " + string + " already exists");
        }
        this.getCombinableDomainIdToCountsMap().put(string, n);
    }

    public SortedMap<String, Integer> getCombinableDomainIdToCountsMap() {
        return this._combinable_domain_id_to_count_map;
    }

    public SortedSet<String> getKeyDomainProteins() {
        return this._key_domain_proteins;
    }

    public int getNumberOfProteinsExhibitingCombinationWith(String string) {
        if (!this.getCombinableDomainIdToCountsMap().containsKey(string)) {
            throw new IllegalArgumentException("Domain with id " + string + " not found");
        }
        return (Integer)this.getCombinableDomainIdToCountsMap().get(string);
    }

    public String toString() {
        return this.toStringBuffer(DomainSimilarityCalculator.Detailedness.LIST_COMBINING_DOMAIN_FOR_EACH_SPECIES, false).toString();
    }

    public StringBuffer toStringBuffer(DomainSimilarityCalculator.Detailedness detailedness, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (detailedness == DomainSimilarityCalculator.Detailedness.PUNCTILIOUS) {
            if (bl) {
                stringBuffer.append("<td>");
            }
            stringBuffer.append(this.getKeyDomainDomainsCount());
            if (bl) {
                stringBuffer.append("</td><td>");
            } else {
                stringBuffer.append("\t");
            }
            stringBuffer.append(this.getKeyDomainProteinsCount());
            if (bl) {
                stringBuffer.append("</td><td>");
            } else {
                stringBuffer.append("\t");
            }
            stringBuffer.append(this.getCombinableDomainsCount());
            if (bl) {
                stringBuffer.append("</td><td>");
            }
        }
        if (bl) {
            Set<String> set = this.getCombinableDomainIdToCountsMap().keySet();
            for (String object : set) {
                stringBuffer.append(" ");
                if (bl) {
                    stringBuffer.append("<a href=\"http://pfam.xfam.org/family/" + object + "\">" + object + "</a>");
                } else {
                    stringBuffer.append(object);
                }
                if (detailedness != DomainSimilarityCalculator.Detailedness.PUNCTILIOUS) continue;
                stringBuffer.append(":");
                stringBuffer.append(this.getCombinableDomainIdToCountsMap().get(object));
            }
            stringBuffer.append(" [");
            boolean bl2 = true;
            for (String string : this.getKeyDomainProteins()) {
                String string2 = PrintableSpeciesSpecificDcData.obtainSeqLink(string);
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string2);
            }
            stringBuffer.append("]");
            stringBuffer.append("</td>");
        }
        return stringBuffer;
    }

    public StringBuffer getSeqIdsTabSeparated() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (String string : this.getKeyDomainProteins()) {
            String string2 = PrintableSpeciesSpecificDcData.obtainSeqId(string);
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("\t");
            }
            stringBuffer.append(string2);
        }
        return stringBuffer;
    }

    private int getCombinableDomainsCount() {
        return this._combinable_domains_count;
    }

    private int getKeyDomainDomainsCount() {
        return this._key_domain_domains_count;
    }

    private int getKeyDomainProteinsCount() {
        return this._key_domain_proteins.size();
    }

    private static String obtainSeqId(String string) {
        String string2 = "";
        Accession accession = SequenceAccessionTools.parseAccessorFromString(string);
        string2 = accession == null ? string : accession.getValue();
        return string2;
    }

    private static String obtainSeqLink(String string) {
        Accession accession = SequenceAccessionTools.parseAccessorFromString(string);
        if (accession != null) {
            if (accession.getSource().equals(Accession.Source.UNIPROT.toString())) {
                return "<a class=\"pl\" href=\"https://www.uniprot.org/uniprot/" + accession.getValue() + "\" target=\"_up_window\">" + accession.getValue() + "</a>";
            }
            if (accession.getSource().equals(Accession.Source.NCBI.toString())) {
                return "<a class=\"pl\" href=\"https://www.ncbi.nlm.nih.gov/protein/" + accession.getValue() + "\" target=\"_up_window\">" + accession.getValue() + "</a>";
            }
            if (accession.getSource().equals(Accession.Source.REFSEQ.toString())) {
                return "<a class=\"pl\" href=\"https://www.ncbi.nlm.nih.gov/nuccore/" + accession.getValue() + "\" target=\"_up_window\">" + accession.getValue() + "</a>";
            }
        }
        return "<a class=\"ps\" href=\"http://www.google.com/search?q=" + string + "\" target=\"_g_window\">" + string + "</a>";
    }
}

