/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyBranch;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.sdi.GSDIR;
import org.forester.sdi.SDI;
import org.forester.sdi.SDIException;

public class SDIR {
    private static final double ZERO_DIFF = 1.0E-6;
    private int _count;
    private int _min_dup;
    private int _min_cost;
    private double _min_height;
    private double _min_diff;
    private long _time_sdi;

    public SDIR() {
        this.init();
    }

    public int getCount() {
        return this._count;
    }

    public double getMinimalDiffInSubTreeHeights() {
        return this._min_diff;
    }

    public int getMinimalDuplications() {
        return this._min_dup;
    }

    public int getMinimalMappingCost() {
        return this._min_cost;
    }

    public double getMinimalTreeHeight() {
        return this._min_height;
    }

    public long getTimeSumSDI() {
        return this._time_sdi;
    }

    public Phylogeny[] infer(Phylogeny phylogeny, Phylogeny phylogeny2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n) throws SDIException {
        Object object;
        this.init();
        SDI sDI = null;
        ArrayList<Phylogeny> arrayList = new ArrayList<Phylogeny>();
        Phylogeny[] phylogenyArray = null;
        List<PhylogenyBranch> list = null;
        Phylogeny phylogeny3 = null;
        PhylogenyNode phylogenyNode = null;
        PhylogenyNode phylogenyNode2 = null;
        PhylogenyNode phylogenyNode3 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MAX_VALUE;
        int n7 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = Double.MAX_VALUE;
        double d4 = 0.0;
        double[] dArray = new double[2];
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        if (n < 1) {
            n = 1;
        }
        if (bl && bl2) {
            bl2 = false;
        }
        if (!(bl || bl2 || bl3)) {
            throw new IllegalArgumentException("parameter to minimize not given for rooting of phylogeny");
        }
        phylogeny3 = phylogeny.copy();
        if (phylogeny3.getNumberOfExternalNodes() <= 1) {
            phylogeny3.setRooted(true);
            this.setMinimalDuplications(0);
            this.setMinimalTreeHeight(0.0);
            phylogenyArray = new Phylogeny[]{phylogeny3};
            return phylogenyArray;
        }
        Object object2 = phylogeny3.iteratorPostorder();
        while (object2.hasNext()) {
            object = object2.next();
            if (((PhylogenyNode)object).isRoot()) {
                if (((PhylogenyNode)object).getNumberOfDescendants() == 2 || ((PhylogenyNode)object).getNumberOfDescendants() == 3) continue;
                throw new SDIException("gene tree has " + ((PhylogenyNode)object).getNumberOfDescendants() + " descendents at its root");
            }
            if (((PhylogenyNode)object).isExternal() || ((PhylogenyNode)object).getNumberOfDescendants() == 2) continue;
            throw new SDIException("gene tree is not completely binary");
        }
        object2 = phylogeny2.iteratorPostorder();
        while (object2.hasNext()) {
            object = object2.next();
            if (((PhylogenyNode)object).isExternal() || ((PhylogenyNode)object).getNumberOfDescendants() == 2) continue;
            throw new SDIException("species tree (after stripping) is not completely binary");
        }
        phylogeny3.reRoot(phylogeny3.getFirstExternalNode());
        list = SDIR.getBranchesInPreorder(phylogeny3);
        if (bl || bl2) {
            sDI = new SDI(phylogeny3, phylogeny2);
            n2 = sDI.getDuplicationsSum();
        }
        object2 = new HashSet();
        for (n7 = 0; n7 < list.size(); ++n7) {
            block43: {
                block45: {
                    block46: {
                        block47: {
                            block48: {
                                block49: {
                                    block44: {
                                        phylogenyNode = phylogeny3.getRoot();
                                        phylogenyNode2 = phylogenyNode.getChildNode1();
                                        phylogenyNode3 = phylogenyNode.getChildNode2();
                                        bl7 = phylogenyNode.isDuplication();
                                        object = list.get(n7);
                                        GSDIR.reRoot((PhylogenyBranch)object, phylogeny3);
                                        if (bl || bl2) {
                                            n2 = sDI.updateM(bl7, phylogenyNode2, phylogenyNode3);
                                        }
                                        if (object2.contains(object)) break block43;
                                        if (!bl) break block44;
                                        n3 = sDI.computeMappingCostL();
                                        if (bl3 && n3 <= n6) {
                                            dArray = SDIR.moveRootOnBranchToMinHeight(phylogeny3);
                                            d = dArray[0];
                                            d2 = dArray[1];
                                        }
                                        if (n3 == n6) {
                                            if (bl3) {
                                                bl6 = false;
                                                bl5 = false;
                                                if (d < d3) {
                                                    d3 = d;
                                                    n4 = 1;
                                                    bl5 = true;
                                                } else if (d == d3) {
                                                    ++n4;
                                                    bl6 = true;
                                                }
                                                if (Math.abs(d2) < d4) {
                                                    d4 = Math.abs(d2);
                                                }
                                            }
                                            if (bl4) {
                                                if (bl3) {
                                                    if (bl5) {
                                                        arrayList.clear();
                                                        arrayList.add(phylogeny3.copy());
                                                    } else if (bl6 && arrayList.size() < n) {
                                                        arrayList.add(phylogeny3.copy());
                                                    }
                                                } else {
                                                    ++n4;
                                                    if (arrayList.size() < n) {
                                                        arrayList.add(phylogeny3.copy());
                                                    }
                                                }
                                            } else if (!bl3) {
                                                ++n4;
                                            }
                                        } else if (n3 < n6) {
                                            if (bl3) {
                                                d3 = d;
                                                d4 = Math.abs(d2);
                                            }
                                            if (bl4) {
                                                arrayList.clear();
                                                arrayList.add(phylogeny3.copy());
                                            }
                                            n4 = 1;
                                            n6 = n3;
                                        }
                                        if (n2 < n5) {
                                            n5 = n2;
                                        }
                                        break block43;
                                    }
                                    if (!bl2) break block45;
                                    if (bl3 && n2 <= n5) {
                                        dArray = SDIR.moveRootOnBranchToMinHeight(phylogeny3);
                                        d = dArray[0];
                                        d2 = dArray[1];
                                    }
                                    if (n2 != n5) break block46;
                                    if (bl3) {
                                        bl6 = false;
                                        bl5 = false;
                                        if (d < d3) {
                                            d3 = d;
                                            n4 = 1;
                                            bl5 = true;
                                        } else if (d == d3) {
                                            ++n4;
                                            bl6 = true;
                                        }
                                        if (Math.abs(d2) < d4) {
                                            d4 = Math.abs(d2);
                                        }
                                    }
                                    if (!bl4) break block47;
                                    if (!bl3) break block48;
                                    if (!bl5) break block49;
                                    arrayList.clear();
                                    arrayList.add(phylogeny3.copy());
                                    break block43;
                                }
                                if (!bl6 || arrayList.size() >= n) break block43;
                                arrayList.add(phylogeny3.copy());
                                break block43;
                            }
                            ++n4;
                            if (arrayList.size() >= n) break block43;
                            arrayList.add(phylogeny3.copy());
                            break block43;
                        }
                        if (bl3) break block43;
                        ++n4;
                        break block43;
                    }
                    if (n2 >= n5) break block43;
                    if (bl3) {
                        d3 = d;
                        d4 = Math.abs(d2);
                    }
                    if (bl4) {
                        arrayList.clear();
                        arrayList.add(phylogeny3.copy());
                    }
                    n4 = 1;
                    n5 = n2;
                    break block43;
                }
                if (bl3) {
                    dArray = SDIR.moveRootOnBranchToMinHeight(phylogeny3);
                    d = dArray[0];
                    d2 = dArray[1];
                    if (Math.abs(d2) < 1.0E-6) {
                        sDI = new SDI(phylogeny3, phylogeny2);
                        n5 = sDI.getDuplicationsSum();
                        d3 = d;
                        d4 = Math.abs(d2);
                        n4 = 1;
                        if (!bl4) break;
                        arrayList.add(phylogeny3.copy());
                        break;
                    }
                }
            }
            object2.add(object);
        }
        if (bl4) {
            arrayList.trimToSize();
            phylogenyArray = new Phylogeny[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                phylogenyArray[i] = (Phylogeny)arrayList.get(i);
                phylogenyArray[i].recalculateNumberOfExternalDescendants(false);
            }
        }
        this.setCount(n4);
        this.setMinimalDuplications(n5);
        this.setMinimalMappingCost(n6);
        this.setMinimalTreeHeight(d3);
        this.setMinimalDiffInSubTreeHeights(Math.abs(d4));
        return phylogenyArray;
    }

    private void init() {
        this._count = -1;
        this._min_dup = Integer.MAX_VALUE;
        this._min_cost = Integer.MAX_VALUE;
        this._min_height = Double.MAX_VALUE;
        this._min_diff = Double.MAX_VALUE;
        this._time_sdi = -1L;
    }

    private void setCount(int n) {
        this._count = n;
    }

    private void setMinimalDiffInSubTreeHeights(double d) {
        this._min_diff = d;
    }

    private void setMinimalDuplications(int n) {
        this._min_dup = n;
    }

    private void setMinimalMappingCost(int n) {
        this._min_cost = n;
    }

    private void setMinimalTreeHeight(double d) {
        this._min_height = d;
    }

    public static List<PhylogenyBranch> getBranchesInPreorder(Phylogeny phylogeny) {
        ArrayList<PhylogenyBranch> arrayList = new ArrayList<PhylogenyBranch>();
        if (phylogeny.isEmpty() || phylogeny.getNumberOfExternalNodes() <= 1) {
            return arrayList;
        }
        if (phylogeny.getNumberOfExternalNodes() == 2) {
            arrayList.add(new PhylogenyBranch(phylogeny.getRoot().getChildNode1(), phylogeny.getRoot().getChildNode2()));
            return arrayList;
        }
        HashSet<Long> hashSet = new HashSet<Long>();
        HashSet<Long> hashSet2 = new HashSet<Long>();
        PhylogenyNode phylogenyNode = phylogeny.getRoot();
        while (!phylogenyNode.isRoot() || !hashSet2.contains(phylogenyNode.getId())) {
            if (!phylogenyNode.isExternal() && !hashSet2.contains(phylogenyNode.getId())) {
                if (!hashSet.contains(phylogenyNode.getId()) && !hashSet2.contains(phylogenyNode.getId())) {
                    hashSet.add(phylogenyNode.getId());
                    phylogenyNode = phylogenyNode.getChildNode1();
                } else {
                    hashSet2.add(phylogenyNode.getId());
                    phylogenyNode = phylogenyNode.getChildNode2();
                }
                if (!phylogenyNode.getParent().isRoot()) {
                    arrayList.add(new PhylogenyBranch(phylogenyNode, phylogenyNode.getParent()));
                    continue;
                }
                if (phylogenyNode.isExternal()) continue;
                arrayList.add(new PhylogenyBranch(phylogeny.getRoot().getChildNode1(), phylogeny.getRoot().getChildNode2()));
                continue;
            }
            if (!phylogenyNode.getParent().isRoot() && !phylogenyNode.isExternal()) {
                arrayList.add(new PhylogenyBranch(phylogenyNode, phylogenyNode.getParent()));
            }
            phylogenyNode = phylogenyNode.getParent();
        }
        return arrayList;
    }

    private static double[] moveRootOnBranchToMinHeight(Phylogeny phylogeny) {
        PhylogenyNode phylogenyNode = phylogeny.getRoot();
        if (phylogenyNode.getNumberOfDescendants() != 2) {
            throw new IllegalArgumentException("attempt to move root to minimize height on root where number of child nodes does not equal two");
        }
        PhylogenyNode phylogenyNode2 = phylogenyNode.getChildNode(0);
        PhylogenyNode phylogenyNode3 = phylogenyNode.getChildNode(1);
        double d = 0.5 * ((phylogenyNode2.getDistanceToParent() > 0.0 ? phylogenyNode2.getDistanceToParent() : 0.0) + (phylogenyNode3.getDistanceToParent() > 0.0 ? phylogenyNode3.getDistanceToParent() : 0.0));
        phylogenyNode2.setDistanceToParent(d);
        phylogenyNode3.setDistanceToParent(d);
        double d2 = phylogenyNode2.getDistanceToParent();
        double d3 = 0.0;
        double d4 = 0.0;
        double[] dArray = new double[2];
        double d5 = phylogeny.calculateSubtreeHeight(phylogeny.getRoot().getChildNode(0), false);
        double d6 = phylogeny.calculateSubtreeHeight(phylogeny.getRoot().getChildNode(1), false);
        d3 = d5 - d6;
        d4 = phylogeny.calculateHeight(false);
        if (d2 > 0.0) {
            if (2.0 * d2 > Math.abs(d3)) {
                phylogenyNode2.setDistanceToParent(d2 - d3 / 2.0);
                phylogenyNode3.setDistanceToParent(d2 + d3 / 2.0);
                dArray[0] = d4 - Math.abs(d3 / 2.0);
                dArray[1] = 0.0;
            } else {
                if (d3 > 0.0) {
                    phylogenyNode2.setDistanceToParent(0.0);
                    phylogenyNode3.setDistanceToParent(2.0 * d2);
                    dArray[1] = d3 - 2.0 * d2;
                } else {
                    phylogenyNode2.setDistanceToParent(2.0 * d2);
                    phylogenyNode3.setDistanceToParent(0.0);
                    dArray[1] = d3 + 2.0 * d2;
                }
                dArray[0] = d4 - d2;
            }
        } else {
            dArray[0] = d4;
            dArray[1] = d3;
        }
        return dArray;
    }
}

