/*
 * Decompiled with CFR 0.152.
 */
package org.forester.msa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.msa.BasicMsa;
import org.forester.msa.Msa;
import org.forester.sequence.BasicSequence;
import org.forester.sequence.MolecularSequence;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.DescriptiveStatistics;

public final class MsaMethods {
    private ArrayList<String> _ignored_seqs_ids;

    private MsaMethods() {
        this.init();
    }

    public Object clone() {
        throw new NoSuchMethodError();
    }

    public final synchronized Msa deleteGapColumns(double d, int n, Msa msa) {
        this.init();
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("max allowed gap ration is out of range: " + d);
        }
        boolean bl = n > 0;
        boolean[] blArray = new boolean[msa.getLength()];
        int n2 = 0;
        for (int i = 0; i < msa.getLength(); ++i) {
            boolean bl2 = blArray[i] = (double)MsaMethods.calcGapSumPerColumn(msa, i) / (double)msa.getNumberOfSequences() > d;
            if (blArray[i]) continue;
            ++n2;
        }
        ArrayList<MolecularSequence> arrayList = new ArrayList<MolecularSequence>(msa.getNumberOfSequences());
        for (int i = 0; i < msa.getNumberOfSequences(); ++i) {
            char[] cArray = new char[n2];
            int n3 = 0;
            int n4 = 0;
            for (int j = 0; j < msa.getLength(); ++j) {
                if (blArray[j]) continue;
                char c = msa.getResidueAt(i, j);
                cArray[n3++] = c;
                if (c == '-') continue;
                ++n4;
            }
            if (bl) {
                if (n4 >= n) {
                    arrayList.add(new BasicSequence(msa.getIdentifier(i), cArray, msa.getType()));
                    continue;
                }
                this._ignored_seqs_ids.add(msa.getIdentifier(i).toString());
                continue;
            }
            arrayList.add(new BasicSequence(msa.getIdentifier(i), cArray, msa.getType()));
        }
        if (arrayList.size() < 1) {
            return null;
        }
        return BasicMsa.createInstance(arrayList);
    }

    public synchronized ArrayList<String> getIgnoredSequenceIds() {
        return this._ignored_seqs_ids;
    }

    private synchronized void init() {
        this._ignored_seqs_ids = new ArrayList();
    }

    public static final DescriptiveStatistics calcNumberOfGapsStats(Msa msa) {
        int[] nArray = MsaMethods.calcNumberOfGapsInMsa(msa);
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        for (int n : nArray) {
            basicDescriptiveStatistics.addValue(n);
        }
        return basicDescriptiveStatistics;
    }

    public static final int[] calcNumberOfGapsInMsa(Msa msa) {
        int n = msa.getNumberOfSequences();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = MsaMethods.calcNumberOfGaps(msa.getSequence(i));
        }
        return nArray;
    }

    public static final int calcNumberOfGaps(MolecularSequence molecularSequence) {
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < molecularSequence.getLength(); ++i) {
            if (molecularSequence.isGapAt(i)) {
                if (bl) continue;
                ++n;
                bl = true;
                continue;
            }
            bl = false;
        }
        return n;
    }

    public static DescriptiveStatistics calcBasicGapinessStatistics(Msa msa) {
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        for (int i = 0; i < msa.getLength(); ++i) {
            basicDescriptiveStatistics.addValue((double)MsaMethods.calcGapSumPerColumn(msa, i) / (double)msa.getNumberOfSequences());
        }
        return basicDescriptiveStatistics;
    }

    public static double calcGapRatio(Msa msa) {
        int n = 0;
        for (int i = 0; i < msa.getNumberOfSequences(); ++i) {
            for (int j = 0; j < msa.getLength(); ++j) {
                if (msa.getResidueAt(i, j) != '-') continue;
                ++n;
            }
        }
        return (double)n / (double)(msa.getLength() * msa.getNumberOfSequences());
    }

    public static int calcGapSumPerColumn(Msa msa, int n) {
        int n2 = 0;
        for (int i = 0; i < msa.getNumberOfSequences(); ++i) {
            if (!msa.isGapAt(i, n)) continue;
            ++n2;
        }
        return n2;
    }

    public static final double calcNormalizedShannonsEntropy(int n, Msa msa) {
        double d = 0.0;
        for (int i = 0; i < msa.getLength(); ++i) {
            d += MsaMethods.calcNormalizedShannonsEntropy(n, msa, i);
        }
        return d / (double)msa.getLength();
    }

    public static final double calcNormalizedShannonsEntropy(int n, Msa msa, int n2) {
        double d = 0.0;
        double d2 = msa.getNumberOfSequences();
        HashMap<Character, Integer> hashMap = null;
        if (n == 6) {
            hashMap = MsaMethods.calcResidueDistribution6(msa, n2);
        } else if (n == 7) {
            hashMap = MsaMethods.calcResidueDistribution7(msa, n2);
        } else if (n == 20) {
            hashMap = MsaMethods.calcResidueDistribution20(msa, n2);
        } else if (n == 21) {
            hashMap = MsaMethods.calcResidueDistribution21(msa, n2);
        } else {
            throw new IllegalArgumentException("illegal value for k: " + n);
        }
        if (hashMap.size() == 1) {
            return 0.0;
        }
        for (int n3 : hashMap.values()) {
            double d3 = (double)n3 / d2;
            d += d3 * Math.log(d3);
        }
        if (d2 < (double)n) {
            return -(d / Math.log(d2));
        }
        return -(d / Math.log(n));
    }

    public static final DescriptiveStatistics calculateEffectiveLengthStatistics(Msa msa) {
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        for (int i = 0; i < msa.getNumberOfSequences(); ++i) {
            MolecularSequence molecularSequence = msa.getSequence(i);
            basicDescriptiveStatistics.addValue(molecularSequence.getLength() - molecularSequence.getNumberOfGapResidues());
        }
        return basicDescriptiveStatistics;
    }

    public static final DescriptiveStatistics calculateIdentityRatio(int n, int n2, Msa msa) {
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        for (int i = n; i <= n2; ++i) {
            basicDescriptiveStatistics.addValue(MsaMethods.calculateIdentityRatio(msa, i));
        }
        return basicDescriptiveStatistics;
    }

    public static final double calculateIdentityRatio(Msa msa, int n) {
        SortedMap<Character, Integer> sortedMap = MsaMethods.calculateResidueDestributionPerColumn(msa, n);
        int n2 = 0;
        for (Map.Entry<Character, Integer> entry : sortedMap.entrySet()) {
            if (entry.getValue() <= n2) continue;
            n2 = entry.getValue();
        }
        return (double)n2 / (double)msa.getNumberOfSequences();
    }

    public static SortedMap<Character, Integer> calculateResidueDestributionPerColumn(Msa msa, int n) {
        TreeMap<Character, Integer> treeMap = new TreeMap<Character, Integer>();
        for (Character c : msa.getColumnAt(n)) {
            if (c.charValue() == '-') continue;
            if (!treeMap.containsKey(c)) {
                treeMap.put(c, 1);
                continue;
            }
            treeMap.put(c, (Integer)treeMap.get(c) + 1);
        }
        return treeMap;
    }

    public static synchronized MsaMethods createInstance() {
        return new MsaMethods();
    }

    public static final Msa removeSequence(Msa msa, String string) {
        ArrayList<MolecularSequence> arrayList = new ArrayList<MolecularSequence>();
        for (int i = 0; i < msa.getNumberOfSequences(); ++i) {
            if (string.equals(msa.getIdentifier(i))) continue;
            arrayList.add(msa.getSequence(i));
        }
        if (arrayList.size() < 1) {
            return null;
        }
        return BasicMsa.createInstance(arrayList);
    }

    public static final Msa removeSequences(Msa msa, List<String> list) {
        ArrayList<MolecularSequence> arrayList = new ArrayList<MolecularSequence>();
        for (int i = 0; i < msa.getNumberOfSequences(); ++i) {
            if (list.contains(msa.getIdentifier(i))) continue;
            arrayList.add(msa.getSequence(i));
        }
        if (arrayList.size() < 1) {
            return null;
        }
        return BasicMsa.createInstance(arrayList);
    }

    public static Msa removeSequencesByMinimalLength(Msa msa, int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < msa.getNumberOfSequences(); ++i) {
            int n2 = 0;
            for (int j = 0; j < msa.getLength(); ++j) {
                if (msa.getResidueAt(i, j) == '-') continue;
                ++n2;
            }
            if (n2 >= n) continue;
            arrayList.add(i);
        }
        return MsaMethods.removeSequencesByRow(msa, arrayList);
    }

    public static final Msa removeSequencesByRow(Msa msa, List<Integer> list) {
        ArrayList<MolecularSequence> arrayList = new ArrayList<MolecularSequence>();
        for (int i = 0; i < msa.getNumberOfSequences(); ++i) {
            if (list.contains(i)) continue;
            arrayList.add(msa.getSequence(i));
        }
        if (arrayList.size() < 1) {
            return null;
        }
        return BasicMsa.createInstance(arrayList);
    }

    private static final HashMap<Character, Integer> calcResidueDistribution20(Msa msa, int n) {
        HashMap<Character, Integer> hashMap = new HashMap<Character, Integer>();
        for (int i = 0; i < msa.getNumberOfSequences(); ++i) {
            char c = msa.getResidueAt(i, n);
            if (c == '-') continue;
            if (!hashMap.containsKey(Character.valueOf(c))) {
                hashMap.put(Character.valueOf(c), 1);
                continue;
            }
            hashMap.put(Character.valueOf(c), 1 + hashMap.get(Character.valueOf(c)));
        }
        return hashMap;
    }

    private static final HashMap<Character, Integer> calcResidueDistribution21(Msa msa, int n) {
        HashMap<Character, Integer> hashMap = new HashMap<Character, Integer>();
        for (int i = 0; i < msa.getNumberOfSequences(); ++i) {
            char c = msa.getResidueAt(i, n);
            if (!hashMap.containsKey(Character.valueOf(c))) {
                hashMap.put(Character.valueOf(c), 1);
                continue;
            }
            hashMap.put(Character.valueOf(c), 1 + hashMap.get(Character.valueOf(c)));
        }
        return hashMap;
    }

    private static final HashMap<Character, Integer> calcResidueDistribution6(Msa msa, int n) {
        HashMap<Character, Integer> hashMap = new HashMap<Character, Integer>();
        for (int i = 0; i < msa.getNumberOfSequences(); ++i) {
            int n2;
            char c = msa.getResidueAt(i, n);
            if (c == 'A' || c == 'V' || c == 'L' || c == 'I' || c == 'M' || c == 'C') {
                n2 = 97;
            } else if (c == 'F' || c == 'W' || c == 'Y' || c == 'H') {
                n2 = 114;
            } else if (c == 'S' || c == 'T' || c == 'N' || c == 'Q') {
                n2 = 112;
            } else if (c == 'K' || c == 'R') {
                n2 = 111;
            } else if (c == 'D' || c == 'E') {
                n2 = 101;
            } else {
                if (c != 'G' && c != 'P') continue;
                n2 = 115;
            }
            if (!hashMap.containsKey(Character.valueOf((char)n2))) {
                hashMap.put(Character.valueOf((char)n2), 1);
                continue;
            }
            hashMap.put(Character.valueOf((char)n2), 1 + hashMap.get(Character.valueOf((char)n2)));
        }
        return hashMap;
    }

    private static final HashMap<Character, Integer> calcResidueDistribution7(Msa msa, int n) {
        HashMap<Character, Integer> hashMap = new HashMap<Character, Integer>();
        for (int i = 0; i < msa.getNumberOfSequences(); ++i) {
            char c = msa.getResidueAt(i, n);
            int n2 = 45;
            if (c == 'A' || c == 'V' || c == 'L' || c == 'I' || c == 'M' || c == 'C') {
                n2 = 97;
            } else if (c == 'F' || c == 'W' || c == 'Y' || c == 'H') {
                n2 = 114;
            } else if (c == 'S' || c == 'T' || c == 'N' || c == 'Q') {
                n2 = 112;
            } else if (c == 'K' || c == 'R') {
                n2 = 111;
            } else if (c == 'D' || c == 'E') {
                n2 = 101;
            } else if (c == 'G' || c == 'P') {
                n2 = 115;
            }
            if (!hashMap.containsKey(Character.valueOf((char)n2))) {
                hashMap.put(Character.valueOf((char)n2), 1);
                continue;
            }
            hashMap.put(Character.valueOf((char)n2), 1 + hashMap.get(Character.valueOf((char)n2)));
        }
        return hashMap;
    }
}

