/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.tools;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.TreePanel;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.util.ForesterUtil;
import org.forester.util.SequenceAccessionTools;

public final class Blast {
    public static final void openNcbiBlastWeb(String string, boolean bl, TreePanel treePanel) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("http://www.ncbi.nlm.nih.gov/blast/Blast.cgi?CMD=Web&DATABASE=nr&PAGE=");
        if (bl) {
            stringBuilder.append("Nucleotide");
        } else {
            stringBuilder.append("Proteins");
        }
        stringBuilder.append("&QUERY=");
        stringBuilder.append(string);
        try {
            AptxUtil.launchWebBrowser(new URI(stringBuilder.toString()), "_aptx_blast");
        }
        catch (IOException iOException) {
            AptxUtil.showErrorMessage(treePanel, iOException.toString());
            iOException.printStackTrace();
        }
        catch (URISyntaxException uRISyntaxException) {
            AptxUtil.showErrorMessage(treePanel, uRISyntaxException.toString());
            uRISyntaxException.printStackTrace();
        }
    }

    public static final String obtainQueryForBlast(PhylogenyNode phylogenyNode) {
        Accession accession;
        String string = "";
        if (phylogenyNode.getNodeData().isHasSequence()) {
            if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getMolecularSequence())) {
                string = phylogenyNode.getNodeData().getSequence().getMolecularSequence();
            }
            if (ForesterUtil.isEmpty(string) && phylogenyNode.getNodeData().getSequence().getAccession() != null && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAccession().getValue()) && (accession = SequenceAccessionTools.parseAccessorFromString(phylogenyNode.getNodeData().getSequence().getAccession().getValue())) != null) {
                string = accession.getValue();
            }
            if (ForesterUtil.isEmpty(string) && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getName()) && (accession = SequenceAccessionTools.parseAccessorFromString(phylogenyNode.getNodeData().getSequence().getName())) != null) {
                string = accession.getValue();
            }
            if (ForesterUtil.isEmpty(string) && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getSymbol()) && (accession = SequenceAccessionTools.parseAccessorFromString(phylogenyNode.getNodeData().getSequence().getSymbol())) != null) {
                string = accession.getValue();
            }
            if (ForesterUtil.isEmpty(string) && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getGeneName()) && (accession = SequenceAccessionTools.parseAccessorFromString(phylogenyNode.getNodeData().getSequence().getGeneName())) != null) {
                string = accession.getValue();
            }
        }
        if (ForesterUtil.isEmpty(string) && !ForesterUtil.isEmpty(phylogenyNode.getName()) && (accession = SequenceAccessionTools.parseAccessorFromString(phylogenyNode.getName())) != null) {
            string = accession.getValue();
        }
        return string;
    }

    public static final boolean isContainsQueryForBlast(PhylogenyNode phylogenyNode) {
        return !ForesterUtil.isEmpty(Blast.obtainQueryForBlast(phylogenyNode));
    }
}

