/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public final class table2tree {
    private static final String PRG_NAME = "table2tree";
    private static final String PRG_VERSION = "1.00";
    private static final String PRG_DATE = "180312";

    public static void main(String[] stringArray) {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE);
        System.out.println();
        if (stringArray.length != 2) {
            table2tree.argumentsError();
        }
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        File file = commandLineArguments.getFile(0);
        File file2 = commandLineArguments.getFile(1);
        if (file2.exists()) {
            ForesterUtil.fatalError(PRG_NAME, file2 + " already exists");
        }
        if (!file.exists()) {
            ForesterUtil.fatalError(PRG_NAME, file + " does not exist");
        }
        BasicTable<String> basicTable = null;
        try {
            basicTable = BasicTableParser.parse(file, '\t');
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
        }
        System.out.println("Number of rows: " + basicTable.getNumberOfRows());
        Phylogeny phylogeny = new Phylogeny();
        phylogeny.setRooted(true);
        phylogeny.setRerootable(false);
        phylogeny.setDescription("based on " + file);
        PhylogenyNode phylogenyNode = new PhylogenyNode();
        phylogenyNode.setName("r");
        phylogeny.setRoot(phylogenyNode);
        for (int i = 0; i < basicTable.getNumberOfRows(); ++i) {
            Taxonomy taxonomy;
            Comparable<Taxonomy> comparable;
            Object object;
            String string = basicTable.getValueAsString(0, i);
            String string2 = basicTable.getValueAsString(1, i);
            String string3 = basicTable.getValueAsString(2, i);
            String string4 = basicTable.getValueAsString(3, i);
            String string5 = basicTable.getValueAsString(4, i);
            if (string4.startsWith("unclassified") || string4.startsWith("unassigned") || string5.startsWith("unclassified") || string5.startsWith("unassigned")) continue;
            List<PhylogenyNode> list = phylogeny.getNodesViaScientificName(string4);
            if (list.size() < 1) {
                object = new PhylogenyNode();
                comparable = new Taxonomy();
                ((Taxonomy)comparable).setScientificName(string4);
                ((PhylogenyNode)object).getNodeData().addTaxonomy((Taxonomy)comparable);
                phylogeny.getRoot().addAsChild((PhylogenyNode)object);
                list.add((PhylogenyNode)object);
            } else if (list.size() > 1) {
                ForesterUtil.fatalError(PRG_NAME, "This should not have happened: " + string4 + " is somehow unspecific");
            }
            object = phylogeny.getNodesViaScientificName(string5);
            if (object.size() < 1) {
                comparable = new PhylogenyNode();
                taxonomy = new Taxonomy();
                taxonomy.setScientificName(string5);
                ((PhylogenyNode)comparable).getNodeData().addTaxonomy(taxonomy);
                list.get(0).addAsChild((PhylogenyNode)comparable);
                object.add(comparable);
            } else if (object.size() > 1) {
                ForesterUtil.fatalError(PRG_NAME, "This should not have happened: " + string5 + " is somehow unspecific");
            }
            comparable = new PhylogenyNode();
            taxonomy = new Taxonomy();
            taxonomy.setScientificName(string);
            try {
                taxonomy.setTaxonomyCode(string3);
            }
            catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
                ForesterUtil.fatalError(PRG_NAME, phyloXmlDataFormatException.getMessage());
            }
            taxonomy.setIdentifier(new Identifier(string2, "uniprot"));
            ((PhylogenyNode)comparable).getNodeData().addTaxonomy(taxonomy);
            ((PhylogenyNode)object.get(0)).addAsChild((PhylogenyNode)comparable);
        }
        try {
            PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
            phylogenyWriter.toPhyloXML(phylogeny, 0, file2);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
        }
        System.out.println("Successfully wrote: " + file2);
        System.out.println();
    }

    private static void argumentsError() {
        System.out.println("table2tree <infile> <outfile>");
        System.out.println();
        System.exit(-1);
    }
}

