/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.model.threedimensional;

import com.approximatrix.charting.model.threedimensional.AbstractDotPlotDataModel;
import com.approximatrix.charting.model.threedimensional.DotPlotDataModelConstraints;
import java.awt.Color;
import java.util.TreeSet;

public class ColorDotPlotDataModel
extends AbstractDotPlotDataModel {
    private static final int DEFAULT_WIDTH = 500;
    private static final int DEFAULT_HEIGHT = 500;
    private int w = 500;
    private int h = 500;
    protected double[] x = null;
    protected double[] y = null;
    protected Color[] c = null;

    public ColorDotPlotDataModel() {
    }

    public ColorDotPlotDataModel(int[] x, int[] y, Color[] color) {
        if (x == null || y == null || color == null) {
            throw new NullPointerException();
        }
        int size = Math.min(x.length, Math.min(y.length, color.length));
        this.x = new double[size];
        this.y = new double[size];
        this.c = color;
        int i = 0;
        while (i < size) {
            this.x[i] = x[i];
            this.y[i] = y[i];
            ++i;
        }
        this.initialize();
    }

    public ColorDotPlotDataModel(double[] x, double[] y, Color[] color) throws NullPointerException {
        if (x == null || y == null || color == null) {
            throw new NullPointerException();
        }
        this.x = x;
        this.y = y;
        this.c = color;
        this.initialize();
    }

    private void initialize() {
        this.scanRanges(this.x, this.y);
        this.constraints = new DotPlotDataModelConstraints(this, 0);
    }

    public void setResolution(int w, int h) {
        if (w != this.w || h != this.h) {
            this.dataImage = null;
        }
        this.w = w;
        this.h = h;
        this.fireChartDataModelChangedEvent(this);
    }

    @Override
    protected void buildImage() {
        this.initializeImage(this.w, this.h);
        int limit = this.getDataSetLength(0);
        int[] ix = super.getXIndices(this.x);
        int[] iy = super.getYIndices(this.y);
        int i = 0;
        while (i < limit) {
            try {
                this.dataImage.setRGB(ix[i], iy[i], this.c[i].getRGB());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            ++i;
        }
    }

    @Override
    protected double getFirstColumnValue() {
        return this.minX;
    }

    @Override
    protected double getLastColumnValue() {
        return this.maxX;
    }

    @Override
    protected TreeSet getOrderedValues(int axis) {
        return null;
    }

    @Override
    public Object getColumnValueAt(int col) {
        return this.x[col];
    }

    @Override
    public Object getColumnValueAt(int set, int col) {
        if (set != 0) {
            throw new IndexOutOfBoundsException("Set 0 is the only valid data set");
        }
        return this.x[col];
    }

    @Override
    public int getDataSetLength(int set) throws IndexOutOfBoundsException {
        if (set != 0) {
            throw new IndexOutOfBoundsException("Set 0 is the only valid data set");
        }
        return Math.min(this.x.length, Math.min(this.y.length, this.c.length));
    }

    @Override
    public int getDataSetNumber() {
        if (this.x == null || this.y == null || this.c == null) {
            return 0;
        }
        return 1;
    }

    @Override
    public Number getValueAt(int set, int index) throws IndexOutOfBoundsException {
        if (set != 0) {
            throw new IndexOutOfBoundsException("Set 0 is the only valid data set");
        }
        return new Integer(this.c[index].getRGB());
    }

    public void setValueAt(int x, int y, Color value) {
        this.setValueAt((double)x, (double)y, value);
    }

    public void setValueAt(double x, double y, Color value) {
        int newi = this.getDataSetLength(0);
        double[] newx = new double[newi + 1];
        double[] newy = new double[newi + 1];
        Color[] newc = new Color[newi + 1];
        newx[newi] = x;
        newy[newi] = y;
        newc[newi] = value;
        int i = 0;
        while (i < newi) {
            newx[i] = this.x[i];
            newy[i] = this.y[i];
            newc[i] = this.c[i];
            ++i;
        }
        this.x = newx;
        this.y = newy;
        this.c = newc;
        this.dataImage = null;
        this.maxX = Math.max(x, this.maxX);
        this.maxY = Math.max(y, this.maxY);
        this.minX = Math.min(x, this.minX);
        this.minY = Math.min(y, this.minY);
    }
}

