/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BBZoomLevelFormat;
import org.broad.igv.bbfile.BBZoomLevelHeader;
import org.broad.igv.bbfile.RPTree;
import org.broad.igv.util.stream.IGVSeekableBufferedStream;

public class BBZoomLevels {
    private static Logger log = Logger.getLogger(BBZoomLevels.class);
    private long zoomHeadersOffset;
    private int zoomLevelsCount;
    private ArrayList<BBZoomLevelHeader> zoomLevelHeaders;
    private ArrayList<BBZoomLevelFormat> zoomLevelFormatList;
    private ArrayList<RPTree> zoomLevelRPTree;

    public BBZoomLevels(SeekableStream is, long fileOffset, int zoomLevels, boolean isLowToHigh, int uncompressBufSize) {
        this.zoomHeadersOffset = fileOffset;
        this.zoomLevelsCount = zoomLevels;
        IGVSeekableBufferedStream fis = new IGVSeekableBufferedStream(is, 512000);
        int zoomHeadersRead = this.readZoomHeaders(fis, this.zoomHeadersOffset, zoomLevels, isLowToHigh);
        if (zoomHeadersRead > 0) {
            int index;
            this.zoomLevelFormatList = new ArrayList();
            for (index = 0; index < zoomHeadersRead; ++index) {
                int zoomLevel = index + 1;
                long zoomDataOffset = this.zoomLevelHeaders.get(index).getDataOffset();
                long dataSize = this.zoomLevelHeaders.get(index).getIndexOffset() - zoomDataOffset - 4L;
                BBZoomLevelFormat zoomLevelData = new BBZoomLevelFormat(zoomLevel, fis, zoomDataOffset, dataSize, isLowToHigh, uncompressBufSize);
                this.zoomLevelFormatList.add(zoomLevelData);
            }
            this.zoomLevelRPTree = new ArrayList();
            for (index = 0; index < zoomHeadersRead; ++index) {
                long zoomIndexOffset = this.zoomLevelHeaders.get(index).getIndexOffset();
                RPTree zoomRPTree = new RPTree(fis, zoomIndexOffset, isLowToHigh, uncompressBufSize, true);
                this.zoomLevelRPTree.add(zoomRPTree);
            }
        }
    }

    public long getZoomHeadersOffset() {
        return this.zoomHeadersOffset;
    }

    public int getZoomHeaderCount() {
        return this.zoomLevelHeaders.size();
    }

    public ArrayList<BBZoomLevelHeader> getZoomLevelHeaders() {
        return this.zoomLevelHeaders;
    }

    public BBZoomLevelHeader getZoomLevelHeader(int level) {
        if (level < 1 || level > this.zoomLevelsCount) {
            return null;
        }
        return this.zoomLevelHeaders.get(level - 1);
    }

    public ArrayList<BBZoomLevelFormat> getZoomLevelFormats() {
        return this.zoomLevelFormatList;
    }

    public RPTree getZoomLevelRPTree(int level) {
        if (level < 1 || level > this.zoomLevelsCount) {
            return null;
        }
        return this.zoomLevelRPTree.get(level - 1);
    }

    public void printZoomHeaders() {
        if (this.zoomLevelHeaders.size() == this.zoomLevelsCount) {
            log.debug((Object)("Zoom level headers read for " + this.zoomLevelsCount + " levels:"));
        } else {
            log.error((Object)("Zoom level headers not successfully read for " + this.zoomLevelsCount + "levels."));
        }
        for (int index = 0; index < this.zoomLevelHeaders.size(); ++index) {
            this.zoomLevelHeaders.get(index).print();
        }
    }

    private int readZoomHeaders(SeekableStream fis, long fileOffset, int zoomLevels, boolean isLowToHigh) {
        int level = 0;
        if (zoomLevels < 1) {
            return 0;
        }
        this.zoomLevelHeaders = new ArrayList();
        for (int index = 0; index < zoomLevels; ++index) {
            level = index + 1;
            BBZoomLevelHeader zoomLevelHeader = new BBZoomLevelHeader(fis, fileOffset, level, isLowToHigh);
            this.zoomLevelHeaders.add(zoomLevelHeader);
            fileOffset += 24L;
        }
        return level;
    }
}

