/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.rans;

import htsjdk.samtools.cram.compression.rans.ArithmeticDecoder;
import htsjdk.samtools.cram.compression.rans.RANSDecodingSymbol;
import htsjdk.samtools.cram.compression.rans.Utils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class D14 {
    D14() {
    }

    static void uncompress(ByteBuffer inBuffer, ByteBuffer outBuffer, ArithmeticDecoder[] D, RANSDecodingSymbol[][] syms) {
        int out_sz = outBuffer.remaining();
        inBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int rans0 = inBuffer.getInt();
        int rans1 = inBuffer.getInt();
        int rans2 = inBuffer.getInt();
        int rans7 = inBuffer.getInt();
        int isz4 = out_sz >> 2;
        int i0 = 0;
        int i1 = isz4;
        int i2 = 2 * isz4;
        int i7 = 3 * isz4;
        int l0 = 0;
        int l1 = 0;
        int l2 = 0;
        int l7 = 0;
        while (i0 < isz4) {
            int c0 = 0xFF & D[l0].R[Utils.RANSDecodeGet(rans0, 12)];
            int c1 = 0xFF & D[l1].R[Utils.RANSDecodeGet(rans1, 12)];
            int c2 = 0xFF & D[l2].R[Utils.RANSDecodeGet(rans2, 12)];
            int c7 = 0xFF & D[l7].R[Utils.RANSDecodeGet(rans7, 12)];
            outBuffer.put(i0, (byte)c0);
            outBuffer.put(i1, (byte)c1);
            outBuffer.put(i2, (byte)c2);
            outBuffer.put(i7, (byte)c7);
            rans0 = syms[l0][c0].advanceSymbolStep(rans0, 12);
            rans1 = syms[l1][c1].advanceSymbolStep(rans1, 12);
            rans2 = syms[l2][c2].advanceSymbolStep(rans2, 12);
            rans7 = syms[l7][c7].advanceSymbolStep(rans7, 12);
            rans0 = Utils.RANSDecodeRenormalize(rans0, inBuffer);
            rans1 = Utils.RANSDecodeRenormalize(rans1, inBuffer);
            rans2 = Utils.RANSDecodeRenormalize(rans2, inBuffer);
            rans7 = Utils.RANSDecodeRenormalize(rans7, inBuffer);
            l0 = c0;
            l1 = c1;
            l2 = c2;
            l7 = c7;
            ++i0;
            ++i1;
            ++i2;
            ++i7;
        }
        while (i7 < out_sz) {
            int c7 = 0xFF & D[l7].R[Utils.RANSDecodeGet(rans7, 12)];
            outBuffer.put(i7, (byte)c7);
            rans7 = syms[l7][c7].advanceSymbol(rans7, inBuffer, 12);
            l7 = c7;
            ++i7;
        }
    }
}

