/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.Transform;

import FCSalyzer.Transform.ChannelTransformCached;
import FCSalyzer.Transform.FCStransformer;

public class ChannelTransform
implements FCStransformer {
    float decades;
    double scaleStart;
    double logFactor;
    long channelCount;
    long maxChannel;

    ChannelTransform(float offset, float logDecades, long channelCount) {
        this.decades = logDecades;
        this.logFactor = (double)channelCount / (double)logDecades;
        this.scaleStart = offset;
        this.channelCount = channelCount;
        this.maxChannel = channelCount - 1L;
    }

    public static FCStransformer getTransformer(float offset, float logDecades, long channelCount) {
        FCStransformer newT = ChannelTransformCached.getTransformer(offset, logDecades, channelCount);
        if (newT != null) {
            return newT;
        }
        return new ChannelTransform(offset, logDecades, channelCount);
    }

    @Override
    public double scale(double value) {
        if (value <= this.scaleStart) {
            return 0.0;
        }
        float channel = (float)(Math.log10(value / this.scaleStart) / (double)this.decades);
        return channel;
    }

    @Override
    public double inverse(double channel) {
        return Math.pow(10.0, channel / this.logFactor) * this.scaleStart;
    }

    @Override
    public int getApproximateNegativeRange() {
        return 1;
    }

    @Override
    public int getNegativePercentageIndex() {
        return -2;
    }
}

