/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.g729;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.ArrayIOUtils;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.audio.g729.Decoder;

public class JavaDecoder
extends AbstractCodec2 {
    private static final short BIT_0 = 127;
    private static final short BIT_1 = 129;
    private static final int L_FRAME = 80;
    private static final int SERIAL_SIZE = 82;
    private static final short SIZE_WORD = 80;
    private static final short SYNC_WORD = 27425;
    private static final int INPUT_FRAME_SIZE_IN_BYTES = 10;
    private static final int OUTPUT_FRAME_SIZE_IN_BYTES = 160;
    private Decoder decoder;
    private short[] serial;
    private short[] sp16;

    public JavaDecoder() {
        super("G.729 Decoder", AudioFormat.class, (Format[])new AudioFormat[]{new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)});
        this.inputFormats = new AudioFormat[]{new AudioFormat("g729/rtp", 8000.0, -1, 1)};
    }

    private void depacketize(byte[] inFrame, int inFrameOffset, short[] serial) {
        serial[0] = 27425;
        serial[1] = 80;
        for (int s = 0; s < 80; ++s) {
            int in = inFrame[inFrameOffset + s / 8];
            serial[2 + s] = 0 != (in &= 1 << 7 - s % 8) ? 129 : 127;
        }
    }

    @Override
    protected void doClose() {
        this.serial = null;
        this.sp16 = null;
        this.decoder = null;
    }

    @Override
    protected void doOpen() throws ResourceUnavailableException {
        this.serial = new short[82];
        this.sp16 = new short[80];
        this.decoder = new Decoder();
    }

    @Override
    protected int doProcess(Buffer inBuffer, Buffer outBuffer) {
        int inLength = inBuffer.getLength();
        int frameCount = inLength / 10;
        if (frameCount < 1) {
            this.discardOutputBuffer(outBuffer);
            return 4;
        }
        byte[] in = (byte[])inBuffer.getData();
        int inOffset = inBuffer.getOffset();
        int outOffset = outBuffer.getOffset();
        int outLength = 160 * frameCount;
        byte[] out = JavaDecoder.validateByteArraySize(outBuffer, outOffset + outLength, false);
        for (int i = 0; i < frameCount; ++i) {
            this.depacketize(in, inOffset, this.serial);
            inLength -= 10;
            inOffset += 10;
            this.decoder.process(this.serial, this.sp16);
            JavaDecoder.writeShorts(this.sp16, out, outOffset);
            outOffset += 160;
        }
        inBuffer.setLength(inLength);
        inBuffer.setOffset(inOffset);
        outBuffer.setLength(outLength);
        return 0;
    }

    private static void writeShorts(short[] in, byte[] out, int outOffset) {
        int i = 0;
        int o = outOffset;
        while (i < in.length) {
            ArrayIOUtils.writeShort(in[i], out, o);
            ++i;
            o += 2;
        }
    }
}

