/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.dictionary.myspell;

import java.io.IOException;
import org.dts.spell.dictionary.myspell.AffEntry;
import org.dts.spell.dictionary.myspell.AffixHeader;
import org.dts.spell.dictionary.myspell.AffixMgr;
import org.dts.spell.dictionary.myspell.Conditions;
import org.dts.spell.dictionary.myspell.HEntry;
import org.dts.spell.dictionary.myspell.Utils;

public class PfxEntry
extends AffEntry {
    public PfxEntry(AffixMgr pmyMgr, AffixHeader header, String line) throws IOException {
        super(pmyMgr, header, line);
    }

    protected Conditions createConditions(String cs) {
        if (!(cs = cs.trim()).equals(".")) {
            cs = cs + ".*";
        }
        return Conditions.createFrom(cs);
    }

    public HEntry check(String word) {
        if (!word.startsWith(this.appnd)) {
            return null;
        }
        String firstWord = this.strip + word.substring(this.appnd.length());
        if (!this.conds.match(firstWord)) {
            return null;
        }
        HEntry he = this.pmyMgr.lookup(firstWord);
        if (he != null && he.astr != null && Utils.TestAff(he.astr, this.achar, he.astr.length())) {
            return he;
        }
        if ((this.xpflg & Utils.XPRODUCT) != 0 && (he = this.pmyMgr.suffix_check(firstWord, Utils.XPRODUCT, this)) != null) {
            return he;
        }
        return null;
    }

    boolean allowCross() {
        return (this.xpflg & Utils.XPRODUCT) != 0;
    }

    public String add(String word) {
        if (!word.startsWith(this.strip)) {
            return null;
        }
        if (!this.conds.match(word)) {
            return null;
        }
        return this.appnd + word.substring(this.strip.length());
    }

    protected void build_list() {
        this.pmyMgr.build_pfxlist(this);
    }
}

