/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.util.regex.Pattern;
import org.freedesktop.dbus.ExportedObject;

class ObjectTree {
    private TreeNode root = new TreeNode("");
    public static final Pattern slashpattern = Pattern.compile("/");

    private TreeNode recursiveFind(TreeNode treeNode, String string) {
        if ("/".equals(string)) {
            return treeNode;
        }
        String[] stringArray = string.split("/", 2);
        if (string.startsWith(treeNode.name)) {
            if (string.equals(treeNode.name)) {
                return treeNode;
            }
            if (treeNode.down == null) {
                return null;
            }
            return this.recursiveFind(treeNode.down, stringArray[1]);
        }
        if (treeNode.right == null) {
            return null;
        }
        if (0 > treeNode.right.name.compareTo(stringArray[0])) {
            return null;
        }
        return this.recursiveFind(treeNode.right, string);
    }

    private TreeNode recursiveAdd(TreeNode treeNode, String string, ExportedObject exportedObject, String string2) {
        String[] stringArray = slashpattern.split(string, 2);
        if (string.startsWith(treeNode.name)) {
            if (1 == stringArray.length || "".equals(stringArray[1])) {
                treeNode.object = exportedObject;
                treeNode.data = string2;
            } else {
                if (treeNode.down == null) {
                    String[] stringArray2 = stringArray[1].split("/", 2);
                    treeNode.down = new TreeNode(stringArray2[0]);
                }
                treeNode.down = this.recursiveAdd(treeNode.down, stringArray[1], exportedObject, string2);
            }
        } else if (treeNode.right == null) {
            treeNode.right = new TreeNode(stringArray[0]);
            treeNode.right = this.recursiveAdd(treeNode.right, string, exportedObject, string2);
        } else if (0 > treeNode.right.name.compareTo(stringArray[0])) {
            TreeNode treeNode2 = new TreeNode(stringArray[0]);
            treeNode2.right = treeNode.right;
            treeNode.right = treeNode2;
            treeNode.right = this.recursiveAdd(treeNode.right, string, exportedObject, string2);
        } else {
            treeNode.right = this.recursiveAdd(treeNode.right, string, exportedObject, string2);
        }
        return treeNode;
    }

    public void add(String string, ExportedObject exportedObject, String string2) {
        this.root = this.recursiveAdd(this.root, string, exportedObject, string2);
    }

    public void remove(String string) {
        TreeNode treeNode = this.recursiveFind(this.root, string);
        treeNode.object = null;
        treeNode.data = null;
    }

    public String Introspect(String string) {
        TreeNode treeNode = this.recursiveFind(this.root, string);
        if (null == treeNode) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<node name=\"");
        stringBuilder.append(string);
        stringBuilder.append("\">\n");
        if (null != treeNode.data) {
            stringBuilder.append(treeNode.data);
        }
        treeNode = treeNode.down;
        while (null != treeNode) {
            stringBuilder.append("<node name=\"");
            stringBuilder.append(treeNode.name);
            stringBuilder.append("\"/>\n");
            treeNode = treeNode.right;
        }
        stringBuilder.append("</node>");
        return stringBuilder.toString();
    }

    private String recursivePrint(TreeNode treeNode) {
        String string = "";
        if (null != treeNode) {
            string = string + treeNode.name;
            if (null != treeNode.object) {
                string = string + "*";
            }
            if (null != treeNode.down) {
                string = string + "/{" + this.recursivePrint(treeNode.down) + "}";
            }
            if (null != treeNode.right) {
                string = string + ", " + this.recursivePrint(treeNode.right);
            }
        }
        return string;
    }

    public String toString() {
        return this.recursivePrint(this.root);
    }

    class TreeNode {
        String name;
        ExportedObject object;
        String data;
        TreeNode right;
        TreeNode down;

        public TreeNode(String string) {
            this.name = string;
        }

        public TreeNode(String string, ExportedObject exportedObject, String string2) {
            this.name = string;
            this.object = exportedObject;
            this.data = string2;
        }
    }
}

