/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import net.sf.profiler4j.agent.ThreadInfo;
import net.sf.profiler4j.console.AppEvent;
import net.sf.profiler4j.console.AppEventListener;
import net.sf.profiler4j.console.AppEventType;
import net.sf.profiler4j.console.Console;
import net.sf.profiler4j.console.client.ClientException;

public class ThreadPanel
extends JPanel
implements AppEventListener {
    private Console app;
    private JPanel topPanel = null;
    private JPanel viewPanel = null;
    private JButton refreshButton = null;
    private JScrollPane jScrollPane = null;
    private JTextPane text = null;

    public ThreadPanel() {
        this.initialize();
    }

    public ThreadPanel(Console app) {
        this.app = app;
        this.initialize();
        app.addListener(this);
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(300, 200);
        this.add((Component)this.getTopPanel(), "North");
        this.add((Component)this.getViewPanel(), "Center");
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            this.topPanel = new JPanel();
            this.topPanel.setLayout(flowLayout);
            this.topPanel.add((Component)this.getRefreshButton(), null);
        }
        return this.topPanel;
    }

    private JPanel getViewPanel() {
        if (this.viewPanel == null) {
            this.viewPanel = new JPanel();
            this.viewPanel.setLayout(new BorderLayout());
            this.viewPanel.add((Component)this.getJScrollPane(), "Center");
        }
        return this.viewPanel;
    }

    private JButton getRefreshButton() {
        if (this.refreshButton == null) {
            this.refreshButton = new JButton();
            this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/profiler4j/console/images/refresh.gif")));
            this.refreshButton.setToolTipText("Refresh info");
            this.refreshButton.setEnabled(true);
            this.refreshButton.setPreferredSize(new Dimension(32, 32));
            this.refreshButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ThreadPanel.this.refreshThreads();
                }
            });
        }
        return this.refreshButton;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setFont(new Font("Monospaced", 0, 12));
            this.jScrollPane.setViewportView(this.getText());
        }
        return this.jScrollPane;
    }

    private JTextPane getText() {
        if (this.text == null) {
            this.text = new JTextPane();
            this.text.setEditable(false);
            this.text.setContentType("text/html");
            this.text.setEditable(false);
            this.text.setBackground(SystemColor.info);
        }
        return this.text;
    }

    public boolean receiveEvent(AppEvent ev) {
        if (ev.getType() == AppEventType.CONNECTED) {
            this.refreshButton.setEnabled(true);
            try {
                boolean[] capabilities = this.app.getClient().setThreadMonitoring(true, true);
                System.out.println("Supports thread contention monitoring? " + capabilities[0]);
                System.out.println("Supports thread cpu time monitoring? " + capabilities[1]);
            }
            catch (ClientException e) {
                this.app.error("Could not set thread monitoring options", e);
            }
        } else if (ev.getType() == AppEventType.TO_DISCONNECT) {
            this.refreshButton.setEnabled(false);
            try {
                this.app.getClient().setThreadMonitoring(false, false);
            }
            catch (ClientException e) {
                this.app.error("Could not reset thread monitoring options", e);
            }
            this.text.setText("");
        }
        return false;
    }

    private void refreshThreads() {
        StringBuilder out = new StringBuilder();
        this.text.setText("");
        out.append("<html><head><style type=\"text/css\">th {font-style: plain; border-style: none; border-width: thin; padding: 5px; marging: 0px;}td {border-style: solid; border-width: thin; padding: 5px; marging: 0px; background-color: #ffffee}</style><body>");
        try {
            for (ThreadInfo ti : this.app.getClient().getThreadInfo(null, Integer.MAX_VALUE)) {
                out.append("<table width=100%><tr>");
                out.append("<th width=240>Thread name</th>");
                out.append("<th>Thread id</th>");
                out.append("<th>State</th>");
                out.append("<th>Blocked time (ms)</th>");
                out.append("<th>Blocked count</th>");
                out.append("<th>Waited time (ms)</th>");
                out.append("</tr>");
                out.append("<tr>");
                out.append("<td><b>" + ti.getThreadName() + "</b></td>");
                out.append("<td>" + ti.getThreadId() + "</td>");
                out.append("<td>" + (Object)((Object)ti.getThreadState()) + "</td>");
                out.append("<td>" + ti.getBlockedTime() + "</td>");
                out.append("<td>" + ti.getBlockedCount() + "</td>");
                out.append("<td>" + ti.getWaitedTime() + "</td>");
                out.append("</tr>");
                out.append("<tr><td colspan=6>");
                out.append("Stack trace:<pre>");
                for (StackTraceElement ste : ti.getStackTrace()) {
                    out.append("    " + ste.getClassName() + "." + ste.getMethodName() + ":" + (ste.isNativeMethod() ? "(Native Method)" : (ste.getLineNumber() < 0 ? "(Source Unavailable)" : String.valueOf(ste.getLineNumber()))) + "\n");
                }
                out.append("</pre></td></tr></table><br>");
            }
        }
        catch (ClientException e1) {
            this.app.error("Could not get thread info", e1);
        }
        out.append("</body></html>");
        int caret = this.text.getCaretPosition();
        this.text.setText(out.toString());
        this.text.setCaretPosition(Math.min(caret, out.length()));
    }
}

