/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import net.sf.profiler4j.console.AppEvent;
import net.sf.profiler4j.console.AppEventListener;
import net.sf.profiler4j.console.AppEventType;
import net.sf.profiler4j.console.MainFrame;
import net.sf.profiler4j.console.Prefs;
import net.sf.profiler4j.console.Project;
import net.sf.profiler4j.console.ProjectDialog;
import net.sf.profiler4j.console.Rule;
import net.sf.profiler4j.console.StatusBarPanel;
import net.sf.profiler4j.console.client.Client;
import net.sf.profiler4j.console.client.ClientException;
import net.sf.profiler4j.console.client.ProgressCallback;
import net.sf.profiler4j.console.client.Snapshot;
import net.sf.profiler4j.console.util.task.LongTask;
import net.sf.profiler4j.console.util.task.LongTaskExecutorDialog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class Console {
    private static final Log log = LogFactory.getLog(Console.class);
    private Client client;
    private Project project;
    private MainFrame mainFrame;
    private StatusBarPanel statusBar;
    private File lastDir;
    private Prefs prefs;
    private Document tipDoc;
    private Timer memoryPanelTimer = new Timer(1000, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (Console.this.client.isConnected()) {
                try {
                    Console.this.sendEvent(AppEventType.GOT_MEMORY_INFO, Console.this.client.getMemoryInfo());
                }
                catch (ClientException re) {
                    Console.this.error("Could not refresh memory info", re);
                    Console.this.memoryPanelTimer.stop();
                }
            }
        }
    });
    private List<AppEventListener> listeners = new ArrayList<AppEventListener>();
    private FileFilter projectFilter = new FileFilter(){

        public boolean accept(File file) {
            String filename = file.getName();
            return filename.endsWith(".p4j");
        }

        public String getDescription() {
            return "*.p4j (Profiling Project)";
        }
    };

    public Console(Prefs prefs) {
        this.prefs = prefs;
        this.project = new Project();
        this.lastDir = new File(System.getProperty("user.home"));
        this.client = new Client();
        SAXBuilder builder = new SAXBuilder();
        try {
            this.tipDoc = builder.build(this.getClass().getResource("tips.xml"));
        }
        catch (JDOMException e) {
            this.error("Could not read tips (XML Error)", e);
        }
        catch (IOException e) {
            this.error("Could not read tips (I/O Error)", e);
        }
    }

    public Document getTipDoc() {
        return this.tipDoc;
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void error(String message) {
        JOptionPane.showMessageDialog(this.mainFrame, message, "Error", 0);
    }

    public void error(String message, Throwable t) {
        JOptionPane.showMessageDialog(this.mainFrame, message + "\nMessage: " + t.getMessage(), "Error", 0);
    }

    public void connect() {
        LongTask t = new LongTask(){

            public void executeInBackground() throws Exception {
                this.setTaskMessage("Establishing connection with SIP-Communicator");
                Console.this.client.connect(Console.this.project.getHostname(), Console.this.project.getPort());
                this.setTaskMessage("Activating profiling rules...");
                Console.this.client.applyRules(Console.this.project.formtRules(), Console.this.project.formatOptions(), new ProgressCallback(){
                    private int max;

                    public void operationStarted(int amount) {
                        this.max = amount;
                    }

                    public void update(int value) {
                        this.setTaskProgress(value * 100 / this.max);
                        this.setTaskMessage("Activating profiling rules... (class " + value + " of " + this.max + ")");
                    }
                });
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Console.this.sendEvent(AppEventType.CONNECTED);
                        Console.this.memoryPanelTimer.start();
                    }
                });
            }
        };
        this.runInBackground(t);
    }

    public void disconnect() {
        if (!this.client.isConnected()) {
            return;
        }
        LongTask t = new LongTask(){

            public void executeInBackground() throws Exception {
                this.setTaskMessage("Undoing changes to classes...");
                Console.this.client.restoreClasses(new ProgressCallback(){
                    private int max;

                    public void operationStarted(int amount) {
                        this.max = amount;
                        this.update(0);
                    }

                    public void update(int value) {
                        this.setTaskProgress(value * 100 / this.max);
                        this.setTaskMessage("Undoing changes to classes... (class " + value + " of " + this.max + ")");
                    }
                });
            }
        };
        this.runInBackground(t);
        this.memoryPanelTimer.stop();
        this.sendEvent(AppEventType.TO_DISCONNECT);
        try {
            this.client.disconnect();
        }
        catch (ClientException e) {
            this.error("Connection was close with error: (" + e.getMessage() + ")", e);
        }
        this.sendEvent(AppEventType.DISCONNECTED);
    }

    public boolean newProject() {
        Project p;
        ProjectDialog d;
        int ret;
        if (this.client.isConnected() && (ret = JOptionPane.showConfirmDialog(this.mainFrame, "Proceed and disconnect?", "New Profiling Project", 0)) == 1) {
            return false;
        }
        if (this.checkUnsavedChanges()) {
            return false;
        }
        if (this.client.isConnected()) {
            this.disconnect();
            if (this.client.isConnected()) {
                return false;
            }
        }
        if ((d = new ProjectDialog(this.mainFrame, this)).edit(p = new Project())) {
            this.project = p;
            return true;
        }
        return false;
    }

    public void openProject() {
        int ret;
        if (this.client.isConnected() && (ret = JOptionPane.showConfirmDialog(this.mainFrame, "Proceed and disconnect?", "Open Profiling Project", 0)) == 1) {
            return;
        }
        if (this.checkUnsavedChanges()) {
            return;
        }
        if (this.client.isConnected()) {
            this.disconnect();
            if (this.client.isConnected()) {
                return;
            }
        }
        JFileChooser fc = new JFileChooser(this.lastDir);
        fc.addChoosableFileFilter(this.projectFilter);
        if (fc.showOpenDialog(this.mainFrame) == 0) {
            File selFile = fc.getSelectedFile();
            SAXBuilder builder = new SAXBuilder();
            Document doc = null;
            try {
                doc = builder.build(selFile);
            }
            catch (JDOMException e) {
                this.error("XML Error", e);
            }
            catch (IOException e) {
                this.error("I/O Error", e);
            }
            if (doc != null) {
                Project p = new Project();
                Element el = doc.getRootElement();
                p.setHostname(el.getChildText("Host"));
                p.setPort(Integer.parseInt(el.getChildText("Port")));
                Element rulesEl = el.getChild("Rules");
                p.setAccess(Rule.AccessOption.valueOf(rulesEl.getAttributeValue("access")));
                p.setBeanprops(Boolean.parseBoolean(rulesEl.getAttributeValue("beanProps")));
                p.getRules().clear();
                for (Element r : rulesEl.getChildren("Rule")) {
                    Rule rule = new Rule(r.getText(), Rule.Action.valueOf(r.getAttributeValue("action")));
                    p.getRules().add(rule);
                }
                p.setFile(selFile);
                p.clearChanged();
                this.project = p;
                this.lastDir = selFile.getParentFile();
            }
        }
    }

    public void close() {
        if (this.checkUnsavedChanges()) {
            return;
        }
        if (this.client.isConnected()) {
            this.disconnect();
            if (this.client.isConnected()) {
                return;
            }
        }
    }

    public boolean saveProject(boolean saveAs) {
        if (this.project.getFile() == null || saveAs) {
            JFileChooser fc = new JFileChooser(this.lastDir);
            fc.setDialogTitle("Save Project As");
            fc.addChoosableFileFilter(this.projectFilter);
            if (fc.showSaveDialog(this.mainFrame) == 0) {
                File f = fc.getSelectedFile();
                if (!f.getName().endsWith(".p4j")) {
                    f = new File(f.getAbsolutePath() + ".p4j");
                }
                this.project.setFile(f);
            } else {
                return true;
            }
        }
        Element rootEl = new Element("Profiler4jProject");
        Document doc = new Document(rootEl);
        rootEl.addContent((Content)new Element("Host").setText(this.project.getHostname()));
        rootEl.addContent((Content)new Element("Port").setText(String.valueOf(this.project.getPort())));
        Element rulesEl = new Element("Rules");
        rootEl.addContent((Content)rulesEl);
        rulesEl.setAttribute("access", this.project.getAccess().name());
        rulesEl.setAttribute("beanProps", String.valueOf(this.project.isBeanprops()));
        for (Rule rule : this.project.getRules()) {
            rulesEl.addContent((Content)new Element("Rule").setText(rule.getPattern()).setAttribute("action", rule.getAction().name()));
        }
        try {
            FileWriter fw = new FileWriter(this.project.getFile());
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            outputter.output(doc, (Writer)fw);
            fw.close();
            this.project.clearChanged();
        }
        catch (IOException e) {
            this.error("I/O Error", e);
        }
        return false;
    }

    public boolean editProject() {
        ProjectDialog d = new ProjectDialog(this.mainFrame, this);
        return d.edit(this.project);
    }

    public void applyRules() {
        LongTask t = new LongTask(){

            public void executeInBackground() throws Exception {
                this.setTaskMessage("Activating profiling rules...");
                Console.this.client.applyRules(Console.this.project.formtRules(), Console.this.project.formatOptions(), new ProgressCallback(){
                    private int max;

                    public void operationStarted(int amount) {
                        this.max = amount;
                        this.setTaskProgress(0);
                    }

                    public void update(int value) {
                        this.setTaskProgress(value * 100 / this.max);
                        this.setTaskMessage("Activating profiling rules... (class " + value + " of " + this.max + ")");
                    }
                });
            }
        };
        this.runInBackground(t);
        if (t.getError() == null) {
            this.sendEvent(AppEventType.RULES_APPLIED);
        }
    }

    public void takeSnapshot() {
        LongTask t = new LongTask(){

            public void executeInBackground() throws Exception {
                this.setTaskMessage("Retrieving snapshot...");
                this.setValue(Console.this.client.getSnapshot());
            }
        };
        this.runInBackground(t);
        if (t.getError() == null) {
            Snapshot s = (Snapshot)t.getValue();
            this.sendEvent(AppEventType.SNAPSHOT, s);
        }
    }

    private boolean checkUnsavedChanges() {
        if (this.project.isChanged()) {
            int ret = JOptionPane.showConfirmDialog(this.mainFrame, "Project has unsaved changes? Save before exit?", "Unsaved Changes", 1);
            if (ret == 2) {
                return true;
            }
            if (ret == 0) {
                return this.saveProject(false);
            }
        }
        return false;
    }

    public void exit() {
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException e) {
            System.err.println("ERROR: could not flush preferences to disk");
            e.printStackTrace();
        }
        if (this.checkUnsavedChanges()) {
            return;
        }
        if (this.sendEvent(AppEventType.APP_CLOSING)) {
            return;
        }
        if (this.client.isConnected()) {
            this.disconnect();
            if (!this.client.isConnected()) {
                this.sendEvent(AppEventType.APP_CLOSED);
            }
        } else {
            this.sendEvent(AppEventType.APP_CLOSED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInBackground(LongTask task) {
        this.memoryPanelTimer.stop();
        try {
            LongTaskExecutorDialog d = new LongTaskExecutorDialog(this.mainFrame);
            d.setLocationRelativeTo(this.mainFrame);
            d.runTask(task);
        }
        finally {
            this.memoryPanelTimer.restart();
        }
    }

    public void addListener(AppEventListener l) {
        this.listeners.add(l);
    }

    public void removeListener(AppEventListener l) {
        this.listeners.remove(l);
    }

    private boolean sendEvent(AppEventType evType) {
        return this.sendEvent(new AppEvent(evType));
    }

    private boolean sendEvent(AppEventType evType, Object arg) {
        AppEvent ae = new AppEvent(evType, arg);
        return this.sendEvent(ae);
    }

    private boolean sendEvent(AppEvent ev) {
        for (AppEventListener l : this.listeners) {
            boolean vetoed = l.receiveEvent(ev);
            if (!vetoed) continue;
            if (!ev.getType().isVetoable()) {
                throw new IllegalArgumentException("AppEventType " + (Object)((Object)ev.getType()) + " is not vetoable");
            }
            return true;
        }
        return false;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public void setMainFrame(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.statusBar = mainFrame.getStatusBarPanel();
    }

    public void setStatusMessage(String msg) {
        this.statusBar.setMessage(msg);
    }

    public Client getClient() {
        return this.client;
    }

    public static void main(String[] args) {
        System.out.println();
        System.out.println("+--------------------------------------------------------+");
        System.out.println("| Profiler4j Console " + String.format("%-36s", "(SC integrated)") + "|");
        System.out.println("| Copyright 2006 Antonio S. R. Gomes                     |");
        System.out.println("| See LICENSE-2.0.txt for details                        |");
        System.out.println("+--------------------------------------------------------+");
        Prefs prefs = new Prefs();
        System.setProperty("swing.aatext", String.valueOf(prefs.isAntialiasing()));
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        final Console app = new Console(prefs);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame f = new MainFrame(app);
                app.setMainFrame(f);
                if (!app.getClient().isConnected()) {
                    app.connect();
                }
                f.pack();
                f.setVisible(true);
            }
        });
    }
}

