/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console;

import java.io.File;
import java.io.FileFilter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.Charset;

public class Bootstrap {
    private static final String MAIN_CLASS = "java.net.sf.profiler4j.console.Console";

    public static void main(String[] args) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            URL url = Bootstrap.class.getResource("Bootstrap.class");
            if (url.toString().startsWith("jar:file:")) {
                File homeDir = Bootstrap.getDir(url);
                File libDir = new File(homeDir, "lib");
                File[] libs = libDir.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith(".jar");
                    }
                });
                URL[] urls = new URL[libs.length];
                int l0 = homeDir.getAbsolutePath().length();
                for (int i = 0; i < libs.length; ++i) {
                    Bootstrap.print("Added library " + libs[i].getAbsolutePath().substring(l0 + 1));
                    urls[i] = libs[i].toURI().toURL();
                }
                loader = new URLClassLoader(urls, Bootstrap.class.getClassLoader());
                Thread.currentThread().setContextClassLoader(loader);
            }
            Class<?> cc = loader.loadClass(MAIN_CLASS);
            Method m = cc.getDeclaredMethod("main", String[].class);
            m.invoke(null, new Object[]{args});
        }
        catch (InvocationTargetException e) {
            Bootstrap.print("Could not bootstrap application", e.getTargetException());
            System.exit(1);
        }
        catch (Exception e) {
            Bootstrap.print("Could not bootstrap application", e);
            System.exit(1);
        }
    }

    private static File getDir(URL url) throws UnsupportedEncodingException {
        String s = url.toString();
        s = URLDecoder.decode(s, Charset.defaultCharset().name());
        int p = s.indexOf("!");
        if ((s = s.substring(9, p)).indexOf(58) == 2) {
            s = s.substring(1);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            sb.append(s.charAt(i) == '/' ? File.separatorChar : s.charAt(i));
        }
        s = sb.toString();
        File homeDir = new File(s).getParentFile();
        Bootstrap.print("Install dir is " + homeDir.getAbsolutePath());
        return homeDir;
    }

    private static void print(String s) {
        System.out.println("[P4J-BOOTSTRAP] " + s);
    }

    private static void print(Object s, Throwable t) {
        System.out.println("[P4J-BOOTSTRAP] " + s);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        for (String ste : sw.toString().split("\n+")) {
            System.out.println("[P4J-BOOTSTRAP] " + ste);
        }
    }
}

