/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.agent;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.profiler4j.agent.BytecodeTransformer;
import net.sf.profiler4j.agent.ClassUtil;
import net.sf.profiler4j.agent.Config;
import net.sf.profiler4j.agent.Log;
import net.sf.profiler4j.agent.Profiler4JError;
import net.sf.profiler4j.agent.Rule;
import net.sf.profiler4j.agent.Server;
import net.sf.profiler4j.agent.SnapshotUtil;
import net.sf.profiler4j.agent.ThreadProfiler;
import net.sf.profiler4j.agent.Transformer;
import net.sf.profiler4j.agent.Utils;

public class Agent {
    static Transformer t;
    static Instrumentation inst;
    static final Object waitConnectionLock;
    static Server server;
    static Config config;
    static RuntimeMXBean rtbean;
    static List<GarbageCollectorMXBean> gcbeans;
    static MemoryMXBean membean;
    static ThreadMXBean threadbean;
    static volatile boolean beingShutdown;
    static final Set<String> modifiedClassNames;
    static int modifiedClassCount;

    public static void premain(String args, Instrumentation inst) {
        block4: {
            Log.print(0, "+---------------------------------------------------+");
            Log.print(0, "| Profiler4j Agent " + String.format("%-33s", "(SC integrated)") + "|");
            Log.print(0, "| Copyright 2006 Antonio S. R. Gomes                |");
            Log.print(0, "| See LICENSE-2.0.txt details                       |");
            Log.print(0, "+---------------------------------------------------+");
            Agent.doPreInitialization(inst);
            try {
                config = new Config(args);
                if (!config.isEnabled()) break block4;
                Log.setVerbosity(config.getVerbosity());
                server = new Server(config);
                server.start();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                t = new Transformer(config);
                BytecodeTransformer.enabled = true;
                inst.addTransformer(t);
                Agent.inst = inst;
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        beingShutdown = true;
                        BytecodeTransformer.enabled = false;
                        if (config.isSaveSnapshotOnExit()) {
                            SnapshotUtil.saveSnapshot();
                        }
                        ClassUtil.releaseLock();
                        Log.print(0, "Profiler stopped");
                    }
                });
            }
            catch (Throwable any) {
                Log.print(0, "UNEXPECTED ERROR", any);
                System.exit(1);
            }
        }
    }

    private static void doPreInitialization(Instrumentation inst) {
        if (!ClassUtil.acquireLock()) {
            System.exit(-1);
        }
        try {
            Log.print(0, "Creating backup for already loaded classes...");
            for (Class c : inst.getAllLoadedClasses()) {
                if (c.isInterface() || c.isArray() || c.isAnnotation() || c.isSynthetic() || c.isPrimitive()) continue;
                Transformer.scheduleRedefine(c.getClassLoader(), c.getName(), null);
                byte[] bytes = ClassUtil.loadClassBytesAsResource(c);
                ClassUtil.saveClassBackup(c.getName(), c.getClassLoader(), bytes);
            }
            Log.print(0, "Proceeding to application initialization...");
        }
        catch (Throwable ex) {
            Log.print(0, "Could not initialize agent", ex);
            System.exit(-1);
        }
    }

    static Class[] getLoadedClasses(boolean skipNonEnhanceable) {
        if (!skipNonEnhanceable) {
            return inst.getAllLoadedClasses();
        }
        ArrayList<Class> list = new ArrayList<Class>();
        for (Class cls : inst.getAllLoadedClasses()) {
            if (cls.isInterface() || cls.isArray() || t.rejectByDefault(cls.getName())) continue;
            list.add(cls);
        }
        return list.toArray(new Class[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int startNewSession(String optionsAsStr, String rulesAsStr, Transformer.Callback callback) throws IOException {
        Object object = ThreadProfiler.globalLock;
        synchronized (object) {
            Class[] classes = Agent.getLoadedClasses(true);
            Log.print(0, "*** Scheduling class reloading (max " + classes.length + ")");
            ThreadProfiler.startSessionConfig();
            config.parseRules(optionsAsStr, rulesAsStr);
            Set<String> set = modifiedClassNames;
            synchronized (set) {
                modifiedClassNames.clear();
                modifiedClassCount = 0;
            }
            int n = 0;
            for (Class c : classes) {
                if (!Agent.mustRedefineClass(c) || !ClassUtil.getClassFile(c).exists()) continue;
                Transformer.scheduleRedefine(c.getClassLoader(), c.getName(), callback);
                ++n;
            }
            ThreadProfiler.endSessionConfig();
            return n;
        }
    }

    public static boolean mustRedefineClass(Class c) {
        if (config.getLastRules() != null) {
            for (Rule rule : config.getLastRules()) {
                if (!Agent.ruleMatchesClass(rule, c)) continue;
                if (rule.getAction() != Rule.Action.ACCEPT) break;
                return true;
            }
        }
        if (config.getRules() != null) {
            for (Rule rule : config.getRules()) {
                if (!Agent.ruleMatchesClass(rule, c)) continue;
                if (rule.getAction() != Rule.Action.ACCEPT) break;
                return true;
            }
        }
        return false;
    }

    private static boolean ruleMatchesClass(Rule r, Class c) {
        String s = r.getPattern();
        int p1 = s.indexOf(40);
        int p2 = s.indexOf(41);
        if (p1 > 0 && p2 > p1) {
            s = s.substring(0, p1);
            return Utils.getRegex(s).matcher(c.getName() + ".").matches();
        }
        throw new Profiler4JError("Invalid rule pattern '" + s + "'");
    }

    static {
        waitConnectionLock = new Object();
        rtbean = ManagementFactory.getRuntimeMXBean();
        gcbeans = ManagementFactory.getGarbageCollectorMXBeans();
        membean = ManagementFactory.getMemoryMXBean();
        threadbean = ManagementFactory.getThreadMXBean();
        modifiedClassNames = new HashSet<String>();
    }

    public static interface ReloadCallBack {
        public void setMaxValue(int var1) throws Exception;

        public void setValue(int var1) throws Exception;
    }
}

