/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public final class EasyMockProperties {
    private static final String PREFIX = "easymock.";
    private static volatile EasyMockProperties instance;
    private final Properties properties = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EasyMockProperties getInstance() {
        if (instance != null) return instance;
        Class<EasyMockProperties> clazz = EasyMockProperties.class;
        synchronized (EasyMockProperties.class) {
            if (instance != null) return instance;
            instance = new EasyMockProperties();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private EasyMockProperties() {
        InputStream in = this.getClassLoader().getResourceAsStream("easymock.properties");
        if (in != null) {
            in = new BufferedInputStream(in);
            try {
                this.properties.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read easymock.properties file");
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            if (!(entry.getKey() instanceof String) || !entry.getKey().toString().startsWith(PREFIX)) continue;
            this.properties.put(entry.getKey(), entry.getValue());
        }
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String setProperty(String key, String value) {
        if (!key.startsWith(PREFIX)) {
            throw new IllegalArgumentException("Invalid key (" + key + "), an easymock property starts with \"" + PREFIX + "\"");
        }
        if (value == null) {
            return (String)this.properties.remove(key);
        }
        return (String)this.properties.setProperty(key, value);
    }

    private ClassLoader getClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        return cl;
    }
}

