/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks;

import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.tasks.DNSTask;

public class RecordReaper
extends DNSTask {
    static Logger logger = Logger.getLogger(RecordReaper.class.getName());

    public RecordReaper(JmDNSImpl jmDNSImpl) {
        super(jmDNSImpl);
    }

    public String getName() {
        return "RecordReaper(" + (this.getDns() != null ? this.getDns().getName() : "") + ")";
    }

    public void start(Timer timer) {
        if (!this.getDns().isCanceling() && !this.getDns().isCanceled()) {
            timer.schedule((TimerTask)this, 10000L, 10000L);
        }
    }

    public void run() {
        if (this.getDns().isCanceling() || this.getDns().isCanceled()) {
            return;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.getName() + ".run() JmDNS reaping cache");
        }
        long now = System.currentTimeMillis();
        for (DNSEntry entry : this.getDns().getCache().allValues()) {
            try {
                DNSRecord record = (DNSRecord)entry;
                if (record.isStale(now)) {
                    this.getDns().renewServiceCollector(record);
                }
                if (!record.isExpired(now)) continue;
                this.getDns().updateRecord(now, record, JmDNSImpl.Operation.Remove);
                this.getDns().getCache().removeDNSEntry(record);
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, this.getName() + ".Error while reaping records: " + entry, exception);
                logger.severe(this.getDns().toString());
            }
        }
    }
}

