/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.annotation.introspection.EjbComponentAnnotationScanner;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.archivist.ArchivistFor;
import com.sun.enterprise.deployment.archivist.ExtensionsArchivist;
import com.sun.enterprise.deployment.io.ApplicationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.ConfigurationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.AnnotationDetector;
import com.sun.enterprise.deployment.util.ApplicationValidator;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.shared.ArchivistUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.xml.sax.SAXParseException;

@Service
@PerLookup
@ArchivistFor(value="ear")
public class ApplicationArchivist
extends Archivist<Application> {
    @Inject
    Provider<ArchivistFactory> archivistFactory;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ApplicationArchivist.class);

    public ApplicationArchivist() {
        this.handleRuntimeInfo = true;
    }

    @Override
    public ArchiveType getModuleType() {
        return DOLUtils.earType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void writeContents(ReadableArchive in, WritableArchive out) throws IOException {
        Vector<String> filesToSkip = new Vector<String>();
        if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
            DOLUtils.getDefaultLogger().fine("Write " + out.getURI() + " with " + this);
        }
        Enumeration alreadyWritten = out.entries();
        while (alreadyWritten.hasMoreElements()) {
            String elementName = (String)alreadyWritten.nextElement();
            filesToSkip.add(elementName);
        }
        Iterator<ModuleDescriptor<BundleDescriptor>> i$ = ((Application)this.descriptor).getModules().iterator();
        while (true) {
            ModuleDescriptor<BundleDescriptor> aModule;
            block10: {
                if (!i$.hasNext()) {
                    super.writeContents(in, out, filesToSkip);
                    return;
                }
                aModule = i$.next();
                Archivist subArchivist = this.archivistFactory.get().getArchivist(aModule.getModuleType());
                subArchivist.initializeContext(this);
                subArchivist.setModuleDescriptor(aModule);
                if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                    DOLUtils.getDefaultLogger().info("Write " + aModule.getArchiveUri() + " with " + subArchivist);
                }
                WritableArchive internalJar = out.createSubArchive(aModule.getArchiveUri());
                InputStream is = in.getEntry(aModule.getArchiveUri());
                File tmpFile = null;
                try {
                    boolean ok;
                    if (in instanceof WritableArchive) {
                        subArchivist.setArchiveUri(internalJar.getURI().getSchemeSpecificPart());
                    } else {
                        tmpFile = ApplicationArchivist.getTempFile(this.path);
                        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpFile));
                        ArchivistUtils.copy((InputStream)is, (OutputStream)bos);
                        subArchivist.setArchiveUri(tmpFile.getAbsolutePath());
                    }
                    subArchivist.writeContents(internalJar);
                    out.closeEntry(internalJar);
                    if (tmpFile == null || (ok = tmpFile.delete())) break block10;
                }
                catch (Throwable throwable) {
                    boolean ok;
                    if (tmpFile != null && !(ok = tmpFile.delete())) {
                        logger.log(Level.WARNING, localStrings.getLocalString("enterprise.deployment.cantDelete", "Error deleting file {0}", new Object[]{tmpFile.getAbsolutePath()}));
                    }
                    throw throwable;
                }
                logger.log(Level.WARNING, localStrings.getLocalString("enterprise.deployment.cantDelete", "Error deleting file {0}", new Object[]{tmpFile.getAbsolutePath()}));
            }
            filesToSkip.add(aModule.getArchiveUri());
        }
    }

    @Override
    public Application getDefaultBundleDescriptor() {
        return Application.createApplication();
    }

    @Override
    public Application open(ReadableArchive appArchive) throws IOException, SAXParseException {
        this.setManifest(appArchive.getManifest());
        Application appDesc = (Application)this.readStandardDeploymentDescriptor(appArchive);
        return this.openWith(appDesc, appArchive);
    }

    @Override
    public Application openWith(Application application, ReadableArchive archive) throws IOException, SAXParseException {
        this.setManifest(archive.getManifest());
        this.setDescriptor(application);
        HashMap<ExtensionsArchivist, RootDeploymentDescriptor> extensions = new HashMap<ExtensionsArchivist, RootDeploymentDescriptor>();
        if (this.extensionsArchivists != null) {
            for (ExtensionsArchivist extension : this.extensionsArchivists) {
                Object o;
                if (!extension.supportsModuleType(this.getModuleType()) || !((o = extension.open(this, archive, this.descriptor)) instanceof RootDeploymentDescriptor)) continue;
                if (o != this.descriptor) {
                    extension.addExtension(this.descriptor, (RootDeploymentDescriptor)o);
                }
                extensions.put(extension, (RootDeploymentDescriptor)o);
            }
        }
        boolean origHandleRuntimeInfo = this.handleRuntimeInfo;
        this.handleRuntimeInfo = false;
        if (!this.readModulesDescriptors(application, archive)) {
            return null;
        }
        this.handleRuntimeInfo = origHandleRuntimeInfo;
        if (this.handleRuntimeInfo) {
            this.readRuntimeDeploymentDescriptor(archive, application);
            for (Map.Entry extension : extensions.entrySet()) {
                if (extension.getValue() == null) continue;
                ((ExtensionsArchivist)extension.getKey()).readRuntimeDeploymentDescriptor(this, archive, (RootDeploymentDescriptor)extension.getValue());
            }
            if (this.classLoader != null) {
                this.validate(null);
            }
        }
        return application;
    }

    public Application createApplication(ReadableArchive archive, boolean directory) throws IOException, SAXParseException {
        if (this.hasStandardDeploymentDescriptor(archive)) {
            return (Application)this.readStandardDeploymentDescriptor(archive);
        }
        return this.getApplicationFromIntrospection(archive, directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Application getApplicationFromIntrospection(ReadableArchive archive, boolean directory) {
        File[] files;
        String appRoot = archive.getURI().getSchemeSpecificPart();
        if (appRoot.endsWith(File.separator)) {
            appRoot = appRoot.substring(0, appRoot.length() - 1);
        }
        Application app = Application.createApplication();
        app.setLoadedFromApplicationXml(false);
        app.setVirtual(false);
        String appName = appRoot.substring(appRoot.lastIndexOf(File.separatorChar) + 1);
        app.setName(appName);
        ArrayList<ReadableArchive> unknowns = new ArrayList<ReadableArchive>();
        for (File subModule : files = ApplicationArchivist.getEligibleEntries(new File(appRoot), directory)) {
            ReadableArchive subArchive;
            block26: {
                block29: {
                    block28: {
                        String uri;
                        block27: {
                            ModuleDescriptor md;
                            subArchive = null;
                            try {
                                subArchive = this.archiveFactory.openArchive(subModule);
                            }
                            catch (IOException ex) {
                                logger.log(Level.WARNING, ex.getMessage());
                            }
                            String name = subModule.getName();
                            uri = ApplicationArchivist.deriveArchiveUri(appRoot, subModule, directory);
                            if (!directory && name.endsWith(".war") || directory && (name.endsWith("_war") || name.endsWith(".war"))) {
                                md = new ModuleDescriptor();
                                md.setArchiveUri(uri);
                                md.setModuleType(DOLUtils.warType());
                                app.addModule((ModuleDescriptor<BundleDescriptor>)md);
                                break block26;
                            }
                            if (!directory && name.endsWith(".rar") || directory && (name.endsWith("_rar") || name.endsWith(".rar"))) {
                                md = new ModuleDescriptor();
                                md.setArchiveUri(uri);
                                md.setModuleType(DOLUtils.rarType());
                                app.addModule((ModuleDescriptor<BundleDescriptor>)md);
                                break block26;
                            }
                            if ((directory || !name.endsWith(".jar")) && (!directory || !name.endsWith("_jar") && !name.endsWith(".jar"))) break block26;
                            AppClientArchivist acArchivist = new AppClientArchivist();
                            if (!acArchivist.hasStandardDeploymentDescriptor(subArchive) && !acArchivist.hasRuntimeDeploymentDescriptor(subArchive) && acArchivist.getMainClassName(subArchive.getManifest()) == null) break block27;
                            ModuleDescriptor md2 = new ModuleDescriptor();
                            md2.setArchiveUri(uri);
                            md2.setModuleType(DOLUtils.carType());
                            md2.setManifest(subArchive.getManifest());
                            app.addModule((ModuleDescriptor<BundleDescriptor>)md2);
                            if (subArchive == null) continue;
                            try {
                                subArchive.close();
                            }
                            catch (IOException ioe) {
                                logger.log(Level.WARNING, localStrings.getLocalString("enterprise.deployment.errorClosingSubArch", "Error closing subarchive {0}", new Object[]{subModule.getAbsolutePath()}), ioe);
                            }
                            continue;
                        }
                        Archivist ejbArchivist = this.archivistFactory.get().getArchivist(DOLUtils.ejbType());
                        if (!ejbArchivist.hasStandardDeploymentDescriptor(subArchive) && !ejbArchivist.hasRuntimeDeploymentDescriptor(subArchive)) break block28;
                        ModuleDescriptor md = new ModuleDescriptor();
                        md.setArchiveUri(uri);
                        md.setModuleType(DOLUtils.ejbType());
                        app.addModule((ModuleDescriptor<BundleDescriptor>)md);
                        if (subArchive == null) continue;
                        try {
                            subArchive.close();
                        }
                        catch (IOException ioe) {
                            logger.log(Level.WARNING, localStrings.getLocalString("enterprise.deployment.errorClosingSubArch", "Error closing subarchive {0}", new Object[]{subModule.getAbsolutePath()}), ioe);
                        }
                        continue;
                    }
                    break block29;
                    {
                        catch (IOException ex) {
                            logger.log(Level.WARNING, ex.getMessage());
                        }
                    }
                }
                unknowns.add(subArchive);
                subArchive = null;
            }
            if (subArchive == null) continue;
            try {
                subArchive.close();
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, localStrings.getLocalString("enterprise.deployment.errorClosingSubArch", "Error closing subarchive {0}", new Object[]{subModule.getAbsolutePath()}), ioe);
            }
            continue;
            catch (Throwable throwable) {
                if (subArchive != null) {
                    try {
                        subArchive.close();
                    }
                    catch (IOException ioe) {
                        logger.log(Level.WARNING, localStrings.getLocalString("enterprise.deployment.errorClosingSubArch", "Error closing subarchive {0}", new Object[]{subModule.getAbsolutePath()}), ioe);
                    }
                }
                throw throwable;
            }
        }
        if (unknowns.size() > 0) {
            AnnotationDetector detector = new AnnotationDetector(new EjbComponentAnnotationScanner());
            for (int i = 0; i < unknowns.size(); ++i) {
                File jarFile = new File(((ReadableArchive)unknowns.get(i)).getURI().getSchemeSpecificPart());
                try {
                    if (detector.hasAnnotationInArchive((ReadableArchive)unknowns.get(i))) {
                        String uri = ApplicationArchivist.deriveArchiveUri(appRoot, jarFile, directory);
                        ModuleDescriptor md = new ModuleDescriptor();
                        md.setArchiveUri(uri);
                        md.setModuleType(DOLUtils.ejbType());
                        app.addModule((ModuleDescriptor<BundleDescriptor>)md);
                    }
                    ((ReadableArchive)unknowns.get(i)).close();
                    continue;
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, ex.getMessage());
                }
            }
        }
        return app;
    }

    private static String deriveArchiveUri(String appRoot, File subModule, boolean deploydir) {
        if (deploydir) {
            return FileUtils.revertFriendlyFilename((String)subModule.getName());
        }
        String aRoot = null;
        try {
            aRoot = new File(appRoot).getCanonicalPath();
        }
        catch (IOException ex) {
            aRoot = appRoot;
        }
        String uri = null;
        try {
            uri = subModule.getCanonicalPath().substring(aRoot.length() + 1);
        }
        catch (IOException ex) {
            uri = subModule.getAbsolutePath().substring(aRoot.length() + 1);
        }
        return uri.replace(File.separatorChar, '/');
    }

    private static File[] getEligibleEntries(File appRoot, boolean deploydir) {
        if (deploydir) {
            return appRoot.listFiles(new DirectoryIntrospectionFilter());
        }
        Vector<File> files = new Vector<File>();
        ApplicationArchivist.getListOfFiles(appRoot, files, new ArchiveIntrospectionFilter(appRoot.getAbsolutePath()));
        return files.toArray(new File[files.size()]);
    }

    private static void getListOfFiles(File directory, Vector<File> files, FilenameFilter filter) {
        File[] list = directory.listFiles(filter);
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].isDirectory()) {
                files.add(list[i]);
                continue;
            }
            ApplicationArchivist.getListOfFiles(list[i], files, filter);
        }
    }

    public boolean readModulesDescriptors(Application app, ReadableArchive appArchive) throws IOException, SAXParseException {
        ArrayList nonexistentModules = new ArrayList();
        List<ModuleDescriptor> sortedModules = this.sortModules(app);
        for (ModuleDescriptor aModule : sortedModules) {
            if (aModule.getArchiveUri().indexOf(" ") != -1) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.unsupporturi", "Unsupported module URI {0}, it contains space(s)", new Object[]{aModule.getArchiveUri()}));
            }
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().fine("Opening sub-module " + aModule);
            }
            BundleDescriptor descriptor = null;
            Archivist newArchivist = this.archivistFactory.get().getArchivist(aModule.getModuleType());
            newArchivist.initializeContext(this);
            newArchivist.setRuntimeXMLValidation(this.getRuntimeXMLValidation());
            newArchivist.setRuntimeXMLValidationLevel(this.getRuntimeXMLValidationLevel());
            newArchivist.setAnnotationProcessingRequested(this.annotationProcessingRequested);
            ReadableArchive embeddedArchive = appArchive.getSubArchive(aModule.getArchiveUri());
            if (embeddedArchive == null) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.nosuchmodule", "Could not find sub module [{0}] as defined in application.xml", new Object[]{aModule.getArchiveUri()}));
            }
            embeddedArchive.setParentArchive(appArchive);
            DOLUtils.setExtensionArchivistForSubArchivist(this.habitat, embeddedArchive, aModule, app, newArchivist);
            if (aModule.getAlternateDescriptor() != null) {
                InputStream is = appArchive.getEntry(aModule.getAlternateDescriptor());
                DeploymentDescriptorFile ddFile = newArchivist.getStandardDDFile();
                ddFile.setXMLValidation(newArchivist.getXMLValidation());
                ddFile.setXMLValidationLevel(newArchivist.getXMLValidationLevel());
                if (appArchive.getURI() != null) {
                    ddFile.setErrorReportingString(appArchive.getURI().getSchemeSpecificPart());
                }
                descriptor = (BundleDescriptor)ddFile.read(is);
                descriptor.setApplication(app);
                is.close();
                HashMap<ExtensionsArchivist, RootDeploymentDescriptor> extensions = new HashMap<ExtensionsArchivist, RootDeploymentDescriptor>();
                List<ExtensionsArchivist> extensionsArchivists = newArchivist.getExtensionArchivists();
                if (extensionsArchivists != null) {
                    for (ExtensionsArchivist extensionsArchivist : extensionsArchivists) {
                        Object rdd = extensionsArchivist.open(newArchivist, embeddedArchive, descriptor);
                        if (!(rdd instanceof RootDeploymentDescriptor)) continue;
                        extensions.put(extensionsArchivist, (RootDeploymentDescriptor)rdd);
                    }
                }
                newArchivist.postStandardDDsRead(descriptor, embeddedArchive, extensions);
                newArchivist.readAnnotations(embeddedArchive, descriptor, extensions);
                newArchivist.postAnnotationProcess(descriptor, embeddedArchive);
                newArchivist.postOpen(descriptor, embeddedArchive);
                if (this.isHandlingRuntimeInfo()) {
                    DOLUtils.readAlternativeRuntimeDescriptor(appArchive, embeddedArchive, newArchivist, descriptor, aModule.getAlternateDescriptor());
                    for (Map.Entry entry : extensions.entrySet()) {
                        if (entry.getValue() == null) continue;
                        ((ExtensionsArchivist)entry.getKey()).readRuntimeDeploymentDescriptor(newArchivist, embeddedArchive, (RootDeploymentDescriptor)entry.getValue());
                    }
                }
            } else {
                descriptor = (BundleDescriptor)newArchivist.open(embeddedArchive, app);
            }
            embeddedArchive.close();
            if (descriptor != null) {
                descriptor.getModuleDescriptor().setArchiveUri(aModule.getArchiveUri());
                aModule.setModuleName(descriptor.getModuleDescriptor().getModuleName());
                aModule.setDescriptor(descriptor);
                descriptor.setApplication(app);
                aModule.setManifest(newArchivist.getManifest());
                if (appArchive.exists("META-INF/application.xml") || !aModule.getModuleType().equals((Object)DOLUtils.warType())) continue;
                aModule.setContextRoot(aModule.getModuleName());
                continue;
            }
            return false;
        }
        for (ModuleDescriptor nonexistentModule : nonexistentModules) {
            app.removeModule((ModuleDescriptor<BundleDescriptor>)nonexistentModule);
        }
        return true;
    }

    private List<ModuleDescriptor> sortModules(Application app) {
        ArrayList<ModuleDescriptor> sortedModules = new ArrayList<ModuleDescriptor>();
        sortedModules.addAll(app.getModuleDescriptorsByType(DOLUtils.rarType()));
        sortedModules.addAll(app.getModuleDescriptorsByType(DOLUtils.ejbType()));
        sortedModules.addAll(app.getModuleDescriptorsByType(DOLUtils.warType()));
        sortedModules.addAll(app.getModuleDescriptorsByType(DOLUtils.carType()));
        return sortedModules;
    }

    @Override
    public void readRuntimeDeploymentDescriptor(ReadableArchive archive, Application descriptor) throws IOException, SAXParseException {
        if (descriptor != null) {
            for (ModuleDescriptor<BundleDescriptor> md : descriptor.getModules()) {
                Archivist archivist = this.archivistFactory.get().getArchivist(md.getModuleType());
                archivist.initializeContext(this);
                archivist.setRuntimeXMLValidation(this.getRuntimeXMLValidation());
                archivist.setRuntimeXMLValidationLevel(this.getRuntimeXMLValidationLevel());
                ReadableArchive subArchive = archive.getSubArchive(md.getArchiveUri());
                if (md.getAlternateDescriptor() != null) {
                    DOLUtils.readAlternativeRuntimeDescriptor(archive, subArchive, archivist, (BundleDescriptor)md.getDescriptor(), md.getAlternateDescriptor());
                    continue;
                }
                archivist.readRuntimeDeploymentDescriptor(subArchive, (BundleDescriptor)md.getDescriptor());
            }
        }
        super.readRuntimeDeploymentDescriptor(archive, descriptor);
    }

    @Override
    public void validate(ClassLoader aClassLoader) {
        ClassLoader cl = aClassLoader;
        if (cl == null) {
            cl = this.classLoader;
        }
        if (cl == null) {
            return;
        }
        ((Application)this.descriptor).setClassLoader(cl);
        ((Application)this.descriptor).visit(new ApplicationValidator());
    }

    @Override
    public DeploymentDescriptorFile getStandardDDFile() {
        if (this.standardDD == null) {
            this.standardDD = new ApplicationDeploymentDescriptorFile();
        }
        return this.standardDD;
    }

    @Override
    public List<ConfigurationDeploymentDescriptorFile> getConfigurationDDFiles() {
        if (this.confDDFiles == null) {
            this.confDDFiles = DOLUtils.getConfigurationDeploymentDescriptorFiles(this.habitat, "ear");
        }
        return this.confDDFiles;
    }

    @Override
    public boolean performOptionalPkgDependenciesCheck(ReadableArchive archive) throws IOException {
        if (!super.performOptionalPkgDependenciesCheck(archive)) {
            return false;
        }
        if (this.descriptor == null) {
            throw new IOException("Application object not set on archivist");
        }
        boolean returnValue = true;
        for (ModuleDescriptor<BundleDescriptor> md : ((Application)this.descriptor).getModules()) {
            Archivist subArchivist;
            ReadableArchive sub = archive.getSubArchive(md.getArchiveUri());
            if (sub == null || (subArchivist = this.archivistFactory.get().getArchivist(md.getModuleType())).performOptionalPkgDependenciesCheck(sub)) continue;
            returnValue = false;
        }
        return returnValue;
    }

    @Override
    public void copyInto(ReadableArchive source, WritableArchive target) throws IOException {
        try {
            Application a = (Application)this.readStandardDeploymentDescriptor(source);
            this.copyInto(a, source, target);
        }
        catch (SAXParseException spe) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.fileCopyFailure", spe);
        }
    }

    public void copyInto(Application a, ReadableArchive source, WritableArchive target) throws IOException {
        this.copyInto(a, source, target, true);
    }

    public void copyInto(Application a, ReadableArchive source, WritableArchive target, boolean overwriteManifest) throws IOException {
        Vector<String> entriesAdded = new Vector<String>();
        for (ModuleDescriptor<BundleDescriptor> aModule : a.getModules()) {
            entriesAdded.add(aModule.getArchiveUri());
            ReadableArchive subSource = source.getSubArchive(aModule.getArchiveUri());
            WritableArchive subTarget = target.createSubArchive(aModule.getArchiveUri());
            Archivist newArchivist = this.archivistFactory.get().getArchivist(aModule.getModuleType());
            ReadableArchive subArchive = this.archiveFactory.openArchive(subTarget.getURI());
            subSource.setParentArchive(subArchive);
            newArchivist.copyInto(subSource, subTarget, overwriteManifest);
            target.closeEntry(subTarget);
            String subModulePath = subSource.getURI().getSchemeSpecificPart();
            String parentPath = source.getURI().getSchemeSpecificPart();
            if (subModulePath.startsWith(parentPath)) {
                subModulePath = subModulePath.substring(parentPath.length() + File.separator.length());
                Enumeration subEntries = subSource.entries();
                while (subEntries.hasMoreElements()) {
                    String anEntry = (String)subEntries.nextElement();
                    entriesAdded.add(subModulePath + "/" + anEntry);
                }
            }
            subSource.close();
            subArchive.close();
        }
        super.copyInto(source, target, entriesAdded, overwriteManifest);
    }

    @Override
    protected boolean postHandles(ReadableArchive abstractArchive) throws IOException {
        if (!(abstractArchive instanceof FileArchive)) {
            return false;
        }
        File file = new File(abstractArchive.getURI());
        if (file.isDirectory()) {
            for (String dirName : abstractArchive.getDirectories()) {
                if (!ApplicationArchivist.resemblesTopLevelSubmodule(dirName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected String getArchiveExtension() {
        return ".ear";
    }

    private static boolean resemblesTopLevelSubmodule(String entryName) {
        return entryName.endsWith("_war") || entryName.endsWith("_jar") || entryName.endsWith("_rar") || entryName.endsWith(".war") || entryName.endsWith(".jar") || entryName.endsWith(".rar");
    }

    private static class ArchiveIntrospectionFilter
    implements FilenameFilter {
        private String libDir;
        private final FileArchive.StaleFileManager sfm;

        ArchiveIntrospectionFilter(String root) {
            try {
                this.sfm = FileArchive.StaleFileManager.Util.getInstance((File)new File(root));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            this.libDir = root + File.separator + "lib" + File.separator;
        }

        @Override
        public boolean accept(File dir, String name) {
            File currentFile = new File(dir, name);
            if (currentFile.isDirectory()) {
                return this.sfm.isEntryValid(currentFile, true);
            }
            if (name.endsWith(".war") || name.endsWith(".rar")) {
                return this.sfm.isEntryValid(currentFile, true);
            }
            String path = currentFile.getAbsolutePath();
            if (!path.startsWith(this.libDir) && path.endsWith(".jar")) {
                return this.sfm.isEntryValid(currentFile, true);
            }
            return false;
        }
    }

    private static class DirectoryIntrospectionFilter
    implements FilenameFilter {
        DirectoryIntrospectionFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            File currentFile = new File(dir, name);
            if (!currentFile.isDirectory()) {
                return false;
            }
            return ApplicationArchivist.resemblesTopLevelSubmodule(name);
        }
    }
}

