/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;
import ndr.NdrBuffer;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.transport.JIComRuntimeEndpoint;
import rpc.Endpoint;
import rpc.ProviderException;
import rpc.RpcException;
import rpc.Transport;
import rpc.core.PresentationSyntax;

final class JIComRuntimeTransport
implements Transport {
    public static final String PROTOCOL = "ncacn_ip_tcp";
    private Properties properties;
    private Socket socket;
    private OutputStream output;
    private InputStream input;
    private boolean attached;

    public JIComRuntimeTransport(String address, Properties properties) throws ProviderException {
        this.properties = properties;
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Endpoint attach(PresentationSyntax syntax) throws IOException {
        if (this.attached) {
            throw new RpcException("Transport already attached.");
        }
        JIComRuntimeEndpoint endPoint = null;
        try {
            this.socket = (Socket)JISystem.internal_getSocket();
            this.output = null;
            this.input = null;
            this.attached = true;
            endPoint = new JIComRuntimeEndpoint(this, syntax);
        }
        catch (Exception ex) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return endPoint;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.attached = false;
            this.socket = null;
            this.output = null;
            this.input = null;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.attached = false;
            this.socket = null;
            this.output = null;
            this.input = null;
            return;
        }
    }

    public void send(NdrBuffer buffer) throws IOException {
        if (!this.attached) {
            throw new RpcException("Transport not attached.");
        }
        if (this.output == null) {
            this.output = this.socket.getOutputStream();
        }
        this.output.write(buffer.getBuffer(), 0, buffer.getLength());
        this.output.flush();
    }

    public void receive(NdrBuffer buffer) throws IOException {
        if (!this.attached) {
            throw new RpcException("Transport not attached.");
        }
        if (this.input == null) {
            this.input = this.socket.getInputStream();
        }
        buffer.length = this.input.read(buffer.getBuffer(), 0, buffer.getCapacity());
    }
}

