/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.phpunit;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.project.environment.PhpEnvironment;
import org.netbeans.modules.php.project.ui.Utils;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class PhpUnitOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1284325558169934603L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JLabel errorLabel;
    private JLabel installationInfoLabel;
    private JLabel learnMoreLabel;
    private JLabel noteLabel;
    private JButton phpUnitBrowseButton;
    private JLabel phpUnitInfoLabel;
    private JLabel phpUnitLabel;
    private JLabel phpUnitPhp53InfoLabel;
    private JButton phpUnitSearchButton;
    private JTextField phpUnitTextField;

    public PhpUnitOptionsPanel() {
        this.initComponents();
        this.errorLabel.setText(" ");
        this.phpUnitTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            private void processUpdate() {
                PhpUnitOptionsPanel.this.fireChange();
            }
        });
    }

    public String getPhpUnit() {
        return this.phpUnitTextField.getText();
    }

    public void setPhpUnit(String string) {
        this.phpUnitTextField.setText(string);
    }

    public void setError(String string) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(string);
    }

    public void setWarning(String string) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(string);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.phpUnitLabel = new JLabel();
        this.phpUnitTextField = new JTextField();
        this.phpUnitBrowseButton = new JButton();
        this.phpUnitSearchButton = new JButton();
        this.noteLabel = new JLabel();
        this.phpUnitInfoLabel = new JLabel();
        this.phpUnitPhp53InfoLabel = new JLabel();
        this.installationInfoLabel = new JLabel();
        this.learnMoreLabel = new JLabel();
        this.errorLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.phpUnitLabel, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.phpUnitBrowseButton, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitBrowseButton.text"));
        this.phpUnitBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhpUnitOptionsPanel.this.phpUnitBrowseButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.phpUnitSearchButton, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitSearchButton.text"));
        this.phpUnitSearchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhpUnitOptionsPanel.this.phpUnitSearchButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.noteLabel, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.noteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.phpUnitInfoLabel, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.phpUnitPhp53InfoLabel, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitPhp53InfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.installationInfoLabel, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.installationInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.learnMoreLabel, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.learnMoreLabel.text"));
        this.learnMoreLabel.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                PhpUnitOptionsPanel.this.learnMoreLabelMouseEntered(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                PhpUnitOptionsPanel.this.learnMoreLabelMousePressed(mouseEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(0, 0, 0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.errorLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.phpUnitLabel).addPreferredGap(0).add((Component)this.phpUnitTextField, -1, 199, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.phpUnitBrowseButton).addPreferredGap(0).add((Component)this.phpUnitSearchButton)).add((Component)this.noteLabel))).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.phpUnitInfoLabel)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.phpUnitPhp53InfoLabel)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.installationInfoLabel)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.learnMoreLabel))).add(0, 0, 0)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.phpUnitLabel).add((Component)this.phpUnitTextField, -2, -1, -2).add((Component)this.phpUnitSearchButton).add((Component)this.phpUnitBrowseButton)).add(18, 18, 18).add((Component)this.noteLabel).addPreferredGap(0).add((Component)this.phpUnitInfoLabel).add(18, 18, 18).add((Component)this.phpUnitPhp53InfoLabel).add(18, 18, 18).add((Component)this.installationInfoLabel).addPreferredGap(0).add((Component)this.learnMoreLabel).addPreferredGap(0, 47, Short.MAX_VALUE).add((Component)this.errorLabel).add(0, 0, 0)));
    }

    private void phpUnitBrowseButtonActionPerformed(ActionEvent actionEvent) {
        Utils.browsePhpUnit(this, this.phpUnitTextField);
    }

    private void phpUnitSearchButtonActionPerformed(ActionEvent actionEvent) {
        String string = UiUtils.SearchWindow.search((UiUtils.SearchWindow.SearchWindowSupport)new UiUtils.SearchWindow.SearchWindowSupport(){

            public List<String> detect() {
                return PhpEnvironment.get().getAllPhpUnits();
            }

            public String getWindowTitle() {
                return NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"LBL_PhpUnitsTitle");
            }

            public String getListTitle() {
                return NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"LBL_PhpUnits");
            }

            public String getPleaseWaitPart() {
                return NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"LBL_PhpUnitsPleaseWaitPart");
            }

            public String getNoItemsFound() {
                return NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"LBL_NoPhpUnitsFound");
            }
        });
        if (string != null) {
            this.phpUnitTextField.setText(string);
        }
    }

    private void learnMoreLabelMouseEntered(MouseEvent mouseEvent) {
        mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void learnMoreLabelMousePressed(MouseEvent mouseEvent) {
        try {
            URL uRL = new URL("http://www.phpunit.de/manual/current/en/installation.html");
            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
    }
}

